/*
 phpBB2 - Basic DB data for Attachment Mod in mssql (F. Javier Lancharro)

 $Id: attach_mssql_basic.sql,v 2.0.5 2002/01/31 20:03:00 meik Exp $

*/

BEGIN TRANSACTION;

/*
  -- attach types
*/
SET IDENTITY_INSERT phpbb_attach_types ON;

INSERT INTO phpbb_attach_types (type_id, type_name, category, allow_type, download_mode, upload_image, max_filesize) VALUES (1,'Images',1,1,1,'',0);
INSERT INTO phpbb_attach_types (type_id, type_name, category, allow_type, download_mode, upload_image, max_filesize) VALUES (2,'Archives',0,1,1,'',0);
INSERT INTO phpbb_attach_types (type_id, type_name, category, allow_type, download_mode, upload_image, max_filesize) VALUES (3,'Plain Text',0,0,1,'',0);
INSERT INTO phpbb_attach_types (type_id, type_name, category, allow_type, download_mode, upload_image, max_filesize) VALUES (4,'Documents',0,0,1,'',0);
INSERT INTO phpbb_attach_types (type_id, type_name, category, allow_type, download_mode, upload_image, max_filesize) VALUES (5,'Real Media',0,0,2,'',0);
INSERT INTO phpbb_attach_types (type_id, type_name, category, allow_type, download_mode, upload_image, max_filesize) VALUES (6,'Streams',2,0,1,'',0);
INSERT INTO phpbb_attach_types (type_id, type_name, category, allow_type, download_mode, upload_image, max_filesize) VALUES (7,'Flash Files',3,0,1,'',0);

SET IDENTITY_INSERT phpbb_attach_types OFF;

/*
  -- attach typeconfig
*/
SET IDENTITY_INSERT phpbb_attach_typeconfig ON;

INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (1, 1,'image/gif','gif');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (2, 1,'image/ief','ief');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (3, 1,'image/jpeg','jpeg jpg jpe');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (4, 1,'image/pjpeg','jpg');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (5, 1,'image/png','png');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (6, 1,'image/x-png','png');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (7, 1,'image/tiff','tiff tif');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (8, 1,'image/x-cmu-raster','ras');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (9, 1,'image/x-portable-anymap','pnm');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (10, 1,'image/x-portable-bitmap','pbm');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (11, 1,'image/x-portable-graymap','pgm');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (12, 1,'image/x-portable-pixmap','ppm');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (13, 1,'image/x-rgb','rgb');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (14, 1,'image/x-xbitmap','xbm');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (15, 1,'image/x-xpixmap','xpm');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (16, 1,'image/x-xwindowdump','xwd');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (17, 2,'application/x-compress','z Z');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (18, 2,'application/x-gtar','gtar tgz');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (19, 2,'application/x-gunzip','gz');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (20, 2,'application/x-gzip','gz');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (21, 2,'application/x-gzip-compressed','gz');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (22, 2,'application/x-tar','tar');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (23, 2,'application/zip','zip');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (24, 2,'application/x-zip-compressed','zip');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (25, 3,'text/plain','asc txt c cc h hh cpp hpp');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (26, 4,'application/excel','xls');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (27, 4,'application/msword','doc dot wrd');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (28, 4,'application/pdf','pdf');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (29, 4,'application/postscript','ai eps ps');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (30, 4,'application/powerpoint','ppt');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (31, 5,'application/vnd.rn-realmedia','rm');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (32, 6,'audio/x-ms-wma','wma');
INSERT INTO phpbb_attach_typeconfig (mime_id, type_id, type_string, explain_mimetype) VALUES (33, 7,'application/x-shockwave-flash','swf');

SET IDENTITY_INSERT phpbb_attach_typeconfig OFF;

/*
  -- attach extensions
*/
SET IDENTITY_INSERT phpbb_attach_extensions ON;

INSERT INTO phpbb_attach_extensions (ext_id, extension) VALUES (1,'php');
INSERT INTO phpbb_attach_extensions (ext_id, extension) VALUES (2,'php3');
INSERT INTO phpbb_attach_extensions (ext_id, extension) VALUES (3,'php4');
INSERT INTO phpbb_attach_extensions (ext_id, extension) VALUES (4,'phtml');
INSERT INTO phpbb_attach_extensions (ext_id, extension) VALUES (5,'pl');
INSERT INTO phpbb_attach_extensions (ext_id, extension) VALUES (6,'asp');
INSERT INTO phpbb_attach_extensions (ext_id, extension) VALUES (7,'cgi');

SET IDENTITY_INSERT phpbb_attach_extensions OFF;

/*
  -- attach config
*/
INSERT INTO phpbb_attach_config (config_name, config_value) VALUES ('upload_dir','files');
INSERT INTO phpbb_attach_config (config_name, config_value) VALUES ('max_filesize','262144');
INSERT INTO phpbb_attach_config (config_name, config_value) VALUES ('upload_img','images/icon_clip.gif');
INSERT INTO phpbb_attach_config (config_name, config_value) VALUES ('max_attachments','3');
INSERT INTO phpbb_attach_config (config_name, config_value) VALUES ('disable_mod','0');
INSERT INTO phpbb_attach_config (config_name, config_value) VALUES ('topic_icon','');
INSERT INTO phpbb_attach_config (config_name, config_value) VALUES ('mime_table','');
INSERT INTO phpbb_attach_config (config_name, config_value) VALUES ('attachment_quota','52428800');

COMMIT;
