#ifndef SERIAL_H_SEEN
#define SERIAL_H_SEEN 1

#include "config.h"

#if defined(HAVE_SYS_TERMIOS_H)
#  include <sys/termios.h>      /* for speed_t */
#else
#  error "No <sys/termios.h> available.  Unable to continue."
#endif /* HAVE_SYS_TERMIOS_H */

/* limit the amount of spew that goes in the syslog when we lose the UPS */
#define SER_ERR_LIMIT 10	/* start limiting after 10 in a row  */
#define SER_ERR_RATE 100	/* then only print every 100th error */

int ser_open(const char *port);

int ser_set_speed(int fd, const char *port, speed_t speed);

int ser_close(int fd, const char *port);

int ser_send_char(int fd, char ch);

/* send the results of the format string with d_usec delay after each char */
unsigned int ser_send_pace(int fd, unsigned long d_usec, const char *fmt, ...);

/* send the results of the format string with no delay */
unsigned int ser_send(int fd, const char *fmt, ...);

/* send buflen bytes from buf with no delay */
int ser_send_buf(int fd, const char *buf, size_t buflen);

/* send buflen bytes from buf with d_usec delay after each char */
int ser_send_buf_pace(int fd, unsigned long d_usec, const char *buf, 
	size_t buflen);

int ser_get_char(int fd, char *ch, long d_sec, long d_usec);

/* keep reading until buflen bytes are received or a timeout occurs */
int ser_get_buf_len(int fd, char *buf, size_t buflen, long d_sec, long d_usec);

/* reads a line up to <endchar>, discarding anything else that may follow,
   with callouts to the handler if anything matches the alertset */
int ser_get_line_alert(int fd, char *buf, size_t buflen, char endchar,
	const char *ignset, const char *alertset, void handler (char ch), 
	long d_sec, long d_usec);

/* as above, only with no alertset handling (just a wrapper) */
int ser_get_line(int fd, char *buf, size_t buflen, char endchar,
	const char *ignset, long d_sec, long d_usec);

int ser_flush_in(int fd, const char *ignset, int verbose);

/* unified failure reporting: call these often */
void ser_comm_fail(const char *fmt, ...);
void ser_comm_good(void);


#endif	/* SERIAL_H_SEEN */
