#include <stdio.h>
#include <stdlib.h>
/*#include <dos.h>*/
#include <string.h>
#include "compiler.h"

#ifdef __TURBOC__
#include <dir.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#endif

#include "ffind.h"

#ifdef OS_2
#define INCL_NOPM
#define INCL_DOS
#include <os2.h>
#endif

static char path[256];

int
findmatch(filename, ff)
	char *filename;
	FFIND *ff;
{
	register i;
	register char *ptr;
	char mask[256];

	struct stat st;
	struct dirent *dp;

	if (filename == NULL || ff == NULL) return 0;
	if ((ptr = strrchr(strcpy(path, filename), '/')) == NULL) {
		ptr = filename;
		strcpy(path, ".");
	} else	*ptr++ = '\0';
	if ((ff->dirp = opendir(path)) == NULL) return 0;
	if ((dp = readdir(ff->dirp)) != NULL) {
		for (i = 0; *ptr; ptr++) switch (*ptr) {
			case '/':	break;
			case '\\':	mask[i++] = '\\'; mask[i++] = '\\'; break;
			case '?':	mask[i++] = '.'; break;
			case '.':	mask[i++] = '\\'; mask[i++] = '.'; break;
			case '*':	mask[i++] = '.'; mask[i++] = '*'; break;
			default:	mask[i++] = *ptr;
		}
		mask[i++] = '$';
		mask[i++] = '\0';
		if (!regcomp(&ff->rgc, mask, REG_ICASE|REG_NOSUB)) {
			do {
				if (!regexec(&ff->rgc, dp->d_name, (size_t)0, NULL, 0)) {
					sprintf(mask, "%s/%s", path, dp->d_name);
					if (stat(mask, &st) == 0) {
						ff->ff_attrib =	st.st_mode;
						ff->ff_ftime  =	st.st_mtime;
						ff->ff_fsize  =	st.st_size;
						strcpy(ff->ff_name, dp->d_name);
						return 1;
					}
				}
			} while ((dp = readdir(ff->dirp)) != NULL);
		}
	}
	(void)closedir(ff->dirp);
	return 0;
}

/* FindOpen;  Use like MSDOS "find first" function,  except be sure to
 * release allocated system resources by caling FindClose() with the
 * handle returned by this function.
 *
 * returns:  NULL  -- file not found.
 *
 */

FFIND * _fast FindOpen(char *filespec, unsigned short attribute)
{
  FFIND *ff;

  ff=malloc(sizeof(FFIND));

  if (ff)
  {

#if defined(__TURBOC__)

    if (findfirst(filespec,(struct ffblk *)ff,attribute))
    {
      free(ff);
      ff=NULL;
    }

#elif defined(OS_2)

    USHORT usSearchCount = 1;
    FILEFINDBUF findbuf;

    ff->hdir=HDIR_CREATE;

    if (!DosFindFirst(filespec,&ff->hdir,attribute,&findbuf,
                      sizeof(FILEFINDBUF),&usSearchCount,0L))
    {
      ff->ff_attrib=(char)findbuf.attrFile;
      ff->ff_fsize=findbuf.cbFile;

      ff->ff_ftime=*((USHORT *)&findbuf.ftimeLastWrite);
      ff->ff_fdate=*((USHORT *)&findbuf.fdateLastWrite);

      strncpy(ff->ff_name,findbuf.achName,sizeof(ff->ff_name));
    }
    else
    {
      free(ff);
      ff = NULL;
    }

#elif defined(__MSC__) || defined(__WATCOMC__)

    if (_dos_findfirst(filespec,attribute,(struct find_t *)ff))
    {
      free(ff);
      ff=NULL;
    }
#else
	if (!findmatch(filespec, ff)) {
		free(ff);
		ff = NULL;
	}
#endif
}
  return ff;
}

/* FindNext:   returns 0 if next file was found, non-zero if it was not.
 *
 */

int _fast FindNext(FFIND *ff)
{
  int rc=-1;

  if (ff)
  {

#if defined(__TURBOC__)

    rc=findnext((struct ffblk *)ff);

#elif defined(OS_2)

    USHORT usSearchCount = 1;
    FILEFINDBUF findbuf;

    if(ff->hdir && !DosFindNext(ff->hdir,&findbuf,sizeof(findbuf),&usSearchCount))
    {
      ff->ff_attrib=(char)findbuf.attrFile;
      ff->ff_ftime=*((USHORT *)&findbuf.ftimeLastWrite);
      ff->ff_fdate=*((USHORT *)&findbuf.fdateLastWrite);
      ff->ff_fsize=findbuf.cbFile;
      strncpy(ff->ff_name, findbuf.achName, sizeof(ff->ff_name));
      rc=0;
    }
#elif defined(__MSC__) || defined(__WATCOMC__)
    rc=_dos_findnext((struct find_t *)ff);
#else
	struct stat st;
	struct dirent *dp;
	char fpathname[256];

	while ((dp = readdir(ff->dirp)) != NULL) if (!regexec(&ff->rgc, dp->d_name, (size_t)0, NULL, 0)) {
		sprintf(fpathname, "%s/%s", path, dp->d_name);
		if (stat(fpathname, &st) == 0) {
			ff->ff_attrib =	st.st_mode;
			ff->ff_ftime  =	st.st_mtime;
			ff->ff_fsize  =	st.st_size;
			strcpy(ff->ff_name, dp->d_name);
			rc = 0;
			break;
		}
	}
#endif
  }
  return rc;
}

/* FindClose: End a directory search.  Failure to call this function will
 * result in unclosed file handles (os/2),  and un-free()'d memory (dos/os2).
 *
 */
void _fast FindClose(FFIND *ff)
{
  if (ff)
  {
#ifdef OS_2
    if(ff->hdir)
        DosFindClose(ff->hdir);
#endif
	if (ff->dirp) {
		closedir(ff->dirp);
		regfree(&ff->rgc);
	}
    free(ff);
  }
}

/* This function was added because it is SIGNIFICANTLY faster under OS/2 to
 * call DosQPathInfo() rather than DosFindFirst(),   if all you are
 * intested in is getting a specific file's date/time/size.
 *
 *PLF Thu  10-17-1991  18:12:37
 */

FFIND * _fast FindInfo(char *filespec)
{
#ifndef OS_2
    return FindOpen(filespec, 0);
#else
    FFIND *ff;
    FILESTATUS fs;
    char *f;

    ff = malloc(sizeof(*ff));
    if(!ff)
        return NULL;

    memset(ff, 0, sizeof(*ff));
    if (!DosQPathInfo(filespec, FIL_STANDARD, (PBYTE)&fs, sizeof(fs), 0L))
    {
      ff->ff_attrib=(char)fs.attrFile;
      ff->ff_ftime=*((USHORT *)&fs.ftimeLastWrite);
      ff->ff_fdate=*((USHORT *)&fs.fdateLastWrite);
      ff->ff_fsize=fs.cbFile;


      f = strrchr(filespec, '\\');    /* isolate file name */
      if(!f)
          f = filespec;
      else
          f++;
      strncpy(ff->ff_name, f, sizeof(ff->ff_name));
    }
    else{
        free(ff);
        return NULL;
    }
    return ff;
#endif
}

#ifdef TEST_SHELL

#define TRUE 1
#define FALSE 0

int walk(char *path);

void main(int argc, char **argv)
{
    walk("\\");     /* start at root*/
}

/* this simple function assumes the path ALWAYS has an ending backslash */
walk(char *path)
{
    FFIND *ff;
    int done = FALSE;
    char full[66];

    strcpy(full, path);
    strcat(full, "*.*");
    if( ff = FindOpen(full, MSDOS_subdir) ){
        for(done = FALSE; !done; done = FindNext(ff)){
            if( (ff->ff_attrib & MSDOS_subdir) && (ff->ff_name[0] != '.') ){
                strcpy(full, path);
                strcat(full, ff->ff_name);
                puts(full);
                strcat(full, "\\");
                if( !walk(full) )
                    return(FALSE);
            }
        }
        FindClose(ff);
        return(TRUE);
    }
    else{
        puts("FindOpen() failed");
    }
    return(FALSE);
}

#endif

