/*
 *	Copyright (c) 1994 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#ifdef	HAVE_NOT_RANDOM
#define	srandom srand
#define	random rand
#endif

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif
#define	LEN		512		/* max file path len	*/
#define	USERCONF	".user.conf"	/* user conf file	*/
#define	PASSWORD	"PASSWORD"	/* password keyword	*/

char homedir[LEN];

char *assignpasswd();
char *getstrfile();
int putstrfile();

main(argc, argv)
	int argc;
	char **argv;
{
	int dontchown = 0;
	char *ptr, fn[LEN];
	struct stat st;

	strcpy(homedir, ".");
	sprintf(fn, "%s/%s", homedir, USERCONF);
	if (stat(fn, &st) < 0) {
		fprintf(stderr, "stat(\"%s\"): %s\n", fn, strerror(errno));
		if (putstrfile(USERCONF, PASSWORD, ""))
			fprintf(stderr, "But \"%s\" will be created!\n", fn);
		else {
			fprintf(stderr, "creat(\"%s\"): %s\n", fn, strerror(errno));
			exit(1);
		}
		dontchown++;
	}
	if ((ptr = assignpasswd()) == NULL) {
		fprintf(stderr, "Password was NOT changed!\n");
		exit(1);
	}
	if (!putstrfile(USERCONF, PASSWORD, ptr)) {
		fprintf(stderr, "fopen(\"%s\"): %s\n", fn, strerror(errno));
		exit(1);
	}
	if (!dontchown) {
		if (chown(fn, st.st_uid, st.st_gid) < 0) {
			fprintf(stderr, "chown(\"%s\"): %s\n", fn, strerror(errno));
			exit(1);
		}
		fprintf(stderr, "Password was changed.\n");
	} else	fprintf(stderr, "Password was created.\n");
	exit(0);
}

/*
 * Get string value from conf file.
 */
char *
getstrfile(conf, nam, def)
	char *conf, *nam, *def;
{
	int len, flag = FALSE;
	char *p;
	FILE *fp;
	static char strval[LEN];

	len = strlen(nam);
	sprintf(strval, "%s/%s", homedir, conf);
	if ((fp = fopen(strval, "r")) != NULL) {
		memset(strval, 0, sizeof(strval));
		while (fgets(strval, sizeof(strval), fp) != NULL) {
			for (p = strval; *p && *p != '\n' && *p != '\r'; p++);
			*p = '\0';
			if (strval[0] != '\0' && strval[0] != '#' &&
			    strncmp(strval, nam, len) == 0) {
				flag = TRUE;
				break;
			}
		}
		fclose(fp);
	}
	if (flag && strval[len+1] != '\0') return &strval[len+1];
	return def;
}

/*
 * Put string value to conf file.
 */
putstrfile(conf, nam, val)
	char *conf, *nam, *val;
{
	int len, flag = FALSE;
	FILE *fp, *fpw;
	char tmpfile[LEN], conffile[LEN], buf[LEN], *p;

	sprintf(tmpfile, "%s/tmp_XXXXXX", homedir);
	mktemp(tmpfile);
	if ((fpw = fopen(tmpfile, "w")) == NULL) return 0;
	len = strlen(nam);
	sprintf(conffile, "%s/%s", homedir, conf);
	if ((fp = fopen(conffile, "r")) != NULL) {
		while (fgets(buf, LEN, fp) != NULL) {
			for (p = buf; *p && *p != '\n' && *p != '\r'; p++);
			*p = '\0';
			if (strncmp(buf, nam, len) == 0) {
				flag = TRUE;
				if (strcmp(&buf[len+1], val) != 0) {
					fprintf(fpw, "%s=%s\n", nam, val);
					continue;
				}
			}
			fprintf(fpw, "%s\n", buf);
		}
		fclose(fp);
	}
	if (!flag) fprintf(fpw, "%s=%s\n", nam, val);
	fclose(fpw);
	chmod(tmpfile, 0644);
	unlink(conffile);
	link(tmpfile, conffile);
	unlink(tmpfile);
	return 1;
}

/*
 * Return new encrypted password or NULL.
 */
char *
assignpasswd()
{
	register char *p;
	int tries, retry, len;
	char buf[25], salt[9];

	for (buf[0] = '\0', tries = retry = 0;;) {
		p = getpass("New password:");
		if (!*p) return NULL;
		len = strlen(p);
		if (len > 24) {
			if (++retry > 5) return NULL;
			printf("Very long password.\n");
			continue;
		}
		if (len <= 5 && ++tries < 2) {
			if (++retry > 5) return NULL;
			printf("Please enter a longer password.\n");
			continue;
		}
		strcpy(buf, p);
		memset(p, 0, len);
		for (p = buf; *p && islower(*p); ++p);
		if (!*p && ++tries < 2) {
			if (++retry > 5) return NULL;
			printf("Please don't use an all-lower case password.\n");
			continue;
		}
		p = getpass("Retype password:");
		len = strcmp(buf, p);
		memset(p, 0, strlen(p));
		if (!len) break;
		if (++retry > 5) return NULL;
		printf("Mismatch; try again.\n");
	}
	/* grab a random printable character that isn't a colon */
	srandom((int)time((time_t *)NULL));
	to64(&salt[0], random(), 2);
	salt[2] = '\0';
	return ((char *)crypt(buf, salt));
}

static unsigned char itoa64[] =		/* 0 ... 63 => ascii - 64 */
	"./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

to64(s, v, n)
	register char *s;
	register long v;
	register int n;
{
	while (--n >= 0) {
		*s++ = itoa64[v&0x3f];
		v >>= 6;
	}
}
