#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifndef	DEBUG
#include <sys/time.h>
#include <syslog.h>
#include <ctype.h>
#include "netchat.h"
#include "callsign.h"
#endif

static struct sb {
	char **ts, **rs;
	int nts, nrs;
} *bl = NULL;
static int nbl = 0;

char *
strupr(str)
	char *str;
{
	register unsigned char *p;

	for (p = str; *p; p++) {
		if (*p >= 0xc0 && *p < 0xe0) *p = *p + 32; /* koi8 */
		else if (islower(*p)) *p = toupper(*p);
	}
	return str;
}

int
inittable(str)
	char *str;
{
	static int bs = 0;

	if ((unsigned char)*str > 0x20) {
		if (!bs) { 
			if ((bl = realloc(bl, ++nbl * sizeof(struct sb))) == NULL) {
#ifdef	DEBUG
				perror("realloc");
#else
				syslog(LOG_ERR, "realloc: %m");
#endif
				return -1;
			}
			if ((bl[nbl-1].ts = malloc(sizeof(char *))) == NULL) {
#ifdef	DEBUG
				perror("malloc");
#else
				syslog(LOG_ERR, "malloc: %m");
#endif
				return -1;
			}
			bl[nbl-1].rs = NULL;
			bl[nbl-1].nts = bl[nbl-1].nrs = 0;
		} else if ((bl[nbl-1].ts = realloc(bl[nbl-1].ts, (bl[nbl-1].nts+1) * sizeof(char *))) == NULL) {
#ifdef	DEBUG
			perror("realloc");
#else
			syslog(LOG_ERR, "realloc: %m");
#endif
			return -1;
		}
		bl[nbl-1].ts[bl[nbl-1].nts++] = strdup(strupr(str));
		bs = 1;
	} else if (bl) {
		if ((bl[nbl-1].rs = realloc(bl[nbl-1].rs, (bl[nbl-1].nrs+1) * sizeof(char *))) == NULL) {
#ifdef	DEBUG
			perror("realloc");
#else
			syslog(LOG_ERR, "realloc: %m");
#endif
			return -1;
		}
		while (*str && (unsigned char)*str <= 0x20) str++;
		bl[nbl-1].rs[bl[nbl-1].nrs++] = strdup(str);
		bs = 0;
	}
	return 0;
}

#ifdef	DEBUG

main(argc, argv)
	int argc;
	char *argv[];
{
	FILE *fp;
	int i, j;
	char *p, buf[256];

	if ((fp = fopen("psys.lng", "r")) == NULL) exit(1);
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		if ((p = strchr(buf, '\n')) != NULL) *p = 0;
		if (!*buf || *buf == ';' || *buf == '#') continue;
		if (inittable(buf) < 0) break;
	}
	fclose(fp);
	for (i = 0; i < nbl; i++) {
		printf("Block %d\n", i);
		printf("\tTokens: %d\n", bl[i].nts);
		for (j = 0; j < bl[i].nts; j++)
			printf("\t\t%s\n", bl[i].ts[j]);
		printf("\tReplies: %d\n", bl[i].nrs);
		for (j = 0; j < bl[i].nrs; j++)
			printf("\t\t%s\n", bl[i].rs[j]);
	}
}

#else

int
initpsys(file)
	char *file;
{
	register char *ptr;
	char *line;

	if ((ptr = (char *)loadfile(file)) == NULL) {
		syslog(LOG_ERR, "initpsys: %s: %m", file);
		return -1;
	}
	for (; (line = strchr(ptr, '\n')) != NULL; ptr = line) {
		*line++ = 0;
		if (!*ptr || *ptr == '#') continue;
		if (inittable(ptr) < 0) return -1;
	}
	return (nbl ? 0 : -1);
}

char *
psys(user, str)
	char *user, *str;
{
	register i, j;
	register unsigned char *p, *p1;
	int n;
	char *p2, buf[256];
	struct timeval t;
	static char reply[256];

	if (!nbl || !bl) return NULL;
	(void)strupr(str);
	for (i = 0; i < nbl; i++) { /* blocks */
		for (j = 0; j < bl[i].nts; j++) { /* tokens */
			p = bl[i].ts[j];
			switch (*p) {
			case '^':	/* begin str */
				p++;
				if (!strncmp(str, p, strlen(p))) goto found;
				break;
			case '@':	/* exactly match */
				p++;
				if (!strcmp(str, p)) goto found;
				break;
			case '$':	/* by token */
				p++;
				for (p1 = strcpy(buf, str);
				     p1 = strtok(p1, " \t,;!?"); p1 = NULL)
					if (!strcmp(p1, p)) goto found;
				break;
			default:
				if (strstr(str, p)) goto found;
			}
		}
	}
	return NULL; /* no match */
found:
	if ((p = strchr(user, ':')) != NULL) *p = 0;
	reply[0] = 0;
	gettimeofday(&t, NULL);
	p = bl[i].rs[t.tv_usec % bl[i].nrs]; /* get random reply */
	if (*p == '\0' || *p == '#') return NULL;
	for (p1 = reply; *p; p++) {
		if (*p != '%') {
			*p1++ = *p;
			*p1 = 0;
			continue;
		}
		switch (*++p) {
		case 'u':	/* user name as is */
			p2 = user;
			break;
		case 'n':	/* full user name */
			p2 = getlogname(user);
			break;
		case 'f':	/* first user name */
			p2 = strcpy(buf, getlogname(user));
			if ((str = strchr(p2, ' ')) != NULL) *str = 0;
			break;
		case 'l':	/* last user name */
			p2 = getlogname(user);
			if ((str = strchr(p2, ' ')) != NULL) p2 = ++str;
			break;
		case 'a':	/* abbreviated f)ist l)ast user name */
			p2 = getlogname(user);
			n = 0;
			buf[n++] = *p2;
			if ((str = strchr(p2, ' ')) != NULL) buf[n++] = *++str;
			buf[n] = 0;
			p2 = buf;
			break;
		case 'm':	/* my name */
			p2 = username;
			break;
		case 't':	/* matched token */
			p2 = bl[i].ts[j];
			if (*p2 == '^' || *p2 == '@' || *p2 == '$') p2++;
			break;
		default:	/* error */
			p2 = "ERROR";
		}
		p1 += strlen(strcpy(p1, p2));
	}
	return reply;
}

#endif	/* DEBUG */
