/*
 *	Copyright (c) 1994-1996 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#define	CALLSIGNLIST	".callsign.conf"

/*
 * Initialize callsign functions; must be called before any other functions.
 * The `orgdir' is a directory where plased CALLSIGNLIST file.
 * Return number of callsign entries.
 */
int initcallsign(char *orgdir);

/*
 * Search name by sign. Return name or NULL if not found.
 */
char *getnamebysign(char *sign);

/*
 * Search sign by name. Return sign or NULL if not found.
 */
char *getsignbyname(char *name);

/*
 * Return full login name of user.
 */
char *getlogname(char *user);

/*
 * Add sign entry to callsign file. Return -1 on error, 0 if succesfull.
 */
int addsignent(char *sign, char *name);

/*
 * Return callsign entry; each next call return next entry or NULL if EOF.
 */
char *getsignent(void);

/*
 * Rewind callsign entries; after that getsignent() return first entry.
 */
void closesignent(void);
