/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

int
isdigitstr(str)
	register char *str;
{
	if (*str == '\0') return 0;
	while (*str) {
		if (!isdigit((unsigned char)*str)) break;
		str++;
	}
	return (*str == '\0');
}

int
isquotedstr(s)
	register char *s;
{
	while (*s && *s == ' ') s++;
	if (*s == '>' || *s == ':') return 1;
	while (isalpha(*s)) s++;
	return (*s == '>');
}

int
chrlwr(chr)
	int chr;
{
	unsigned char ch = chr & 0377;

	if (ch >= 0xe0)		ch = ch - 32;
	else if (isupper(ch))	ch = tolower(ch);
	return ch;
}

/* Make lower case only for English and Russian(KOI-8) characters */
char *
strlwr(str)
	char *str;
{
	register char *s = str;

	while (*s) {
		*s = chrlwr(*s);
		s++;
	}
	return str;
}

char *
strnlwr(str, n)
	char *str;
	int n;
{
	register i = 0;
	register char *s = str;

	while (*s && i++ < n) {
		*s = chrlwr(*s);
		s++;
	}
	return str;
}

int
chrupr(chr)
	int chr;
{
	unsigned char ch = chr & 0377;

	if (ch >= 0xc0 && ch < 0xe0)	ch = ch + 32;
	else if (islower(ch))		ch = toupper(ch);
	return ch;
}

/* Make upper case only for English and Russian(KOI-8) characters */
char *
strupr(str)
	char *str;
{
	register char *s = str;

	while (*s) {
		*s = chrupr(*s);
		s++;
	}
	return str;
}

char *
strnupr(str, n)
	char *str;
	int n;
{
	register i = 0;
	register char *s = str;

	while (*s && i++ < n) {
		*s = chrupr(*s);
		s++;
	}
	return str;
}

/* Make lower case copy only for English and Russian(KOI-8) characters */
void
makelowercase(s, t)
	register char *s, *t;
{
	while (*s) {
		*t = chrlwr(*s);
		s++, t++;
	}
	*t = 0;
}

/* Make upper case copy only for English and Russian(KOI-8) characters */
void
makeuppercase(s, t)
	register char *s, *t;
{
	while (*s) {
		*t = chrupr(*s);
		s++, t++;
	}
	*t = 0;
}

/* Make ignore case search only for English and Russian(KOI-8) characters */
char *
__strcasestr(s1, s2)
	char *s1, *s2;
{
	register char *str1, *str2, *ptr;

	if ((str1 = malloc(strlen(s1)+1)) == NULL ||
	    (str2 = malloc(strlen(s2)+1)) == NULL) return NULL;
	makelowercase(s1, str1);
	makelowercase(s2, str2);
	ptr = strstr(str1, str2);
	free(str1);
	free(str2);
	if (ptr == NULL) return NULL;
	str2 = &s1[ptr - str1];
	return str2;
}

/* Compare string. Russian(KOI-8) characters are supported */
int
strcomp(s1, s2)
	register unsigned char *s1, *s2;
{
	static unsigned char rc[64] = {
61, 31, 32, 53, 35, 36, 51, 34, 52, 39, 40, 41, 42, 43, 44, 45, 46, 62, 47, 48, 49, 50, 37, 33, 59, 58, 38, 55, 60, 56, 54, 57,
29, 0, 1, 22, 4, 5, 20, 3, 21, 8, 9, 10, 11, 12, 13, 14, 15, 30, 16, 17, 18, 19, 6, 2, 27, 26, 7, 24, 28, 25, 23, 63
	};
	register unsigned char c1, c2;

	while (*s1 && *s2) {
		c1 = *s1++;
		if (c1 >= 0xc0) c1 = rc[c1] + 0xc0;
		c2 = *s2++;
		if (c2 >= 0xc0) c2 = rc[c2] + 0xc0;
		if (c1 < c2) return -1;
		if (c1 > c2) return 1;
	}
	if (*s1 < *s2) return -1;
	if (*s1 > *s2) return 1;
	return 0;
}

char *
strippath(name)
	char *name;
{
	register char *ptr;
	if ((ptr = strrchr(name, '/')) != NULL) return ++ptr;
	return name;
}

char *
skiplp(s)	/* skip leading path */
	char *s;
{
	register char *p = s;
	int flag = 0;

	while (*p == '/' || *p == '.') {
		if (*p++ == '/') {
			flag++;
			break;
		}
	}
	return (flag ? p : s);
}

char *
sec2str(sec)
	register sec;
{
	register hours, minutes, seconds;
	static char sec2strbuf[40];

	hours = sec / 3600;
	seconds = sec % 3600;
	minutes = seconds / 60;
	seconds %= 60;
	if (hours)
		sprintf(sec2strbuf, "%d:%02d:%02d", hours, minutes, seconds);
	else	sprintf(sec2strbuf, "%02d:%02d", minutes, seconds);
	return sec2strbuf;
}

char *
itoa(d)
	int d;
{
	static char str[16];
	snprintf(str, sizeof(str), "%d", d);
	return str;
}
