/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>


char *
gettzone()
{
	static char *tzs = NULL;
	static char *empty = "";

	if (tzs == NULL) { /* To get the timezone, compare localtime with GMT */
		struct tm lt, *gt;
		time_t tm;
		int tz, sign;

		if ((tzs = (char *)malloc(10)) == NULL) return empty;
		*tzs = '\0';
		tm = time(NULL);
		if ((gt = localtime(&tm)) == NULL) return empty;
		lt = *gt;
		if ((gt = gmtime(&tm)) == NULL) return empty;
		tz = lt.tm_yday - gt->tm_yday;
		if (tz > 1) tz = 24;
		else if (tz < -1) tz = -24;
		else tz *= 24;
		tz += lt.tm_hour - gt->tm_hour;
		tz *= 60;
		tz += lt.tm_min - gt->tm_min;
		tz /= 60;
		sign = 0;
		if (tz < 0) tz = -tz, sign++;
		sprintf(tzs, "%c%02d00", sign ? '-' : '+', tz);
	}
	return tzs;
}

/* fprint Message-Id and Date fields for the outgoing letter */
fprint_msgid(fp, host)
	FILE *fp;
	char *host;
{
	struct timeval tv;
	struct tm *tm;
	char buf[50];

	gettimeofday(&tv, NULL);
	tm = localtime((time_t *)&tv.tv_sec);
	strftime(buf, sizeof(buf), "%Y%m%d%H%M%S", tm);
	fprintf(fp, "Message-Id: <%s.%ld@%s>\n", buf, tv.tv_usec, host);
	strftime(buf, sizeof(buf), "%a, %e %b %Y %H:%M:%S", tm);
	fprintf(fp, "Date: %s %s\n", buf, gettzone());
}
