/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/file.h>

/*
 * Check to see if input pending on fd.
 */

#ifdef	FIONREAD

int
inqueue(fd)
	int fd;
{
	int queue;

	if (ioctl(fd, FIONREAD, &queue) < 0)
		return 0;

	return queue;
}

#elif	FIORDCHK

int
inqueue(fd)
	int fd;
{
	int queue;

	if (ioctl(fd, FIORDCHK, &queue) < 0)
		return 0;

	return queue;
}

#else	/* use select(), it maybe a bit slow */

#include <sys/time.h>
#include <unistd.h>

int
inqueue(fd)
	int fd;
{
	struct timeval timeout = {0, 0};
	fd_set ready;

	FD_ZERO(&ready);
	FD_SET(fd, &ready);
	if (select(fd + 1, &ready, (fd_set *)0, (fd_set *)0, &timeout) < 0)
		return 0;

	return FD_ISSET(fd, &ready);
}

#endif
