/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_UDPSERV_H_
#define	_TNS_UDPSERV_H_

/*
 * Netchat protocol keywords.
 */
#define	STARTTALKMARKER		"<want talk>"
#define	ALIVETALKMARKER		"<i'm alive>"
#define	ENDTALKMARKER		"<end talk>"
#define	COMINCONFMARKER		"<come in conf>\007"
#define	LEAVECONFMARKER		"<leave conf>"
#define	HANGUPLINE		"<hangup line>"
#define	KICKEDCONFMARKER	"<kicked from conf>"
#define	TALKPORTID		"talkport: "
#define	CMDSERVMARKER		"<cmd serv>"
#define	GETINFOMARKER		"<get info>"
#define	ATTEMPTTOKICK		"<kick %s>"
#define	ATTEMPTTOTERM		"<term %s>"
#define	ATTEMPTTOGRANT		"<grant %s>"
#define	ATTEMPTTOBAN		"<ban %s>"
#define	ATTEMPTTOUNBAN		"<unban %s>"

#define	LOOPBACK		"127.0.0.1"
extern unsigned long localhost;

/*
 * Initialize network operation and registry receiver function.
 * Return udp port number (network bytes order) we are listen for or -1.
 */
extern int udpserv(void (*receiver)(unsigned long from, char *data, int out_flag));

/*
 * Send data throught udp to localhost.
 */
extern int udpsend(int port, char *data, int len);

/*
 * Reply data throught udp back to requested host.
 */
extern int udpreply(char *data, int len);

#endif	/* !_TNS_UDPSERV_H_ */
