/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_REMATCH_H_
#define	_TNS_REMATCH_H_

#ifdef	HAVE_V8_REGEXP
#include <regexp.h>
#define	regex	regexp
#else
#include <regex.h>
#define	regex	regex_t
#endif

/* compile regex expression */
extern regex *recomp(char *pat);

/* free memory under compiled regex expression */
extern void refree(regex *rgc);

/* match string by compiled regex expression */
extern int reexec(regex *rgc, char *str);

/* match string by regex pattern */
extern int rematch(char *pat, char *str);

#endif	/* !_TNS_REMATCH_H_ */
