/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_GETCONF_H_
#define	_TNS_GETCONF_H_

/* Global variables */

extern char *bbsdir;	/* bbs originate directory */

/* Function prototypes */

/* initialize the bbs originate directory */
extern int initgetconf(char *orgdir);	/* orgdir maybe NULL */

/* return bbs directory or NULL if no bbs found in that system */
extern char *getbbsdir(void);

/* return user home directory or NULL if no such user */
extern char *getuserdir(char *user);

/* return path to user config file or NULL */
extern char *getuserfile(char *user);

/* return user name based on config file path or NULL */
extern char *getusername(char *path);

/* get string value from config file specified by path */
extern char *getfileconf(char *path, char *var, char *def);

/* get string value from bbs system config file */
extern char *getsysconf(char *var, char *def);

/* return path string in form suitable for users view */
extern char *getshowpath(char *path);

/* print detailed user information; return number of lines or -1 */
extern int getuserinfo(int (*print)(const char *, ...), char *user);

#endif	/* !_TNS_GETCONF_H_ */
