/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/*
 *	Copyright (c) 1994-1997 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_DRIVE_H_
#define	_TNS_DRIVE_H_

#include <sys/types.h>
#include <syslog.h>	/* just for error logging levels */

/* External functions */

#define	MAILER			"MAILER"
#define	DEFMAILER		"bin/send_mail"
#define	INEWS			"INEWS"
#define	DEFINEWS		"bin/send_news"
#define	LOGOUT			"LOGOUT"
#define	DEFLOGOUT		"bin/logout"
#define	EDITOR			"EDITOR"
#define	DEFEDITOR		"bin/pico"	/* We use Restricted PICO */
#define	SHELL			"SHELL"
#define	DEFSHELL		"bin/sh"

/* Common definitions */

typedef	void (*sigfunc) ();

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#define	ECHOENABLE	TRUE
#define	ECHODISABLE	FALSE
#define	FIRSTOPEN	2

#define	MAX_MENU_UID		99	/* regular users can't create menu */
#define	MAXBBSUSERS		256
#define	MAXPRIVLEVEL		99
#define	MAXCONFLINES		2048
#define	MAXSTACKSIZE		2048	/* max files or msgs in single area */
#define	MAXCONFENTRIES		100
#define	MAXFILENAMELEN		40
#define	MAXSEARCHSTRINGS	10
#define	MAXSTRINGLENGTH		79
#define	MAXDESCLINES		5
#define	MAXFATTACHSIZE		102400	/* bytes */
#define	DEFMSGZONE		2
#define	USRBUFSIZE		4096	/* 4kb */
#define	MAX_PARAM_LEN		128

#define	BBS			"bbs"

#define	DEFMENUPATH		"Main_menu"
#define	DEFREALNAME		"TNS User"
#define	DEFORG			"Unknown"
#define	DEFLANGUAGE		"English"
#define	USERDEFFROM		"DEFINE-FROM"
#define	USERDEFGROUP		"default"

#define	DEFDLSIZELIMIT		1024		/* Kb */
#define	DEFULMULTIPLIER		2
#define	MAXSCRLINES		43
#define	DEFSCRLINES		24

#define	DEFREADFILES		".readfiles"
#define	DEFUPLOADPATH		".files"
#define	DEFFILESLIST		"files.bbs"
#define	HIDEDIRS		"HIDEDIRS"
#define	USERLISTFILE		".userlist"
#define	MAILBOX			".mbox"

#define	XFERLOG			"XFERLOG"
#define	LOGFILE			"LOGFILE"
#define	LOGLEVEL		"LOGLEVEL"
#define	MONITOR			"MONITOR"
#define	MAXUSERS		"MAXUSERS"
#define	INFINITY		"INFINITY"

/* Timer section */
#define	INACTTIMER		3		/* 3min - inactivity timer */
#define	LOGINTIMELEFT		3		/* 3min - max login time */
#define	DEFTIMELEFT		60		/* time left 60 minuts */
#define	DAILYTIMELEFT		"DAILYTIMELEFT"
#define	TIMECOUNTER		10

/* User's limits */
#define	DEFPRIVLEVEL		0		/* 0 - minimum priv level */

/* Terminal section */
#define	DUMP			"dump"
#define	VT52			"vt52"		/* Dump terminal */
#define	VT100			"vt100"		/* ANSI support */
#define	ANSI			"ansi"		/* ANSI support */
#define	IBMPC3			"ibmpc3"	/* ANSI support */
#define	AT386			"at386"		/* ANSI support */
#define	RIP			"rip"		/* RIP<tm> support */
#define	MAXTERMLEN		7

#define	NODESCONFILE		"NODESCONFILE"
#define	DEFNODESCONFILE		"*** No description on file ***"

#define	MYPIDFILE		"/tmp/%s.%s"
#define	CONNECTFILE		"/tmp/CONNECT.%s"
#define	RECVBATCH		"/tmp/recv-batch.%s"
#define	SENDBATCH		"/tmp/send-batch.%s"
#define	TMPFILEMASK		"/tmp/dlXXXXXX"
#define	DSZLOG			"/tmp/dszlog"
#define	MONITORDIR		"/tmp/tnsmon"
#define	TNSMONPID		"/tmp/tnsmon/PID"
#define	BANLIST			"/tmp/banlist"

/* Some useful menu driven files */
#define	HELPFILE		".help"
#define	HEADERFILE		".header"
#define	FOOTERFILE		".footer"

#define	MENUPASSWORD		".password"
#define	MENUPASSSHOW		".password.show"

/* Config files */
#define	MAINSYSTEMCONF		"/etc/tns/system"
#define	SYSTEMCONF		".system.conf"
#define	MAINLIMITSCONF		"/etc/tns/limits"
#define	LIMITSCONF		".limits.conf"
#define	MAINTTYCONF		"/etc/tns/tty"
#define	TTYCONF			".tty.conf"
#define	MAINVIEWERSCONF		"/etc/tns/viewers"
#define	VIEWERSCONF		".viewers.conf"
#define	MAINFTPCONF		"/etc/tns/ftp"
#define	FTPCONF			".ftp.conf"
#define	MAINLANGCONF		"/etc/tns/language"
#define	LANGCONF		".language.conf"
#define	MAINFILESLIST		"/etc/tns/filelist"
#define	FILESLIST		".filelist.conf"
#define	USRHOMEDIR		"usr"
#define	USERCONF		".user.conf"
#define	CHARGEUSERCONF		".cuser.conf"
#define	TIMEGETCONF		".guser.conf"
#define	FILEAREACONF		".filearea.conf"
#define	MSGAREACONF		".msgarea.conf"
#define	USENETPATHCONF		".usenetpath.conf"
#define	USENETAREACONF		".usenetarea.conf"
#define	BADNAMESLIST		".badnames.conf"
#define	CALLSIGNLIST		".callsign.conf"
#define	FTPLISTCONF		".ftplist.conf"

/* User home rc files */
#define	FILE_RC			".filerc"
#define	MSG_RC			".msgrc"
#define	NEWS_RC			".newsrc"
#define	FTP_RC			".ftprc"
#define	MAIL_RC			".mailrc"

/* Seachable in user home directory first */
#define	STARTUPFILE		".startup"
#define	BADADDRFILE		".badaddr.conf"
#define	ALIASESFILE		".aliases.conf"
#define	USERFORWARDFILE		".forward"

/* Show to user files */
#define	TTYALLOWED		"./.ttyallow.show"	/* showfile() */
#define	BANNER			"~.banner.show"		/* display() */
#define	NEWUSERSWELCOME		"~.newusers.show"
#define	USERDENY		"~.userdeny.show"
#define	BADPASSWORD		"~.badpasswd.show"
#define	DAYLIMIT		"~.daylimit.show"
#define	CHARGELIMIT		"~.climit.show"
#define	USERNOTFOUND		"~.notfound.show"
#define	NEWUSER			"~.newuser.show"
#define	ROOKIE			"~.rookie.show"
#define	WELCOME			"~.welcome.show"
#define	GOODBYE			"~.goodbye.show"

/* Flag files */
#define	NOLOGIN			"./.nologin"
#define	NEWUSERSDENY		"~.nonewuser"
#define	SETUSERFILE		"/etc/tns/.setuser"

/* Global flags section */
extern int globalflags;		/* bit mapped */
#define	LISTMODE_EXT		1	/* execute external program */
#define	LISTMODE_RAW		2	/* raw list, do not stat() files */
#define	LISTMODE_ALL		4	/* show off-line files */
#define	INACTIVITY		8
#define	SEARCHPATH		16
#define	SEARCHFILE		32
#define	NEWFILES		64
#define	MSGFORYOU		128
/* #define	NOKEYWORDS		256 */	/* unused */
#define	IMMQUIT			512
#define	BEGINCHAT		1024
#define	EXTERNALMENUFLAG	2048
#define	SENDINPROGRESS		4096
#define	RECVINPROGRESS		8192
#define	USENETREADERINUSE	16384
#define	WANTTALK		32768
#define	NOMOREFLAG		65536
#define	LANGPRESELECTED		131072
#define	EXTERNALTALK		262144

extern int termflags;		/* value */
#define	DUMPTERM		0
#define	ANSITERM		1
#define	RIPTERM			2
#define	RIPTERM2		4
#define	RIPMOUSE		8
#define	CLEARBUTTONS		16
#define	HOTKEYON		32
#define	SHORTMENUON		64

/*
 * Global variables from drive.c
 */
extern char *systemid;
extern char *systemname;	/* name of this system		*/
extern char *systemhost;	/* hostname of this system	*/
extern char *sysmailto;		/* E-mail of Sys Admin		*/
extern char *sysadmname;	/* Name of Sys Admin		*/

extern char callsign[];		/* User call signature		*/
extern char homedir[];		/* User home directory		*/
extern char dirpath[];		/* Current menu directory path	*/
extern char term[];		/* Term type. VT100, ANSI, etc	*/
extern char fntty[];		/* slash-fixed tty name		*/
extern int privlevel;		/* User Access Level (0-99max)	*/
extern time_t lastcalltime;	/* User last logged time	*/
extern char *usergroup;		/* Group name of current user	*/
extern char userconf[];		/* user config file name	*/

extern char *loginline;		/* login line description or nil */
extern char *remote_addr;	/* Remote IP address (if any)	*/
extern char *remote_host;	/* Remote host name (if any)	*/

extern char *editorworkfile;	/* editor work file		*/
extern char *talkaddrfile;	/* HOME/.talk.ttyXX addr file	*/
extern char *ftpcachfile;	/* ftp cach file		*/

extern char *shellprog;		/* Path to prefered system shell*/
extern char *editprog;		/* Path to prefered system editor*/
extern char *talkprog;		/* Path to external talk program*/
extern char *fingerprog;	/* Path to the finger program	*/
extern char *logoutprog;	/* Path to logout procedure	*/
extern char *mailerprog;	/* Path to ext. mailer program	*/
extern char *inewsprog;		/* Path to ext. inews program	*/
extern char *progloader;	/* Path to loader of user progs */

extern char tmpbuf[];

extern void (*error)(int, const char *, ...); /* Error logging function	*/
#define	LOGIT	(*error)

/* misc.c */
extern char *writeletter;

/* menu.c */
extern int scrlines;		/* How many lines on screen	*/

/* login.c */
extern char *orgdir;		/* myself home dir		*/

/* art.c */
extern char *newssort;

/* cmd.c */
extern time_t newfilestime;


#if !defined(_CURSES_H_) && !defined(_CURSES_H) && !defined(CURSES_H)
/*
 * Global functions and variables from io.c
 *	flag: 0 - any char, 1 - only < 0x80
 */
extern int nchr;		/* How many chars contain input buffer */
#define	hotkey() (termflags & HOTKEYON) ? getask(ECHOENABLE) : getkey(ECHOENABLE)
#ifdef	__STDC__
extern int getchr(int flag);	/* Get char from fd=0,	<Enter> = '\0'	*/
extern int getkey(int echo);	/* Get char from stdbuf, <Enter> = '\r'	*/
extern char *getstr(int max, int flag, int echo); /* Get string stdbuf	*/
extern char *gettok(int max, int flag, int echo); /* Get token stdbuf	*/
extern char *editstr(char *str, int max, int flag); /* Edit str stdbuf	*/
extern int putchr(unsigned char);
extern int putstr(const char *fmt, ...);
extern char *putstrmax(char *str, int max);
#else
extern int getchr();
extern int getkey();
extern char *getstr();
extern char *gettok();
extern char *editstr();
extern int putchr();
extern int putstr();
extern char *putstrmax();
#endif
#endif

/* Function prototypes */

#ifdef	__STDC__

extern char *prompt_str(int msg, char *str, int max);
extern char *sysmsg(int msg);
extern char *itoa(int d);
extern char *strippath(char *file);
extern char *skiplp(char *path);
extern char *sec2str(int sec);
extern char *get_env(char *env, char *def);
extern char *strlwr(char *str);
extern char *strupr(char *str);
extern char *strnlwr(char *str);
extern char *strnupr(char *str, int n);
extern char *__strcasestr(char *s1, char *s2);
extern void quit(int status);
extern char *setarea(char *path);
extern char *getarea(void);
extern char *getfileconf(char *path, char *var, char *def);

/* userconf.c */
extern char *getuserconf(char *var, char *def);
extern void putuserconf(char *var, char *val);

extern char *strdupf(char *fmt, ...);
extern int strcatf(char *buf, const char *fmt, ...);
extern int display(int flag, char *fmt, ...);
extern int invoke_syscmd(char *fmt, ...);
extern int invoke_cmd(char *fmt, ...);
extern void vproctitle();
extern void proctitle(char *fmt, ...);

extern char *getsysconf(char *var, char *def);
extern char *mesgtty(char *state);
extern void externaltalk(void);
extern char *fixfname(char *file, int protect);
extern char *loadfile(char *);
extern char *makeshowpath(char *path);
extern FILE *sfopen(char *path, char *mode);
extern char *getrcent(char *file, char *var);
extern void putrcent(char *file, char *var, char *val);
extern void uudecode(FILE *in, FILE *out);
extern void frombase64(FILE *in, FILE *out);

#else	/* !__STDC__ */

extern char *prompt_str();
extern char *sysmsg();
extern char *itoa();
extern char *strippath();
extern char *skiplp();
extern char *sec2str();
extern char *get_env();
extern char *strlwr();
extern char *strupr();
extern char *strnlwr();
extern char *strnupr();
extern char *__strcasestr();
extern char *makestrotime();
extern void quit();
extern char *setarea();
extern char *getarea();
extern char *getfileconf();

/* userconf.c */
extern char *getuserconf();
extern void putuserconf();

extern char *strdupf();
extern char *strdupf();
extern int display();
extern int invoke_syscmd();
extern int invoke_cmd();
extern void vproctitle();
extern void proctitle();

extern char *getsysconf();
extern char *mesgtty();
extern void externaltalk();
extern char *fixfname();
extern char *loadfile();
extern char *makeshowpath();
extern FILE *sfopen();
extern char *getrcent();
extern void putrcent();
extern void uudecode();
extern void frombase64();

#endif	/* !__STDC__ */

#endif	/* !_TNS_DRIVE_H_ */
