/*
 *	Copyright (c) 1994,1995 The CAD lab of the
 *	Siberian State Academy of Telecommunication, RU
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef _ZMDM_H
#define _ZMDM_H

#ifdef ZMDM
#define EXTERN
#else
#define EXTERN extern
#endif

#ifndef	TRUE
#define TRUE  1
#define FALSE 0
#endif

#define ENDOFFRAME 2
#define FRAMEOK    1
#define TIMEOUT   -1	/* rx routine did not receive a character within timeout */
#define INVHDR    -2	/* invalid header received; but within timeout */
#define INVDATA   -3	/* invalid data subpacket received */
#define ZDLEESC 0x8000	/* one of ZCRCE; ZCRCG; ZCRCQ or ZCRCW was received; ZDLE escaped */

#define HDRLEN     5	/* size of a zmodme header */

EXTERN unsigned char rxd_header[ZMAXHLEN];	/* last received header */
EXTERN int rxd_header_len;			/* last received header size */

/*
 * receiver capability flags
 * extracted from the ZRINIT frame as received
 */
EXTERN int can_fcs_32;
EXTERN int escape_all_control_characters;	/* guess */
EXTERN int use_variable_headers;	/* use variable length headers */

EXTERN void fd_init(void);	/* make the io channel raw */
EXTERN void fd_exit(void);	/* reset io channel to state before zmodem was called */
EXTERN void tx_hheader(unsigned char * buf,int n);
EXTERN void tx_bheader(unsigned char * buf,int n);
EXTERN int rx_header(int to);	/* receive any header with timeout in milliseconds */

#endif
