/*
 *	Copyright (c) 1994 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef		TRUE
#define		TRUE		1
#define		FALSE		0
#endif

#define	USESPOOL		1
#define	USENNTP			2
#define	READ_NEWS_MODE		(USESPOOL|USENNTP)
#define	INN_NNTP_SERVER		4
#define	XOVER_SUPPORTED		8

#define	WRITEARTICLE	".article"
#define	WRITELETTER	".letter"
#define	NEWNEWSRC	".newnewsrc"
#define	DELGROUPS	".delgroups"
#define	INDEXDIR	".index"
#define	NEWSGROUPS	".newsgroups"

#define		MAX_PAGES	1000
#define		NOTE_UNAVAIL	-1

#define		LEN		1024
#define		TABLE_SIZE	1409		/* should be prime */
#define		COLS		80


struct header {
	long artnum;		/* Article number */
	char *subject;		/* Subject: line from mail header */
	char *from;		/* From: line from mail header */
	int thread;
	int inthread;
	int unread;		/* has this article been read? */
				/* 0 = read, 1 = unread, 2 = will return */
	long date;		/* Date: line from header in seconds */
};

/*
 *  header.artnum:
 *	article number in spool directory for group
 *
 *  header.thread:
 *	initially -1
 *	points to another arts[] (struct header): zero and up
 *	-2 means article has expired (wasn't found in file search
 *	of spool directory for the group)
 *
 *  header.inthread:
 *	FALSE for the first article in a thread, TRUE for all
 *	following articles in thread
 *
 *  header.read:
 *	boolean, has this article been read or not
 */

struct group_ent {
	char *name;		/* newsgroup name */
	char *desc;		/* newsgroup description */
	long max;		/* max. article number */
	long min;		/* min. article number */
	int next;		/* next active entry in hash chain */
	int flag;
};

#define		NOTGOT		0x01	/* haven't put in my_group yet */
#define		SUBS		0x02	/* subscribed to */
#define		ctrl(c)		((c) & 0x1F)

extern int top;
extern struct header *arts;
extern long *base;
extern int max_art;

extern char *writearticle;
extern char *indexdir;
extern char *newsrc;
extern char *newnewsrc;
extern char *delgroups;
extern int top_base;
extern int group_hash[];

extern int num_active;
extern struct group_ent *active;
extern int *my_group;
extern int *unread;
extern int max_active;

extern int local_top;
extern char *eat_re();
extern int update;
extern char *h;
extern char cstate[];
extern int local_index;

#ifndef _STRING_H
extern char *strcpy();
extern char *strncat();
extern char *strncpy();
#endif

extern long atol();
extern void make_group_path();

extern int note_line;
extern int note_page;
extern long note_mark[];
extern int note_end;
extern int rotate;
extern int last_resp;
extern int this_resp;

extern int usenetinuse;

/* parsedate.y */
extern time_t parsedate(/* char *p, TIMEINFO *now */);

#ifdef	HAVE_ANSI_ASSERT
#define	assert(p)	if(! (p)) asfail(__FILE__, __LINE__, #p); else
#else
#define	assert(p)	if(! (p)) asfail(__FILE__, __LINE__, "p"); else
#endif
