/* set screen width (for command wrapping) */
extern void ripio_set_width(unsigned int width);

/* obtain current screen width setting */
extern unsigned int ripio_get_width(void);

/* [internal] begin a RIPscrip command */
extern void ripio_command(int baggage);

/* end RIPscrip command line */
extern void ripio_flush(void);

/* [internal] output an unsigned int in base 36 */
extern void ripio_meganum(unsigned int value, int digits);

/* [internal] output a text string */
extern void ripio_text(const char *string);

/* Query RIPscrip version number */
extern void ripio_query(void);

/* Disables all RIPscrip processing */
extern void ripio_disable(void);

/* Enables RIPscrip processing */
extern void ripio_enable(void);

/* ----- RIPscrip V2.A1 functions ----- */

/* Header command for subsequent RIPscrip sequence */
extern void rip_header(unsigned int flags, unsigned int revision, unsigned int res);

/* Sets the base math for most RIPscrip parameters */
extern void rip_set_base_math(unsigned int base_math);

/* Sets the base math for most RIPscrip parameters */
extern void rip_set_coordinate_size(unsigned int byte_size, unsigned int res);

/* Sets the coordinate for the World Frame */
extern void rip_set_world_frame(unsigned int x_dim, unsigned int y_dim);

/* Define the size and location of the Text Window */
extern  void rip_text_window(unsigned int x0, unsigned int y0, unsigned int x1,
			     unsigned int y1, unsigned int wrap, unsigned int size);

/* Define the size & location of the Graphics Window */
extern void rip_viewport(unsigned int x0, unsigned int y0, unsigned int x1,
			 unsigned int y1);

/* Sets the coordinates for the Drawing Frame */
extern void rip_set_drawing_frame(unsigned int x_dim, unsigned int y_dim);

/* Clear Graphics/Text Windows & reset to full screen */
extern void rip_reset_windows(void);

/* Clears Text Window to current background color */
extern void rip_erase_window(void);

/* Clear Graphics Window to current background color */
extern void rip_erase_view(void);

/* Move text cursor to row & column in Text Window */
extern void rip_gotoxy(unsigned int x, unsigned int y);

/* Move cursor to upper-left corner of Text Window */
extern void rip_home(void);

/* Erase current line from cursor to end of line */
extern void rip_erase_eol(void);

/* Set current Drawing Color for graphics */
extern void rip_color(unsigned int color);
#define RIP_BLACK		0
#define RIP_BLUE		1
#define RIP_GREEN		2
#define RIP_CYAN		3
#define RIP_RED			4
#define RIP_MAGENTA		5
#define RIP_BROWN		6
#define RIP_LIGHTGRAY		7
#define RIP_DARKGRAY		8
#define RIP_LIGHTBLUE		9
#define RIP_LIGHTGREEN		10
#define RIP_LIGHTCYAN		11
#define RIP_LIGHTRED		12
#define RIP_LIGHTMAGENTA	13
#define RIP_YELLOW		14
#define RIP_WHITE		15
#define RIP_BACKGROUND		0

/* Set background Drawing Color for graphics */
extern void rip_back_color(unsigned int color);

/* Set 16-color Palette from master 64-color palette */
extern void rip_set_palette(unsigned int c1, unsigned int c2, unsigned int c3,
			    unsigned int c4, unsigned int c5, unsigned int c6, unsigned int c7,
			    unsigned int c8, unsigned int c9, unsigned int c10, unsigned int c11,
			    unsigned int c12, unsigned int c13, unsigned int c14,unsigned int c15,
			    unsigned int c16);
#define RIP_EGA_BLACK		0
#define RIP_EGA_BLUE		1
#define RIP_EGA_GREEN		2
#define RIP_EGA_CYAN		3
#define RIP_EGA_RED		4
#define RIP_EGA_MAGENTA		5
#define RIP_EGA_BROWN		20
#define RIP_EGA_LIGHTGRAY	7
#define RIP_EGA_DARKGRAY	56
#define RIP_EGA_LIGHTBLUE	57
#define RIP_EGA_LIGHTGREEN	58
#define RIP_EGA_LIGHTCYAN	59
#define RIP_EGA_LIGHTRED	60
#define RIP_EGA_LIGHTMAGENTA	61
#define RIP_EGA_YELLOW		62
#define RIP_EGA_WHITE		63

/* Set color of 16-color Palette from Master Palette */
extern void rip_one_palette(unsigned int color, unsigned int value);

/* Set Drawing Palette entries to RGB colors */
extern void rip_set_drawing_palette();

/* Set Drawing Palette entries to RGB colors */
extern void rip_one_drawing_palette(unsigned int entry, unsigned int bits,
				    unsigned int rgb_color);

/* Set the Color Drawing Mode (MAP or DIRECT RGB) */
extern void rip_set_color_mode(unsigned int mode, unsigned int bits);
#define	RIP_COLOR_MAPPING	0
#define	RIP_DIRECT_RGB		1

/* Set drawing mode for graphics primitives */
extern void rip_write_mode(unsigned int mode);
#define RIP_COPY_MODE	0
#define RIP_XOR_MODE	1
#define	RIP_OR_MODE	2
#define	RIP_AND_MODE	3
#define	RIP_NOT_MODE	4

/* Move the current drawing position to (X,Y) */
extern void rip_move(unsigned int x, unsigned int y);

/* Draw text in current font/color at current spot */
extern void rip_text(const char *text_string);

/* Draw text in current font/color at specific spot */
extern void rip_text_xy(unsigned int x, unsigned int y, const char *text_string);

/* Select current font style, orientation and size */
extern void rip_font_style(unsigned int font, unsigned int direction, unsigned int size,
			   unsigned int h_align, unsigned int v_align);
/* font */
#define RIP_DEFAULT_FONT		0
#define RIP_TRIPLEX_FONT		1
#define RIP_SMALL_FONT			2
#define RIP_SANS_SERIF_FONT		3
#define RIP_GOTHIC_FONT			4
#define RIP_SCRIPT_FONT			5
#define RIP_SIMPLE_FONT			6
#define RIP_TRIPLEX_SCRIPT_FONT		7
#define RIP_COMPLEX_FONT		8
#define RIP_EUROSTYLE_FONT		9
#define RIP_BOLD_FONT			10

/* direction */
#define RIP_HORIZ_DIR			0
#define RIP_VERT_DIR			1

/* h_align */
#define	RIP_HALIGN_LEFT			0
#define	RIP_HALIGN_RIGHT		1
#define	RIP_HALIGN_CENTER		2

/* v_align */
#define	RIP_VALIGN_TOP			0
#define	RIP_VALIGN_BOTTOM		1
#define	RIP_VALIGN_CENTER		2
#define	RIP_VALIGN_BASELINE		3

/* Select current font style, orientation and size */
extern void rip_extended_font(unsigned int direction, unsigned int size,
			      unsigned int style, unsigned int h_align,
			      unsigned int v_align, const char *font_name_string);
/* direction in degrees */
#define	RIP_DEGREES_HORIZ	0
#define	RIP_DEGREES_VERT	90

/* style -- bit mapped */
#define	RIP_FONTSTYLE_NORMAL	0
#define	RIP_FONTSTYLE_BOLD	1
#define	RIP_FONTSTYLE_ITALIC	2
#define	RIP_FONTSTYLE_STRIKE	4
#define	RIP_FONTSTYLE_UNDERLINE	8

/* Draws one pixel using current drawing color */
extern void rip_pixel(unsigned int x, unsigned int y);

/* Draw a line in the current color/line style */
extern void rip_line(unsigned int x0, unsigned int y0, unsigned int x1,
		     unsigned int y1);

/* Draw a rectangle in current color/line style */
extern void rip_rectangle(unsigned int x0, unsigned int y0, unsigned int x1,
			  unsigned int y1);

/* Draw filled rectangle with fill color/pattern */
extern void rip_bar(unsigned int x0, unsigned int y0, unsigned int x1,
		    unsigned int y1);

/* Draw circle in current color and line thickness */
extern void rip_circle(unsigned int x_center, unsigned int y_center,
		       unsigned int radius);
#define RIP_EGA_ASPECT_RATIO (31.0/40.0)

/* Draw elliptical arc in current color/line style */
extern void rip_oval(unsigned int x, unsigned int y, unsigned int st_ang,
		     unsigned int end_ang, unsigned int x_rad, unsigned int y_rad);

/* Draw filled ellipse using current color/pattern */
extern void rip_filled_oval(unsigned int x_center, unsigned int y_center,
			    unsigned int x_rad, unsigned int y_rad);

/* Draw circular arc in current color/line thickness */
extern void rip_arc(unsigned int x, unsigned int y, unsigned int st_ang,
		    unsigned int end_ang, unsigned int radius);

/* Draw an elliptical arc */
extern void rip_oval_arc(unsigned int x, unsigned int y, unsigned int st_ang,
			 unsigned int e_ang, unsigned int radx, unsigned int rady);

/* Draws a circular pie slice */
extern void rip_pie_slice(unsigned int x, unsigned int y, unsigned int st_ang,
			  unsigned int end_ang, unsigned int radius);

/* Draws an elliptical pie slice */
extern void rip_oval_pie_slice(unsigned int x, unsigned int y,
			       unsigned int st_ang, unsigned int e_ang,
			       unsigned int radx, unsigned int rady);

/* Draw a bezier curve */
extern void rip_bezier(unsigned int x1, unsigned int y1, unsigned int x2,
		       unsigned int y2, unsigned int x3, unsigned int y3,
		       unsigned int x4, unsigned int y4, unsigned int cnt);

/* Draw poly-bizier curve (multi-segmented) */
extern void rip_poly_bizier(unsigned int num, ...);

/* Draw polygon in current color/line-style */
extern void rip_polygon(unsigned int npoints, ...);

/* Draw filled polygon in current color/fill pattern */
extern void rip_fill_polygon(unsigned int npoints, ...);

/* Draw a Poly-Line (multi-faceted line) */
extern void rip_polyline(unsigned int npoints, ...);

/* Flood fill screen area with current fill settings */
extern void rip_fill(unsigned int x, unsigned int y, unsigned int border);

/* Defines a line style and thickness */
extern void rip_line_style(unsigned int odd_draw, unsigned int style,
			   unsigned int user_pat, unsigned int thick);
/* odd_draw */
#define	RIP_TRANSPARENT_SPACES	0
#define	RIP_BACKGROUND_SPACES	1

/* style */
#define RIP_SOLID_LINE		0
#define RIP_DOTTED_LINE		1
#define RIP_CENTER_LINE		2
#define RIP_DASHED_LINE		3
#define RIP_USERBIT_LINE	4

/* thick */
#define RIP_NORM_WIDTH		1
#define RIP_THICK_WIDTH		3

/* Set current fill style (predefined) & fill color */
extern void rip_fill_style(unsigned int pattern, unsigned int color);
#define RIP_EMPTY_FILL		0
#define RIP_SOLID_FILL		1
#define RIP_LINE_FILL		2
#define RIP_LTSLASH_FILL	3
#define RIP_SLASH_FILL		4
#define RIP_BKSLASH_FILL	5
#define RIP_LTBKSLASH_FILL	6
#define RIP_HATCH_FILL		7
#define RIP_XHATCH_FILL		8
#define RIP_INTERLEAVE_FILL	9
#define RIP_WIDE_DOT_FILL	10
#define RIP_CLOSE_DOT_FILL	11

/* Set user-definable (custom) fill pattern/color */
extern void rip_fill_pattern(unsigned int c1, unsigned int c2, unsigned int c3,
		      unsigned int c4, unsigned int c5, unsigned int c6,
		      unsigned int c7, unsigned int c8, unsigned int col);

/* End of RIPscrip Scene */
extern void rip_no_more(void);

/* Defines a rectangular hot mouse region */
extern void rip_mouse(unsigned int num, unsigned int x0, unsigned int y0,
		      unsigned int x1, unsigned int y1, unsigned int clk,
		      unsigned int clr, unsigned int res, const char *text);

/* Destroys all previously defined hot mouse regions */
extern void rip_kill_mouse_fields(void);

/* Destroys any Mouse Fields inside a region */
extern void rip_kill_enclosed_mouse_fields(unsigned int x0, unsigned int y0,
					   unsigned int x1, unsigned int y1,
					   unsigned int flags);

/* Define a rectangular text region */
extern void rip_begin_text(unsigned int x1, unsigned int y1, unsigned int x2,
			   unsigned int y2, unsigned int res);

/* Display a line of text in rectangular text region */
extern void rip_region_text(unsigned int justify, const char *text_string);

/* End a rectangular text region */
extern void rip_end_text(void);

/* Copy rectangular image to clipboard (as icon) */
extern void rip_get_image(unsigned int x0, unsigned int y0, unsigned int x1,
			  unsigned int y1, unsigned int clipboard_no);

/* Pastes the clipboard contents onto the screen */
extern void rip_put_image(unsigned int x, unsigned int y, unsigned int clipboard_no,
			  unsigned int mode, unsigned int res);

/* Write contents of the clipboard (icon) to disk */
extern void rip_write_icon(unsigned int clipboard_no, const char *filename);

/* Loads and displays a disk-based icon to screen */
extern void rip_load_icon(unsigned int x, unsigned int y, unsigned int clipboard_no,
			  unsigned int mode, unsigned int clipboard, 
			  unsigned int res, const char *filename);
/* clipboard */
#define	RIP_LOAD_VERBATIM	0
#define	RIP_LOAD_CLIPBOARD	1

/* Loads and displays a disk-based bitmap to screen */
extern void rip_load_bitmap(unsigned int x0, unsigned int y0, unsigned int x1,
			    unsigned int y1, unsigned int clipboard_no,
			    unsigned int mode, unsigned int palette,
			    unsigned int dither, unsigned int clipboard,
			    unsigned int res, const char *filename);

/* Display a scalable photo type image */
extern void rip_image(unsigned int res, const char *filename);

/* Alter subsequent displayed image settings */
extern void rip_image_style(unsigned int x0, unsigned int y0, unsigned int x1,
			    unsigned int y1, unsigned int flags, unsigned int res);

/* Button style definition */
extern void rip_button_style(unsigned int wid, unsigned int hgt, unsigned int orient,
			     unsigned int flags, unsigned int size, unsigned int dfore,
			     unsigned int dback, unsigned int bright, unsigned int dark,
			     unsigned int surface, unsigned int grp_no,
			     unsigned int flags2, unsigned int uline_col,
			     unsigned int corner_col, unsigned int clipboard_no,
			     unsigned int slot, unsigned int res);

/* Define a Mouse Button */
extern void rip_button(unsigned int x0, unsigned int y0, unsigned int x1,
		       unsigned int y1, unsigned int hotkey, unsigned int flags,
		       unsigned int slot, const char *text);

/* Define a text variable */
extern void rip_define(unsigned int flags, unsigned int res, const char *text);

/* Defines a scroller interface object */
extern void rip_scroller(unsigned int id, unsigned int x0, unsigned int y0,
			 unsigned int x1, unsigned int y1, unsigned int entries,
			 unsigned int cur_ent, unsigned int page_size,
			 unsigned int flags, unsigned int size, unsigned int bright,
			 unsigned int dark, unsigned int surface, unsigned int corner,
			 unsigned int res, const char *host_string);

/* Query the contents of a text variable */
extern void rip_query(unsigned int mode, unsigned int window_num,
		      unsigned int res, const char *text);

/* Copy (scroll) screen region up/down */
extern void rip_scroll(unsigned int x0, unsigned int y0, unsigned int x1,
		       unsigned int y1, unsigned int mode, unsigned int res,
		       unsigned int dest_line);

/* Copy a screen area to a new location (bit blit) */
extern void rip_copy_blit(unsigned int x0, unsigned int y0, unsigned int x1,
			  unsigned int y1, unsigned int dx0, unsigned int dy0,
			  unsigned int mode, unsigned int res);

/* Playback local .RIP file */
extern void rip_read_scene(unsigned int res, const char *filename);

/* Query existing information on a particular file */
extern void rip_file_query(unsigned int mode, unsigned int res,
			   const char *filename);

/* Alter the current mouse cursor shape that is shown on the screen */
extern void rip_set_mouse_cursor(unsigned int cursor_style, unsigned int res);

/* Switch to another Text Window (activate) */
extern void rip_switch_text_window(unsigned int window_num, unsigned int res);

/* Switch to another Graphics Viewport (activate) */
extern void rip_switch_viewport(unsigned int viewport_num, unsigned int res);

/* Switches to a new Drawing Style Context */
extern void rip_switch_style(unsigned int style_num, unsigned int res);

/* Sets a sequence to send host to refresh display */
extern void rip_set_refresh(unsigned int res, const char *refresh_string);

/* Causes the Client Terminal to Pause */
extern void rip_delay(unsigned int delay_period);

/* Set Baud Rate Emulation for Local RIP Playback */
extern void rip_baud_emulation(unsigned int rate_val);

/* Begins a bitmap animated motion sequence */
extern void rip_animate(unsigned int res, unsigned int clipboard_no, unsigned int pages,
			unsigned int page_inc, unsigned int flags, unsigned int invis_color,
			unsigned int res2, unsigned int x0, unsigned int y0,
			unsigned int segments, ...);

/* Controls animation sequences */
extern void rip_animation_control(unsigned int mode, unsigned int res);

/* Enter block transfer mode with host */
extern void rip_enter_block_mode(unsigned int mode, unsigned int proto,
				 unsigned int file_type, unsigned int res,
				 const char *filename);

/* Begin a generic UU-Encoded data block */
extern void rip_begin_uuencode_block(unsigned int file_type, unsigned int res);

/* Begin RIF streamable image block */
extern void rip_display_rif_image();

/* ----- vector interfaces ----- */

/* Set 16-color Palette from master 64-color palette */
extern void ripv_set_palette(unsigned char colors[16]);

/* Draw polygon in current color/line-style */
extern void ripv_polygon(unsigned int npoints, unsigned short *polypoints);

/* Draw filled polygon in current color/fill pattern */
extern void ripv_fill_polygon(unsigned int npoints,
    unsigned short *polypoints);

/* Draw a Poly-Line (multi-faceted line) */
extern void ripv_polyline(unsigned int npoints, unsigned short *polypoints);

/* Set user-definable (custom) fill pattern/color */
extern void ripv_fill_pattern(unsigned char upattern[8], unsigned int color);
