/*
 * Copyright (c) 1995 by KrutoyMuzi Inc., (Victor Malov)
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "compat.h"
#include "parseftp.h"

/*
 * Returns the number of the month given or -1 on error.
 */
int
Str2Month(str)
	char *str;
{
	register i;
	extern char *month[];

	if (str != NULL) {
		for (i = 0; i < 12; i++)
			if (!strncasecmp(str, month[i], 3))
				return i;
	}
	return -1;
}

/*
 * Converts a date string from 'ls -l' to a time_t number.
 * This is needed in order to put out the date using the same format 
 * using the same format for a directory listings.
 */
time_t
Str2Time(Month, Day, Time, Year)
	char *Month, *Day, *Time, *Year;
{
	struct tm *time_info;		/* Points to static tm strcture */
	char *s;
	time_t tval;

	if (!Month || !Day || !Time) return 0;

	tval = time(NULL);
	if ((time_info = gmtime(&tval)) == NULL) return 0;

	time_info->tm_isdst = -1;		/* disable summer time */
	if ((time_info->tm_mon = Str2Month(Month)) < 0) return 0;

	time_info->tm_mday = atoi(Day);
	time_info->tm_wday = 0;
	time_info->tm_yday = 0;

	if ((s = strchr(Time, ':')) == NULL) {
		time_info->tm_year = atoi(Time) % 100;
		time_info->tm_sec = 0;
		time_info->tm_min = 0;
		time_info->tm_hour = 0;
	} else {						     
	/* If the time is given as hh:mm, then the file is less than 1 year
	   old, but we might shift calandar year. This i avoided by checking 
	   if the date parse is future or not. */
		*s++ = '\0';
		time_info->tm_sec = 1;
		time_info->tm_min = atoi(s);		/* Right side of ':' */
		time_info->tm_hour = atoi(Time);	/* Left  side of ':' */
		if (mktime(time_info) > tval) --time_info->tm_year;
	}
	if (Year != NULL) {
		int year = atoi(Year) % 100;
		if (time_info->tm_year != year) {
			time_info->tm_year = year;
			time_info->tm_sec = 0;
			time_info->tm_min = 0;
			time_info->tm_hour = 0;
		}
	}
	tval = mktime(time_info);
	if (tval < 0) tval = 0;
	return tval;
}

/*
 * Converts the file type from 'ls -l' into a long.
 */
mode_t
Str2Mode(str)
	char *str;
{
	mode_t mode = 0;

	if (!str || !*str) return 0;
    
	/* Special files etc. are all handled like regular files */

	/* File type */
	switch (*str++) {			
		case 'd': mode = S_IFMT & S_IFDIR; break;
		case 'l': mode = S_IFMT & S_IFLNK; break;
		default:  mode = S_IFMT & S_IFREG; break;
	}

	/* User */
	if (*str++ == 'r') mode |= S_IRUSR;		
	if (*str++ == 'w') mode |= S_IWUSR;
	switch (*str++) {
		case 'x': mode |= S_IXUSR; break;
		case 's': mode |= (S_IXUSR | S_ISUID); break;
		case 'S': mode |= S_ISUID; break;
	}

	/* Group */
	if (*str++ == 'r') mode |= S_IRGRP;		           
	if (*str++ == 'w') mode |= S_IWGRP;
	switch (*str++) {
		case 'x': mode |= S_IXGRP; break;
		case 's': mode |= (S_IXGRP | S_ISGID); break;
		case 'S': mode |= S_ISGID; break;
	}

	/* Other */
	if (*str++ == 'r') mode |= S_IROTH;			   
	if (*str++ == 'w') mode |= S_IWOTH;
	switch (*str++) {
		case 'x': mode |= S_IXOTH; break;
		case 't': mode |= (S_IXOTH | S_ISVTX); break;
		case 'T': mode |= S_ISVTX; break;

	}
	return mode;
}

/*
 * Extract the name, size, and date from an 'ls' The function expects
 * the following or at of the ls-line:
 *
 * <permission> <nlink> <owner> [<group>] <size> <date> <filename>
 *
 * The group is not always present and is therefor optional. Both owner
 * and group can be numbers.
 *
 * Returns -1 on error.
 */
int
parse_ls_line(line, file)
	char *line;
	dir_file_info *file;
{
	char *column, *s[6];
	int i;

	if (!line || !*line || !file) return -1;

	/* Permissions */
	if ((column = strtok(line, " \t")) == NULL) return -1;
	if ((file->mode = Str2Mode(column)) == 0) return -1;

	/* Links */
	if ((column = strtok(NULL, " \t")) == NULL) return -1;
	file->nlink = atoi(column);

	/* Owner */
	if ((column = strtok(NULL, " \t")) == NULL) return -1;
	file->uid = column;

	/* Group and/or Size, Date, Time, Name */
	for (i = 0; i < 6; i++) {
		s[i] = strtok(NULL, " \t");
		if (s[i] == NULL) break;
	}
	if (i == 6 && Str2Month(s[2]) >= 0) {	/* Yes, group */
	/* s[0]->gid; s[1]->size; s[2]->Month; s[3]->Day; s[4]->Time; s[5]->Name */
		file->gid = s[0];
		file->size = atoi(s[1]);
		if ((file->mtime = Str2Time(s[2], s[3], s[4], NULL)) == 0)
			return -1;
		file->name = s[5];
		return 0;
	}
	if (i == 6 && Str2Month(s[1]) >= 0) {	/* Novell/HellSoft ftpd */
	/* s[0]->size; s[1]->Month; s[2]->Day; s[3]->Year; s[4]->Time; s[5]->Name */
		file->gid = NULL;
		file->size = atoi(s[0]);
		if ((file->mtime = Str2Time(s[1], s[2], s[4], s[3])) == 0)
			return -1;
		file->name = s[5];
		return 0;
	}
	if (i == 5 && Str2Month(s[1]) >= 0) {	/* No, group no! */
	/* s[0]->size; s[1]->Month; s[2]->Day; s[3]->Time; s[4]->Name */
		file->gid = NULL;
		file->size = atoi(s[0]);
		if ((file->mtime = Str2Time(s[1], s[2], s[3], NULL)) == 0)
			return -1;
		file->name = s[4];
		return 0;
	}
	return -1;
}
