/*
 *	Copyright (c) 1994 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "drive.h"
#include "usenet.h"

add_newsrc_group(group)
	char *group;
{
	int len, flag = FALSE;
	FILE *fp;
	char buf[8192];

	len = strlen(group);
	if ((fp = fopen(newsrc, "a+")) == NULL) {
		LOGIT(LOG_ERR, "can't create \"%s\": %m", newsrc);
		return;
	}
	rewind(fp);
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		if (strncmp(buf, group, len) == 0) {
			flag = TRUE;
			break;
		}
	}
	if (!flag) fprintf(fp, "%s: \n", group);
	fclose(fp);
}

/*
 *  Load the sequencer rang lists and mark arts[] according to the
 *  .newsrc info for a particular group.  i.e.  rec.arts.comics: 1-94,97
 */
read_newsrc_line(group)
	char *group;
{
	FILE *fp;
	char buf[8192];
	char *p;

	if ((fp = sfopen(newsrc, "r")) == NULL) return;
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		p = buf;
		while (*p && *p != '\n' && *p != ' ' && *p != ':' && *p != '!')
			p++;
		*p++ = '\0';
		if (strcmp(buf, group) != 0) continue;
		parse_seq(p);
		break;
	}
	sfclose(fp);
}

/*
 *  For our current group, update the sequencer information in .newsrc
 */
update_newsrc(group, groupnum)
	char *group;
	int groupnum;		/* index into active[] for this group */
{
	FILE *fp, *newfp;
	char buf[8192];
	char *p, c;

	if ((fp = sfopen(newsrc, "r")) == NULL) return;
	if ((newfp = sfopen(newnewsrc, "w")) == NULL) {
		sfclose(fp);
		return;
	}
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		if ((p = strchr(buf, '\n')) != NULL) *p = '\0';
		p = buf;
		while (*p && *p != ' ' && *p != ':' && *p != '!') p++;
		c = *p;
		if (c != '\0') *p++ = '\0';
		if (c != '!' && c != ' ') c = ':';
		if (strcmp(buf, group) == 0) {
			fprintf(newfp, "%s%c ", buf, c);
			print_seq(newfp, groupnum);
			fprintf(newfp, "\n");
		} else	fprintf(newfp, "%s%c%s\n", buf, c, p);
	}
	sfclose(fp);
	sfclose(newfp);
	unlink(newsrc);
	link(newnewsrc, newsrc);
	unlink(newnewsrc);
}

print_seq(fp, groupnum)
	FILE *fp;
	int groupnum;		/* index into active[] for this group */
{
	register i;
	int flag = FALSE;
	long artnum, artmax, last_read;
	extern int artnum_comp(), comparenews();

	assert(top >= 0);

	/* Sort into the same order as in the spool directory */
	if (top > 0) qsort(arts, top, sizeof(struct header), artnum_comp);

 	/*
 	 * Note that killed and expired articles do not appear in arts[].
 	 * So, even if top is 0 there may be sequencer info to output.
	 */
 	if (top > 0 && arts[top-1].artnum > active[groupnum].max)
 		artmax = arts[top-1].artnum;
 	else	artmax = active[groupnum].max;

 	for (artnum = 1, i = 0; artnum <= artmax; ++artnum, ++i) {
 		assert(i <= top);
 		if (i == top || !arts[i].unread || artnum != arts[i].artnum) {
  			if (flag) fprintf(fp, ",");
  			else flag = TRUE;
 			fprintf(fp, "%ld", artnum);
 			while (i < top && !arts[i].unread) i++;
  			last_read = (i < top ? arts[i].artnum - 1 : artmax);
 			if (last_read != artnum)
				fprintf(fp, "-%ld", last_read);
 			assert(i <= top);
 			if (i == top) break;
 			artnum = arts[i].artnum;
  		}
  	}
    	fflush(fp);

	/* Resort back into required sort order */
 	if (top > 0) qsort(arts, top, sizeof(struct header), comparenews);
	
/*
	if (top <= 0) {
		if (active[groupnum].min > 1) {
			fprintf(fp, "1-%ld", active[groupnum].min);
			fflush(fp);
		}
		return;
	}
	i = 0;
	if (arts[0].artnum > 1) {
		for (; i < top && !arts[i].unread; i++) ;
		if (i > 0) {
			if (i == top && arts[i-1].artnum < active[groupnum].max)
				fprintf(fp, "1-%ld", active[groupnum].max);
			else	fprintf(fp, "1-%ld", arts[i-1].artnum);
		} else	fprintf(fp, "1-%ld", arts[0].artnum - 1);
		flag = TRUE;
	}
	for (; i < top; i++) {
		if (!arts[i].unread) {
			if (flag) fprintf(fp, ",");
			else flag = TRUE;
			fprintf(fp, "%ld", arts[i].artnum);
			if (i+1 < top && !arts[i+1].unread) {
				while (i+1 < top && !arts[i+1].unread) i++;
				if (i+1 == top && arts[i].artnum < active[groupnum].max)
					fprintf(fp, "-%ld", active[groupnum].max);
				else	fprintf(fp, "-%ld", arts[i].artnum);
			}
		}
	}
	if (!flag && active[groupnum].min > 1)
		fprintf(fp, "1-%ld", active[groupnum].min);
	fflush(fp);
*/
}

parse_seq(s)
	char *s;
{
	long low, high;
	int i;

	while (*s) {
		while (*s && (*s < '0' || *s > '9')) s++;
		if (*s && *s >= '0' && *s <= '9') {
			low = atol(s);
			while (*s && *s >= '0' && *s <= '9') s++;
			if (*s == '-') {
				s++;
				high = atol(s);
				while (*s && *s >= '0' && *s <= '9') s++;
			} else	high = low;
			for (i = 0; i < top; i++)
				if (arts[i].artnum >= low && arts[i].artnum <= high)
					arts[i].unread = 0;
		}
	}
}

parse_unread(s, groupnum)
char *s;
int groupnum;			/* index for group in active[] */
{
	long low, high;
	long last_high;
	int sum = 0;
	int gotone = FALSE;
	int n;

/*
 *  Read the first range from the .newsrc sequencer information.  If the
 *  top of the first range is higher than what the active file claims is
 *  the bottom, use it as the new bottom instead
 */

	high = 0;
	if (*s) {
		while (*s && (*s < '0' || *s > '9'))
			s++;

		if (*s && *s >= '0' && *s <= '9') {
			low = atol(s);
			while (*s && *s >= '0' && *s <= '9')
				s++;
			if (*s == '-') {
				s++;
				high = atol(s);
				while (*s && *s >= '0' && *s <= '9')
					s++;
			}  else
				high = low;
			gotone = TRUE;
		}
	}

	if (high < active[groupnum].min)
		high = active[groupnum].min;

	while (*s) {
		last_high = high;

		while (*s && (*s < '0' || *s > '9'))
			s++;

		if (*s && *s >= '0' && *s <= '9') {
			low = atol(s);
			while (*s && *s >= '0' && *s <= '9')
				s++;
			if (*s == '-') {
				s++;
				high = atol(s);
				while (*s && *s >= '0' && *s <= '9')
					s++;
			}  else
				high = low;

			if (low > last_high)	/* otherwise seq out of order */
				sum += (low - last_high) - 1;
		}
	}

	if (gotone) {
		if (active[groupnum].max > high)
			sum += active[groupnum].max - high;
		return sum;
	}

	n = (int) (active[groupnum].max - active[groupnum].min);
	if (n < 2)
		return 0;

	return -1;
}

get_line_unread(group, groupnum)
char *group;
int groupnum;				/* index for group in active[] */
{
	FILE *fp;
	char buf[8192];
	char *p;
	int ret = -1;

	fp = sfopen(newsrc, "r");
	if (fp == NULL)
		return -1;

	while (fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		p = buf;
		while (*p && *p != '\n' && *p != ' ' && *p != ':' && *p != '!')
			p++;
		*p++ = '\0';
		if (strcmp(buf, group) != 0)
			continue;
		ret = parse_unread(p, groupnum);
		break;
	}

	sfclose(fp);
	return ret;
}

/*
reset_newsrc()
{
	FILE *fp;
	FILE *newfp;
	char buf[8192];
	char *p;
	char c;
	int gotit = FALSE;
	int i;

	fp = sfopen(newsrc, "r");
	if ((newfp = sfopen(newnewsrc, "w")) == NULL) goto update_done;
	if (fp != NULL) {
		while (fgets(buf, sizeof(buf), fp) != NULL) {
			buf[sizeof(buf)-1] = '\0';
			for (p = buf; *p && *p != '\n'; p++) ;
			*p = '\0';

			p = buf;
			while (*p && *p != ' ' && *p != ':' && *p != '!')
					p++;
			c = *p;
			if (c != '\0')
				*p++ = '\0';

			if (c != '!')
				c = ':';

			fprintf(newfp, "%s%c\n", buf, c);
		}
		sfclose(fp);
	}

	sfclose(newfp);
	unlink(newsrc);
	link(newnewsrc, newsrc);
	unlink(newnewsrc);

update_done:
	for (i = 0; i < local_top; i++)
		unread[i] = -1;
}
*/

mark_group_read(group, groupnum)
char *group;
int groupnum;			/* index into active[] for this group */
{
	FILE *fp;
	FILE *newfp;
	char buf[8192];
	char *p;
	char c;
	int gotit = FALSE;

	if (active[groupnum].max < 2) return;

	fp = sfopen(newsrc, "r");
	if ((newfp = sfopen(newnewsrc, "w")) == NULL) return;
	if (fp != NULL) {
		while (fgets(buf, sizeof(buf), fp) != NULL) {
			buf[sizeof(buf)-1] = '\0';
			for (p = buf; *p; p++)
				if (*p == '\n') {
					*p = '\0';
					break;
				}

			p = buf;
			while (*p && *p != ' ' && *p != ':' && *p != '!')
					p++;
			c = *p;
			if (c != '\0')
				*p++ = '\0';

			if (c != '!')
				c = ':';

			if (strcmp(buf, group) == 0) {
				fprintf(newfp, "%s%c 1-%ld\n", buf, c,
						active[groupnum].max);
				gotit = TRUE;
			} else
				fprintf(newfp, "%s%c%s\n", buf, c, p);
		}
		sfclose(fp);
	}

	sfclose(newfp);
	unlink(newsrc);
	link(newnewsrc, newsrc);
	unlink(newnewsrc);
}

hangnewsrc()
{
	extern int curgrpidx;

	if ((globalflags & USENETREADERINUSE) &&
	    curgrpidx >= 0 && active != NULL && my_group != NULL)
		update_newsrc(active[my_group[curgrpidx]].name,
			      my_group[curgrpidx]);
}
