/*
 *	Copyright (c) 1994,1995 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#ifdef	__STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <time.h>

#include "drive.h"
#include "sysmsg.h"
#include "usenet.h"
#include "group.h"
#include "rematch.h"
#include "variables.h"
#include "loginfo.h"

#define	MAX_CMD_PARAMS	20

extern struct loginfo process;

char *delgroups;
char *newsrc;
char *newnewsrc;
char *indexdir;
char *writearticle;
char *writeletter;
char *workdir;

char subject_search_string[LEN+1];
char author_search_string[LEN+1];
char body_search_string[LEN+1];


/*
 * Deterimines users path for an rc file in the home directory, etc.
 */
init_selfinfo()
{
	extern char *langname, readfilesdir[];

	if (globalflags & LANGPRESELECTED)
		putuserconf(LANGUAGE, langname);
	else if (language(getuserconf(LANGUAGE, DEFLANGUAGE)) <= 0) {
		LOGIT(LOG_CRIT, "can't reinitialize language");
		quit(1);
	}
	workdir = strdupf("%s/%s", orgdir, DEFUPLOADPATH);
	if (mkdir(workdir, 0750) < 0 && errno != EEXIST) {
		LOGIT(LOG_CRIT, "can't mkdir \"%s\": %m", workdir);
		quit(1);
	}
	indexdir = strdupf("%s/%s", homedir, INDEXDIR);
	if (mkdir(indexdir, 0750) < 0 && errno != EEXIST) {
		LOGIT(LOG_CRIT, "can't mkdir \"%s\": %m", indexdir);
		quit(1);
	}
	writearticle = strdupf("%s/%s", homedir, WRITEARTICLE);
	writeletter = strdupf("%s/%s", homedir, WRITELETTER);
	newsrc = strdupf("%s/%s", homedir, NEWS_RC);
	newnewsrc = strdupf("%s/%s", homedir, NEWNEWSRC);
	delgroups = strdupf("%s/%s", homedir, DELGROUPS);
	initmailarea();
	initfilearea();
	initusenetarea();
	initftparea();
	(void)strcpy(readfilesdir, getsysconf(READFILESDIR, DEFREADFILES));
}

/*
 * clobber argv so ps will show what we're doing.
 * stolen from sendmail
 */
void
#ifdef	__STDC__
vproctitle(char *fmt, va_list ap)
#else
vproctitle(fmt, ap)
	char *fmt;
	va_list ap;
#endif
{
	register i;
	char *p, buf[200];
	extern char **Argv, *LastArgv;

	(void) strcpy(buf, process.name);
	i = strlen(buf);
	if (usergroup != NULL) {
		strcat(buf, " <");
		i += 2;
		if (process.flags & CHARGEUSER)	buf[i++] = 'C';
		else				buf[i++] = 'R';
		if (process.flags & HIDDENUSER)	buf[i++] = 'H';
		if (process.flags & INFINITYUSER)	buf[i++] = 'I';
		if (process.flags & TERMINATOR)	buf[i++] = 'T';
		else if (process.flags & KICKER)	buf[i++] = 'K';
		sprintf(&buf[i], ",%d,%s>", privlevel, usergroup);
		i += strlen(&buf[i]);
	}
	(void) strcat(buf, ": ");
	i += 2;

	(void) vsnprintf(&buf[i], sizeof(buf)-i, fmt, ap);

	p = Argv[0];
	*p++ = '-';
	i = strlen(buf);
	if (i > LastArgv - p - 2) {
		i = LastArgv - p - 2;
		buf[i] = '\0';
	}
	(void) strcpy(p, buf);
/*
	p += i;
	while (p < LastArgv) *p++ = ' ';
*/
}

void
#ifdef	__STDC__
proctitle(char *fmt, ...)
#else
proctitle(fmt, va_alist)
	char *fmt;
	va_dcl
#endif
{
	va_list ap;
#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	vproctitle(fmt, ap);
	va_end(ap);
}

int
#ifdef	__STDC__
strcatf(char *catbuf, const char *fmt, ...)
#else
strcatf(catbuf, fmt, va_alist)
	char *catbuf;
	const char *fmt;
	va_dcl
#endif
{
	int i;
	char buf[LEN];
	va_list ap;

#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	i = vsnprintf(buf, LEN, fmt, ap);
	va_end(ap);
	(void)strcat(catbuf, buf);
	return i;
}

char *
#ifdef	__STDC__
strdupf(char *fmt, ...)
#else
strdupf(fmt, va_alist)
	char *fmt;
	va_dcl
#endif
{
	char *ptr, buf[LEN];
	va_list ap;

#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void) vsnprintf(buf, LEN, fmt, ap);
	va_end(ap);
	if ((ptr = strdup(buf)) == NULL) {
		LOGIT(LOG_CRIT, "Can't allocate memory");
		quit(1);
	}
	return ptr;
}

int
#ifdef	__STDC__
put_env(char *fmt, ...)
#else
put_env(fmt, va_alist)
	char *fmt;
	va_dcl
#endif
{
	char buf[LEN];
	va_list ap;

#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void) vsnprintf(buf, LEN, fmt, ap);
	va_end(ap);
	return putenv(buf);
}

int
legalfname(ptr)
	char *ptr;
{
	char *ptr2;

	if (strlen(ptr) < 3) {
		warning(MSG_SHORTFILENAME, 1);
		return FALSE;
	}
	if (*ptr == '.' || *ptr == '#' || *ptr == '-'|| *ptr == '$') {
		warning(MSG_BADFIRSTCHAR, 1);
		return FALSE;
	}
	if ((ptr2 = strpbrk(ptr, "*/\\|`<>!;:&,% \t")) != NULL) {
		putstr(" '%c'", *ptr2);
		warning(MSG_BADCHARINFNAME, 1);
		return FALSE;
	}
	if (!strcmp(ptr, DEFFILESLIST)) {
		warning(MSG_FNAMERESERVED, 1);
		return FALSE;
	}
	return TRUE;
}

/* Check and try to correct file name */
char *
fixfname(name, protect)
	char *name;
	int protect;
{
	register char *ptr, *ptr2;

	if ((ptr = strrchr(name, '\\')) != NULL) ptr++;
	else ptr = name;
	ptr = strippath(ptr);
	while (*ptr == '.' || *ptr == '#'|| *ptr == '-' || *ptr == '$') ptr++;
	if (protect) {
		for (ptr2 = strlwr(ptr); *ptr2; ptr2++)
			if (strchr("*/\\|`<>!;:&,% \t", *ptr2) != NULL)
				*ptr2 = '_';
/*		if (!strcmp(ptr, DEFFILESLIST)) {
			warning(MSG_FNAMERESERVED, 1);
			*ptr = '\0';
		}
*/	}
	return ptr;
}

int
nopermission(grf)
	int grf;
{
	int len;
	char buf[40];

	nchr = buf[0] = 0;
	if (grf & GRF_S) strcat(buf, " SCAN");
	if (grf & GRF_R) strcat(buf, " READ");
	if (grf & GRF_W) strcat(buf, " WRITE");
	if (grf & GRF_D) strcat(buf, " DEL");
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[1;31m");
	putstr("%s %s! ", buf, sysmsg(MSG_NOPERMISSION));
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[0;37m");
	anykey();
	putchr('\n');
	return 0;
}

/*
 *  Which base note (an index into base[]) does a respnum
 *  (an index into arts[]) corresponsd to?
 *
 *  In other words, base[] points to an entry in arts[] which is
 *  the head of a thread, linked with arts[].thread.  For any q: arts[q],
 *  find i such that base[i]->arts[n]->arts[o]->...->arts[q]
 */
which_base(n)
	int n;
{
	register i, j;

	for (i = 0; i < top_base; i++)
		for (j = base[i]; j >= 0; j = arts[j].thread)
			if (j == n) return i;
	LOGIT(LOG_ERR, "which_base: can't find base article");
	return 0;
}

/*
 *  Find how deep in a thread a response is.  Start counting at zero
 */
which_resp(n)
	int n;
{
	register i;
	int num = 0;

	for (i = base[which_base(n)]; i != -1; i = arts[i].thread)
		if (i == n) break;
		else num++;
	return num;
}

/*
 *  Given an index into base[], find the number of responses for
 *  that basenote
 */
nresp(n)
	int n;
{
	int i;
	int oldi = -3;
	int sum = 0;

	assert(n < top_base)
	for (i = base[n]; i != -1; i = arts[i].thread) {
		assert(i != -2)
		assert(i != oldi)
		oldi = i;
		sum++;
	}
	return sum - 1;
}

/*
 *  Find the previous response.  Go to the last response in the previous
 *  thread if we go past the beginning of this thread.
 */
prev_response(n)
	int n;
{
	int i, j;
	int prev;

	for (i = 0; i < top_base; i++) {
		for (prev = -1, j = base[i]; j >= 0; j = arts[j].thread)
			if (j == n) goto prevbreak;
			else prev = j;
	}
	LOGIT(LOG_ERR, "prev_response: can't find base article");
	return -1;
prevbreak:
	if (prev >= 0) return prev;
	else if (i <= 0) return -1;
	else {
		for (j = base[i-1]; arts[j].thread >= 0; j = arts[j].thread) ;
		return j;
	}
}

/*
 *  Find the next response.  Go to the next basenote if there
 *  are no more responses in this thread
 */
next_response(n)
	int n;
{
	int i;

	if (n < 0) return 0;
	if (arts[n].thread >= 0) return arts[n].thread;
	i = which_base(n) + 1;
	if (i >= top_base) return -1;
	return base[i];
}

/*
 *  Given a respnum (index into arts[]), find the respnum of the
 *  next basenote
 */
next_basenote(n)
	int n;
{
	int i;

	i = which_base(n) + 1;
	if (i >= top_base) return -1;
	return base[i];
}

/*
 *  Find the next unread response in this group 
 */
next_unread(n)
	int n;
{
	while (n >= 0) {
		if (arts[n].unread == 1) return n;
		n = next_response(n);
	}
	return -1;
}

/*
 *  Find the previous unread response in this thread
 */
prev_unread(n)
	int n;
{
	while (n >= 0) {
		if (arts[n].unread == 1) return n;
		n = prev_response(n);
	}
	return -1;
}

/*
 *  Return the number of unread articles there are within a thread
 */
new_responses(thread)
int thread;
{
	int i;
	int sum = 0;

	for (i = base[thread]; i >= 0; i = arts[i].thread)
		if (arts[i].unread) sum++;
	return sum;
}

void
make_group_path(name, path)
	char *name, *path;
{
	register char *ptr = strcpy(path, name);

	while (*ptr) {
		if (*ptr == '.') *ptr = '/';
		ptr++;
	}
}

int
copy_fp(a, b, prefix)
	FILE *a, *b;
	char *prefix;
{
	int lncnt = 0;
	char buf[8192];

	while (fgets(buf, 8192, a) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		fprintf(b, "%s%s", prefix, buf);
		lncnt++;
	}
	return lncnt;
}

/* Environment variable we're looking for	 */
/* Default value if no environ value found	 */
/* If Default value none then report fatal error */
char *
get_env(env, def)
	char *env, *def;	
{
	char *ptr;

	if ((ptr = getenv(env)) != NULL) return(ptr);
	else {
		if (def == NULL) envfail(env);
		return(def);
	}
}

envfail(s)
	char *s;
{
	fprintf(stderr, "can't find \"%s\" in environment\n", s);
	exit(1);
}

int
cvttxtfile(nam, dir)
	char *nam;
	int dir;
{
	int fd, n;
	struct stat st;
	char *txt, *ptr;
	extern unsigned char table[256][2];

	if (stat(nam, &st) < 0 || !st.st_size) return -1;
	if ((txt = malloc((int)st.st_size + 1)) == NULL) return -1;
	if ((fd = open(nam, O_RDWR)) < 0) {
		free(txt);
		return -1;
	}
	while ((n = read(fd, txt, (int)st.st_size)) < 0 && errno == EINTR);
	if (n != st.st_size) {
		close(fd);
		free(txt);
		return -1;
	}
	txt[n] = '\0';
	for (ptr = txt; *ptr != '\0'; ptr++)
		*ptr = table[(u_char)*ptr][dir];
	lseek(fd, 0, SEEK_SET);
	while (write(fd, txt, n) < 0 && errno == EINTR);
	close(fd);
	free(txt);
	return 0;
}

int
invoke_editor(lncnt)
	int lncnt;
{
	int i;
	char *av[MAX_CMD_PARAMS+1], buf[1024], *p;
	extern int insert_file();
	extern char *progloader;

	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[1;37m");
	putstr("\n%s\n\n", sysmsg(MSG_DELIMITER));
	if (!prompt_yn(MSG_WANTMSGUPLOAD, NULL, 'N')) {
		if (prompt_yn(MSG_WANTMSGINSERT, NULL, 'N'))
			lncnt = up_load(-1);
		else	lncnt = selectfiles(homedir, insert_file, MSG_SELECTINSERTFILE);
		if (lncnt < 1) return 0;
		lncnt++;
	} else if (cvttxtfile(editorworkfile, 1) < 0) { /* truncate it */
		if ((i = open(editorworkfile, O_WRONLY|O_CREAT|O_TRUNC)) < 0)
			LOGIT(LOG_ERR, "can't create \"%s\": %m", editorworkfile);
		else close(i);
	}
	chmod(editorworkfile, 0666); /* group writable */
	clearbuttons();

	if (progloader != NULL) {
		(void) strcpy(buf, progloader);
		(void) strcat(buf, " ");
		i = strlen(buf);
	} else	i = 0;
	if (lncnt)
		sprintf(&buf[i], "%s +%d %s", editprog, lncnt, editorworkfile);
	else	sprintf(&buf[i], "%s %s", editprog, editorworkfile);
	for (i = 0, p = buf; i < MAX_CMD_PARAMS &&
	     (p = strtok(p, " \t")) != NULL; p = NULL) {
		av[i++] = p;
		if (i == 1) av[i++] = strippath(p);
	}
	av[i] = NULL;

	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[0;37m");
	i = run(av[0], &av[1]);
	if (cvttxtfile(editorworkfile, 0) == 0) chmod(editorworkfile, 0640);
	return i == 0;
}

int
#ifdef	__STDC__
invoke_syscmd(char *fmt, ...)
#else
invoke_syscmd(fmt, va_alist)
	char *fmt;
	va_dcl
#endif
{
	int i;
	char *av[MAX_CMD_PARAMS+1], buf[1024], *p;
	va_list ap;

#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void) vsnprintf(buf, sizeof(buf), fmt, ap);
	va_end(ap);
	for (i = 0, p = buf; i < MAX_CMD_PARAMS &&
	     (p = strtok(p, " \t")) != NULL; p = NULL) {
		av[i++] = p;
		if (i == 1) av[i++] = strippath(p);
	}
	av[i] = NULL;
	return (run(av[0], &av[1]) == 0);
}

int
#ifdef	__STDC__
invoke_cmd(char *fmt, ...)
#else
invoke_cmd(fmt, va_alist)
	char *fmt;
	va_dcl
#endif
{
	int i;
	char *av[MAX_CMD_PARAMS+1], buf[1024], *p;
	va_list ap;
	extern char *progloader;

	if (progloader != NULL) {
		(void) strcpy(buf, progloader);
		(void) strcat(buf, " ");
		i = strlen(buf);
	} else	i = 0;
#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void) vsnprintf(&buf[i], sizeof(buf)-i, fmt, ap);
	va_end(ap);
	for (i = 0, p = buf; i < MAX_CMD_PARAMS &&
	     (p = strtok(p, " \t")) != NULL; p = NULL) {
		av[i++] = p;
		if (i == 1) av[i++] = strippath(p);
	}
	av[i] = NULL;
	return (run(av[0], &av[1]) == 0);
}

add_signature(fp)
	FILE *fp;
{
	char *ptr;

	if ((ptr = getuserconf(SIGNATURE, NULL)) != NULL)
		fprintf(fp, "---\n%s\n", ptr);
}

/*
 * Parse "accesslevel_for_read/accesslevel_for_write" string.
 * If it's right string then fill first and second digit and return TRUE.
 */
int
parse_access(str, first, second)
	char *str;
	int *first, *second;
{
	register char *p = str;

	if (*p == '/') {
		p++;
		if (!isdigitstr(p)) return FALSE;
		*first = 0;
		*second = atoi(p);
		return TRUE;
	}
	if ((p = strchr(str, '/')) != NULL) {
		*p++ = '\0';
		if (!isdigitstr(str)) return FALSE;
		*first = atoi(str);
		if (*p == '\0') {
			*second = MAXPRIVLEVEL;
			return TRUE;
		}
		if (!isdigitstr(p)) return FALSE;
		*second = atoi(p);
		return TRUE;
	}
	if (!isdigitstr(str)) return FALSE;
	*first = atoi(str);
	*second = MAXPRIVLEVEL;
	return TRUE;
}

int
isillegaladdr(addr)
	char *addr;
{
	char *ptr, *line, buf[1024];
	
	sprintf(buf, "%s/%s", homedir, BADADDRFILE);
	if ((ptr = loadfile(buf)) == NULL &&
	    (ptr = loadfile(BADADDRFILE)) == NULL) return 0;

	for (; (line = strchr(ptr, '\n')) != NULL; ptr = line) {
		*line++ = '\0';
		while ((u_char)*ptr <= 0x20 && *ptr) ptr++;
		if (!*ptr || *ptr == '#') continue;
		if (rematch(ptr, addr)) return TRUE;
	}
	return FALSE;
}

search_body(current_art, group_path)
	int current_art;
	char *group_path;
{
	char *ptr;
	int i, count = 0;

	if ((ptr = prompt_str(MSG_BODYSEARCH, body_search_string, 20)) == NULL)
		return -1;
	strcpy(body_search_string, ptr);
	i = current_art;
	do {
		i = next_response(i);
		if (i < 0) i = 0;
		if (search_art_body(body_search_string, arts[i].artnum, group_path))
			return i;
		if (count % 10 == 0) {
			if (count == 0)
				putstr("  %s     ", sysmsg(MSG_SEARCHING));
			else	putstr("\b\b\b\b%-4d", count);
		}
		count++;
	} while (i != current_art);
	warning(MSG_NOTFOUND, -1);
	return -1;
}

search_art_body(ss, art, group_path)
	char *ss;
	long art;
	char *group_path;
{
	FILE *fp;
	char buf[LEN];
	extern FILE *open_art_fp();

	if ((fp = open_art_fp(group_path, art)) == NULL) return FALSE;
/*
 * We want to search all *
 	while (fgets(buf, LEN, fp) != NULL) if (*buf == '\n') break;
 */
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		if (__strcasestr(buf, ss) != NULL) {
			fclose(fp);
			return TRUE;
		}
	}
	fclose(fp);
	return FALSE;
}

search_author(current_art, forward)
	int current_art, forward;
{
	int i;
	char *ptr;

	if (forward < 0) {
		forward = TRUE;
		if (author_search_string[0] == '\0') i = TRUE;
		else i = FALSE;
	} else i = TRUE;
	if (i) {
		if (forward)	i = MSG_AUTHORSEARCHF;
		else		i = MSG_AUTHORSEARCHB;
		if ((ptr = prompt_str(i, author_search_string, 20)) == NULL)
			return -1;
		strcpy(author_search_string, ptr);
	}
	i = current_art;
	do {
		if (forward) {
			i = next_response(i);
			if (i < 0) i = 0;
		} else {
			i = prev_response(i);
			if (i < 0) i = choose_resp(top_base - 1,
						   nresp(top_base - 1));
		}
		if (__strcasestr(arts[i].from, author_search_string) != NULL)
			return i;
	} while (i != current_art);
	warning(MSG_NOTFOUND, -1);
	return -1;
}

search_subject(current_art, forward)
	int current_art, forward;
{
	int i;
	char *ptr;

	if (forward < 0) {
		forward = TRUE;
		if (subject_search_string[0] == '\0') i = TRUE;
		else i = FALSE;
	} else i = TRUE;
	if (i) {
		if (forward)	i = MSG_SUBJSEARCHF;
		else		i = MSG_SUBJSEARCHB;
		if ((ptr = prompt_str(i, subject_search_string, 20)) == NULL)
			return -1;
		strcpy(subject_search_string, ptr);
	}
	i = current_art;
	do {
		if (forward) i++;
		else i--;
		if (i >= top_base) i = 0;
		if (i < 0) i = top_base - 1;
		if (__strcasestr(arts[i].subject, subject_search_string) != NULL)
			return i;
	} while (i != current_art);
	warning(MSG_NOTFOUND, -1);
	return -1;
}

int
showfile(fn)
	char *fn;
{
	FILE *fp;
	char buf[LEN];

	if ((fp = sfopen(fn, "r")) == NULL) return FALSE;
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		putstr(buf);
	}
	sfclose(fp);
	return TRUE;
}

badline(file, line)
	char *file, *line;
{
	LOGIT(LOG_ERR, "Bad line \"%s\" in %s", line, file);
}
