/*
 *	Copyright (c) 1994,1995 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include "drive.h"
#include "sysmsg.h"
#include "rematch.h"
#include "loginfo.h"

extern int errno;
extern struct loginfo process;

#define	MIMECONF		".mime"

/* conf */
static struct {
	char *exp;
	char *ext;
	char *file;
	char *prg;
} mime[MAXCONFENTRIES];

static time_t mimeconf_mtime = 0;

static int
mimerefresh(menudir, mimedir)
	char *menudir, *mimedir;
{
	int i, j;
	char *top, *ptr, *ptr2, *line, *exp, *ext, fpath[1024], buf[1024];
	time_t tmp_mtime;
	struct stat st;

	sprintf(fpath, "%s/%s", mimedir, MIMECONF);
	if (stat(fpath, &st) < 0 || !st.st_size || !st.st_mtime) {
		sprintf(fpath, "%s/%s", menudir, MIMECONF);
		if (stat(fpath, &st) < 0 || !st.st_size || !st.st_mtime)
			return -1;
	}
	if (st.st_mtime == mimeconf_mtime) return 0;
	tmp_mtime = st.st_mtime;
	if ((i = open(fpath, O_RDONLY)) < 0) return -1;
	if ((top = ptr = malloc((int)st.st_size + 2)) == NULL) {
		close(i);
		return -1;
	}
	while ((j = read(i, ptr, (int)st.st_size)) < 0 && errno == EINTR);
	close(i);
	if (j != st.st_size) {
		free(top);
		return -1;
	}
	if (ptr[j-1] != '\n') ptr[j++] = '\n';
	ptr[j] = '\0';

	for (i = 0; i < MAXCONFENTRIES-1 &&
	     (line = strchr(ptr, '\n')) != NULL; ptr = line) {
		*line++ = '\0';
		while ((u_char)*ptr <= 0x20 && *ptr) ptr++;
		if (!*ptr || *ptr == '#') continue;
		exp = ptr;
		while ((u_char)*ptr > 0x20) ptr++;
		if (*ptr) for (*ptr++ = 0; (u_char)*ptr <= 0x20 && *ptr; ptr++);
		if (!*ptr) continue;
		ext = ptr;
		while ((u_char)*ptr > 0x20) ptr++;
		if (*ptr) for (*ptr++ = 0; (u_char)*ptr <= 0x20 && *ptr; ptr++);
		if (!*ptr) continue;
		if (strstr(ptr, "%s") == NULL) {
			badline(fpath, ptr);
			continue;
		}
		for (ptr2 = ptr, j = 0; (u_char)*ptr2 > 0x20; ptr2++, j++)
			buf[j] = *ptr2;
		buf[j] = '\0';
		if (stat(buf, &st) < 0 || (st.st_mode & S_IFMT) != S_IFREG ||
		    !(st.st_mode & S_IRUSR) || !(st.st_mode & S_IXUSR)) {
			badline(fpath, buf);
			continue;
		}
		if (mimeconf_mtime && mime[i].prg != NULL) {
			free(mime[i].exp);
			free(mime[i].ext);
			free(mime[i].file);
			free(mime[i].prg);
		}
		if ((mime[i].file = malloc(sizeof(TMPFILEMASK) +
					       strlen(ext) + 2)) == NULL) break;
		mime[i].file[0] = '\0';
		mime[i].exp = strdup(exp);
		mime[i].ext = strdup(ext);
		mime[i].prg = strdup(ptr);
		i++;
	}
	mime[i].prg = NULL;
	free(top);
	if (!i) return -1;
	mimeconf_mtime = tmp_mtime;
	return 0;
}

mimeclear()
{
	if (mimeconf_mtime) {
		register i;
		for (i = 0; mime[i].prg; i++)
			if (mime[i].file[0]) {
				unlink(mime[i].file);
				mime[i].file[0] = '\0';
			}
	}
}

int
mimefiles(menudir, mimedir, files)
	char *menudir, *mimedir, *files[];
{
	int m, f, a, mem, len;
	sigfunc intsave;
	char *ptr, execbuf[1024], *avf[MAXCONFLINES+1];

	if (mimerefresh(menudir, mimedir) < 0) return -1;
	intsave = signal(SIGINT, SIG_IGN);
	len = strlen(mimedir);
	for (m = 0; mime[m].prg; m++) {
		if (mime[m].file[0]) unlink(mime[m].file);
		mkstemp(strcpy(mime[m].file, TMPFILEMASK));
		unlink(mime[m].file);
		strcat(mime[m].file, ".");
		strcat(mime[m].file, mime[m].ext);
		sprintf(execbuf, mime[m].prg, mime[m].file);
		for (a = 0, ptr = execbuf;
		     (ptr = strtok(ptr, " \t")) != NULL; ptr = NULL) {
			avf[a++] = ptr;
			if (a == 1) avf[a++] = strippath(ptr);
		}
		mem = a;
		for (f = 0; files[f]; f++) {
			if (*files[f] != '\0' &&
			    !strncmp(files[f], mimedir, len) &&
			    rematch(mime[m].exp, strippath(files[f])))
				avf[a++] = files[f];
		}
		avf[a] = NULL;
		if (a > mem) {
			char uprbuf[40];
			struct stat st;

			makeuppercase(mime[m].ext, uprbuf);
			putchr('\n');
			putstr(sysmsg(MSG_MIMEFOUND), uprbuf);
			putchr('\n');
			nchr = 1;
			if (run(avf[0], &avf[1]) == 0 &&
			    stat(mime[m].file, &st) == 0) {
				strncpy(avf[mem], mime[m].file, strlen(avf[mem]));
				mem++;
				while (avf[mem] != NULL) *avf[mem++] = '\0';
				nchr = 0;
				mem = (int)st.st_size/1024;
				ptr = sec2str(((int)st.st_size/128+1)*128*11/(process.baud+1));
				if (termflags & (ANSITERM | RIPTERM))
					putstr("\n\033[1;37m%s: \033[33m%s \033[0;32m(%dkb, %s)\n", uprbuf, strippath(mime[m].file), mem, ptr);
				else	putstr("\n%s: %s (%dkb, %s)\n", uprbuf, strippath(mime[m].file), mem, ptr);
			} else {
				LOGIT(LOG_ERR, "%s failed: exec \"%s\", dest \"%s\", mimedir \"%s\"",
				    uprbuf, avf[0], mime[m].file, mimedir);
				putstr("%s\n", sysmsg(MSG_CANTOPENFILE));
				mime[m].file[0] = '\0';
			}
			nchr = 0;
		} else	mime[m].file[0] = '\0';
	}
	(void)signal(SIGINT, intsave);
	return 0;
}
