/*
 *	Copyright (c) 1994,1995 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef	__STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>

#include "drive.h"
#include "scandir.h"
#include "sysmsg.h"
#include "ripwraps.h"
/*#include "usenet.h"
#include "msgapi.h"*/
#include "variables.h"
#include "version.h"

#define	RESPONSE_TIMEOUT	4	/* sec */
#define	X 590
#define	Y 136

char termtype[10];
int termflags = 0;
int scrlines = DEFSCRLINES;

isripterm()
{
	char *p;
	int xx, yy, v, s;
	static char *termsoft[5] = {
		"Generic RIPscrip terminal",
		"RIPterm",
		"Qmodem Pro",
		"Telix",
		"Qmodem Pro for Windows"
	};
	extern char *getresponse();

	putstr("  Sensing...");
	ripio_query();
	p = getresponse(14, RESPONSE_TIMEOUT);
	if (p != NULL && !strncmp(p, "RIPSCRIP", 8)) {
		if (sscanf(&p[8], "%2d%2d%1d%1d", &xx, &yy, &v, &s) != 4)
			return 0;
		if (xx > 1) termflags |= RIPTERM2;
		putstr(" %s %d.%d.%d", v < 5 ? termsoft[v] : "Unknown", xx, yy, s);
		return 1;
	}
	return 0;
}

static int
acceptfiles(path, file)
	char *path;
	register struct dir_ent *file;
{
	if ((file->mode & S_IFMT) == S_IFREG) {
		register char *ptr;

		if ((ptr = strrchr(file->name, '.')) != NULL) {
			ptr++;
			if (!strcmp(ptr, "icn") || !strcmp(ptr, "rip"))
				return 1;
			if (termflags & RIPTERM2) {
				if (!strcmp(ptr, "bmp") || !strcmp(ptr, "jpg"))
					return 1;
			}
		}
	}
	return 0;
}

#define	ICONSDIR	".icons"

void
loadripfiles()
{
	int i, j, n, proto;
	struct dir_ent *flst;
	char *ptr, cmdbuf[1024], tmpbuf[1024];

	if ((ptr = getsysconf("ICONSPROTO", NULL)) == NULL) return;
	if ((proto = atoi(ptr)) == 0) return;
	if ((ptr = strchr(ptr, ':')) == NULL) return;
	strcpy(cmdbuf, ++ptr);

	sprintf(tmpbuf, "%s/%s", orgdir, ICONSDIR);
	if ((n = scan_dir(tmpbuf, &flst, acceptfiles, SCAN_SORTBYSIZE)) <= 0)
		return;

	pleasewait(1);
	putchr('\n');
	for (i = j = 0; i < n; i++) {
		rip_file_query(2, 0, flst[i].name);
		ripio_flush();
		ptr = getstr(0, 1, ECHODISABLE);
		if (ptr[0] == '1' && ptr[1] == '.' &&
		    atoi(&ptr[2]) == flst[i].size) continue;
		strcat(cmdbuf, " ");
		strcat(cmdbuf, flst[i].name);
		j++;
	}
	free_dir(&flst, n);
	if (!j) return;
	sprintf(tmpbuf, "%s/%s", orgdir, ICONSDIR);
	chdir(tmpbuf);
	rip_enter_block_mode(0, proto, 4, 0, "<>");
	ripio_flush();
	system(cmdbuf);
	chdir(orgdir);
}


/**********************************/
/*** Init/Close Graph functions ***/

graphopen(reset)
	int reset;
{
	char *ptr;
	char buf[80];
	extern char *systemname;

	nchr = 0;
	if (!reset) {
		if ((ptr = getuserconf(SCRLINES, NULL)) != NULL) {
			int i = atoi(ptr);
			if (i >= 20 && i <= MAXSCRLINES) scrlines = i-1;
		}
		if ((ptr = getuserconf(HOTKEY, NULL)) != NULL) {
			if (*ptr == '1' || !strcasecmp(ptr, "Yes") || !strcasecmp(ptr, "On"))
				termflags |= HOTKEYON;
		}
		if ((ptr = getuserconf(SHORTMENU, NULL)) != NULL) {
			if (*ptr == '1' || !strcasecmp(ptr, "Yes") || !strcasecmp(ptr, "On"))
				termflags |= SHORTMENUON;
		}
	}
	if ((termflags & ANSITERM) && reset) putstr("\033[0;37;40m\033[H\033[J");
	if (termflags & RIPTERM) {
		if (!reset) {
			ripio_enable();
			ripio_flush();
			if (termflags & RIPTERM2) {
				rip_header(1|4|16, 1, 0);
				ripio_flush();
			}
			rip_query(0, 0, 0, "$MSTAT$^m");
			ripio_flush();
			if (!strcmp(getstr(0, 1, ECHODISABLE), "YES"))
				termflags |= RIPMOUSE;
			else {
				putstr("%s\n", sysmsg(MSG_NOMOUSE));
				termflags &= ~RIPMOUSE;
				sleep(1);
			}
			loadripfiles();
/*			rip_query(0, 0, 0, "$MUSIC$"); */
		}
		scrlines = DEFSCRLINES;
		rip_reset_windows();
		rip_query(0, 0, 0, "$SBAROFF$");
		rip_text_window(2, 15, 81, 39, 1, 1);
		rip_viewport(0, 0, 639, 349);
		rip_fill_style(RIP_SOLID_FILL, RIP_LIGHTGRAY);
		rip_bar(2, 2, 637, 347);
		rip_erase_window();
		rip_line_style(0, RIP_SOLID_LINE, 0, RIP_THICK_WIDTH);
		rip_color(RIP_WHITE);
		rip_line(0, 349, 0, 0);
		rip_line(0, 0, 639, 0);
		rip_line(577, 118, 577, 321);
		rip_line(577, 321, 6, 321);
		rip_color(RIP_DARKGRAY);
		rip_line(639, 0, 639, 349);
		rip_line(639, 349, 0, 349);
		rip_line(6, 321, 6, 118);
		rip_line(6, 118, 577, 118);

		rip_line_style(0, RIP_SOLID_LINE, 0, RIP_NORM_WIDTH);
		rip_color(RIP_BLACK);
		rip_line(4, 345, 4, 4);
		rip_line(4, 4, 635, 4);
		rip_color(RIP_WHITE);
		rip_line(635, 4, 635, 345);
		rip_line(635, 345, 4, 345);

		rip_color(RIP_RED);
		rip_font_style(RIP_TRIPLEX_SCRIPT_FONT, RIP_HORIZ_DIR, 1,
			       RIP_HALIGN_LEFT, RIP_VALIGN_TOP);
		strncpy(buf, systemname, 32);
		buf[32] = '\0';
		rip_text_xy(15, 321, buf);
		rip_color(RIP_BLACK);
		rip_font_style(RIP_SMALL_FONT, RIP_HORIZ_DIR, 2,
			       RIP_HALIGN_LEFT, RIP_VALIGN_TOP);
		sprintf(buf, "(C)1996 CAD lab  %s", systemid);
		rip_text_xy(350, 334, buf);
		rip_font_style(RIP_SMALL_FONT, RIP_HORIZ_DIR, 4,
			       RIP_HALIGN_LEFT, RIP_VALIGN_TOP);
		rip_text_xy(350, 323, sysadmname);
		rip_query(0, 0, 0, "$COFF$$HKEYON$$TABON$$VT102ON$");
		ripio_flush();
		rip_no_more();
		rip_no_more();
		rip_no_more();
		ripio_flush();
		rip_load_icon(586, 50, 0, RIP_COPY_MODE, 0, 36, "logo");
		ripio_flush();
	}
}

graphclose()
{
	nchr = 0;
	if (termflags & RIPTERM) {
		putchr('\n');
		rip_query(0, 0, 0, "$SBARON$$CON$");
		ripio_flush();
		rip_no_more();
		rip_no_more();
		rip_no_more();
		ripio_flush();
		ripio_disable();
	}
}

/**********************/
/*** Menu functions ***/

int menu_index = 0;
extern struct dir_ent *menu_item;
extern int menu_num;

int
menu_dump()
{
	register int i, j, n, m;
	char *ptr, ch;

	if ((termflags & SHORTMENUON) && menu_index != -1) goto get_menu_index;

	display(0, HEADERFILE);
	if (!(globalflags & EXTERNALMENUFLAG)) {
		for (i = j = 0; i < menu_num; i++) {
			ch = (char)menu_item[i].key;
			if (!ch) continue;
			n = m = 0;
			ptr = menu_item[i].name;
			while (*ptr && *ptr != '.' && n < 19) {
				if (!m && *ptr == ch) {
					putstr("(%c)", *ptr);
					n += 3;
					m++;
				} else {
					if (*ptr != '_') putchr(*ptr);
					else putchr(' ');
					n++;
				}
				ptr++;
			}
			if (++j == 4) {
				j = 0;
				putchr('\n');
			} else for (m = n; m < 19; m++) putchr(' ');
		}
		if (j) putchr('\n');
	}
get_menu_index:
	j = 0;
	n = nchr;
	do {
		if (++j > 1) {
			nchr = 0;
			if (n) {
				i = -1;
				break;
			}
			j = 1;
		}
		putchr('\n');
		if (!display(0, FOOTERFILE)) putstr("> ");
		ch = chrupr(hotkey());
		if (ch == '.') {
			i = -1;
			break;
		}
		if (ch == '?') {
			i = -2;
			break;
		}
		for (i = 0; i < menu_num; i++)
			if (ch == (char)menu_item[i].key) break;
	} while (i == menu_num);
	putchr('\n');
	menu_index = i;
	globalflags &= ~NOMOREFLAG;
	return i;
}

int
menu_ansi()
{
	register int i, j, n ,m;
	char *ptr, ch;

	/* Normal, White foreground */
	putstr("\033[0;37m");

	if ((termflags & SHORTMENUON) && menu_index != -1) goto get_menu_index;

	display(0, HEADERFILE);
	if (!(globalflags & EXTERNALMENUFLAG)) {
		/* Normal display, Black background,  Cyan foreground */
		putstr("\033[0;40;36m");
		for (i = j = 0; i < menu_num; i++) {
			ch = (char)menu_item[i].key;
			if (!ch) continue;
			n = m = 0;
			ptr = menu_item[i].name;
			while (*ptr && *ptr != '.') {
				if (!m && *ptr == ch) {
					/* Bold/Yellow foreground Menu items Key */
					putstr("\033[1;33m%c\033[0;36m", *ptr);
					m++;
				} else {
					if (*ptr != '_') putchr(*ptr);
					else putchr(' ');
				}
				ptr++;
				if (++n > 18) break;
			}
			if (++j == 4) {
				j = 0;
				putchr('\n');
			} else for (m = n; m < 19; m++) putchr(' ');
		}
		if (j) putchr('\n');
	}
	/* Normal, White foreground */
	putstr("\033[0;37m");
get_menu_index:
	j = 0;
	n = nchr;
	do {
		if (++j > 1) {
			nchr = 0;
			if (n) {
				i = -1;
				break;
			}
			j = 1;
		}
		putchr('\n');
		if (!display(0, FOOTERFILE)) putstr("> ");
		ch = chrupr(hotkey());
		if (ch == '.') {
			i = -1;
			break;
		}
		if (ch == '?') {
			i = -2;
			break;
		}
		for (i = 0; i < menu_num; i++)
			if (ch == (char)menu_item[i].key) break;
	} while (i == menu_num);
	putchr('\n');
	menu_index = i;
	globalflags &= ~NOMOREFLAG;
	return i;
}

#define	MAXSUBMENU	16
#define	MAXSUBITEM	30

int
menu_rip()
{
	register i, j, x, y;
	int sbm[MAXSUBMENU];
	char *ptr, ch;
	char buf[256], label[80];
	static int subitems = 0;
	void ripsave(), riprestore();
	extern char *makestrpath();

	putstr("\033[0;37m");
	clearbuttons();
	termflags &= ~CLEARBUTTONS;
	i = display(0, HEADERFILE);
	putchr('\r');
	if (i) rip_text_window(2, 15, 81, 39, 1, 1);
	rip_get_image(X, Y+34*0, X+32, Y+34*4+32, 0);
	rip_query(0, 0, 0, "$SCB$$COFF$");
	ripio_flush();

	if (globalflags & EXTERNALMENUFLAG) goto after_menu;

	if (i) rip_kill_mouse_fields();
	rip_button_style(0, 0, 02, (2|256|512|1024|16384),
			 RIP_NORM_WIDTH, RIP_BLACK, 0,
			 RIP_WHITE, RIP_DARKGRAY, RIP_LIGHTGRAY,
			 0, (2|8), RIP_BLUE, RIP_LIGHTGRAY, 0, 0, 0);
	ripio_flush();

	for (i = j = 0; i < menu_num; i++) {
		if (menu_item[i].key &&
		    (menu_item[i].mode & S_IFMT) == S_IFDIR) {
			sbm[j++] = i;
			if (j == MAXSUBMENU) break;
		}
	}
	if (j) for (i = j, x = 630, y = 621/j; i > 0; i--, x -= y) {
		strcpy(label, menu_item[sbm[i-1]].name);
		if ((ptr = strrchr(label, '.')) != NULL) *ptr = 0;
		for (ptr = label; *ptr; ptr++) if (*ptr == '_') *ptr = ' ';
		if (i == 1) y += 621%j;
		ch = (char)menu_item[sbm[i-1]].key;
		sprintf(buf, "<>%.*s<>%c", y/7, label, ch);
		rip_button(x-y, 22, x, 33, ch, 0, 0, buf);
	}
	rip_button(576, 9, 630, 20, '?', 0, 0, "<>? help<>?");
	rip_button(9, 9, 575, 20, '.', 02, 0, "<><>.");
	ptr = strncpy(buf, makestrpath(), sizeof(buf));
	buf[sizeof(buf)-1] = '\0';
	i = strlen(ptr);
	if (i > 60) {
		j = i - 60;
		ptr += j;
		i -= j;
	}
	rip_color(RIP_BLUE);
	rip_text_xy(310 - i * 4, 8, ptr);

	for (i = j = 0, x = 9, y = 37; i < menu_num && j < MAXSUBITEM; i++) {
		ch = (char)menu_item[i].key;
		if (!ch || (menu_item[i].mode & S_IFMT) == S_IFDIR) continue;
		strcpy(label, menu_item[i].name);
		if ((ptr = strrchr(label, '.')) != NULL) *ptr = 0;
		for (ptr = label; *ptr; ptr++) if (*ptr == '_') *ptr = ' ';
		sprintf(buf, "<>%.16s<>%c", label, ch);
		rip_button(x, y, x+110, y+11, ch, 0, 0, buf);
		y += 13;
		if (++j % 6 == 0) x += 114, y = 37;
	}
	if (j < subitems) {
		int l = j;
		subitems -= l;
		for (i = 0; i < subitems; i++) {
			rip_bar(x-1, y-1, x+110, y+11);
			y += 13;
			if (++l % 6 == 0) x += 114, y = 37;
		}
	}
	subitems = j;
	rip_mouse(0, 586, 50, 586+32, 50+32, 0, 0, 0, "^@");
	rip_no_more();
	rip_no_more();
	rip_no_more();
	ripio_flush();
after_menu:
	do {
		x = chrupr(getask(ECHODISABLE));
		if (!x) {
			ripsave();
			globalflags |= NOMOREFLAG;
			x = display(0, ".logo.rip");
			globalflags &= ~NOMOREFLAG;
			if (x) riprestore();
			goto after_menu;
		}
		if (x == '.') {
			i = -1;
			break;
		}
		if (x == '?') {
			i = -2;
			break;
		}
		for (i = 0; i < menu_num; i++)
			if (x == (char)menu_item[i].key) break;
	} while (i == menu_num);
	rip_query(0, 0, 0, "$BLIP$");
	rip_kill_mouse_fields();
	ripio_flush();
	globalflags &= ~NOMOREFLAG;
	return i;
}

/*
 * Here defined terminal depended menu driven funtions table.
 */
static struct menufunc {
	int (*f)();
	char *term;
	char *termsupp;
	int termflag;
} menufuncs[] = {
	{ menu_dump, DUMP,   DUMP, DUMPTERM },
	{ menu_dump, VT52,   DUMP, DUMPTERM },	/* Dump terminal */
	{ menu_ansi, VT100,  ANSI, ANSITERM },	/* ANSI support */
	{ menu_ansi, ANSI,   ANSI, ANSITERM },	/* ANSI support */
	{ menu_ansi, IBMPC3, ANSI, ANSITERM },	/* ANSI support */
	{ menu_ansi, AT386,  ANSI, ANSITERM },	/* ANSI support */
	{ menu_rip,  RIP,    RIP,  RIPTERM  },	/* RIP<tm> support */
	{ 0, 0 },
};

/*
 * Assign terminal type to terminal function.
 */
int
(*find_term(term))()
	char *term;
{
	extern char *strlwr();
	struct menufunc *p;

	for (p = menufuncs; p->f; ++p)
		if (!strcasecmp(term, p->term)) {
			makelowercase(p->termsupp, termtype);
			termflags |= p->termflag;
			return p->f;
		}
	makelowercase(DUMP, termtype);
	return menu_dump;
}


/*
 * Display content of file with variables and commands.
 */

char *
page_up(top, cur)
	register char *top, *cur;
{
	register nl, flag;

	for (nl = 0; cur > top; cur--) {
		flag = 0;
		if (*cur == '\n') cur--, flag++;
		if (cur <= top) return top;
		if (*cur == '\r') cur--, flag++;
		if (flag) nl++, cur++;
		if (nl > scrlines) return cur + flag;
	}
	return top;
}

int
#ifdef	__STDC__
display(int flag, char *fmt, ...)
#else
display(flag, fmt, va_alist)
	int flag;
	char *fmt;
	va_dcl
#endif
{
	va_list ap;
	register fd;
	register char *ptr, *line;
	int lncnt = 0, crln, flines, nc;
	struct stat st;
	char *ptrbuf, keyword[1024], tmpbuf[1024], temp[128];
	extern void (*do_cmd())();
	extern char *(*do_disp())();
	extern char *stdfile;
	extern int errno;

#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void)vsnprintf(keyword, sizeof(keyword), fmt, ap);
	va_end(ap);

	line = keyword;
	if (*line == '!') line++;
	else if (*line == '|') line++, lncnt++;

	if (*line != '/') {
		if (*line == '~') ptr = orgdir, line++;
		else ptr = dirpath;
		sprintf(tmpbuf, "%s/%s", ptr, line);
		line = tmpbuf;
	}
	if ((ptr = strchr(line, ' ')) != NULL) *ptr = '\0';
	if (stat(line, &st) < 0 || (st.st_mode & S_IFMT) != S_IFREG) {
		line = strippath(line);
		if (stat(line, &st) < 0 || (st.st_mode & S_IFMT) != S_IFREG)
			return 0;
	}
	if (st.st_size < 2) return 0;
	if (st.st_uid > MAX_MENU_UID) flag = 1;
	if (ptr != NULL) *ptr = ' ';

	if (st.st_mode & S_IXUSR) {
		if (st.st_uid > MAX_MENU_UID) return 0;
		if (lncnt) {
			stdfile = mktemp(strcpy(temp, TMPFILEMASK));
			invoke_cmd(line);
			if (stat(temp, &st) < 0) return 0;
			if (!st.st_size) {
				unlink(temp);
				return 0;
			}
			line = temp;
			lncnt = -1;
		} else	return invoke_cmd(line);
	}

	LOGIT(LOG_DEBUG, "display: \"%s\"", line);

	if ((ptrbuf = malloc((int)st.st_size + 2)) == NULL) return 0;
	if ((fd = open(line, O_RDONLY)) < 0) {
		free(ptrbuf);
		return 0;
	}
	if (lncnt == -1) unlink(line);
	while ((lncnt = read(fd, ptrbuf, (int)st.st_size)) < 0 && errno == EINTR);
	close(fd);
	if (lncnt != st.st_size) {
		free(ptrbuf);
		return 0;
	}
	if (ptrbuf[lncnt-1] != '\n') ptrbuf[lncnt++] = '\n';
	ptrbuf[lncnt] = '\0';
	st.st_size = lncnt;
	lncnt = flines = 1;
	line = ptrbuf;

	while (*line) {
		for (nc = 0, crln = 1; *line != '\r' && *line != '\n'; line++) {
			if (*line == '%') {
				if (line[1] == '\\') {
					crln = 0;
					line++;
					continue;
				}
				for (fd = 0, ptr = &line[1];
				     fd < sizeof(keyword)-1 && *ptr != '%' &&
				     *ptr != '\r' && *ptr != '\n' && isprint(*ptr);
				     ptr++, fd++) {
					keyword[fd] = *ptr;
					if (isspace(*ptr) &&
					    keyword[0] != '!' &&
					    keyword[0] != '|') {
						fd = 0;
						break;
					}
				}
				keyword[fd] = '\0';
				if (fd && *ptr == '%') {
					line += strlen(keyword) + 1;
					if (flag) continue;
					insvariables(keyword);
					if (keyword[0] != '!' &&
					    keyword[0] != '|') {
						for (fd = 0; isdigit(keyword[fd]); fd++);
						if (keyword[fd]) {
							for (fd = 0; isupper(keyword[fd]); fd++);
							if (keyword[fd] == '=') {
								keyword[fd++] = '\0';
								(void)(*do_disp(keyword))(&keyword[fd]);
							} else if (keyword[fd]) (*do_cmd(keyword))();
							else nc += putstr((*do_disp(keyword))(NULL));
						} else	sleep(atoi(keyword));
					} else	display(flag, keyword);
					continue;
				}
			}
			putchr(*line);
			nc++;
		}
		if (line[0] == '\r' && line[1] == '\n') line++;
		line++;
		if (flines < scrlines) flines++;
		if (crln) putchr('\n');
		nc /= 79;
		while (nc--) lncnt++;
show_again:
		switch (more(&lncnt)) {
			case -2:
				line = ptrbuf;
				break;
			case -1:
				line = page_up(ptrbuf, page_up(ptrbuf, line));
				break;
			case 1:
				break;
			case 2:
				line = page_up(ptrbuf, &ptrbuf[(int)st.st_size]);
				break;
			default:
				free(ptrbuf);
				return 2;
		}
	}
	if (flines < scrlines || (globalflags & NOMOREFLAG)) {
		free(ptrbuf);
		return 1;
	}
	putstr("\007<EOF>\r");
	lncnt = scrlines;
	goto show_again;
}

void
hidestr(str)
	char *str;
{
	register i, len = strlen(str);
	for (i = 0; i < len; i++) putchr('\b');
	for (i = 0; i < len; i++) putchr(' ');
	putchr('\r');
	return;
}

void
ripsave()
{
	if (termflags & RIPTERM) {
		putchr('\r');
		rip_query(0, 0, 0, "$STW$$SMF$$SAVE$");
		ripio_flush();
	}
}

void
riprestore()
{
	if (termflags & RIPTERM) {
		putchr('\r');
		rip_query(0, 0, 0, "$RTW$$RMF$$RESTORE$");
		rip_fill_style(RIP_SOLID_FILL, RIP_LIGHTGRAY);
		rip_font_style(RIP_SMALL_FONT, RIP_HORIZ_DIR, 4,
			       RIP_HALIGN_LEFT, RIP_VALIGN_TOP);
		ripio_flush();
	}
}

clearbuttons()
{
	if (termflags & CLEARBUTTONS) {
		putchr('\r');
		rip_kill_mouse_fields();
		rip_query(0, 0, 0, "$RCB$$PCB$");
		ripio_flush();
	}
	if (termflags & RIPTERM2) {
		putchr('\r');
		rip_set_mouse_cursor(0, 0);
		ripio_flush();
	}
}

savescr()
{
	if (termflags & RIPTERM) {
		putchr('\r');
		rip_query(0, 0, 0, "$SAVE$$STW$$ETW$$COFF$");
		ripio_flush();
	}
}

restorescr()
{
	if (termflags & RIPTERM) {
		putchr('\r');
		rip_query(0, 0, 0, "$RTW$$RESTORE$");
		ripio_flush();
	}
}

cursoroff()
{
	if (termflags & RIPTERM) {
		putchr('\r');
		rip_query(0, 0, 0, "$COFF$");
		ripio_flush();
	}
}

cursoron()
{
	if (termflags & RIPTERM) {
		putchr('\r');
		rip_query(0, 0, 0, "$CON$");
		ripio_flush();
	}
}

pleasewait(flag)
	int flag;
{
	if (flag != -1) {
		clearline();
		if (termflags & RIPTERM2) {
			rip_set_mouse_cursor(6, 0);
			ripio_flush();
		} else if (flag) psysmsg(MSG_PLEASEWAIT);
	}
}

int
anykey()
{
	int ch;

	if (nchr) return 0;
	if (termflags & RIPMOUSE) {
		putchr('\r');
		rip_get_image(X, Y+34*5, X+32, Y+34*5+32, 0);
		rip_button_style(0, 0, 0, (128|1024|16384),
				 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		rip_button(X, Y+34*5, 0, 0, 'Q', 2, 0, "ok<><>Q");
		if (termflags & RIPTERM2) rip_set_mouse_cursor(5, 0);
		rip_no_more();
		rip_no_more();
		rip_no_more();
		ripio_flush();
		ch = chrupr(getask(ECHODISABLE));
		putchr('\r');
		rip_put_image(X, Y+34*5, 0, 0, 0);
		rip_query(0, 0, 0, "$RMF$");
		if (termflags & RIPTERM2) rip_set_mouse_cursor(0, 0);
		ripio_flush();
	} else {
		char *ptr = sysmsg(MSG_PRESSANYKEY);
		if (termflags & (ANSITERM | RIPTERM))
			putstr(" \033[36m%s\033[37m", ptr);
		else	putstr(" %s", ptr);
		ch = getask(ECHODISABLE);
		hidestr(ptr);
	}
	return ch;
}

int
more(curline)
	int *curline;
{
	int ch = 1;
	char *ptr;

	if (globalflags & NOMOREFLAG) return 1;
	if (*curline >= scrlines) {
		ptr = sysmsg(MSG_MORE_TNS);
		*curline = 0;
		if (termflags & RIPMOUSE) {
			termflags |= CLEARBUTTONS;
			cursoroff();
			rip_kill_mouse_fields();
			rip_button_style(0, 0, 0, (2|128|1024|16384),
					 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
			rip_button(X, Y+34*0, 0, 0, 'T', 0, 0, "top<><>T");
			rip_button(X, Y+34*1, 0, 0, 'U', 0, 0, "up<><>U");
			rip_button(X, Y+34*2, 0, 0, 'Q', 2, 0, "quit<><>Q");
			rip_button(X, Y+34*3, 0, 0, 'D', 0, 0, "down<><>D");
			rip_button(X, Y+34*4, 0, 0, 'B', 0, 0, "bot<><>B");
			if (termflags & RIPTERM2) rip_set_mouse_cursor(0, 0);
			rip_no_more();
			rip_no_more();
			rip_no_more();
			ripio_flush();
			ch = chrupr(getask(ECHODISABLE));
			rip_kill_mouse_fields();
			if (termflags & RIPTERM2) rip_set_mouse_cursor(6, 0);
			ripio_flush();
		} else do {
			if (termflags & (ANSITERM | RIPTERM))
				putstr("\033[36m%s\033[37m", ptr);
			else	putstr("%s", ptr);
			ch = chrupr(getask(ECHODISABLE));
			hidestr(ptr);
			ptr = sysmsg(MSG_MOREHELP);
		} while (ch == '?');

		switch (ch) {
			case 'T':	/* Top */
			case '<':
				clearscr();
				ch = -2;
				break;
			case '\b':
			case 'U':	/* Up */
				clearscr();
				ch = -1;
				break;
			case 'B':	/* Bottom */
			case '>':
				clearscr();
				ch = 2;
				break;
			case '\r':
			case '\n':
			case 'N':	/* Quit */
			case 'Q':
			case 238: ch = 0;
				break;
			default: ch = 1; /* Down */
		}
	}
	(*curline)++;
	return ch;
}

int
morenum(pnum, scrline, range)
	int pnum, *scrline, range;
{
	int ch = 0;
	char *ptr, *p;

	if (*scrline >= scrlines) {
		ptr = sysmsg(MSG_MORENUM);
		*scrline = 0;
		if (termflags & RIPMOUSE) {
			termflags |= CLEARBUTTONS;
			cursoroff();
			rip_kill_mouse_fields();
			rip_button_style(0, 0, 0, (2|128|1024|16384),
					 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
			rip_button(X, Y+34*0, 0, 0, 'T', 0, 0, "top<><>T");
			rip_button(X, Y+34*1, 0, 0, 'U', 0, 0, "up<><>U");
			rip_button(X, Y+34*2, 0, 0, 'Q', 2, 0, "quit<><>Q");
			rip_button(X, Y+34*3, 0, 0, 'D', 0, 0, "down<><>D");
			rip_button(X, Y+34*4, 0, 0, 'B', 0, 0, "bot<><>B");
			rip_mouse(0, 8, 120, 575, 319, 0, 0, 0, ":$XY$^m");
			if (termflags & RIPTERM2) rip_set_mouse_cursor(4, 0);
			rip_no_more();
			rip_no_more();
			rip_no_more();
			ripio_flush();
			ch = chrupr(getask(ECHODISABLE));
			rip_kill_mouse_fields();
			if (termflags & RIPTERM2) rip_set_mouse_cursor(6, 0);
			ripio_flush();
		} else do {
			if (termflags & (ANSITERM | RIPTERM))
				putstr("\033[36m%s\033[37m", ptr);
			else	putstr("%s", ptr);
			ch = chrupr(getask(ECHODISABLE));
			hidestr(ptr);
			ptr = sysmsg(MSG_MORENUMHELP);
		} while (ch == '?');

		switch (ch) {
			case ':':	/* Mouse X:Y */
				ptr = getstr(0, 1, ECHODISABLE);
				if ((p = strchr(ptr, ':')) != NULL) {
					int x;
					*p++ = '\0';
					if ((x = atoi(ptr)) >= 8 &&
					    (ch = atoi(p)) >= 120) {
						ch = ((ch-120)/8)*2+x/290;
						if (ch < scrlines * 2)
							/* mouse offset */
							ch += (range + 1);
						else	ch = 0; /* Down */
					} else ch = -1;
				} else ch = -1;		/* No mouse? go Quit */
				break;
			case 'T':	/* Top */
			case '<':
				clearscr();
				ch = -4;
				break;
			case 'B':	/* Bottom */
			case '>':
				clearscr();
				ch = -3;
				break;
			case '\b':
			case 'U':	/* Up */
				clearscr();
				ch = -2;
				break;
			case '\r':
			case '\n':
			case 'N':	/* Quit */
			case 'Q':
			case 238: ch = -1;
				break;
			default:
			if (isdigit(ch)) {	/* Number */
				ch = prompt_num(pnum, ch-'0', range);
				if (!ch) ch = -1; /* Quit */
			} else	ch = 0;	/* Down */
		}
	}
	(*scrline)++;
	return ch;
}

showbuttons(mode)
	int mode;
{
	if (termflags & RIPMOUSE) {
		termflags |= CLEARBUTTONS;
		cursoroff();
		rip_kill_mouse_fields();
		rip_button_style(0, 0, 0, (2|128|1024|16384),
				 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		rip_button(X, Y+34*0, 0, 0, 'P', 0, 0, "left<><>p");
		rip_button(X, Y+34*1, 0, 0, 'N', 0, 0, "right<><>n");
		rip_button(X, Y+34*2, 0, 0, 'Q', 0, 0, "quit<><>q");
		if (mode)
			rip_button(X, Y+34*3, 0, 0, 'R', 0, 0, "edit<><>F");
		else	rip_button(X, Y+34*3, 0, 0, 'R', 0, 0, "edit<><>R");
		rip_button(X, Y+34*4, 0, 0, 'W', 0, 0, "disk<><>w");
		rip_no_more();
		rip_no_more();
		rip_no_more();
		ripio_flush();
	}
}

int
MsgAfterEditor()
{
	int ch;

	if (termflags & RIPMOUSE) {
		termflags |= CLEARBUTTONS;
		cursoroff();
		rip_kill_mouse_fields();
		rip_button_style(0, 0, 0, (2|128|1024|16384),
				 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		rip_button(X, Y+34*1, 0, 0, 'P', 0, 0, "post<><>P");
		rip_button(X, Y+34*2, 0, 0, 'Q', 2, 0, "quit<><>Q");
		rip_button(X, Y+34*3, 0, 0, 'E', 0, 0, "edit<><>E");
		rip_no_more();
		rip_no_more();
		rip_no_more();
		ripio_flush();
		ch = chrupr(getask(ECHODISABLE));
		clearbuttons();
	} else {
		char *ptr = sysmsg(MSG_MSGAFTEREDITOR);
		if (termflags & ANSITERM)
			putstr("\033[36m%s\033[37m", ptr);
		else	putstr("%s", ptr);
		ch = chrupr(getask(ECHODISABLE));
		hidestr(ptr);
	}
	if (ch == 'P') return 2;
	if (ch == 'E') return 1;
	return 0;
}

int
clearline()
{
	return putstr("\r                                                                               \r");
}

clearscr()
{
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[H\033[J");
	else putchr('\n');
}

int
warning(pnum, cr)
	int pnum, cr;
{
	int nc;

	nchr = 0;
	if (cr < 0) clearline();
	else putchr(' ');
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[1;31m");
	nc = psysmsg(pnum);
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[0;37m");
	if (cr > 0) putchr('\n');
	else putchr(' ');
	return nc;
}

hidestrlen(len)
	int len;
{
	register i;

	for (i = 0; i < len; i++) putchr('\b');
	for (i = 0; i < len; i++) putchr(' ');
	putchr('\r');
}

#define	MAXPROMPTLEN	70

char *
prompt_str(pnum, defstr, maxlen)
	int pnum;
	char *defstr;
	int maxlen;
{
	register i, j;
	char *ptr;

	if (nchr || pnum < 1) {
		if (maxlen < 0) return defstr;
		return getstr(0, 0, ECHODISABLE);
	}
	ptr = sysmsg(pnum);
	clearline();
	if (maxlen < 0) {
		if (termflags & (ANSITERM | RIPTERM))
			putstr("\033[1;36m%s\033[5;37m:\033[0m ", ptr);
		else	putstr("%s: ", ptr);
		putstr("%s\n", defstr ? defstr : "");
		return defstr;
	}
	i = MAXSTRINGLENGTH - (strlen(ptr) + 2);
	if (!maxlen || maxlen > i) maxlen = i;

	if (termflags & RIPTERM2) {
		char buf[MAXPROMPTLEN*2];

		if (defstr != NULL)
			sprintf(buf, "$,:PROMPT,%d@%s=%s$^m", maxlen, ptr, defstr);
		else	sprintf(buf, "$,:PROMPT,%d@%s$^m", maxlen, ptr);
		rip_query(0, 0, 0, buf);
		ripio_flush();
		ptr = getstr(0, 0, ECHODISABLE);
		if (*ptr == '\0' || !strcmp(ptr, "DENIED")) ptr = NULL;
		return ptr;
	}

	if (termflags & RIPTERM) cursoron();
	if (termflags & (ANSITERM | RIPTERM)) {
		putstr("\033[1;36m%s\033[5;37m:\033[0m ", ptr);
		putstr("\033[1;33;44m%*c\033[%dD", maxlen, ' ', maxlen);
	} else {
		putstr("%s: ", ptr);
		for (i = 0; i < maxlen; i++) putchr('_');
		for (i = 0; i < maxlen; i++) putchr('\b');
	}
	if (defstr != NULL)	ptr = editstr(defstr, maxlen, 0);
	else			ptr = getstr(maxlen, 0, ECHOENABLE);

	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[0;37;40m");
	if (*ptr == '\0') {
		clearline();
		return NULL;
	}
	j = strlen(ptr);
	if (termflags & (ANSITERM | RIPTERM)) putstr("\033[%dD", j);
	else	for (i = 0; i < j; i++) putchr('\b');
	putstr("%-*.*s", maxlen, maxlen, ptr);
	return ptr;
}

char *
usersetup(pnum, nam, maxlen)
	int pnum;
	char *nam;
	int maxlen;
{
	char *ptr;

	ptr = prompt_str(pnum, getuserconf(nam, NULL), maxlen);
	if (ptr != NULL) putuserconf(nam, ptr);
	else putuserconf(nam, "");
	return ptr;
}

#define	MAXPROMPTNUM	"99999"

int
prompt_num(pnum, defnum, maxnum)
	int pnum, defnum, maxnum;
{
	int maxlen, num;
	char *ptr;

	if (maxnum > 0) maxlen = strlen(itoa(maxnum))+1;
	else {
		maxlen = sizeof(MAXPROMPTNUM);
		maxnum = atoi(MAXPROMPTNUM);
	}
	if (defnum > maxnum) return 0;

	if (nchr || pnum < 1) {
		num = atoi(getstr(0, 2, ECHODISABLE));
		if (num < 0 || num > maxnum) num = 0;
		return num;
	}
	clearline();
	ptr = sysmsg(pnum);
	do {
		if (termflags & (ANSITERM | RIPTERM))
			putstr("\033[1;36m%s\033[5;37m:\033[0m ", ptr);
		else 	putstr("%s: ", ptr);
		if (defnum > 0)	ptr = editstr(itoa(defnum), maxlen, 2);
		else		ptr = getstr(maxlen, 2, ECHOENABLE);
		defnum = 0;
		clearline();
		num = atoi(ptr);
		ptr = sysmsg(MSG_TRYAGAIN);
	} while (num < 0 || num > maxnum);
	return num;
}

#define	MAXPROMPTLEN	70

prompt_yn(pnum, arg, def)
	int pnum;
	char *arg;
	char def;
{
	int y, yn, len = 0;
	char *p, *p2, buf[MAXPROMPTLEN+1];

	if (def == 'y' || def == 'Y') {
		yn = MSG_PROMPT_Y;
		y = TRUE;
	} else {
		yn = MSG_PROMPT_N;
		y = FALSE;
	}
	if (pnum || arg) {
		if (pnum) {
			p = sysmsg(pnum);
			if ((p2 = strchr(p, '%')) && p2[1] == 's') {
				if (arg) snprintf(buf, MAXPROMPTLEN, p, arg);
				else {
					int i;
					for (i = 0; *p && *p != '%' &&
					     i < MAXPROMPTLEN; i++, p++)
						buf[i] = *p;
					buf[i] = '\0';
				}
			} else	{
				if (arg) snprintf(buf, MAXPROMPTLEN, "%s %s", p, arg);
				else {
					strncpy(buf, p, MAXPROMPTLEN);
					buf[MAXPROMPTLEN] = '\0';
				}
			}
			p = buf;
		} else	p = arg;
		if (termflags & RIPTERM) {
			char prmt[256];
			if (y)	sprintf(prmt, "((*%s::Y@~Y~es,N@~N~o))", p);
			else	sprintf(prmt, "((*%s::N@~N~o,Y@~Y~es))", p);
			rip_query(0, 0, 0, prmt);
			ripio_flush();
		} else {
			putchr('\r');
			if (termflags & ANSITERM) putstr("\033[1;36m");
			len = putstr("%s %s", p, sysmsg(yn));
			if (termflags & ANSITERM) putstr("\033[0;37m");
		}
	}
	yn = getask(ECHODISABLE);
	if (!(termflags & RIPTERM) && len) hidestrlen(len);
	if (y && yn != 'n' && yn != 'N' &&
		(u_char)yn != 206 && (u_char)yn != 238) return TRUE;
	if (!y && yn != 'y' && yn != 'Y' &&
		(u_char)yn != 196 && (u_char)yn != 228) return TRUE;
	return FALSE;
}
