/*
 *	Copyright (c) 1994,1995 The CAD lab of the
 *	Siberian State Academy of Telecommunication, RU
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "drive.h"
#include "sysmsg.h"

/* MIME BASE64; see RFC1361 */

static char basis_64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static char index_64[128] = {
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,62, -1,-1,-1,63,
	52,53,54,55, 56,57,58,59, 60,61,-1,-1, -1,-1,-1,-1,
	-1, 0, 1, 2,  3, 4, 5, 6,  7, 8, 9,10, 11,12,13,14,
	15,16,17,18, 19,20,21,22, 23,24,25,-1, -1,-1,-1,-1,
	-1,26,27,28, 29,30,31,32, 33,34,35,36, 37,38,39,40,
	41,42,43,44, 45,46,47,48, 49,50,51,-1, -1,-1,-1,-1
};

#define char64(c)  (((c) < 0 || (c) > 127) ? -1 : index_64[(c)])

static void
output64chunk(c1, c2, c3, pads, outfile)
	int c1, c2, c3, pads;
	FILE *outfile;
{
	putc(basis_64[c1>>2], outfile);
	putc(basis_64[((c1 & 0x3)<< 4) | ((c2 & 0xF0) >> 4)], outfile);
	if (pads == 2) {
		putc('=', outfile);
		putc('=', outfile);
	} else if (pads) {
		putc(basis_64[((c2 & 0xF) << 2) | ((c3 & 0xC0) >>6)], outfile);
		putc('=', outfile);
	} else {
		putc(basis_64[((c2 & 0xF) << 2) | ((c3 & 0xC0) >>6)], outfile);
		putc(basis_64[c3 & 0x3F], outfile);
	}
}

/* To BASE64 */
void
tobase64(infile, outfile) 
	FILE *infile, *outfile;
{
	int c1, c2, c3, ct = 0;

	while ((c1 = getc(infile)) != EOF) {
		c2 = getc(infile);
		if (c2 == EOF) output64chunk(c1, 0, 0, 2, outfile);
		else {
			c3 = getc(infile);
			if (c3 == EOF)	output64chunk(c1, c2, 0, 1, outfile);
			else		output64chunk(c1, c2, c3, 0, outfile);
		}
		ct += 4;
		if (ct > 71) {
			putc('\n', outfile);
			ct = 0;
		}
	}
	if (ct) putc('\n', outfile);
	fflush(outfile);
}

/* From BASE64 */
void
frombase64(infile, outfile) 
	FILE *infile, *outfile;
{
	int c1, c2, c3, c4;
	int newline = 0, DataDone = 0;

	/* always reinitialize */
	while ((c1 = getc(infile)) != EOF) {
		if (isspace(c1)) {
			if (c1 == '\n') {
				if (newline++) break; /* \n\n -- exit */
			} else newline = 0;
			continue;
		}
		if (newline && c1 == '-') break; /* boundary line -- exit */
		if (DataDone) continue;
		newline = 0;
		do {
			c2 = getc(infile);
		} while (c2 != EOF && isspace(c2));
		do {
			c3 = getc(infile);
		} while (c3 != EOF && isspace(c3));
		do {
			c4 = getc(infile);
		} while (c4 != EOF && isspace(c4));
		if (c2 == EOF || c3 == EOF || c4 == EOF) {
			fprintf(stderr, "Premature EOF!\n");
			return;
		}
		if (c1 == '=' || c2 == '=') {
			DataDone = 1;
			continue;
		}
		c1 = char64(c1);
		c2 = char64(c2);
		putc(((c1<<2) | ((c2&0x30)>>4)), outfile);
		if (c3 == '=') DataDone = 1;
		else {
			c3 = char64(c3);
			putc((((c2&0XF) << 4) | ((c3&0x3C) >> 2)), outfile);
			if (c4 == '=') DataDone = 1;
			else {
				c4 = char64(c4);
				putc((((c3&0x03) <<6) | c4), outfile);
			}
		}
	}
}

#define DEC(c)	(((c) - ' ') & 077)

/*
 * output a group of 3 bytes (4 input characters).
 * the input chars are pointed to by p, they are to
 * be output to file f.  n is used to tell us not to
 * output all of them at the end of the file.
 */
static void
outdec(p, f, n)
	char *p;
	FILE *f;
	int n;
{
	int c1, c2, c3;

	c1 = DEC(*p) << 2 | DEC(p[1]) >> 4;
	c2 = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
	c3 = DEC(p[2]) << 6 | DEC(p[3]);
	if (n >= 1) putc(c1, f);
	if (n >= 2) putc(c2, f);
	if (n >= 3) putc(c3, f);
}

/* UUDECODE */
void
uudecode(in, out)
	FILE *in;
	FILE *out;
{
	char buf[80];
	char *bp;
	int n;

	for (;;) {
		/* for each input line */
		if (fgets(buf, sizeof(buf), in) == NULL) {
			fprintf(stderr, "Short file\n");
			return;
		}
		buf[sizeof(buf)-1] = '\0';
		n = DEC(buf[0]);
		if (n <= 0) break;
		bp = &buf[1];
		while (n > 0) {
			outdec(bp, out, n);
			bp += 4;
			n -= 3;
		}
	}
}

#define ENC(c) ((c) ? ((c) & 077) + ' ' : '`')

/*
 * output one group of 3 bytes, pointed at by p, on file f.
 */
void
outenc(p, f)
	char *p;
	FILE *f;
{
	int c1, c2, c3, c4;

	c1 = *p >> 2 & 077;
	c2 = ((*p << 4) & 060) | ((p[1] >> 4) & 017);
	c3 = ((p[1] << 2) & 074) | ((p[2] >> 6) & 03);
	c4 = p[2] & 077;
	putc(ENC(c1), f);
	putc(ENC(c2), f);
	putc(ENC(c3), f);
	putc(ENC(c4), f);
}

/* UUENCODE */
int
uuencode(in, out)
	FILE *in;
	FILE *out;
{
	char buf[80];
	register i, n;
	int lines = 0;

	do {
		n = fr(in, buf, 45);
		putc(ENC(n), out);
		for (i = 0; i < n; i += 3) outenc(&buf[i], out);
		putc('\n', out);
		lines++;
	} while (n > 0);
	return lines;
}

/* fr: like read but stdio */
int
fr(fd, buf, cnt)
	FILE *fd;
	char *buf;
	int cnt;
{
	register c, i;

	for (i = 0; i < cnt; i++) {
		c = getc(fd);
		if (c == EOF) return i;
		buf[i] = c;
	}
	return cnt;
}

static void
strcopy(s, t)
	char *s, *t;
{
	int i;
	for (i = 0; *s && *s != '\n'; s++) {
		if (!i && (unsigned char)*s <= 0x20) continue;
		if (*s != '"') {
			if (i++ < MAX_PARAM_LEN) *t++ = *s;
			else break;
		}
	}
	*t = '\0';
}

int
get_content(fp, eof, ctbuf, cebuf)
	FILE *fp;
	long eof;
	char *ctbuf, *cebuf;
{
	char buf[1024];

	*ctbuf = '\0';
	*cebuf = '\0';
	while (ftell(fp) < eof && fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		if (*ctbuf && (buf[0] == '\0' || buf[0] == '\n')) break;
		if (!strncasecmp(buf, "Content-Type: ", 14))
			strcopy(&buf[14], ctbuf);
		else if (!strncasecmp(buf, "Content-Transfer-Encoding: ", 27))
			strcopy(&buf[27], cebuf);
	}
	return *ctbuf ? 1 : 0;
}

int
get_begin(fp, eof, name)
	FILE *fp;
	long eof;
	char *name;
{
	long begin, mode;
	char buf[1024];

	begin = 0;
	while (ftell(fp) < eof && fgets(buf, sizeof(buf), fp) != NULL) {
		buf[sizeof(buf)-1] = '\0';
		if (!begin) {
			if (!strncmp(buf, "begin ", 6) &&
			    sscanf(buf, "begin %o %s", &mode, name) == 2)
				begin = ftell(fp);
		} else if (!strcmp(buf, "end\n")) {
			fseek(fp, begin, SEEK_SET);
			return 1;
		}
	}
	return 0;
}

int
extract_file(fp, func, name)
	FILE *fp;
	void (*func)();
	char *name;
{
	FILE *fpw;
	char buf[1024], *p;

	do {
		p = prompt_str(MSG_SAVEMSGFILE, name, MAXFILENAMELEN);
		if (p == NULL) return 0;
	} while (!legalfname(p));

	sprintf(buf, "%s/%s", homedir, p);
	if ((fpw = sfopen(buf, "w")) == NULL) return 0;
	(*func)(fp, fpw);	/* decode to file */
	sfclose(fpw);
	LOGIT(LOG_INFO, "ExtractFile to \"%s\"", buf);
	return 1;
}
