#include <tcp++/tcp_client.h>
#include <tcp++/tcp_server.h>

static void handle_sig_child(int sig_num);

class TcpGate : public TcpServer
 {
  protected:
   char* to_host;
   int to_port;
   TcpClient* client;

   void handle_client(int sock_fd);
   void run_server_to_client(int sock_fd);
   void run_client_to_server(int sock_fd);

  public:
   TcpGate(int port, int queue_size, char* log_name, char* init_to_host,
    int init_to_port)
     : TcpServer(port, queue_size, log_name)
    {
     to_host = init_to_host;
     to_port = init_to_port;
     info("Started tcp gate server");
    }
   
 };
 
 void TcpGate::run_server_to_client(int sock_fd)
  {
   int bytes = 0;
   char relay_buf[2048];
  
   while(1)
    {
     bytes = client->receive(relay_buf, sizeof(relay_buf));
     if(bytes <= 0)
      break;
     if(bytes > 0)
      if(write(sock_fd, relay_buf,bytes) == -1) 
       warn("server_to_client(): write error");
    }
   close(sock_fd);
   delete client;
   client = NULL;
  }
 void TcpGate::run_client_to_server(int sock_fd)
  {
   int bytes = 0;
   char relay_buf[2048];
   fd_set rfds;
   struct timeval tv;
   int ret_select;

   FD_ZERO(&rfds);
   FD_SET(sock_fd, &rfds);
  
   tv.tv_sec = 5;
   tv.tv_usec = 0;

   //fprintf(stderr, "socket_fd = %d\n", socket_fd);

   ret_select = select(sock_fd + 1, &rfds, NULL, NULL, NULL);
   //fprintf(stderr, "ret_select = %d\n", ret_select);
   
   if(ret_select == -1)
    { 
     warn("Select error: %s", strerror(errno));
     delete client;
     client = NULL;
     return;
    }

   while(1)
    {
     bytes = read(sock_fd, relay_buf, sizeof(relay_buf));
     if(bytes <= 0)
      break;
     if(bytes > 0)
      client->send(relay_buf, bytes);
    }
    close(sock_fd);

    delete client;
    client = NULL;
   }

 void TcpGate::handle_client(int sock_fd)
  {
   info("connect from %s", get_peer_addr(sock_fd));
   //fprintf(stderr, "connect from %s", get_peer_addr(sock_fd));
   client = new TcpClient(to_host, to_port, log);
   if(!*client)
    {
     warn("could not initialize client");
     exit(1);
    }
  
   client->connect();
   if(!*client)
    {
     warn("could not initialize client");
     exit(1);
    }
   pid_t fork_pid;

   switch(fork_pid = fork())
    {
     case -1: 
       warn("fork() failed, time to do the dishes");
       exit(1);
     case 0:
       run_server_to_client(sock_fd);
       break;
     default:
       signal(SIGCHLD, handle_sig_child);
       run_client_to_server(sock_fd);
       kill(fork_pid, SIGTERM);
       break;
    }
  }

  void die(char* fmt, ...)
   {
    va_list ap;
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    exit(1);
   }

  void handle_sig_child(int sig_num)
   {
     int status;
     wait3(&status, WNOHANG, 0);
     exit(0);
   }

  int main(int argc, char** argv)
   {
    if(argc != 2)
     {
      fprintf(stderr, "Usage: tcpgate conf_file\n");
      exit(1);
     }

    char line[256];
    char to_host[256];
    char log_file[256] = {"tcpgate.log"};
    char ip_rules_file[256] = "";
   
    int to_port;
    int port;

    to_host[0] = 0;

    ifstream is(argv[1]);
    if(!is)
     die("could not open %s\n", argv[1]);
     int line_num = 0;

     while(1)
      {
       is.getline(line, sizeof(line));
       if(is.eof())
        break;
       line_num++;
       char* param_name = strtok(line, " ");
       char* param_val = strtok(NULL, " ");

       if(!param_name)
        continue;

       if(!strcmp("port", param_name))
        {
	 if(param_val)
	  port = atoi(param_val);
	 else
	  die("Syntax error on line %d\n", line_num);
	}
       else if(!strcmp("to_port", param_name))
        {
	 if(param_val)
	  to_port = atoi(param_val);
	 else
	  die("Syntax error on line %d\n", line_num);
	}
       else if(!strcmp("to_host", param_name))
        {
	 if(param_val)
	  strncpy(to_host ,param_val, sizeof(to_host));
	 else
	  die("Syntax error on line %d\n", line_num);
	}
       else if(!strcmp("log_file", param_name))
        {
	 if(param_val)
	  strncpy(log_file ,param_val, sizeof(log_file));
	 else
	  die("Syntax error on line %d\n", line_num);
	}
       else if(!strcmp("ip_rules_file", param_name))
        {
	 if(param_val)
	  strncpy(ip_rules_file ,param_val, sizeof(ip_rules_file));
	 else
	  die("Syntax error on line %d\n", line_num);
	}
       else
	  die("Syntax error on line %d\n", line_num);

      }
    int listen_queue = 50;

    if(!to_host[0])
     die("Missing host name in the config file");

    TcpGate gate_server(port, listen_queue, log_file, to_host, to_port);
    
    if(ip_rules_file[0])
     {
      ifstream rules(ip_rules_file);
      if(!rules)
       die("Could not open IP rules file %s", ip_rules_file);

      while(1)
       {
        char* netmask, *netnum;
	char buf[128];
	rules.getline(buf, sizeof(buf));
	if(rules.eof())
	 break;

	netnum = strtok(buf, " /");
     	if(!netnum)
	 die("Syntax error in the IP rules file");
        netmask = strtok(NULL, " ");
     	if(!netmask)
	 die("Syntax error in the IP rules file");
       
	gate_server.add_ip_rule(netnum, netmask);
       }
      
      gate_server.enable_access_control();
     }

    gate_server.run_server();

    return 0;
   }
