#
# spec file for package squid (Version 2.3.STABLE4)
# 
# Copyright  (c)  2001  SuSE GmbH  Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
# 
# please send bugfixes or comments to feedback@suse.de.
#

# neededforbuild  cyrus-sasl openldap2 openldap2-client openldap2-devel openssl openssl-devel sgmltool sharutils sp sp-devel tetex
# usedforbuild    aaa_base aaa_dir autoconf automake base bash bindutil binutils bison bzip compress cpio cpp cracklib cyrus-sasl db devs diffutils e2fsprogs file fileutils findutils flex gawk gcc gdbm gdbm-devel gettext glibc glibc-devel gpm gppshare grep groff gzip kbd less libtool libz m4 make man mktemp modutils ncurses ncurses-devel net-tools netcfg openldap2 openldap2-client openldap2-devel openssl openssl-devel pam pam-devel patch perl ps rcs readline rpm sendmail sgmltool sh-utils shadow sharutils sp sp-devel strace syslogd sysvinit te_ams te_latex tetex texinfo textutils timezone unzip util-linux vim

Name:         squid
Summary:      Squid V2.3 WWW proxy server
Version:      2.3.STABLE4
Release:      121
Copyright:    (C) 2000 by Duane Wessels, University of California, San Diego (UCSD)
Group:        Networking/Daemons
Provides:     http_proxy squid2 squid23
Conflicts:    squid-beta
Obsoletes:    squid2 squid23
Autoreqprov:  on
Source:       squid-%{version}-src.tar.bz2
%define       squid_ldapauth_version 1.3
Source1:      squid_ldapauth-%{squid_ldapauth_version}.tar.bz2
Source2:      rc.squid
Source3:      rc.config.squid
Source4:      README.SuSE
Source5:      pam.squid
Patch:        squid-%{version}.dif
Patch1:       hno-2_3.patch
Patch2:       squid-2.3.stable4-ftp_icon_not_found.patch
Patch3:       squid-2.3.stable4-internal_dns_rcode_table_formatting.patch
Patch4:       squid-2.3.stable4-ipfw_configure.patch
Patch5:       squid-2.3.stable4-invalid_ip_acl_entry.patch
Patch6:       squid-2.3.stable4-accel_only_access.patch
Patch7:       squid-2.3.stable4-html_quoting.patch
Patch8:       squid-2.3.stable4-carp-assertion.patch
Patch9:       squid-2.3.stable4-snmp-community-null-pointer.patch
Patch10:      squid_ldapauth-%{squid_ldapauth_version}.dif
Patch11:      squid-2.3.STABLE4.filter-0.7.patch
Patch12:      squid-2.3.STABLE4.filter-vscan-0.1.patch

%description
 New version of the Squid V2.3 WWW Proxy Server
Home page: http://www.squid-cache.org
Important changes since Squid 2.2:
Domain name matching:
The function which checks for a match between a host name and a
domain name has been rewritten and its behavior is now slightly
different. Previously, the domain 'com' would match the host name
'foo.com', but this is no longer the case. Now, if you must write
'.com' to match 'foo.com'.
Removed dns servers:
In this version, DNS lookups are done by the main Squid process
by default.
Truncate vs. unlink:
In version 2.2, Squid truncated disk files (by default) instead
of unlinking them. This caused some installations to run out
of inodes on the cache disks. Even though truncate makes Squid
a bit faster, we have made the default to use unlink again.
Look at http://squid.nlanr.net/Versions/v2/2.3/ for a full
description.

SuSE series: n

%prep
%setup -n squid-%{version} -a 1
%patch -p1
%patch1 -p1
%patch2 -p0
%patch3 -p0
%patch4 -p0
%patch5 -p0
%patch6 -p0
%patch7 -p0
%patch8 -p0
%patch9 -p0
%patch11 -p1
%patch12 -p1
cd squid_ldapauth*
%patch10

%build
CFLAGS='-Wall -O2 -pipe'
LDFLAGS=' '
ulimit -n 4096
autoconf
./configure --prefix=/usr --sysconfdir=/etc --bindir=/usr/sbin \
	--localstatedir=/var/squid --libexecdir=/usr/sbin \
	--datadir=/usr/share/squid --sharedstatedir=/var/squid \
	--enable-snmp --enable-htcp --enable-delay-pools --enable-filters=yes
make
make -C squid_ldapauth-%{squid_ldapauth_version}
make -C auth_modules/PAM
make -C auth_modules/NCSA
#make -C doc/Programming-Guide

%install
mkdir -p /var/squid/{cache,logs}
make install
make install -C auth_modules/PAM
make install -C auth_modules/NCSA
chown squid.root -R /var/squid
chmod 700 /var/squid
install %{SOURCE2} /etc/init.d/squid
ln -sf ../../etc/init.d/squid /usr/sbin/rcsquid
mkdir -p /var/adm/fillup-templates
install -m 644 %{SOURCE3} /var/adm/fillup-templates
install -d -m 755 doc/scripts
install scripts/*.pl doc/scripts
mv /usr/sbin/cachemgr.cgi doc/scripts
install -d -m 755 doc/contrib
install contrib/*.pl doc/contrib
#rm doc/Programming-Guide/Makefile
install -m 644 %{SOURCE4} .
install -m 644 %{SOURCE5} /etc/pam.d/squid
chown squid.shadow /usr/sbin/pam_auth
chmod g+s /usr/sbin/pam_auth
cd squid_ldapauth-%{squid_ldapauth_version}
install -m 750 -osquid -groot squid_ldapauth /usr/sbin
cp README ../README.squid_ldapauth
cp CREDITS ../CREDITS.squid_ldapauth
cp squid_ldapauth.conf ..

%pre
if [ -e usr/share/squid/errors ]; then
  #echo -n "warning: "
  usr/bin/old usr/share/squid/errors
fi

%post
echo "Updating etc/rc.config..."
if [ -x bin/fillup ] ; then
  bin/fillup -q -d = etc/rc.config var/adm/fillup-templates/rc.config.squid
else
  echo "ERROR: fillup not found. This should not happen. Please compare"
  echo "etc/rc.config and var/adm/fillup-templates/rc.config.squid and"
  echo "update by hand."
fi
sbin/insserv etc/init.d/squid

%postun
sbin/insserv etc/init.d/

%files
%dir /var/squid/cache
%dir /var/squid/logs
%dir /usr/share/squid
%config(noreplace) /etc/squid.conf
%config /etc/pam.d/squid
%config /etc/init.d/squid
%config /usr/share/squid/mib.txt
%config /usr/share/squid/mime.conf
/var/adm/fillup-templates/rc.config.squid
/usr/sbin/RunAccel
/usr/sbin/RunCache
/usr/sbin/client
/usr/sbin/dnsserver
/usr/sbin/rcsquid
/usr/sbin/squid
/usr/sbin/unlinkd
/usr/sbin/pam_auth
/usr/sbin/ncsa_auth
/usr/sbin/squid_ldapauth
/usr/share/squid/errors
/usr/share/squid/icons
/usr/lib/allowtype.so
/usr/lib/auth_authsrv.so
/usr/lib/auth_passwd.so
/usr/lib/bugfinder.so
/usr/lib/cookies.so
/usr/lib/gifanim.so
/usr/lib/htmlfilter.so
/usr/lib/redirect.so
/usr/lib/rejecttype.so
/usr/lib/script.so
/usr/lib/vscan.so
%doc CONTRIBUTORS COPYING COPYRIGHT CREDITS
%doc ChangeLog QUICKSTART README README.SuSE TODO
%doc doc/HTTP-codes.txt doc/draft-vixie-htcp-proto-04.txt
%doc doc/contrib doc/scripts doc/Programming-Guide 
%doc errors src/squid.conf
%doc README.squid_ldapauth CREDITS.squid_ldapauth
%doc squid_ldapauth.conf

%changelog -n squid
* Tue Sep 04 2001 - bodammer@suse.de
- specfile fix: install /etc/squid.conf with noreplace [Bug #10023]
* Fri Aug 24 2001 - ro@suse.de
- removed /lib/security path from pam.d config file
* Thu Aug 16 2001 - bodammer@suse.de
- initscript and textfiles moved away from squid-2.3.STABLE4.dif
* Mon Aug 13 2001 - ro@suse.de
- changed neededforbuild <sp_libs> to <sp-devel>
* Thu May 10 2001 - bodammer@suse.de
- initscript fix: don't start squid in runlevel 2 [bug #7956]
* Wed May 09 2001 - mfabian@suse.de
- bzip2 sources
* Tue Apr 17 2001 - bodammer@suse.de
- initscript fix: check for running squid before creating cache-dir
* Thu Apr 05 2001 - bodammer@suse.de
- squid.conf: allow localhost access to squid by default
- initscript: ulimit -n 4096 added to increase filedescriptors
- cachemgr.cgi moved to doc/scripts
- build of Programming-Guide removed from specfile
* Fri Mar 30 2001 - bodammer@suse.de
- initscript-fix: $named for added for required startup
* Wed Mar 28 2001 - bodammer@suse.de
- new initscript more LSB conform
* Thu Mar 22 2001 - bodammer@suse.de
- new patch from www.squid-cache.org applied
* Fri Mar 16 2001 - kukuk@suse.de
- Fix bogus requires
* Thu Mar 15 2001 - ro@suse.de
- changed for openldap2
* Thu Mar 15 2001 - ro@suse.de
- fixed neededforbuild for openldap
* Tue Feb 13 2001 - bodammer@suse.de
- package squid23 renamed to squid
- specfile: Obsoletes squid2 and squid23 added
  Conflicts squid-beta added (instead of squid24)
- pam_auth: permissions set to sgid shadow
- build of doc/Programming-Guide fixed
* Fri Jan 19 2001 - bodammer@suse.de
- specfile fix: ulimit was missing and conflicts squid24 added
* Tue Dec 19 2000 - bodammer@suse.de
- squid.h patched to allow increase of available filedescriptors:
  set to 4096 at buildtime by "ulimit -n 4096" in spec-file
* Tue Dec 12 2000 - ro@suse.de
- use official tags for required-start
* Mon Dec 11 2000 - bodammer@suse.de
- error in initscript fixed
* Wed Dec 06 2000 - bodammer@suse.de
- Requires ldaplib added in specfile
- errors in README.SuSE fixed
* Tue Dec 05 2000 - bodammer@suse.de
- hno-patch by Henrik Nordstrom included
- Initscript now checks for a running squid
* Mon Dec 04 2000 - bodammer@suse.de
- new patches from www.squid-cache.org included
* Tue Nov 28 2000 - bodammer@suse.de
- Fix location of rcscript
* Fri Nov 24 2000 - bodammer@suse.de
- rcscript update
* Mon Nov 06 2000 - ro@suse.de
- fixed neededforbuild
* Sat Oct 28 2000 - kukuk@suse.de
- Fix need for build filelist
* Mon Sep 18 2000 - bodammer@suse.de
- initscript reload-option fixed
- more patches from www.squid-cache.org
* Mon Jul 24 2000 - bodammer@suse.de
- another patch from www.squid-cache.org added
* Fri Jul 21 2000 - bodammer@suse.de
- patch ftp_icon_not_found from www.squid-cache.org added
* Tue Jul 18 2000 - bodammer@suse.de
- update -> squid-2.3.STABLE4
* Mon Jun 26 2000 - bodammer@suse.de
- another patch from www.squid-cache.org added
* Tue May 23 2000 - bodammer@suse.de
- specfile-fix: installation of docu changed
- initscript fixed
* Thu May 18 2000 - bodammer@suse.de
- new patches ("Disk space over the limit") included
* Wed May 17 2000 - bodammer@suse.de
- update -> squid-2.3STABLE3
* Wed Apr 12 2000 - bodammer@suse.de
- logfile-rotation disabled in squid.conf to avoid interaction
  with logfile-compression configured in /etc/logfiles
* Mon Mar 13 2000 - bodammer@suse.de
- new patches from squid.nlanr.net included
* Fri Mar 03 2000 - bodammer@suse.de
- update -> squid-2.3STABLE2
* Wed Feb 23 2000 - bodammer@suse.de
- more patches from squid.nlanr.net included
- init-script fix: wait for squid to shutdown
- location of pid-file changed to /var/run
* Wed Feb 16 2000 - bk@suse.de
- initial squid2.3STABLE1 package by bodammer
