#!/usr/bin/perl


# NetBilling - stat
#
# (C) 2003, Michael Klimenko
#
# $Revision: 2.3 $
#

use DBI;
use CGI;

require "./procs.pl";

$scriptpath=$spath_stat;

html_start($lang{STAT_TITLE});
print_navmenu();


my $co = new CGI;

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:database=$dbname;host=$dbhost",
                           $dbuser, $dbpass,{'RaiseError' => 1});

if ($dbh == undef) { print "Error connecting to database"; exit(-1); }

print "<DIV align=center><h1>$orgtitle</h1><h2>$lang{STAT_HEAD}</h2></DIV><br>";


if ( ($co->param('Action') eq 'getstat') )  {
    get_stats($dbh, $co->param('smon'), $co->param('syear'), $co->param('emon'), $co->param('eyear'));
} else {
    # print query stats form
    my $null;
    ($null,$null,$null,$null,my $month,my $year,$null,$null,$null) = localtime(time);
    $month++; $year+=1900;

    eval { $sth = $dbh->prepare("SELECT MIN(Year) AS MINYEAR FROM Traffic");$sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    my $minyear;
    if (my $ref = $sth->fetchrow_hashref()) {
	$minyear = $ref->{'MINYEAR'};
    } else {
	$minyear = $year;
    }
    $sth->finish();
    print "<FORM ACTION=$scriptpath METHOD=POST>";
    print "<INPUT TYPE=hidden NAME=Action VALUE=getstat>";
    print "<TABLE align=center>\n";
    print "<TR><TD align=right>$lang{STAT_PERIOD_START}:</TD><TD>"; select_month("smon",1); select_year("syear",$minyear,$year,0); print "</TD></TR>\n";
    print "<TR><TD align=right>$lang{STAT_PERIOD_END}:</TD><TD>"; select_month("emon",$month); select_year("eyear",$minyear,$year,1); print "</TD></TR>\n";
    print "<TR><TD align=center colspan=2><INPUT type=submit VALUE=\"$lang{BTN_GET_REPORT}\"</TD></TR>\n";
    print "</TABLE>\n";
    print "</FORM>\n";
}

$dbh->disconnect();
html_end();

exit;

##########################################

#  
sub get_stats($$$$$)
{
    (my $dbh, my $smon, my $syear, my $emon, my $eyear) = @_;
    my $sth; my $zonelist;
    #   
    eval { $sth = $dbh->prepare("SELECT ID,Name FROM Zone"); $sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    while (my $ref = $sth->fetchrow_hashref()) {
	$zonelist{$ref->{'ID'}} = $ref->{'Name'};
    }
    $sth->finish();
    #        
    eval { $sth = $dbh->prepare("SELECT Zone_ID,Year,Month,SUM(Inbound) AS INB,SUM(Outbound) AS OUTB FROM Traffic WHERE CONCAT(Year,LPAD(Month,2,'0')) >= " . (sprintf "%4d%02d",$syear,$smon) . " AND CONCAT(Year,LPAD(Month,2,'0')) <= " . (sprintf "%4d%02d",$eyear,$emon) . " GROUP BY Zone_ID,Year,Month ORDER BY Year,Month,Zone_ID"); $sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    #  
    print "<DIV align=center><h3>".sprintf($lang{STAT_REPORT_HEAD}, $monthrnames[$smon], $syear, $monthnames[$emon], $eyear)."</h3></DIV>";
    print "<TABLE border=1 align=center  cellspacing=0 align=center class=btbl>\n";
    my @zkeys = keys %zonelist;
    print "<TR style='background-color:#4fafaf'><TH class=btbl rowspan=2>$lang{STAT_REPORT_PERIOD}</TH><TH class=btbl rowspan=2>$lang{STAT_REPORT_DIR}</TH><TH class=btbl colspan=".($#zkeys+1).">$lang{STAT_REPORT_ZONES}</TH></TR>";
    print "<TR style='background-color:#4fafaf'>";
    foreach my $zid (sort keys %zonelist) {
	print "<TH class=btbl>$zonelist{$zid}</TH>";
    }
    print "</TR>\n";
    #      $stat
    while (my $ref = $sth->fetchrow_hashref()) {
	$stat{(sprintf "%4d%02d",$ref->{'Year'},$ref->{'Month'})}{$ref->{'Zone_ID'}} = sprintf("%.3f",$ref->{'INB'}/$bytesinkb/$bytesinkb) .  "&nbsp;$lang{MEGABYTES}<br>" . sprintf("%.3f",$ref->{'OUTB'}/$bytesinkb/$bytesinkb) . "&nbsp;$lang{MEGABYTES}";
    }
    $sth->finish();
    #  
    foreach my $date (sort keys %stat) {
	print "<TR style='background-color:#efef9f'>";
	print "<TD class=btbl>".verbose_date($date)."</TD><TD align=right class=btbl>$lang{STAT_REPORT_DIR_INB}<br>$lang{STAT_REPORT_DIR_OUTB}</TD>";
	foreach my $zid (sort keys %zonelist) {
	    print "<TD align=right class=btbl>".((defined($stat{$date}{$zid}))?($stat{$date}{$zid}):("&nbsp;"))."</TD>";
	}
	print "</TR>";
    }
    print "</TABLE>\n<br>\n";
}

#     "yyyymm"   "M yyyy"
sub verbose_date($)
{
    (my $d) = @_;
    return $monthnames[substr($d,4,2)] . " " . substr($d,0,4);
}

#   
sub select_month($$)
{
    (my $name, my $currentmonth) = @_;
    print "<SELECT NAME=$name>";
    for (my $i=1; $i<=12; $i++) {
	print "<OPTION VALUE=$i" . (($i==$currentmonth) ? " SELECTED" : "") . ">$monthnames[$i]";
    }    
    print "</SELECT>\n";
}

#   
sub select_year($$$$)
{
    (my $name, my $startyear, my $endyear, my $f) = @_;
    print "<SELECT NAME=$name>";
    for ($y=$startyear; $y<=$endyear; $y++) {
        if ($f==0 && $y==$startyear) {
            print "<OPTION VALUE=$y SELECTED>$y";
        } elsif ($f==1 && $y==$endyear) {
            print "<OPTION VALUE=$y SELECTED>$y";
        } else {
            print "<OPTION VALUE=$y>$y";
        }
    }
    print "</SELECT>\n";
}
