
#
# NetBilling - procs
#
# (C) 2003, Michael Klimenko
#
# $Revision: 2.10 $
#

#     
my $config_file = "/home/httpd/netbill/etc/netbill.conf";


###################################################################################
###################################################################################
###################################################################################

use Sys::Syslog;

#   
open(F, $config_file) || die "Can't open $config_file\n";
while(<F>) {
    next if (/^#/);
    if (/^(\S+)\s+(.+)$/) {
	${$1} = $2;
    }
}
close(F);
#    
$language = $default_language;
#   
open(F, $languagedir.$language) || die "Can't open ${languagedir}$language\n";
while(<F>) {
    next if (/^#/);
    if (/^(\S+)=(.+)$/) {
        $lang{$1} = $2;
	$lang{$1} =~ s/\\n/\n/g;
    }
}
close(F);


#    
@mask_const = (
0x00000000,0x80000000,0xC0000000,0xE0000000,0xF0000000,0xF8000000,0xFC000000,0xFE000000,
0xFF000000,0xFF800000,0xFFC00000,0xFFE00000,0xFFF00000,0xFFF80000,0xFFFC0000,0xFFFE0000,
0xFFFF0000,0xFFFF8000,0xFFFFC000,0xFFFFE000,0xFFFFF000,0xFFFFF800,0xFFFFFC00,0xFFFFFE00,
0xFFFFFF00,0xFFFFFF80,0xFFFFFFC0,0xFFFFFFE0,0xFFFFFFF0,0xFFFFFFF8,0xFFFFFFFC,0xFFFFFFFE,0xFFFFFFFF
);

#  
@monthnames = ('',$lang{MON_JAN},$lang{MON_FEB},$lang{MON_MAR},$lang{MON_APR},$lang{MON_MAY},$lang{MON_JUN},
	          $lang{MON_JUL},$lang{MON_AUG},$lang{MON_SEP},$lang{MON_OCT},$lang{MON_NOV},$lang{MON_DEC});

#     
@monthrnames = ('',$lang{MONR_JAN},$lang{MONR_FEB},$lang{MONR_MAR},$lang{MONR_APR},$lang{MONR_MAY},$lang{MONR_JUN},
                   $lang{MONR_JUL},$lang{MONR_AUG},$lang{MONR_SEP},$lang{MONR_OCT},$lang{MONR_NOV},$lang{MONR_DEC});


#  
my $version = '2.0';
###################################################################################

#   HTML
sub html_start($)
{
    my $msg = shift;
    print "Content-type: text/html; charset=\"$lang{ENCODING}\"\n\n";
    print "<HTML><HEAD><META HTTP-EQUIV=Content-Type CONTENT=text/html; charset=$lang{ENCODING}>\n";
    print "<META http-equiv=\"Expires\" content=\"Tue, 20 Aug 1996 0:00:00 GMT\">\n";
    print "<TITLE>NetBilling v$version - $msg</TITLE></HEAD>";
    print "<STYLE type=text/css>\n";
    print "  BODY { font-family: Tahoma; font-size: 12px; color:#000000; background-color: #dfefff; margin-left:10px; margin-right:10px; margin-top:3px; margin-bottom:0px;}\n";
    print "  A { color:#225588; }\n";
    print "  TABLE { font-family: Tahoma; font-size: 12px; }\n";
    print "  TR { font-family: Tahoma; font-size: 12px; }\n";
    print "  TD { font-family: Tahoma; font-size: 12px; }\n";
    print "  .btbl { border-color: #4fafaf;  border-width: 1px; }\n";
    print "  A.atbl { color: #000030; text-decoration: none; }\n";
    print "</STYLE>\n";
    print "<BODY>";
}

#   HTML
sub html_end()
{
    print "<DIV align=center><hr><FONT size=-1 face=arial,tahoma,verdana>";
    print "<A STYLE=\"text-decoration:none;color:#000000\" href=\"http://netbilling.nm.ru\">NetBilling v$version</A><br>";
    print "<A STYLE=\"text-decoration:none;color:#000000\" href=\"mailto:netbilling\@nm.ru\">(C) 2003-2004, Michael Klimenko</A><br>";
    print "</FONT></DIV>\n";
    print "</BODY></HTML>";
}

#   
sub print_navmenu()
{
    print "<DIV align=right>[&nbsp;";
    print "<A href=$spath_log>$lang{MODNAME_LOG}</A>&nbsp;|&nbsp;";
    print "<A href=$spath_stat>$lang{MODNAME_STAT}</A>&nbsp;|&nbsp;";
    print "<A href=$spath_income>$lang{MODNAME_INCOME}</A>&nbsp;|&nbsp;";
    print "<A href=$spath_outlay>$lang{MODNAME_OUTLAY}</A>&nbsp;|&nbsp;";
    print "<A href=$spath_cards>$lang{MODNAME_CARDS}</A>&nbsp;|&nbsp;" if ($cards_needed);
    print "<A href=$spath_zones>$lang{MODNAME_ZONES}</A>&nbsp;|&nbsp;";
    print "<A href=$spath_clients>$lang{MODNAME_CLIENTS}</A>";
    print "&nbsp;]</DIV>";
}

#  IP    
sub ipnum2str($)
{
    my $num = shift;
    my $res = '';
    $res .= ($num & 0xFF000000) >> 24;
    $res .= '.';
    $res .= ($num & 0x00FF0000) >> 16;
    $res .= '.';
    $res .= ($num & 0x0000FF00) >> 8;
    $res .= '.';
    $res .= ($num & 0x000000FF);
    return $res;
}

#  IP    
sub ipstr2num($)
{
    my $str = shift;
    my $res = 0;
    $str =~ /(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})/;
    $res = ($1 << 24) + ($2 << 16) + ($3 << 8) + $4;
    return $res;
}

#     
sub get_date()
{
    (my $sec,my $min,my $hour,my $mday,my $mon,my $year,my $wday,my $yday,my $isdst) = localtime(time);
    return sprintf("%02d:%02d:%02d %02d.%02d.%4d",$hour,$min,$sec,$mday,$mon+1,$year+1900);
}



#    
sub log_msg($)
{
    my $msg = shift;
    if (defined $syslogfacility) {
        openlog('netbill', 'pid', $syslogfacility);
    } else {
        openlog('netbill', 'pid', 'user');
    }
    syslog('info', $msg);
    closelog();

}

#      
sub log_user_event($$$)
{
    (my $dbh, my $cid, my $msg) = @_;
    eval { $dbh->do("INSERT INTO Log VALUES ($cid,NOW(),'$msg')"); };
    if ($@) { print "   Log: $@<br>";}
}

##################################################################################

#     
sub add_money($$$)
{
    (my $dbh, my $cid, my $sum) = @_;
    if ($sum <= 0) { return; };
    eval { $dbh->do("UPDATE Client SET Credit=(Credit+$sum) WHERE ID=$cid") };
    if ($@) {print "<FONT color=red>    ($@).</FONT><br>";return;};
    #   
    eval { $dbh->do("INSERT INTO Income VALUES ($cid,NOW(),$sum)") };
    if ($@) {print "<FONT color=red>     ($@).</FONT><br>"};
}

#     
sub get_money($$$$$)
{
    (my $dbh, my $cid, my $sum, my $descr, my $cancredit) = @_;
    eval { $dbh->do("UPDATE Client SET Credit=(Credit-$sum) WHERE ID=$cid"); };
    if ($@) {print "<FONT color=red>    ($@).</FONT><br>";log_msg("    ($@).");return;};
    #   
    eval { $dbh->do("INSERT INTO Outlay VALUES ($cid,NOW(),$sum,'$descr')"); };
    if ($@) {print "<FONT color=red>     ($@).</FONT><br>"; log_msg("     ($@).");};
    #  ,           
    my $sth;
    eval { $sth=$dbh->prepare("SELECT IP,Credit FROM Client WHERE ID=$cid");$sth->execute(); };
    if ($@) {print "<FONT color=red>     ($@).</FONT><br>"; log_msg("     ($@).");};
    my $ref=$sth->fetchrow_hashref();
    if (($ref->{'Credit'} <= 0) && !$cancredit) {
	eval {
	    $dbh->do("UPDATE Client SET Active=0 WHERE ID=$cid");
	    #      
	    log_user_event($dbh, $cid, "  -  ");
	    $ENV{'PATH'} = '/bin:/usr/bin'; # make tainted
	    delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};
	    my $cmd = "$spath_deactivate $ref->{'IP'}";
	    $cmd =~ /^(.+)$/;
	    log_msg("Exec $1");
	    system($1); #   -  
	}
    }
    if ($@) { print "<FONT color=red>  : $@</FONT>";}
}

1;
