#!/usr/bin/perl


# NetBilling - income
#
# (C) 2003, Michael Klimenko
#
# $Revision: 2.0 $
#

use DBI;
use CGI;

require "./procs.pl";

$scriptpath=$spath_income;

html_start($lang{INC_TITLE});
print_navmenu();


my $co = new CGI;

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:database=$dbname;host=$dbhost",
                           $dbuser, $dbpass,{'RaiseError' => 1});

if ($dbh == undef) { print "Error connecting to database"; exit(-1); }

print "<DIV align=center><h1>$orgtitle</h1><h2>$lang{INC_HEAD}</h2></DIV><br>";

# get incomes of current month by default
my $null;
($null,$null,$null,$null,my $month,my $year,$null,$null,$null) = localtime(time);
$month++; $year+=1900;

if ( ($co->param('Action') eq 'addmoney') && (defined $co->param('ID')) ) {
    if ($co->param('Sum') <= 0) { print "<FONT color=red>$lang{INC_ERR_NEGATIVE_SUMM}</FONT>";
    } else { add_money($dbh, $co->param('ID'), $co->param('Sum'));};
} elsif ( ($co->param('Action') eq 'arch') && (defined $co->param('M')) && (defined $co->param('Y')) )  {
    #  
    $month = $co->param('M'); $year = $co->param('Y');
}
    print "<TABLE width=100% align=center><TR valign=top align=center><TD>";
    get_userincomes($month,$year);
    print "</TD><TD>";
    get_incomearch();
    print "</TD></TR></TABLE><hr>\n";
    get_incomelist($month,$year);
    # print add money form
    print "<DIV align=center><h3>$lang{INC_ADD_MONEY}</h3></DIV>\n";
    print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\"><INPUT TYPE=hidden NAME=Action VALUE=addmoney>";
    print "<TABLE align=center><TR><TD>$lang{INC_CLIENT}:</TD><TD>";
    print "<SELECT NAME=ID>";
    my $sth;
    eval { $sth = $dbh->prepare("SELECT ID,IP FROM Client ORDER BY IP");$sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    while (my $ref=$sth->fetchrow_hashref()) {
	print "<OPTION VALUE='$ref->{'ID'}'>$ref->{'IP'}";
    }
    $sth->finish();
    print "</SELECT></TD></TR>";
    print "<TR><TD>$lang{INC_SUMM}:</TD><TD><INPUT TYPE=text NAME=Sum VALUE='0.00'></TD></TR>";
    print "</TABLE>";
    print "<DIV align=center><INPUT TYPE=submit VALUE='$lang{BTN_ADD_MONEY}'></DIV></FORM>";

$dbh->disconnect();
html_end();

exit;

##########################################

#      
sub get_incomelist($$)
{
    (my $month, my $year) = @_;
    my $sth;
    eval { $sth = $dbh->prepare("SELECT I.*,C.ID,C.IP FROM Income I,Client C WHERE C.ID=I.Client_ID AND MONTH(I.PayTime)=$month AND YEAR(I.PayTime)=$year ORDER BY PayTime");$sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    print "<DIV align=center><h3>".sprintf($lang{INC_REPORT_HEAD},$monthnames[$month],$year)."</h3></DIV>\n";
    print "<TABLE border=1 align=center  cellspacing=0 align=center class=btbl>";
    print "<TR style='background-color:#4fafaf'><TH class=btbl>$lang{INC_TIME}</TH><TH class=btbl>$lang{INC_CLIENT}</TH><TH class=btbl>$lang{INC_SUMM}</TH></TR>";
    while (my $ref = $sth->fetchrow_hashref()) {
	print "<TR style='background-color:#efef9f'><TD class=btbl>$ref->{'PayTime'}</TD><TD class=btbl><A href=$spath_clients?Action=show&ID=$ref->{'ID'} class=atbl>$ref->{'IP'}</A></TD><TD class=btbl>$ref->{'Sum'}&nbsp;$currencysign</TD></TR>";
    }
    $sth->finish();
    print "</TABLE><hr>\n";
}

#        
sub get_userincomes($$)
{
    (my $month, my $year) = @_;
    my $sth;
    eval { $sth = $dbh->prepare("SELECT C.ID,C.IP,SUM(I.Sum) Sum1 FROM Income I,Client C WHERE C.ID=I.Client_ID AND MONTH(I.PayTime)=$month AND YEAR(I.PayTime)=$year GROUP BY I.Client_ID ORDER BY PayTime");$sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    print "<DIV align=center><h3>   ".$monthnames[$month]." $year .</h3></DIV>\n";
    print "<TABLE border=1 align=center  cellspacing=0 align=center class=btbl>";
    print "<TR style='background-color:#4fafaf'><TH class=btbl>$lang{INC_CLIENT}</TH><TH class=btbl>$lang{INC_SUMM}</TH></TR>";
    my $total = 0; #   
    while (my $ref = $sth->fetchrow_hashref()) {
	print "<TR style='background-color:#efef9f'><TD class=btbl><A href='$spath_clients?Action=show&ID=$ref->{'ID'}' class=atbl>$ref->{'IP'}</A></TD><TD class=btbl>$ref->{'Sum1'}&nbsp;$currencysign</TD></TR>";
	$total+=$ref->{'Sum1'};
    }
    $sth->finish();
    # 
    print "<TR style='BACKGROUND-COLOR:#4fafaf'><TD colspan=2 class=btbl></TD></TR><TR style='background-color:#efef9f'><TD align=right class=btbl><B>$lang{INC_RESULT}&nbsp;</B></TD><TD align=center class=btbl><B>${total}&nbsp;$currencysign</B></TD></TR>";
    print "</TABLE>\n";
}

#    
sub get_incomearch($$)
{
    (my $month, my $year) = @_;
    my $sth;
    eval { $sth = $dbh->prepare("SELECT DISTINCT CONCAT(MONTH(PayTime),\".\",YEAR(PayTime)) date  FROM Income ORDER BY PayTime");$sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    print "<DIV align=center><h3>$lang{INC_ARCH_HEAD}</h3></DIV>\n";
    print "<TABLE border=1 align=center cellpadding=2 cellspacing=0 align=center class=btbl>";
    print "<TR style='background-color:#efef9f'>";
    my $dcount = 1;
    while (my $ref = $sth->fetchrow_hashref()) {
	$ref->{'date'} =~ /(^\d{1,2})\.(\d+)$/;
	my $m = $1; my $y = $2;
	my $date = sprintf "%02d.%d",$m,$y;
	print "<TD class=btbl><A href='$scriptpath?Action=arch&M=$m&Y=$y' class=atbl>$date</A></TD>";
	if ($dcount % 4 == 0) {print "</TR><TR style='background-color:#efef9f'>";}
	$dcount++;
    }
    $sth->finish();
    print "</TABLE>\n";
}
