#
#    NetBilling v2 Database
#
# (C) 2003, Michael Klimenko
#
# $Revision: 2.1 $
#

DROP TABLE IF EXISTS Client;
CREATE TABLE Client (
    ID INTEGER AUTO_INCREMENT PRIMARY KEY,
    IP CHAR(15) NOT NULL DEFAULT '0.0.0.0',
    MAC CHAR(17) NOT NULL DEFAULT '00:00:00:00:00:00',
    Credit DECIMAL(8,5) NOT NULL DEFAULT 0,
    Discount TINYINT DEFAULT 0,
    MonthFee DECIMAL(8,2) NOT NULL DEFAULT 0,
    Active BIT NOT NULL DEFAULT 0,
    CanCredit BIT NOT NULL DEFAULT 0,
    Language VARCHAR(15),
    UNIQUE INDEX XAKClientIP (IP)
);

DROP TABLE IF EXISTS User;
CREATE TABLE User (
    ID INTEGER AUTO_INCREMENT PRIMARY KEY,
    Client_ID INTEGER NOT NULL REFERENCES Client(ID) ON DELETE CASCADE,
    Password VARCHAR(20),
    FIO VARCHAR(50),
    Address VARCHAR(80),
    Phone VARCHAR(20),
    Email VARCHAR(40),
    SendDayReport BIT NOT NULL DEFAULT 0,
    SendMonthReport BIT NOT NULL DEFAULT 0,
    UNIQUE INDEX XAKUser (FIO(10), Address, Phone)
);

DROP TABLE IF EXISTS Zone;
CREATE TABLE Zone (
    ID INTEGER AUTO_INCREMENT PRIMARY KEY,
    Name VARCHAR(20) NOT NULL,
    Descr VARCHAR(150),
    PriceIn DECIMAL(8,2) NOT NULL DEFAULT 0,
    PriceOut DECIMAL(8,2) NOT NULL DEFAULT 0,
    OrderNum SMALLINT UNSIGNED NOT NULL,
    UNIQUE INDEX XAKOrderNum (OrderNum)
);

DROP TABLE IF EXISTS Traffic;
CREATE TABLE Traffic (
    Client_ID INTEGER NOT NULL REFERENCES Client(ID) ON DELETE CASCADE,
    Zone_ID INTEGER NOT NULL REFERENCES Zone(ID) ON DELETE CASCADE,
    Year SMALLINT NOT NULL,
    Month TINYINT NOT NULL,
    Inbound BIGINT NOT NULL DEFAULT 0,
    Outbound BIGINT NOT NULL DEFAULT 0,
    CostIn DECIMAL(8,5) NOT NULL DEFAULT 0,
    CostOut DECIMAL(8,5) NOT NULL DEFAULT 0,
    PRIMARY KEY (Client_ID,Zone_ID,Year,Month),
    INDEX XIETraffic (Year,Month)
);

DROP TABLE IF EXISTS Address;
CREATE TABLE Address (
    ID INTEGER AUTO_INCREMENT PRIMARY KEY,
    Zone_ID INTEGER NOT NULL REFERENCES Zone (ID) ON DELETE CASCADE,
    IP INT UNSIGNED NOT NULL DEFAULT 0,
    Mask INT UNSIGNED NOT NULL DEFAULT 0xFFFFFFFF,
    Neg BIT NOT NULL DEFAULT 0,
    UNIQUE INDEX XAKZone (Zone_ID,IP,Mask),
    INDEX XIENeg (Neg)
);

DROP TABLE IF EXISTS Port;
CREATE TABLE Port (
    ID INTEGER AUTO_INCREMENT PRIMARY KEY,
    Address_ID INTEGER NOT NULL REFERENCES Address (ID) ON DELETE CASCADE,
    PortNum SMALLINT UNSIGNED NOT NULL
);

DROP TABLE IF EXISTS Income;
CREATE TABLE Income (
    Client_ID INTEGER NOT NULL REFERENCES Client (ID) ON DELETE CASCADE,
    PayTime DATETIME NOT NULL,
    Sum DECIMAL(8,2) NOT NULL DEFAULT 0,
    PRIMARY KEY (Client_ID,PayTime),
    INDEX XIEIncome (PayTime)
);

DROP TABLE IF EXISTS Outlay;
CREATE TABLE Outlay (
    Client_ID INTEGER NOT NULL REFERENCES Client(ID) ON DELETE CASCADE,
    PayTime DATETIME NOT NULL,
    Sum DECIMAL(8,2) NOT NULL DEFAULT 0,
    Descr VARCHAR(50),
    PRIMARY KEY (Client_ID,PayTime),
    INDEX XIEOutlay (PayTime)
);

DROP TABLE IF EXISTS Card;
CREATE TABLE Card (
    ID INTEGER AUTO_INCREMENT PRIMARY KEY,
    Password VARCHAR(20),
    Sum DECIMAL(8,2) NOT NULL DEFAULT 0,
    GenTime DATETIME NOT NULL,
    INDEX XIECard (GenTime)
);

DROP TABLE IF EXISTS Log;
CREATE TABLE Log (
    Client_ID INTEGER NOT NULL REFERENCES Client(ID) ON DELETE CASCADE,
    EventTime DATETIME NOT NULL,
    Msg VARCHAR(150),
    PRIMARY KEY (Client_ID,EventTime),
    INDEX XIELog (EventTime)
);
