/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: st_any.h,v 1.46.4.2 2005/02/18 18:02:56 anton Exp $ */

#ifdef USE_MYSQL
#if defined (LINUX) || defined (NETBSD)
#include <mysql.h>
#else
#include <mysql/mysql.h>
#endif
#endif

#ifdef USE_POSTGRES
#include <libpq-fe.h>
#endif

//storage types
#define ST_DB_TYPES_NUM       5
extern char *db_type_name[ST_DB_TYPES_NUM];

enum storage_type { UNKNOWN=0, HASH=1, MY_SQL=2, POSTGRES=3, ORACLE=4 };

//categories storage can be
typedef u_char storage_category;

#define ST_NONE		0x00
#define ST_RAW		0x01
#define ST_SUMMARY	0x02
#define ST_UNITS	0x04
#define ST_POLICY	0x08
#define ST_PLANS	0x10
#define ST_SUBPLANS	0x20
#define ST_USERS	0x40
#define ST_CONFIG	0x80
#define ST_ALL		0xFF

#define ST_CONN_TYPES_NUM	11
extern char *st_table_name[ST_CONN_TYPES_NUM];

//Types of connections to storage
enum st_conn_type { ST_CONN_UNDEF=0, ST_CONN_RAW=1, ST_CONN_SUMMARY=2, ST_CONN_MONITOR=3, ST_CONN_LOGIN=4, ST_CONN_QUOTA=5, ST_CONN_EVENTS=6, ST_CONN_OIDS=7, ST_CONN_BILLING=8 , ST_CONN_BDATA=9, ST_CONN_CONFIG=10 };

//////////////////////////////////////////////////////////////////////////
// we need this to server show stat requests
typedef struct stat_data {
        unsigned num_policies;
        unsigned num_points;
        unsigned long long *in;
        unsigned long long *out;
        //merge from message since it was before part of it
        char prefix; // M, W, D, H, F
        time_t ts;
        oid netunit;
} stat_data;
//////////////////////////////////////////////////////////////////////////
#ifdef USE_HASH
void stSaveHash(Service *s);
u_char stLoadHash(Service *s);
#endif

void *stOpenSql(Service *s,st_conn_type type);
unsigned stSaveSql(Service *s, char *filename, st_conn_type type);
u_char stLoadSql(Service *s, void *fd, Message *msg);
void stCloseSql(Service *s, st_conn_type type);
u_char stLgObtainDbData(Login_cfg *cfg);
u_char stQuObtainDbData(Quota_cfg *cfg);
#ifdef HAVE_BILLING
	typedef struct Billing_cfg;
	typedef struct Account;
	u_char stBiObtainDbData(Billing_cfg *cfg);
	u_char stBiLoadBdata(Billing_cfg *cfg);
#endif

#ifdef USE_MYSQL
void *my_stOpenSql(Service *s,st_conn_type type);
unsigned my_stSaveSql(void *fd, char *filename, st_conn_type type);
u_char my_stLoadSql(void *fd, Message *msg);
void my_stCloseSql(void *fd);
u_char my_stLgObtainDbData(void *fd);
u_char my_stQuObtainDbData(void *fd);
   #ifdef HAVE_BILLING
	u_char my_stBiObtainDbData(void *fd);
   	void my_stBiLoadBdata(void *fd, Account *ac, char prefix);
   #endif
#endif

#ifdef USE_POSTGRES
void *pg_stOpenSql(Service *s,st_conn_type type);
unsigned pg_stSaveSql(void *fd, char *filename, st_conn_type type);
u_char pg_stLoadSql(void *fd, Message *msg);
void pg_stCloseSql(void *fd);
u_char pg_stLgObtainDbData(void *fd);
void pg_stLgSetCfg(NetUnit *u, void *fd);
u_char pg_stQuObtainDbData(void *fd);
void pg_stQuSetCfg(NetUnit *u, void *fd);
   #ifdef HAVE_BILLING
	u_char pg_stBiObtainDbData(void *fd);
   	void pg_stBiLoadBdata(void *fd, Account *ac, char prefix);
   #endif
#endif

#ifdef USE_ORACLE
void *ora_stOpenSql(Service *s,st_conn_type type);
unsigned ora_stSaveSql(void *fd, char *filename, st_conn_type type);
u_char ora_stLoadSql(void *fd, Message *msg);
void ora_stCloseSql(void *fd);
u_char ora_stLgObtainDbData(void *fd);
void ora_stLgSetCfg(NetUnit *u, void *fd);
u_char ora_stQuObtainDbData(void *fd);
void ora_stQuSetCfg(NetUnit *u, void *fd);
   #ifdef HAVE_BILLING
	u_char ora_stBiObtainDbData(void *fd);
   	void ora_stBiLoadBdata(void *fd, Account *ac, char prefix);
   #endif
#endif

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
