/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: s_weblogin.c,v 1.35 2005/01/17 13:13:22 jura Exp $ */

#include "netams.h"

Service *Weblogin=NULL;
//////////////////////////////////////////////////////////////////////////
void *sWL(void *s);
void sWLCancel(void *);
void sWLOpenUnit(Connection *conn, WLdata *w, wlUlist *wl, const char *user);
//////////////////////////////////////////////////////////////////////////
void sWLInit(Service *s){
	Weblogin_cfg *cfg = (Weblogin_cfg*)aMalloc(sizeof(Weblogin_cfg));
	cfg->WLroot=NULL;
	cfg->delay=WEBLOGIN_DELAY; //activity will be checked every 110 seconds (default)
	s->cfg=cfg;
	Weblogin=s;
	pthread_create(&(s->t_id), NULL, &sWL, s);
}
//////////////////////////////////////////////////////////////////////////
void sWLProcessCfg(char *param[], Connection *conn, u_char no_flag){
	Service *s=NULL;
	
        //this is quick workaround to support old weblogin way
	// we assume we have only one weblogin service
	if(!(s=Weblogin)) return;

	Weblogin_cfg *cfg=(Weblogin_cfg*)s->cfg;
	User *u;
	WLdata *tmp;

	if (!strcasecmp(param[0], "user")) {
		u=Users.getUser(param[1]);
		if (!u) { aParse(conn, "weblogin unknown user: %s\n", param[1]); return; }

		tmp=(WLdata*)aMalloc(sizeof(WLdata));
		tmp->pol|=SP_DENY_AUTH;
		tmp->user=u;
		tmp->totalunits=0;
		u_char i=2;
		while (param[i]!=empty) {
	 		if (!strcasecmp(param[i], "time")) {
				tmp->timeout=getInterval(param[i+1]);
				if (tmp->timeout>=0) { 
					tmp->timeout_s=set_string(param[i+1]);
					aParse(conn, "weblogin absolute timeout set: %s (%lu sec)\n", param[i+1], tmp->timeout);
				}
				else { 
					aParse(conn, "weblogin timeout invalid: %s\n", param[i+1]);
					aFree(tmp);
					return;
				}
				i++; 
			} 
	 		else if (!strcasecmp(param[i], "inact")) {
				tmp->inact=getInterval(param[i+1]);
				if (tmp->inact>=0) { 
					tmp->inact_s=set_string(param[i+1]);
					aParse(conn, "weblogin inactivity timeout set: %s (%lu sec)\n", param[i+1], tmp->inact);
				}
				else { 
					aParse(conn, "weblogin inactivity invalid: %s\n", param[i+1]);
					aFree(tmp);
					return;
				}
				i++; 
			} 
			else if (!strcasecmp(param[i], "multi")) {
				tmp->multi=1;
				aParse(conn, "weblogin multi-units-open flag is set\n");
			}
			else if (!strcasecmp(param[i], "set")) {
				NetUnit *ut = new NetUnit(NETUNIT_UNKNOWN);
				ut->id=0xFFFFFF;
				SetSysPolicy(param[i+1], ut, conn);
				tmp->pol=ut->sys_policy;
				tmp->pol_perm=ut->sys_policy_perm;
				if (ut->sys_policy_perm) aParse(conn, "weblogin set: sys-%06X-allow\n", ut->sys_policy_perm);
				else aParse(conn, "weblogin set: sys-deny-auth\n");
				delete ut;
				i++;
			}
			else if (!strcasecmp(param[i], "open")) {
				NetUnit *ut;
				oid id;
				u_char j=i+1;
				while (param[j]!=empty) {
					id=strtol(param[j], NULL, 16);
					ut=Units.getUnitById(id);
					if (!ut) ut=Units.getUnit(param[j]);
					if (ut) {
						wlUlist *wl,*pwl=NULL;
						for (wl=tmp->root; wl!=NULL; wl=wl->next) {
							if (wl->u==ut) break;
							pwl=wl;
						}	
						
						if (wl) {
							if(!no_flag) {
								aParse(conn, "unit %06X (%s) is already binded with this weblogin\n", ut->id, ut->name?ut->name:"<>");
								goto AGAIN_WL;
							}
							if(tmp->root == wl) tmp->root=wl->next;
							else pwl->next=wl->next;
							aFree(wl);
							aParse(conn, "unit %06X (%s) unbinded from this weblogin\n", ut->id, ut->name?ut->name:"<>");
							tmp->totalunits--;
						} else {
							if(no_flag) goto AGAIN_WL;
							wl=(wlUlist*)aMalloc(sizeof(wlUlist));
							wl->u=ut;
							wl->next=tmp->root;
							tmp->root=wl;
							aParse(conn, "unit %06X (%s) binded with this weblogin\n", ut->id, ut->name?ut->name:"<>");
							tmp->totalunits++;
						}
					} else aParse(conn, "unit %06X unknown, cannot bind\n", id);
					AGAIN_WL:
					j++;
				}		
				i=j-1;
			}
			else aParse(conn, "unknown weblogin user command: %s\n", param[i]);
			i++;
		}
		// user build complete, should we put it into chain?
		WLdata *w, *wp=NULL; u_char inserted=0;
		for (w=cfg->WLroot; w!=NULL; w=w->next){
			if (w->user==tmp->user && w->pol==tmp->pol && w->timeout==tmp->timeout) {
				tmp->next=w->next;
				inserted=1;
				memcpy(w, tmp, sizeof(WLdata));
			}
			wp=w;
		}
		if (!inserted) {
			if (wp) wp->next=tmp;
			else cfg->WLroot=tmp;
			aParse(conn, "user %s insterted into weblogins table\n", param[1]);
		}
	}
	else if (!strcasecmp(param[0], "auth")) { // "auth user XX password YY [from NN [open MM]]"
		IPFlowStat flow; flow.srcaddr.s_addr=INADDR_ANY;
		User *u=NULL;
		NetUnit *n=NULL; 
		u_char auth;
		u_char spec_open=0, spec_from=0;
		if (!strcasecmp(param[1], "user")) {
			u=Users.getUser(param[2]);
			if (!u) {
				aParse(conn, "user unknown\n");
				return;
			}
		}
		if (!strcasecmp(param[3], "password") && u) {
			auth=aAuth(u->name, param[4]);
			if (auth<UPERM_LOGIN_WEB) {
				aParse(conn, "user %s insufficient permissions or password incorrect\n", u->name);
				return;
			}
		}
		if (!strcasecmp(param[5], "from") && u) {
			spec_from=1;
			inet_aton(param[6], &flow.srcaddr);
			for (NetUnit *u=Units.root; u!=NULL; u=u->next) if (u->Check(&flow) != MATCH_NONE) n=u;
		}
		if (!strcasecmp(param[5], "open") && u) {
			spec_open=1;
			n=Units.getUnit(param[6]);
			if (!n) n=Units.getUnitById(strtol(param[6], NULL, 16));
		}

		// auth process is here
		WLdata *w;
		wlUlist *wl;
		for (w=cfg->WLroot; w!=NULL; w=w->next) if (w->user==u) {
			if (w->multi) { // we can open many, list them
				if (!spec_open)	{
					u_char j=0;
					for (wl=w->root; wl!=NULL; wl=wl->next) {
						fprintf(conn->stream_w, "* * %s %06X ", wl->u->name?wl->u->name:"<>", wl->u->id);
						j++;
					}
					if (j) fprintf(conn->stream_w, "\n");
				}
				else for (wl=w->root; wl!=NULL; wl=wl->next)
					if (n && wl->u==n) sWLOpenUnit(conn, w, wl, u->name?u->name:"<>");
			} // multi==1
			else {
				for (wl=w->root; wl!=NULL; wl=wl->next)
					if ((spec_from && n && wl->u==n) || (!spec_from && wl->u && w->totalunits==1)) sWLOpenUnit(conn, w, wl, u->name?u->name:"<>");
			} // multi==0
		} //for-if, all WLdata
	} // auth
       	else if (!strcasecmp(param[0], "lookup-delay")) {
                unsigned delay=strtol(param[1], NULL, 10);
                if(delay>=1 && delay <24*60*60) {
                        cfg->delay=delay;
                        aParse(conn, "weblogin timers will be checked every %u seconds\n",delay);
                } else
                        aParse(conn, "lookup delay value invalid\n");
	}

	else aParse(conn, "unknown weblogin command: %s\n", param[0]);
	return;
}
//////////////////////////////////////////////////////////////////////////
void sWLListCfg(Service *s, FILE *f){
	Weblogin_cfg *cfg=(Weblogin_cfg*)s->cfg;
	WLdata *w;

	if(cfg->delay!=WEBLOGIN_DELAY) fprintf(f, "lookup-delay %u\n", cfg->delay);
	for (w=cfg->WLroot; w!=NULL; w=w->next) if (w->user && w->user->name) {
		fprintf(f, "user %s ", w->user->name);
		if (w->timeout) fprintf(f, "time %s ", w->timeout_s);
		if (w->inact) fprintf(f, "inact %s ", w->inact_s);
		if (w->pol_perm) fprintf(f, "set sys-%06X-allow ", w->pol_perm);
		else fprintf(f, "set sys-deny-auth ");
		fprintf(f, "%sopen ", w->multi?"multi ":"");
		for (wlUlist *wl=w->root; wl!=NULL; wl=wl->next)
			fprintf(f, "%s ", wl->u->name?wl->u->name:"<>");		
			
		fprintf(f, "\n");
	}
	fprintf(f, "\n");

	return;
}
//////////////////////////////////////////////////////////////////////////
void *sWL(void *ss){
	Service *s=(Service*)ss;
	Weblogin_cfg *cfg=(Weblogin_cfg*)s->cfg;
	WLdata *w;
	wlUlist *wl;
	NetUnit *u;
	time_t now;
	u_char violates;

	aLog(D_INFO, "service weblogin:%u thread started (%p)\n", s->instance, s->cfg);
	pthread_cleanup_push(sWLCancel, s);
	SET_CANCEL();
	s->t_id=pthread_self();

	// now we should sleep before starting service
	if(!(s->flags&SERVICE_RUN)) s->Sleep();

	aLog(D_DEBUG, "service weblogin:%u checking every %u seconds\n", s->instance,cfg->delay);
	while (1) {
		now=time(NULL);
		for (w=cfg->WLroot; w!=NULL; w=w->next) if (w->user && w->user->name) {
			for (wl=w->root; wl!=NULL; wl=wl->next) {
				u=wl->u;
				violates=0;

				if (wl->timeout && (now - wl->open)>wl->timeout) {
					violates=1;
					aLog(D_INFO, "unit %s (%06X) absolute timeout reached, ", u->name?u->name:"<>", u->id);
				}

				if ((u->ap && u->ap->LastUsed() && wl->inact && (now - u->ap->LastUsed())>wl->inact) 
					|| ((!u->ap || !u->ap->LastUsed()) && wl->inact && (now - wl->open)>wl->inact)){
					violates=1;
					aLog(D_INFO, "unit %s (%06X) inactivity timeout reached, ", u->name?u->name:"<>", u->id);
				}
					
				if (violates) {
					aLog(D_INFO, "applying sys-policy\n");
					// actual policy setup
					u->SetSysPolicy(w->pol, ADD, now);
					if (w->pol_perm) u->sys_policy_perm=w->pol_perm; 
					wl->timeout=0; wl->inact=0; wl->open=0;
				}					
			}
		}

		s->Sleep(cfg->delay); // web login timeouts will be checked every cfg->delay seconds
	}

	pthread_cleanup_pop(0);
	return NULL;
}
//////////////////////////////////////////////////////////////////////////
void sWLCancel(void *v){
	Service *s = (Service*)v;
	Weblogin=NULL;
	aFree(s->cfg);
	aLog(D_INFO, "cancelling service weblogin:%u\n", s->instance);
}
//////////////////////////////////////////////////////////////////////////
void cShowTimeouts(Connection *conn){
	Service *s=NULL;
	if(!(s=Weblogin)) return;
       
       	NetUnit *u;
	Weblogin_cfg *cfg=(Weblogin_cfg*)s->cfg;
	WLdata *w;
        wlUlist *wl;
	time_t inact_t, now=time(NULL);
	
	for (w=cfg->WLroot; w!=NULL; w=w->next) if (w->user && w->user->name) {
		for (wl=w->root; wl!=NULL; wl=wl->next) {
			u=wl->u;
			fprintf(conn->stream_w, "%s (%06X) opened %lu sec. ago, last used %lu sec. ago\n", u->name?u->name:"<>", u->id, wl->open?(now - wl->open):-1, (u->ap && u->ap->LastUsed())?(now - u->ap->LastUsed()):-1);
			if (u->ap && u->ap->LastUsed()) inact_t = wl->inact - now + u->ap->LastUsed();
			else inact_t = wl->inact - now + wl->open;
			fprintf(conn->stream_w, "   absolute timeout at %lu sec, inactivity at %lu sec.\n", wl->timeout?(wl->timeout - now + wl->open):-1, wl->inact?inact_t:-1);
		}
	}
}
//////////////////////////////////////////////////////////////////////////
void sWLOpenUnit(Connection *conn, WLdata *w, wlUlist *wl, const char *user){
	wl->open=time(NULL);
	wl->u->SetSysPolicy(w->pol, REMOVE, wl->open);
	if (w->inact_s) wl->inact=w->inact;
	if (w->timeout_s) wl->timeout=w->timeout;
	aParse(conn, "user %s is opening unit %s\n", user, wl->u->name?wl->u->name:"<>");
}
//////////////////////////////////////////////////////////////////////////
