/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: s_monitor.c,v 1.48 2005/01/17 13:13:21 jura Exp $ */

#include "netams.h"

#define MONITOR_DELAY	60	//delay between load into sql

//////////////////////////////////////////////////////////////////////////////////////////
void sMonitorInit(Service *s){
	s->cfg = (Monitor_cfg*)aMalloc(sizeof(Monitor_cfg));
	Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;
    	
	cfg->name=NULL;
    	cfg->total=0;
	cfg->commit=0;
	cfg->time=0;
    	cfg->to=MON_NONE;
    	cfg->storage_no=0;
	cfg->query=(char*)aMalloc(255);
	cfg->fd=NULL;
}
//////////////////////////////////////////////////////////////////////////////////////////
void sMonitorProcessCfg(char *param[], Connection *conn, u_char no_flag){
	Monitor_cfg *cfg=(Monitor_cfg*)conn->service->cfg;

	if (!strcasecmp(param[0], "monitor"))
	if (!strcasecmp(param[1], "?")) { cHelp(conn, no_flag, "monitor"); return; }
	
	if (!strcasecmp(param[1], "to")) {
		Service *st;
		if (cfg->fd) {
			fclose(cfg->fd);
		}
		cfg->fd=NULL;

		if(cfg->to==MON_STORAGE) {
			st = Services.getService(SERVICE_STORAGE, cfg->storage_no);
			if(st) stSaveSql(st,cfg->name,ST_CONN_MONITOR);
		}
		
		if(cfg->name) {
			aFree(cfg->name);
			cfg->name=NULL;
		}

		if (!strcasecmp(param[2], "storage")) {
			Service *st;
			u_short no;
			no=strtol(param[3], NULL, 10);
			st = Services.getService(SERVICE_STORAGE, no);		
			if(!st) {
				aParse(conn, "no such service storage:%u\n",cfg->storage_no);
				return;
			} 

			if (no_flag) { 
				aParse(conn, "switch monitoring off\n");
				cfg->to=MON_NONE;
				return;
			}
			cfg->storage_no=no;
            		cfg->to=MON_STORAGE;
			print_to_string(&cfg->name,"monitor.%u",conn->service->instance);
			aParse(conn, "monitoring to storage %u (%p)\n", cfg->storage_no, st);
				
		} else if (!strcasecmp(param[2], "file")) {
                        if (no_flag) {
				aParse(conn, "switch monitoring off\n");
                                cfg->to=MON_NONE;
				if(cfg->name) aFree(cfg->name);
				cfg->name=NULL;
                                return;
                        }

            		cfg->to=MON_FILE;
            		u_short i=strlen(param[3]);
            		if (i) { 
                		cfg->fd=fopen(param[3], "at");
                		if (cfg->fd) {
                    			setlinebuf(cfg->fd);
					cfg->name=set_string(param[3]);
        				aParse(conn, "monitoring to file %s\n", cfg->name);
                		} else { 
                    			aParse(conn, "unable to open monitor output file %s\n", cfg->name);
                    			cfg->to=MON_NONE;
                    			cfg->fd=NULL;
                    		}
                	}
            		else 
				aParse(conn, "monitor output file name unknown\n");
		} else 
			aParse(conn, "unknown monitor output method\n");
	} else if (!strcasecmp(param[1], "unit")) {
        	NetUnit *u;
        	unsigned oid=strtol(param[2], NULL, 16);
        	if (oid) { 
			u=Units.getUnitById(oid);
            		if (!u) u=Units.getUnit(param[2]); 
		}
        	else u=Units.getUnit(param[2]);

        	if (u) { 
            		if (!no_flag) { 
                		if (Units.setMon(u->id, cfg)) 
					aParse(conn, "monitoring unit %s (%06X)\n", u->name?u->name:"<\?\?>", u->id);
                		else 
					aParse(conn, "set monitoring unit %06X failed!\n", u->id);
            		} else {
                		if (Units.setMon(u->id, NULL)) 
					aParse(conn, "not monitoring unit %s (%06X)\n", u->name?u->name:"<\?\?>", u->id);
                		else 
					aParse(conn, "unset monitoring unit %06X failed!\n", u->id);
                	}
        	} else {
            		if (no_flag) {
                		Units.setMon(0, cfg);
                		aParse(conn, "disable monitoring for all units\n");
            		} else aParse(conn, "cannot monitor this: unit unknown\n");
       		}
    	}

	else aParse(conn, "unknown monitor command\n");

   }	

//////////////////////////////////////////////////////////////////////////////////////////
void cShowMonitor(Connection *conn){
	Service *s=NULL;
        
	while((s=Services.getServiceNextByType(SERVICE_MONITOR,s))) {
        	Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;

		fprintf(conn->stream_w, "service monitor %u\n",s->instance);
    		switch (cfg->to){
        		case MON_NONE:  
				fprintf(conn->stream_w, "Monitoring is off\n");
                    	break;
        	case MON_FILE:  
				fprintf(conn->stream_w, "Monitoring to file: %s\n", cfg->name);
                    		break;
        	case MON_STORAGE:   
				fprintf(conn->stream_w, "Monitoring to storage: %u\n", cfg->storage_no);
                        	break;
        	}
    		if (cfg->to!=MON_NONE) { 
        		fprintf(conn->stream_w, "Units: ");
        		Units.showMon(conn->stream_w, (void*)cfg, 1);
        		fprintf(conn->stream_w, "\n");
        	}
		fprintf(conn->stream_w, "Packets monitored: %lu\n",cfg->total);
	}
    }

//////////////////////////////////////////////////////////////////////////////////////////
void sMonitorListCfg(Service *s, FILE *out){
        Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;
    	
	switch (cfg->to){
        	case MON_NONE:  return;
        	case MON_FILE:  {
                    	fprintf(out, "monitor to file %s\n", cfg->name);
                    	break;
                    	}
        	case MON_STORAGE:   {
                    	fprintf(out, "monitor to storage %u\n", cfg->storage_no);
                    	break;
                    	}
        	}
   		if (cfg->to!=MON_NONE) Units.showMon(out, (void*)cfg, 0);
    	
	fprintf(out, "\n");

}

//////////////////////////////////////////////////////////////////////////////////////////
void aMonitor(NetUnit *u, IPFlowStat *flow){
	Monitor_cfg *cfg=(Monitor_cfg*)u->monitor;
	
	unsigned long t=flow->Last;
	unsigned long len=flow->dOctets;
	unsigned long dpkts=flow->dPkts;
	unsigned flowt=(unsigned)(flow->Last - flow->First);
	
#ifdef DEBUG
	char t_T[30];
	char buf1[32], buf2[32];

	timeU2T(t, (char*)&t_T);
	strcpy(buf1, inet_ntoa(flow->srcaddr)); strcpy(buf2, inet_ntoa(flow->dstaddr));
#endif	

	if (cfg->to==MON_FILE) {
	#ifndef DEBUG
		char t_T[30];
		char buf1[32], buf2[32];
                
		timeU2T(t, (char*)&t_T);
        	strcpy(buf1, inet_ntoa(flow->srcaddr)); strcpy(buf2, inet_ntoa(flow->dstaddr));
        #endif
	
		fprintf(cfg->fd, "%s %u %s %06X ", (char*)&t_T, flowt, u->name?u->name:"<\?\?>", u->id);
      		fprintf(cfg->fd, "%02u if:%u->%u ", flow->prot, ntohs(flow->input), ntohs(flow->output));  	
		if (flow->prot==IPPROTO_TCP || flow->prot==IPPROTO_UDP) {
    	    		fprintf(cfg->fd, "s:%s:%u d:%s:%u", buf1, ntohs(flow->srcport), buf2, ntohs(flow->dstport));
        	} else 
    	    		fprintf(cfg->fd, "s:%s d:%s", buf1, buf2);
		fprintf(cfg->fd, " %lu %lu\n", dpkts, len);
	
	} else if (cfg->to==MON_STORAGE) {
		if(!cfg->fd) {
			cfg->fd=fopen(cfg->name,"a");
			if(!cfg->fd) {
				aLog(D_WARN, "Can't open temporary file %s : %s\n",cfg->name,strerror(errno));
				return;
			}
			setlinebuf(cfg->fd);
		}
		
		fprintf(cfg->fd, "%lu,%u,%u,%u,%u,%u,%u,%u,%lu,%lu\n", t, flowt, u->id, flow->prot, (unsigned)ntohl(flow->srcaddr.s_addr), ntohs(flow->srcport), (unsigned)ntohl(flow->dstaddr.s_addr), ntohs(flow->dstport), dpkts, len);
		cfg->commit++;
		if( cfg->time < t)  {
			cfg->time=t+MONITOR_DELAY;
                	Service *st = Services.getService(SERVICE_STORAGE, cfg->storage_no);
                	if(st) {
				fclose(cfg->fd);
				cfg->fd=NULL;
				stSaveSql(st,cfg->name,ST_CONN_MONITOR);
			}
                	else return;
			cfg->commit=0;
        	} 
        }
	cfg->total++;
#ifdef DEBUG
	aDebug(DEBUG_MONITOR, "%s %u %s %06X %02u s:%s:%u d:%s:%u %lu %lu\n", &t_T, flowt, u->name?u->name:"<\?\?>", u->id, flow->prot, buf1, ntohs(flow->srcport), buf2, ntohs(flow->dstport), dpkts, len);
#endif
}
//////////////////////////////////////////////////////////////////////////////////////////
void sMonitorCancel(void *v){
        Service *s = (Service*)v;
        Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;
	
	aLog(D_INFO, "cancelling service monitor:%u\n", s->instance);
	
	Units.setMon(0, cfg);
	
	if(cfg->fd) fclose(cfg->fd);
	if(cfg->to==MON_STORAGE) {
		Service *st = Services.getService(SERVICE_STORAGE, cfg->storage_no);
                if(st) stSaveSql(st, cfg->name, ST_CONN_MONITOR);
        }
	if(cfg->name) aFree(cfg->name);
	if(cfg->query) aFree(cfg->query);
	aFree(cfg);
}

//////////////////////////////////////////////////////////////////////////////////////////
