/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: s_html.c,v 1.51.4.4 2005/03/16 22:13:16 anton Exp $ */

#include "netams.h"

Service *Html=NULL;
//////////////////////////////////////////////////////////////////////////////////////////
void *sHtml(void *ss);
void sHtmlCancel(void *v);
extern void sHtmlAction(Html_cfg *cfg);

//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlInit(Service *s){
	s->cfg = (Html_cfg*)aMalloc(sizeof(Html_cfg));
	Html_cfg *cfg=(Html_cfg*)s->cfg;

	cfg->path=NULL;
	cfg->lang=HTML_LANG_EN;
	cfg->run_period=NULL;
	cfg->is_distributed=0;
	cfg->cpages=CPAGES_ALL;
	cfg->apages=APAGES_NONE;
	cfg->url=NULL;
	cfg->servlet_url=NULL;
	cfg->is_htaccess=0;
	cfg->conn = new Connection("htmlSave", CONN_FD_NULL);
	cfg->grouproot=NULL;

	pthread_create(&(s->t_id), NULL, &sHtml, s);
	Html=s;
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlProcessCfg(char *param[], Connection *conn, u_char no_flag){
	Html_cfg *cfg=(Html_cfg*)conn->service->cfg;

	if (!strcasecmp(param[0], "path")) {
		cfg->path=set_string(param[1]);
		aParse(conn, "html path is set to %s\n", cfg->path);
	}
	else if (!strcasecmp(param[0], "url")) {
		cfg->url=set_string(param[1]);
		aParse(conn, "URL path is set to %s\n", cfg->url);
	}
	else if (!strcasecmp(param[0], "servlet-url")) {
		cfg->servlet_url=set_string(param[1]);
		aParse(conn, "Servlet URL path is set to %s\n", cfg->servlet_url);
	}
	else if (!strcasecmp(param[0], "run")) {
		cfg->run_period=set_string(param[1]);
		aParse(conn, "html run period is set to %s\n", cfg->run_period);
		if (!strcasecmp(param[1], "distributed")) {
			cfg->is_distributed=1;
			aParse(conn, "html service will run in distributed mode\n");
		}
	}
	else if (!strcasecmp(param[0], "language")) {
		if (!strcasecmp(param[1], "en")) {
			cfg->lang=HTML_LANG_EN;
			aParse(conn, "html output language is ENGLISH\n");
		}
		else if (!strcasecmp(param[1], "ru")) {
			cfg->lang=HTML_LANG_RU;
			aParse(conn, "html output language is RUSSIAN\n");
		}
		else aParse(conn, "html output language %s unsupported\n", param[1]);
	}
	else if (!strcasecmp(param[0], "htaccess")) {
		if (!strcasecmp(param[1], "yes") || strtol(param[1], NULL, 10)==1) {
			aParse(conn, "html service will manage Apache .htaccess and .htpasswd files\n");
			cfg->is_htaccess=1;
		}
		else {
			aParse(conn, "html service will NOT manage Apache .htaccess and .htpasswd files\n");
			cfg->is_htaccess=0;
		}
	}
	else if (!strcasecmp(param[0], "client-pages")) {
		if (!strcasecmp(param[1], "all")) {
			cfg->cpages=CPAGES_ALL;
			aParse(conn, "html client pages creator: all pages\n");
		}
		else if (!strcasecmp(param[1], "groups")) {
			cfg->cpages=CPAGES_GROUPS;
			aParse(conn, "html client pages creator: only group units\n");
		}
		else if (!strcasecmp(param[1], "group")) {
			cfg->cpages=CPAGES_GROUPLIST;
			Html_grouplist_item *gr1 = cfg->grouproot, *gr2=NULL;
			while (gr1) { gr2=gr1->next; aFree(gr1); gr1=gr2; } 
			cfg->grouproot=gr1=NULL;
			aParse(conn, "html client pages creator: members of specified groups:\n");
			
			NetUnit *u;
			for (int i=2; param[i]!=empty; i++ ) {
				if ((u=Units.getUnit(param[i]))) if (u->type==NETUNIT_GROUP) {
					gr1=(Html_grouplist_item*)aMalloc(sizeof (Html_grouplist_item));
					gr1->groupid=u->id;
					aParse(conn, "\t\tgroup: %s, oid=%06X\n", param[i], u->id);
					if (cfg->grouproot==NULL) cfg->grouproot=gr1; else gr2->next=gr1;
					gr2=gr1;
				}
			}

		}
		else if (!strcasecmp(param[1], "none")) {
			cfg->cpages=CPAGES_NONE;
			aParse(conn, "html client pages creator: none created\n");
		}
		else aParse(conn, "html client-pages command %s unsupported\n", param[1]);
	}
	else if (!strcasecmp(param[0], "account-pages")) {
		if (!strcasecmp(param[1], "all")) {
			cfg->apages=APAGES_ALL;
			aParse(conn, "html account pages creator: all pages\n");
		}
		else if (!strcasecmp(param[1], "none")) {
			cfg->apages=APAGES_NONE;
			aParse(conn, "html account pages creator: none created\n");
		}
		else aParse(conn, "html account-pages command %s unsupported\n", param[1]);
	}
	else aParse(conn, "unknown html service command: %s\n", param[0]);
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlListCfg(Service *s, FILE *f){
	Html_cfg *cfg=(Html_cfg*)s->cfg;
	if (cfg->path) fprintf(f, "path %s\n", cfg->path);
	if (cfg->lang==HTML_LANG_EN) fprintf(f, "language en\n");
	else if (cfg->lang==HTML_LANG_RU) fprintf(f, "language ru\n");
	if (cfg->run_period) fprintf(f, "run %s\n", cfg->run_period);
	if (cfg->url) fprintf(f, "url %s\n", cfg->url);
	if (cfg->servlet_url) fprintf(f, "servlet-url %s\n", cfg->servlet_url);
	if (cfg->is_htaccess) fprintf(f, "htaccess yes\n");

	if (cfg->cpages==CPAGES_ALL) fprintf(f, "client-pages all\n");
	else if (cfg->cpages==CPAGES_GROUPS) fprintf(f, "client-pages groups\n");
	else if (cfg->cpages==CPAGES_NONE) fprintf(f, "client-pages none\n");
	else if (cfg->cpages==CPAGES_GROUPLIST && cfg->grouproot) {
		fprintf(f, "client-pages group ");
		NetUnit *u=NULL;
		for (Html_grouplist_item *item=cfg->grouproot; item!=NULL; item=item->next) 
			if ((u=Units.getUnitById(item->groupid))) if (u->name) fprintf(f, "%s ", u->name);
		fprintf(f, "\n");
	}
	
#ifdef HAVE_BILLING
	if (cfg->apages==APAGES_ALL) fprintf(f, "account-pages all\n");
	else if (cfg->apages==APAGES_NONE) fprintf(f, "account-pages none\n");
#endif

	fprintf(f, "\n");
}
//////////////////////////////////////////////////////////////////////////////////////////
void *sHtml(void *ss){
	Service *s=(Service*)ss;

	aLog(D_INFO, "service html:%u thread started (%p)\n", s->instance, s->cfg);
	pthread_cleanup_push(sHtmlCancel, s);
	SET_CANCEL();
	s->t_id=pthread_self();

	Html_cfg *cfg=(Html_cfg*)s->cfg;
	if(!(s->flags&SERVICE_RUN)) s->Sleep();

	// here we should put scheduler task setup code
	if (!cfg->run_period) aLog(D_WARN, "cannot set up scheduler task because no run period defined\n");
	else if (cfg->is_distributed) {
		aLog(D_DEBUG, "distributing html service...\n");
		while (1) {
			s->Sleep(300);

			//cancellation disabled here
			sHtmlAction(cfg);
		}
		//never reach this
		goto FINISH; // suck but I cannot call pthread_cleanup_pop once more - it is just an ugly macro :((
	} else {
		char *buffer=(char*)aMalloc(256);
		snprintf(buffer, 256, "schedule oid 08FFFF action \"html\" time %s", cfg->run_period);
		// snprintf(buffer, 256, "schedule action \"html\" time %s invisible", cfg->run_period);
		aCommand(cInternal, buffer);
		aFree(buffer);
	}

	// here we should put path checking and directories creation

	while(1) {
		s->Sleep(); // we will wait for external wakeup signal from scheduler initiated call

		//cancellation disabled here
		// actual action
		aLog(D_INFO, "html pages creation...\n");
		sHtmlAction(cfg);
		aLog(D_INFO, "html pages created\n");
	}

FINISH:
	pthread_cleanup_pop(0);
	return NULL;
}

//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlCancel(void *v){
	Service *s=(Service*)v;
	Html_cfg *cfg=(Html_cfg*)s->cfg;

	aLog(D_INFO, "cancelling service html:%u\n", s->instance);
	Html=NULL;
	
	if(cfg->path) aFree(cfg->path);
        if(cfg->run_period) aFree(cfg->run_period);
        if(cfg->url) aFree(cfg->url);
        if(cfg->servlet_url) aFree(cfg->servlet_url);
	delete(cfg->conn);
	
	aFree(s->cfg);
}
//////////////////////////////////////////////////////////////////////////////////////////
void cHtml(Connection *conn, char *param[], u_char no_flag){
	// regardless of command parameters, wake up the html service
	if (Html) Html->Wakeup();
	else aParse(conn, "html command while no html service running\n");
}
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
