/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: netflow.h,v 1.20 2005/01/17 13:13:21 jura Exp $ */

/* Cisco NetFlow FlowCollector
 * Copyright (c) 1997 by Cisco Systems, Inc.
 * All rights reserved.        
*/

#define FLOW_VERSION_5 5
#define V5FLOWS_PER_PAK 30
#define  MAX_PKT_SIZE    0xffff

typedef struct Flow5StatHdr {
    ushort version;
    ushort count;           /* The number of records in PDU. */
    unsigned long SysUptime;       /* Current time in millisecs since router booted */
    unsigned long unix_secs;       /* Current seconds since 0000 UTC 1970 */
    unsigned long unix_nsecs;      /* Residual nanoseconds since 0000 UTC 1970 */
    unsigned long flow_sequence;   /* Seq counter of total flows seen */
    unsigned char engine_type;     /* Type of flow switching engine */
    unsigned char engine_id;       /* ID number of the flow switching engine */
    ushort reserved;
} Flow5StatHdr;


typedef struct IPFlow5Stat {
    in_addr srcaddr;    /* Source IP Address */
    in_addr dstaddr;    /* Destination IP Address */
    in_addr nexthop;    /* Next hop router's IP Address */
    ushort input;          /* Input interface index */
    ushort output;         /* Output interface index */

    unsigned long dPkts;           /* Packets sent in Duration */
    unsigned long dOctets;         /* Octets sent in Duration. */
    unsigned long First;           /* SysUptime at start of flow */
    unsigned long Last;            /* and of last packet of flow */

    unsigned short srcport;        /* TCP/UDP source port number or equivalent */
    unsigned short dstport;        /* TCP/UDP destination port number or equivalent */
    unsigned char pad;
    unsigned char tcp_flags;      /* Cumulative OR of tcp flags */
    unsigned char prot;           /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
    unsigned char tos;            /* IP Type-of-Service */
    unsigned short src_as;         /* originating AS of source address */
    unsigned short dst_as;         /* originating AS of destination address */
    unsigned char src_mask;       /* source address prefix mask bits */
    unsigned char dst_mask;       /* destination address prefix mask bits */
    ushort reserved;
} IPFlow5Stat;

typedef struct {
    Flow5StatHdr header;
    IPFlow5Stat  records[V5FLOWS_PER_PAK];
} IPStat5Msg;

//////////////////////////////////////////////////////////////////////////
#ifdef NETFLOW_CLASS

typedef struct entry {
        u_char ip_tos;
        unsigned long ip_len;
        unsigned long count;
        u_char ip_proto;
        in_addr_t ip_src, ip_dst;
        time_t start;
        time_t last;
        entry *next;
        u_short src_port, dst_port;
        u_char expired;
        unsigned id;
} entry;
//////////////////////////////////////////////////////////////////////////
class NetFlow {
        public:

#define MAX_CHUNK               2048 //protection against DoS - max chunks per hash node

#define IPV4_HASH_SIZE	0x10000
#define IPV4_HASH_MASK	(IPV4_HASH_SIZE-1)

//old - symmetric
#define IPV4_HASH(addr1, addr2, port1, port2, proto) ((((addr1) + (addr2)) + (port1) + (port2)+ (proto))&IPV4_HASH_MASK)
//new - assymentric
#define IPV4_ADDR_HASH(addr1,addr2)	(((addr1 >> 16) ^ (addr2 & 0x00FF) ) & IPV4_HASH_MASK)
#define IPV4_FULL_HASH(addr1, addr2, port1, port2)	(((addr1 >> 16) ^ (addr2 & 0x00FF) ^ ((port1 ^ port2) << 8) )& IPV4_HASH_MASK)

                entry **table;
                entry *ready;
                
		time_t t_now;
                time_t t;
		time_t t_msg;

                unsigned t_active;
                unsigned t_inactive;
		unsigned t_expired;
		unsigned t_msg_expired;
	
                unsigned e_used;
                unsigned e_total;
                
		unsigned last_id, expired_id;
                unsigned long long sent_flows;
                unsigned long long sent_packets;

                IPStat5Msg *message;
	
		int udp_socket_fd;
		struct sockaddr_in udp_dest;
		
                NetFlow(char *dst_host, unsigned short dst_port);
                ~NetFlow();
		void SetTimeouts(unsigned active=0,unsigned inactive=0,unsigned expired=0,unsigned msg_expired=0);
                void CheckExpire(entry *e);
                void Expiresearch();
                void Processpacket(struct ip *ip);
                void FlushAll();
                void ToSend(entry *e);
                void DoSend();
		void Status();
};
#endif
//////////////////////////////////////////////////////////////////////////
