/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: main.c,v 1.55.4.3 2005/02/25 17:30:03 anton Exp $ */

#include "netams.h"

Service *sMain;
int global_return_code=0;

int flag_nodaemon=0, flag_log=0, flag_quiet=0, sql_config=0, flag_pid=0, flag_nopid=0, flag_syslog=0;
FILE *LOGFILE;
FILE *configfile;
char *config_file_name=NULL;
char *pid_file_name=NULL;
struct timeval program_start;

int main(int argc, char **argv){
	int op;
	char buf[32];
	
	gettimeofday(&program_start, NULL);
	
	aMemoryInit();
	aOidsInit();

	while((op=getopt(argc, argv, "qdlLPsf:p:")) != EOF){
		switch(op){
			case 'q': 
				flag_quiet = 1;
				break;
			case 'd': flag_nodaemon = 1;
				break;
			case 'l':
				flag_log = 1;
				flag_pid = 1;
				break;
			case 'L':
				flag_syslog = 1;
				flag_pid = 1;
				break;
			case 'P':
				flag_nopid = 1;
				break;
			case 'p':
				pid_file_name=set_string(optarg);
				flag_pid = 1;
				break;
			case 's':
				sql_config = 1;
				break;
			case 'f': 
				config_file_name=set_string(optarg);
				break;
			default: 
				break;
		}
	}

	if (flag_log) {
		LOGFILE = fopen(path_to_log, "at");
		if (LOGFILE==NULL) { 
			fprintf(stderr, "LOGFILE %s opening: %s\n", path_to_log, strerror(errno)); 
			aMemoryRelease();
			exit(-1); 
		}
		setvbuf(LOGFILE, NULL, _IOLBF, 0);
	}
	
	if (flag_pid && !flag_nopid) {
		if (pid_file_name==NULL) pid_file_name=set_string("/var/run/netams.pid");
		FILE *pidfile = fopen(pid_file_name, "wt");
	
		if (pidfile!=NULL) {
			fprintf(pidfile, "%u\n", getpid());
			fclose(pidfile);
		} else {
			fprintf(stderr, "Can't create pid-file: %s\n", strerror(errno));
		}
	}

	if (flag_syslog) openlog("netams", 0, LOG_DAEMON);
	if (!flag_quiet) aShowVersion(stdout);
	if (flag_log) aShowVersion(LOGFILE);

	if (config_file_name==NULL) 
		config_file_name=set_string((char*)path_to_config);
	
	if (!flag_nodaemon) {
		if(chdir(RUN_PATH)<0) {
			mkdir(RUN_PATH,S_IRWXU);
		}
		if(chdir(RUN_PATH)<0)
			aLog(D_CRIT, "Cannot chdir to directory %s: %s\n",RUN_PATH,strerror(errno));
		aLog(D_INFO, "Becoming a daemon...\n");
		daemon(1, 1);
	} else
		aLog(D_INFO, "Stay in debug mode...\n");
	        
	// handling signals
	signal(SIGHUP, (sig_t)logrotate);
	signal(SIGQUIT, (sig_t)termination);
	signal(SIGINT, (sig_t)termination);
	signal(SIGTERM, (sig_t)termination);

	aPermissionsInit();
	aDebugInit();

	sSched=new Service(SERVICE_SCHEDULER, 0);
	Services.Insert(sSched);
	sSched->Start();

	uInternal=new User("<internal>", 1);  uInternal->permissions=UPERM_ALL;
	Users.Insert(uInternal);

	cInternal=new Connection("<internal>", 1); cInternal->permissions=UPERM_ALL;
	cInternal->user=uInternal;
	Connections.Insert(cInternal);
	aDebugAdd(cInternal->debug, "none");

	sMain=new Service(SERVICE_MAIN, 0);
	Services.Insert(sMain);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
	sMain->t_id=cInternal->t_id=pthread_self();

	if (cLoad(cInternal, config_file_name)<0) {
		aLog(D_CRIT, "main/configfile opening: %s\n", strerror(errno));
		aMemoryRelease();
		exit(-1);
	}

	sMain->setSleep();

	Services.StartAll(sMain);

	sMain->Sleep(1); //we must sleep to be sure all services started

	if (!flag_quiet) 
		printf("%s is now operational, %s\n", aaa_fw_software_name, timeU2T(time(NULL), buf));
		
	sprintf(buf, "%d.%d.%d (build %d", aaa_fw_major_version, aaa_fw_minor_version, aaa_fw_subversion, aaa_fw_build_version);
	if (aaa_fw_build_version_local) sprintf(buf+strlen(buf), ".%d", aaa_fw_build_version_local);
	sprintf(buf+strlen(buf), ")");
	LogEvent(SYSTEM, 0, 0, 0, "NeTAMS Startup %s %s", buf, config_file_name);

	sMain->Sleep();

	// the last actual action
	;

	/////////////////////////////////////////////////////////////
	// exit point
	if (!flag_quiet) 
		printf("Shutdown signal received at %s\n", timeU2T(time(NULL), buf));
	aLog(D_INFO, "Shutdown signal received at %s\n", timeU2T(time(NULL), buf));
	LogEvent(SYSTEM, 0, 0, 0, "NeTAMS Shutdown");

	Services.ShutdownAll(sMain);

	aFree(config_file_name); //we need this for "save"

	aMemoryRelease();

	if (!flag_quiet) 
		printf("%s exiting at %s\n", aaa_fw_software_name, timeU2T(time(NULL), buf));
	aLog(D_INFO, "%s exiting with code %d\n", aaa_fw_software_name, global_return_code);

	aLog(D_INFO, "memory usage summary:\ntotal allocated: %llu (%lu times), freed %lu times (%u null)\n", aGetBytesAllocated(), aGetTimesAllocated(), aGetTimesFreed(), aGetTimesFreedNull());
	aLog(D_INFO, "units locking summary:\ntries: %lu, failed: %lu, ratio: %3.2f\n", Units.tries_lock, Units.tries_lock_failed,  !Units.tries_lock?0:100*(float)((double)Units.tries_lock_failed/(double)Units.tries_lock));
	if (flag_log) fclose(LOGFILE);

	if (flag_syslog) closelog();

	if (flag_pid && !flag_nopid && (pid_file_name!=NULL)) unlink(pid_file_name);

	if( global_return_code == PARSE_RELOAD ) 
		if (-1==execvp(argv[0],argv)) perror("reload failed");
	
	return global_return_code;					  
}
/////////////////////////////////////////////////////////////
