/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ds_ipq.c,v 1.21.4.1 2005/03/23 15:17:29 jura Exp $ */

#if defined(LINUX) && !defined(IPTBL_NONE)

#include "netams.h"

/////////////////////////////////////////////////////////////////////////////////////
void ds_ipq_cancel(void *ptr);
/////////////////////////////////////////////////////////////////////////////////////
void* ds_ipq(void *ss) {
	Service *s=(Service*)ss;
	ServiceDS_cfg *cfg=(ServiceDS_cfg*)s->cfg;

	struct ipq_handle *ipq;
	Flow *flow=cfg->flow;
	u_char process_result=0;
        struct timeval start;
	unsigned char *packet=cfg->packet;
	ipq_packet_msg_t *m;
	int status;
	
        #ifndef IPTBL_OLD
                ipq=ipq_create_handle(0, PF_INET);
        #else
                ipq=ipq_create_handle(0);
        #endif
	
        if (!ipq) {
		aLog(D_ERR, "linux ipq handle failed: %s!\n", ipq_errstr());
		return NULL;
	}
        status=ipq_set_mode(ipq, IPQ_COPY_PACKET, sizeof(struct ip)+sizeof(struct tcphdr));
	if(status<0) {
		aLog(D_ERR, "ipq_set_mode failed: %s\n",ipq_errstr());
		return NULL;
	} else {
		aLog(D_INFO, "Capturing first %u bytes of IP packets\n", sizeof(struct ip)+sizeof(struct tcphdr));
	}

        pthread_cleanup_push(ds_ipq_cancel, (void*)ipq);
        pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

	aLog(D_INFO,"IPQ packet processing for data-source:%u initialized\n",s->instance);

        while(1) {
		status = ipq_read(ipq, packet, MAX_PKT_SIZE, 1000);
                gettimeofday(&start, NULL);
                flow->Expiresearch(&start);
                
		if (status == 0)
			continue;
		else if(status < 0) {
			aLog(D_ERR, "ipq_read failed: %s\n",ipq_errstr());
			continue;
		}
		
		switch(ipq_message_type(packet)) {
			case NLMSG_ERROR:
				ipq_get_msgerr(packet);
				aLog(D_WARN, "%s\n", packet);
				continue;
			case IPQM_PACKET:
				break;
			default:
				continue;
		}

		m=ipq_get_packet(packet);
		process_result=flow->Processpacket((struct ip*) m->payload);
		if (process_result) ipq_set_verdict(ipq, m->packet_id, NF_ACCEPT, 0, NULL);
		else ipq_set_verdict(ipq, m->packet_id, NF_DROP, 0, NULL);
		
		sDSMeasure(cfg, &start, m->data_len);
	}
	pthread_cleanup_pop(1);
	return NULL;
}
/////////////////////////////////////////////////////////////////////////////////////
void ds_ipq_cancel(void *ptr) {
	if(ptr) ipq_destroy_handle((struct ipq_handle *) ptr);
}
#endif
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
