#!/bin/sh
# Configuration script for NeTAMS project
# $Id: configure.sh,v 1.27.4.6 2005/02/18 18:04:02 anton Exp $
##########################################################
PATH=/usr/local/sbin:/bin:/usr/bin:/usr/sbin:/sbin:/usr/local/bin
export PATH
makefile=Makefile.run

##########################################################
paths="/usr/lib /usr/local/lib /usr/lib/mysql /usr/local/lib/mysql /usr/local/mysql4/lib/mysql
 /usr/local/include/mysql /usr/local/include /usr/include /usr/include/mysql /usr/local/mysql4/include/mysql
 /opt/csw/include /usr/pkg/include/mysql /usr/pkg/lib/mysql $ORACLE_HOME/lib32 $ORACLE_HOME/lib /usr/include/libipq "
 
locate_file(){
	for val in $paths; do
		to_test="$val/$1"
		#echo "	try: $to_test"
		if [ -f $to_test ]; then
			var=$val
			return
		fi
	done
var=""
}

##########################################################
warn_on_mysql3xx(){
if [ -e "$v1/libmysqlclient.so.10" ]; then 
	echo "!!! Looks like you have MYSQL=3.xx which is NOT supported !!!"
	echo "!!! I will continue making but ensure you ARE using 4.XX  !!!"
fi
}

##########################################################
llu_to_qu_patch(){
	cp src/st_sql_mysql.c src/st_sql_mysql.c.orig
	sed -e "s/llu/qu/g" src/st_sql_mysql.c.orig > src/st_sql_mysql.c
	cp src/st_sql_postgres.c src/st_sql_postgres.c.orig
	sed -e "s/llu/qu/g" src/st_sql_postgres.c.orig > src/st_sql_postgres.c
	cp src/st_hash.c src/st_hash.c.orig
	sed -e "s/llu/qu/g" src/st_hash.c.orig > src/st_hash.c
}

##########################################################
prepare_for_freebsd() {
echo "FreeBSD operating system..."
echo "DEFINE = -DFREEBSD" >> $makefile
echo "LIB = -lpcap -lcrypt -pthread " >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

# paths
echo "PATH_TO_ETC=/usr/local/etc" >> $makefile
echo "PATH_TO_CONFIG=/usr/local/etc/netams.cfg" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/usr/local/etc/rc.d" >> $makefile
echo "DAEMONDIR=/usr/local/libexec"  >> $makefile
echo "SBINDIR=/usr/local/sbin"  >> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

#check for FreeBSD-4.xx and patch
var=`uname -r | cut -b 1`
if [ $var -lt 5 ]; then  
	echo "With FreeBSD 4.XX, patching sources..."
	llu_to_qu_patch
fi

}

##########################################################
prepare_for_netbsd() {

echo "NetBSD operating system..."
echo "DEFINE = -DNETBSD" >> $makefile
echo "LIB = -lpcap -lcrypt -pthread " >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

# paths
echo "PATH_TO_ETC=/usr/pkg/etc" >> $makefile
echo "PATH_TO_CONFIG=/usr/pkg/etc/netams.cfg" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/usr/pkg/etc/rc.d" >> $makefile
echo "DAEMONDIR=/usr/pkg/libexec"  >> $makefile
echo "SBINDIR=/usr/pkg/sbin"  >> $makefile
echo "MANDIR=/usr/pkg/man"  >> $makefile

llu_to_qu_patch

}

##########################################################
prepare_for_openbsd() {
echo "OpenBSD operating system..."
echo "DEFINE = -DOPENBSD" >> $makefile
echo "LIB = -lpcap -pthread" >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

# paths
echo "PATH_TO_ETC=/usr/local/etc" >> $makefile
echo "PATH_TO_CONFIG=/usr/local/etc/netams.cfg" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/usr/local/etc/rc.d" >> $makefile
echo "DAEMONDIR=/usr/local/libexec"  >> $makefile
echo "SBINDIR=/usr/local/sbin"  >> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

}

##########################################################
prepare_for_linux() {
echo "Linux operating system..."
echo "DEFINE = -DLINUX -D_BSD_SOURCE -I/usr/include/pcap -I/usr/libipq" >> $makefile
echo "LIB = -pthread -lpcap -lcrypt " >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

#paths
echo "PATH_TO_ETC=/etc" >> $makefile
echo "PATH_TO_CONFIG=/etc/netams.cfg" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/etc/init.d" >> $makefile
echo "DAEMONDIR=/usr/local/sbin"  >> $makefile
echo "SBINDIR=/usr/local/sbin"  >> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

#ipq
locate_file "libipq.a" && v1=$var && locate_file "libipq.h" && v2=$var
if [ "X$v1" != "X" -a "X$v2" != "X" ]; then
	echo "Will have LIBIPQ support"
	ipv=`iptables -V`
	ipvn=`echo $ipv | sed -e "s/iptables v1.2.//g" -e "s/iptables v1.3./3/g" -e "s/[a-z]//g "` 
	if [ $ipvn -lt 5 ]; then
		echo "          LIBIPQ is <=1.2.4 (yours is .$ipvn)"
		echo "DEFINE += -DIPTBL_OLD" >> $makefile
	fi
	echo "LIB += -lipq -L$v1" >> $makefile
	echo "DEFINE += -I$v2" >> $makefile
else
	echo "DEFINE += -DIPTBL_NONE" >> $makefile
fi

} 
##########################################################
prepare_for_solaris() {
echo "Solaris operating system..."
#paths
echo "PATH_TO_ETC=/etc" >> $makefile
echo "PATH_TO_CONFIG=/etc/netams.cfg" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/etc/init.d" >> $makefile
echo "DAEMONDIR=/usr/local/sbin"  >> $makefile
echo "SBINDIR=/usr/local/sbin"  >> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

echo "INSTALL = /usr/sbin/install" >> $makefile
echo "DEFINE += -DSOLARIS" >>$makefile
echo "LIB += -R/usr/local/lib -lnsl -lsocket -lresolv -lpthread" >> $makefile

	#LIBPCAP support
        if [ -f /usr/local/lib/libpcap.so -a -f /opt/csw/include/pcap.h ]; then
                echo "LIB += -L/opt/csw/lib -lpcap" >> $makefile
                echo "DEFINE += -I/opt/csw/include" >> $makefile
        else
                echo "NO libPCAP"
                echo "DEFINE += -DNOPCAP" >> $makefile
        fi      

}
##########################################################
add_common() {

# mysql
locate_file "libmysqlclient.so" && v1=$var && locate_file "mysql.h" && v2=$var
if [ "X$v1" != "X" -a "X$v2" != "X" ]; then
	echo "Will have MYSQL support"
	echo "	[ $v1	$v2 ]"
	warn_on_mysql3xx
	echo "DEFINE += -DUSE_MYSQL -I$v2" >> $makefile
	echo "LIB += -lmysqlclient -L$v1" >> $makefile
fi


#postgres
locate_file "libpq.so" && v1=$var && locate_file "libpq-fe.h" && v2=$var
if [ "X$v1" != "X" -a "X$v2" != "X" ]; then
	echo "Will have POSTGRESQL support"
	echo "	[ $v1	$v2 ]"
	echo "DEFINE += -DUSE_POSTGRES -I$v2" >> $makefile
	echo "LIB += -lpq -L$v1" >> $makefile
fi

# oracle
# XXX Should check for oci.h presence.
# Oracle moves oci.h around the world, this
# is include paths for 8i/9i. YMMV.
locate_file "libclntsh.so" && v1=$var
if [ "X$v1" != "X" ]; then
	use_oracle=`echo $CONFIGURE_ARGS | awk " /--no-oracle/ { print $1 } " | wc -l`
	if [ $use_oracle -eq 0 ]; then
		echo "Will have ORACLE support"
		echo "	[ $v1 ]"
		echo "DEFINE += -DUSE_ORACLE -I$ORACLE_HOME/rdbms/demo -I$ORACLE_HOME/rdbms/public" >> $makefile
		echo "LIB += -L$v1 -R$v1 -lclntsh" >> $makefile
	fi
fi

#service billing
if [ -f src/billing.c -o -f src/billing.o ]; then
	echo "Will have BILLING service"
	echo "DEFINE += -DHAVE_BILLING" >> $makefile
	echo "SRC += billing.c s_billing.c" >> $makefile
	echo "HEADERFILES += billing.h" >> $makefile
fi

#debug (on by default)
if [ ! "x$1" = "x-nodebug" ]; then
	echo "Will have DEBUG flag set"
	echo "DEFINE += -DDEBUG" >> $makefile
	echo "FLAGS += -g -Wall" >> $makefile
fi

#memory debug (off by default)
if [ "x$1" = "x-memory" ]; then
	echo "Will have MEMORY DEBUGGING"
	echo "DEFINE += -DMEMORY_DEBUG" >> $makefile
fi

cat addon/Makefile.common >> $makefile

if [ -f private/Makefile.private ]; then
	echo "Will have private portion of Makefile"
	cat private/Makefile.private >> $makefile
fi

echo "## Configuration file was built.                        ##"
echo "##########################################################"
}

##########################################################
echo "##########################################################"
echo "## Configuring NeTAMS for build targets...              ##"

if [ ! -f addon/Makefile.common ]; then
	echo "No common Makefile configuration part is found. Bye!"
	exit 1
fi

#header 
rm -rf $makefile
echo "#/*************************************************************************" 	>  $makefile
echo "#***	Authentication, authorization, accounting + firewalling package"		>> $makefile
echo "#***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>"						>> $makefile
echo "#***	(c) 2002-2005 NeTAMS Development Team"										>> $makefile
echo "#***	All rights reserved. See 'Copying' file included in distribution"		>> $makefile
echo "#***	For latest version and more info, visit this project web page"			>> $makefile
echo "#***	located at http://www.netams.com"										>> $makefile
echo "#***		 					"												>> $makefile
echo "#*************************************************************************/"	>> $makefile
echo "# This is automatically generated Makefile for NeTAMS" >> $makefile
echo "# Created `date`" >> $makefile
echo "# Run 'make -f $makefile' to compile" >> $makefile


system=`uname`
if [ $system = "FreeBSD" ]; then
	prepare_for_freebsd  
fi
if [ $system = "OpenBSD" ]; then
	prepare_for_openbsd  
fi
if [ $system = "NetBSD" ]; then
	prepare_for_netbsd  
fi
if [ $system = "Linux" ]; then
	prepare_for_linux  
fi
if [ $system = "Solaris" -o $system = "SunOS" ]; then
 	prepare_for_solaris  
fi

add_common

