--
-- $Id: netams_tg.sql,v 1.2.2.2 2005/03/24 20:16:55 anton Exp $
--

CONNECT netams/netams

prompt 'Create trigger for oids'

CREATE OR REPLACE TRIGGER netams_tr_oids
    BEFORE INSERT ON oids
    FOR EACH ROW
DECLARE   
     row_cnt numeric;
BEGIN
    Select count(*) into row_cnt
        from oids     
        where oid=:new.oid;
      
    if row_cnt>0 then
        Delete from oids where oid=:new.oid;
    end if;
    return;
    
END;
/
--
prompt 'Create trigger for quota'

CREATE OR REPLACE TRIGGER netams_tr_quota
    BEFORE INSERT ON quota
    FOR EACH ROW
DECLARE   
     row_cnt numeric;
BEGIN
    Select count(*) into row_cnt
        from quota     
        where unit_oid  =:new.unit_oid 
          and policy_oid=:new.policy_oid;
      
    if row_cnt>0 then
        Delete from quota 
            where unit_oid=:new.unit_oid 
              and policy_oid=:new.policy_oid;
     
    end if;
    return;
    
END;
/
--
prompt 'Create trigger for summary'

CREATE OR REPLACE TRIGGER netams_tr_summary
    BEFORE INSERT ON summary
    FOR EACH ROW
DECLARE   
     row_cnt numeric;
BEGIN
    Select count(*) into row_cnt
        from summary     
        where prefix=:new.prefix
          and unit_oid=:new.unit_oid
          and policy_oid=:new.policy_oid 
          and t_from=:new.t_from;
      
    if row_cnt>0 then
        Delete from summary 
            where prefix=:new.prefix
              and unit_oid=:new.unit_oid
              and policy_oid=:new.policy_oid 
              and t_from=:new.t_from;
      
    end if;
    return;
    
END;
/
--
prompt 'Create trigger for login'

CREATE OR REPLACE TRIGGER netams_tr_login
    BEFORE INSERT ON login
    FOR EACH ROW
DECLARE   
     row_cnt numeric;
BEGIN
    Select count(*) into row_cnt
        from login     
        where unit_oid=:new.unit_oid;
      
    if row_cnt>0 then
        Delete from login where unit_oid=:new.unit_oid;
    end if;
    return;
    
END;
/
--
prompt 'Create trigger for billing'

CREATE OR REPLACE TRIGGER netams_tr_billing
    BEFORE INSERT ON billing
    FOR EACH ROW
DECLARE   
     row_cnt numeric;
BEGIN
    Select count(*) into row_cnt
        from billing
        where oid=:new.oid;
      
    if row_cnt>0 then
        Delete from billing where oid=:new.oid;
    end if;
    return;
    
END;
/
--
prompt 'Create trigger for billing'

CREATE OR REPLACE TRIGGER netams_tr_billing
    BEFORE INSERT ON billing
    FOR EACH ROW
DECLARE   
     row_cnt numeric;
BEGIN
    Select count(*) into row_cnt
        from billing
        where oid=:new.oid;
      
    if row_cnt>0 then
        Delete from billing where oid=:new.oid;
    end if;
    return;
    
END;
/

--
prompt 'Create trigger for bdata'

CREATE OR REPLACE TRIGGER netams_tr_bdata
    BEFORE INSERT ON bdata
    FOR EACH ROW
DECLARE   
     row_cnt numeric;
BEGIN
    Select count(*) into row_cnt
        from bdata
        where prefix=:new.prefix
          and account_oid=:new.account_oid
          and subplan_oid=:new.subplan_oid 
          and t_from=:new.t_from;
      
    if row_cnt>0 then
        Delete from bdata 
            where prefix=:new.prefix
              and account_oid=:new.account_oid
              and subplan_oid=:new.subplan_oid 
              and t_from=:new.t_from;
      
    end if;
    return;
    
END;
/

exit

