--
-- $Id: netams_tb.sql,v 1.1.2.2 2005/03/24 20:16:55 anton Exp $
--

CONNECT netams/netams

DROP TABLE rawdata
/

PROMPT 'Create table RAWDATA'

CREATE TABLE rawdata 
(
    unit_oid        NUMBER      NOT NULL,
    policy_oid      NUMBER      NOT NULL,
    t_from          NUMBER      NOT NULL,
    t_to            NUMBER      NOT NULL,
    bytes_in        NUMBER(30),
    bytes_out       NUMBER(30)
)
/

CREATE INDEX raw_unit_oid_idx
ON rawdata(unit_oid)
COMPRESS
/

CREATE INDEX raw_policy_oid_idx
ON rawdata(policy_oid)
COMPRESS
/

CREATE INDEX raw_t_from_idx
ON rawdata(t_from)
COMPRESS
/

CREATE INDEX raw_t_to_idx
ON rawdata(t_to)
COMPRESS
/

DROP TABLE summary
/

PROMPT 'Create table SUMMARY'

CREATE TABLE summary 
(
    prefix          CHAR(1)         NOT NULL,
    unit_oid        NUMBER          NOT NULL,
    policy_oid      NUMBER          NOT NULL,
    t_from          NUMBER          NOT NULL,
    bytes_in        NUMBER(30),
    bytes_out       NUMBER(30),
    CONSTRAINT      summ_pk PRIMARY KEY (prefix, unit_oid, policy_oid, t_from)
        USING INDEX REVERSE
)
/

CREATE INDEX summary_unit_oid_idx
ON summary(unit_oid)
COMPRESS
/

CREATE INDEX summary_policy_oid_idx
ON summary(policy_oid)
COMPRESS
/

CREATE INDEX summary_t_from_idx
ON summary(t_from)
COMPRESS
/

DROP TABLE monitor
/

PROMPT 'Create table MONITOR'

CREATE TABLE monitor (
    time            NUMBER          NOT NULL,
    flowt           NUMBER,
    unit_oid        NUMBER,
    proto           NUMBER,
    src             NUMBER          NOT NULL,
    srcport         NUMBER,
    dst             NUMBER          NOT NULL,
    dstport         NUMBER,
    if_in	    NUMBER,
    if_out	    NUMBER,
    as_src          NUMBER,
    as_dst          NUMBER,
    dpkts           NUMBER(30),
    len             NUMBER(30)
)
/

CREATE INDEX monitor_time_idx
ON monitor(time)
COMPRESS
/

CREATE INDEX monitor_unit_oid_idx
ON monitor(unit_oid)
COMPRESS
/

DROP TABLE login
/

PROMPT 'Create table LOGIN'

CREATE TABLE login 
(
    unit_oid        NUMBER           NOT NULL,
    password        VARCHAR2(32),
    inact           NUMBER,
    abs             NUMBER,
    last_changed    NUMBER,
    last_opened_time NUMBER,
    ip              NUMBER          NULL,
    mac             VARCHAR2(18),
    flags           NUMBER          NULL,
    CONSTRAINT      login_unit_oid_pk PRIMARY KEY (unit_oid)
        USING INDEX REVERSE
)
/

DROP TABLE quota
/

PROMPT 'Create table QUOTA'

CREATE TABLE quota 
(
    unit_oid        NUMBER          NOT NULL,
    policy_oid      NUMBER          NOT NULL,
    syspolicy_oid   NUMBER,
    soft_treshold   NUMBER,
    flags           NUMBER,
    last_blocked_time NUMBER,
    notify_soft_oid NUMBER,
    notify_hard_oid NUMBER,
    notify_return_oid NUMBER,
    h_in            NUMBER(30)      NULL,
    h_out           NUMBER(30)      NULL,
    h_sum           NUMBER(30)      NULL,
    d_in            NUMBER(30)      NULL,
    d_out           NUMBER(30)      NULL,
    d_sum           NUMBER(30)      NULL,
    w_in            NUMBER(30)      NULL,
    w_out           NUMBER(30)      NULL,
    w_sum           NUMBER(30)      NULL,
    m_in            NUMBER(30)      NULL,
    m_out           NUMBER(30)      NULL,
    m_sum           NUMBER(30)      NULL,
    block_policy	NUMBER,
    block_policy_flags	NUMBER,
    CONSTRAINT      quota_pk PRIMARY KEY (unit_oid, policy_oid)
        USING INDEX REVERSE
)
/

CREATE INDEX quota_policy_oid_idx
ON quota(policy_oid)
COMPRESS
/

DROP TABLE events
/

PROMPT 'Create table EVENTS'

CREATE TABLE events 
(
    time            NUMBER,
    type            VARCHAR2(8),
    unit_oid        NUMBER,
    user_oid        NUMBER,
    account_oid     NUMBER,
    param           VARCHAR2(254)
)
/

DROP TABLE oids
/

PROMPT 'Create table OIDS'

CREATE TABLE oids 
(
    oid             NUMBER          NOT NULL,
    name            VARCHAR2(32),
    CONSTRAINT      oid_pk PRIMARY KEY (oid)
        USING INDEX REVERSE
)
/

DROP TABLE billing
/

PROMPT 'Create table BILLING'

CREATE TABLE billing 
(
    oid             NUMBER          NOT NULL,
    name            VARCHAR2(32),
    description     VARCHAR2(254),
    balance         NUMBER(15,5),
    units           VARCHAR2(1024),
    plan            NUMBER(10),
    plan_ch         NUMBER,
    nextplan        NUMBER(10),
    nextplan_ch     NUMBER,
    blocked         NUMBER,
    created         NUMBER,
    changed         NUMBER,
    last_fee_ch     NUMBER,
    email           VARCHAR2(32),
    passwd          VARCHAR2(32),
    status          NUMBER          NULL,
    CONSTRAINT      billing_pk PRIMARY KEY (oid)
        USING INDEX REVERSE
)
/

DROP TABLE bdata
/

PROMPT 'Create table BDATA'

CREATE TABLE bdata 
(
    prefix          CHAR(1)         NOT NULL,
    account_oid     NUMBER          NOT NULL,
    subplan_oid     NUMBER          NOT NULL,
    t_from          NUMBER          NOT NULL,
    bytes_in        NUMBER(30)      NULL,
    bytes_out       NUMBER(30)      NULL,
    pay_in          NUMBER(15,5)    NULL,
    pay_out         NUMBER(15,5)    NULL,
    CONSTRAINT      bdata_pk PRIMARY KEY (prefix, account_oid, subplan_oid, t_from)
        USING INDEX REVERSE
)
/

CREATE INDEX bdata_account_oid_idx
ON bdata(account_oid)
COMPRESS
/

CREATE INDEX bdata_subplan_oid_idx
ON bdata(subplan_oid)
COMPRESS
/

CREATE INDEX bdata_t_from_idx
ON bdata(t_from)
COMPRESS
/

exit;

