#!/bin/sh
PATH=/usr/local/sbin:/bin:/usr/bin:/sbin
export PATH
##########################################################
debug=1
log=1
configfile=/usr/local/etc/netams.cfg
appfile=/usr/local/libexec/netams
logfile=netams.log
path=/var/log
##########################################################
# $Id: netams-startup-failover.sh,v 1.2 2004/11/21 22:23:17 anton Exp $

start_loop() {

# echo $appfile -${flags} $configfile
echo -n ' NeTAMS'
cd $path
failcount=0

while : ; do

	rm -rf $corefile 2>&1 >/dev/null                                                    
	start=`date '+%d%H%M%S'`
    $appfile -${flags} $configfile 2>&1 > /dev/null
    eval retstate=$?
	stop=`date '+%d%H%M%S'`

	if [ -r $corefile ]; then
		echo >> netams_core.log
		echo bt | gdb $appfile $corefile >> netams_core.log
	fi

	datesufix=`date "+%Y-%m-%d_%H:%M"`
	mv $path/$logfile $path/$logfile.$datesufix	2>&1 >/dev/null
		   
	t=`expr $stop - $start`

    if test 0 -le $t -a $t -lt 5 ; then
            failcount=`expr $failcount + 1`
    else
            failcount=0
    fi
    
    if test $failcount -gt 5 ; then
          echo "netams: EXITING DUE TO REPEATED, FREQUENT FAILURES" >&2
          exit 1
    fi

    if test $retstate -ne 253; then
        echo "netams: EXITING DUE TO $retstate signal" >&2
        exit 1
    fi
    
sleep 1
done

}

flags="f"

if [ "$debug" -eq 1 ]; then
	eval flags=d$flags
fi

if [ "$log" -eq 1 ]; then
	eval flags=l$flags
fi

system=`uname`
if [ $system = "FreeBSD" ]; then
	corefile="netams.core"
fi
if [ $system = "Linux" ]; then
	corefile="core"
fi

if [ "x$1" = "x" -o "x$1" = "xstart" ]; then
	if [ ! -f $appfile ]; then
	echo "daemon executable is not found at $appfile"
	exit 1
    fi

	if [ ! -f $configfile ]; then
	echo "config file is not found at $configfile"
	exit 1
    fi

	start_loop &
fi

