#include "tcp_ip_ruleset.h"
#include <iostream.h>
#include <fstream.h>

ostream& operator <<(ostream& os, TcpIpRuleSet& r)
 {
  unsigned int i;
  for(i = 0; i < r.rules.size(); i++)
   {
    os << r.rules[i] << endl;
   }

  return os;
 }

ostream& operator <<(ostream& os, TcpIpRule& r)
 {
  os << inet_ntoa(r.netnum) << "/";
  os << inet_ntoa(r.netmask);
  return os;
 }

int TcpIpRuleSet::ok(struct in_addr& host)
 {
  unsigned int i;
 
  if(default_policy == DENY)
   {
    for(i = 0; i < rules.size(); i++)
    {
     if(rules[i].allowed(host))
      return 1;
    }
   
    return 0;
   }

  if(default_policy == ALLOW)
   {
    for(i = 0; i < rules.size(); i++)
    {
     if(rules[i].denied(host))
      return 0;
    }
   
    return 1;
   }
 }

#ifdef DEBUG

int main(int argc, char** argv)
 {
  if(argc != 3)
   {
    cerr << "Usage: " << argv[0] << " rules_file ip_file" << endl;
    exit(1);
   }
 
  ifstream ip(argv[2]), rules(argv[1]);
  if(!rules)
   {
    cerr << "Could not open rules file" << endl;
    exit(1);
   }

  if(!ip)
   {
    cerr << "Could not open ip file" << endl;
    exit(1);
   }

  TcpIpRuleSet r;

   while(1)
    {
     char netnum[128], netmask[128];
     rules >> netnum >> netmask;
     cout << "reading: " << netnum << " " << netmask << endl;
     if(!rules) break;
     r.add_rule(netnum, netmask);
    
    }
 
  cout << "ruleset:" << endl << r;
   while(1)
    {
     char netnum[128], netmask[128];
     rules >> netnum >> netmask;
     cout << "reading: " << netnum << " " << netmask << endl;
     if(!rules) break;
     r.add_rule(netnum, netmask);
    
    }
 
  cout << "access:" << endl ;
 
   while(1)
    {
     char ip_str[128];
     ip >> ip_str;
     if(!ip) break;
     cout << ip_str << " is " << (r.ok(ip_str) ? " allowed " : " denied") << endl ;
    
    }

 }

#endif
