/***

promisc.c	- handles the promiscuous mode flag for the Ethernet
		  interfaces
		  
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997, 1998

This module sets an interface's promiscuous flag using the standard ioctl()
SIOCSIFFLAGS command.

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <curses.h>
#include <panel.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <net/if.h>
#include <linux/if_ether.h>
#include "ifstats.h"
#include "error.h"

extern void initiflist(struct iflist **list);
extern void destroyiflist(struct iflist *list);

void srpromisc(int mode)
{
    int fd;
    struct ifreq ifr;
    struct iflist *list;
    struct iflist *ptmp;
    int istat;
    int response;
    char *errmsg = "Promisc change failed for ";
    char fullmsg[40];

    initiflist(&list);
    ptmp = list;
    fd = socket(PF_INET, SOCK_DGRAM, 0);

    if (fd < 0) {
	errbox("Unable to open socket for flag change", ANYKEY_MSG, &response);
	destroyiflist(list);
	return;
    }
    while (ptmp != NULL) {
	if ((strncmp(ptmp->ifname, "eth", 3) == 0) ||
	    (strncmp(ptmp->ifname, "fddi", 4) == 0)) {
	    strcpy(ifr.ifr_name, ptmp->ifname);
	    istat = ioctl(fd, SIOCGIFFLAGS, &ifr);

	    if (istat < 0) {
		errbox("Unable to obtain interface parameters",
		       ANYKEY_MSG, &response);
		destroyiflist(list);
		close(fd);
		return;
	    }
	    if (mode)
		ifr.ifr_flags |= IFF_PROMISC;
	    else
		ifr.ifr_flags &= ~IFF_PROMISC;

	    istat = ioctl(fd, SIOCSIFFLAGS, &ifr);

	    if (istat < 0) {
		strcpy(fullmsg, errmsg);
		strcat(fullmsg, ptmp->ifname);
		errbox(fullmsg, ANYKEY_MSG, &response);
	    }
	}
	ptmp = ptmp->next_entry;
    }

    close(fd);
    destroyiflist(list);
}
