#!/usr/bin/perl -T
#
#   ipac.cgi v1.0 By Dan Swan  -  Web frontend to ipacsum
#   Jan 4 2000.  
#
#   This is my first crack at perl cgi.  If you've any suggestions
#   as to how I could have pulled this off more securely, I am 
#   very interested in them.  E-mail me at swan_daniel@hotmail.com.  
#
#   Note:  This script outputs .asis files instead of .gifs, in order to 
#   force images to auto-refresh. See the ipacsum man page for details.
#
#   If Images do not refresh, shift-reload to force refresh.
#
#   Todo:  Incorporate full functionality of ipacsum into ipac.cgi, 
#          allow for setting of destination dir, and clean it all up.
#

use POSIX qw(strftime);            
use Sys::Hostname;
use CGI qw/:standard :html3 /;

delete @ENV{qw(ENV PATH)};   # Delete $ENV variable to stop taint from choking on it.

$TRAFDIR="/home/httpd/html/traffic"; #Changing this will presently break script.
$IPADDR=""; #Enter your hostname or IP within the brackets.  If left empty,
            # ipac.cgi will attempt to guess it.  Best left blank if your IP
            # is dynamic.
$cgi_form = new CGI; 
$forminput    = $cgi_form->param('LIST'); # Grab LIST variable from html form

system (`rm -rf /home/httpd/html/traffic/*`);  #remove old files.
# For some reason, unlink is giving a taint error, so I do it this way.  
# No time to fix to make Moritz's release date.   Will fix later.

#Validating tainted input

  if ($forminput eq "today")
     { 
       $forminput = "today";
     }  
elsif ($forminput eq "yesterday")
     {
       $forminput = "yesterday";
     }

elsif ($forminput eq "thisweek")
     {
       $forminput = "this week";
     } 
elsif ($forminput eq "lastweek")
     {
       $forminput = "last week";
     } 
elsif ($forminput eq "thismonth")
     {
       $forminput = "this month";
     }      
elsif ($forminput eq "lastmonth")
     {
       $forminput = "last month";
     }      
elsif ($forminput eq "")
     {
       $forminput = ""
     }           
  else
     {
       die ("Illegal Parameter Sent:  $forminput");  # If it aint one of the above parameters, then die.
     }

$time = strftime "%H%M%S", localtime;


if ($IPADDR eq "")  # Has user declared own hostname?
   { 
   $IPADDR = hostname();  
   }

if (! -d $TRAFDIR)  #Does traffic Directory not exist?
   {
   mkdir ($TRAFDIR,0755);
   }
     
print "Location: http://$IPADDR/traffic/index${time}.html", "\n\n";

system("/usr/local/bin/ipacsum -timeframe \"$forminput\"  --gif $TRAFDIR --gif-index /home/httpd/html/traffic/index${time}.html --gif-caption-in-index  --gif-asis 2>&1 > /dev/null ");

exit (0);   # What the heck.

#
#########################################################
#    Basic form template for use with with ipac.cgi     #
#########################################################

#<HTML>
#
#<HEAD>
#<TITLE> Ipacsum Traffic Stats for My.Host.Name</TITLE>
#</HEAD>
#
#<BODY>
#
#<H1 align=center>Ipacsum Traffic Stats for My.Host.Name</H1>
#
#<FORM METHOD="get" ACTION="/cgi-bin/newipac.cgi">
#
#Today <INPUT TYPE="RADIO" NAME="LIST" VALUE="today"><BR>
#Yesterday <INPUT TYPE="RADIO" NAME="LIST" VALUE="yesterday"><BR>
#This Week<INPUT TYPE="RADIO" NAME="LIST" VALUE="thisweek"><BR>
#This Week<INPUT TYPE="RADIO" NAME="LIST" VALUE="lastweek"><BR>
#This Month <INPUT TYPE="RADIO" NAME="LIST" VALUE="thismonth"><BR>
#This Month <INPUT TYPE="RADIO" NAME="LIST" VALUE="lastmonth"><BR>
#Ever <INPUT TYPE="RADIO" NAME="LIST" VALUE=""><BR>

#<INPUT TYPE="SUBMIT" VALUE="Send It!">
#<INPUT TYPE="RESET" VALUE="Reset">
#</FORM> 
#
#</BODY>
#</HTML>
