/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/***************** gpre version FB-V6.2.908 Firebird 1.0 **********************/
/*
 *	PROGRAM:	JRD Message Facility
 *	MODULE:		build_file.e
 *	DESCRIPTION:	Build message file
 *
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 */

#include "../jrd/ib_stdio.h"
#include <stdlib.h>
#include <string.h>
#include "../jrd/gds.h"
#include "../jrd/common.h"
#include "../jrd/msg.h"
#include "../jrd/gds_proto.h"

#define MAX_LEVELS	4

/*DATABASE DB = "msg.gdb";*/
/**** GDS Preprocessor Definitions ****/
#ifndef _JRD_IBASE_H_
#include <ibase.h>
#endif

static ISC_QUAD
   isc_blob_null = {0,0};	/* initializer for blobs */
static long *gds__null = 0;	/* dummy status vector */
isc_db_handle
   DB = 0;		/* database handle */

isc_tr_handle
   gds__trans = 0;		/* default transaction handle */
long
   isc_status [20],	/* status vector */
   isc_status2 [20];	/* status vector */
long
   isc_array_length, 	/* array return size */
   SQLCODE;		/* SQL status code */
static isc_req_handle
   isc_0 = 0;		/* request handle */

static short
   isc_1l = 157;
static char
   isc_1 [] = {
   4,2,4,1,2,0,7,0,40,119,0,4,0,3,0,7,0,7,0,40,21,0,12,0,2,7,'C',
   1,'J',9,'T','R','A','N','S','M','S','G','S',0,'G',58,47,23,0,
   8,'F','A','C','_','C','O','D','E',25,0,1,0,58,47,23,0,6,'N',
   'U','M','B','E','R',25,0,0,0,58,47,23,0,6,'L','O','C','A','L',
   'E',25,0,2,0,58,59,61,23,0,4,'T','E','X','T',48,23,0,4,'T','E',
   'X','T',21,14,1,0,32,-1,14,1,2,1,21,8,0,1,0,0,0,25,1,0,0,1,23,
   0,4,'T','E','X','T',25,1,1,0,-1,14,1,1,21,8,0,0,0,0,0,25,1,0,
   0,-1,-1,'L'
   };	/* end of blr string for request isc_1 */

static isc_req_handle
   isc_9 = 0;		/* request handle */

static short
   isc_10l = 145;
static char
   isc_10 [] = {
   4,2,4,0,6,0,8,0,7,0,7,0,7,0,7,0,40,119,0,2,7,'C',1,'J',8,'M',
   'E','S','S','A','G','E','S',0,'F',1,'H',23,0,4,'C','O','D','E',
   -1,14,0,2,1,23,0,4,'C','O','D','E',25,0,0,0,1,21,8,0,1,0,0,0,
   25,0,1,0,1,23,0,5,'F','L','A','G','S',25,0,2,0,1,23,0,6,'N',
   'U','M','B','E','R',25,0,3,0,1,23,0,8,'F','A','C','_','C','O',
   'D','E',25,0,4,0,1,23,0,4,'T','E','X','T',25,0,5,0,-1,14,0,1,
   21,8,0,0,0,0,0,25,0,1,0,-1,-1,'L'
   };	/* end of blr string for request isc_10 */

static isc_req_handle
   isc_18 = 0;		/* request handle */

static short
   isc_19l = 73;
static char
   isc_19 [] = {
   4,2,4,0,2,0,7,0,40,21,0,2,7,'C',1,'J',7,'L','O','C','A','L',
   'E','S',0,-1,14,0,2,1,21,8,0,1,0,0,0,25,0,0,0,1,23,0,6,'L','O',
   'C','A','L','E',25,0,1,0,-1,14,0,1,21,8,0,0,0,0,0,25,0,0,0,-1,
   -1,'L'
   };	/* end of blr string for request isc_19 */

static isc_req_handle
   isc_23 = 0;		/* request handle */

static short
   isc_24l = 116;
static char
   isc_24 [] = {
   4,2,4,0,2,0,7,0,40,21,0,2,7,'C',1,'J',7,'L','O','C','A','L',
   'E','S',0,'G',58,48,23,0,6,'L','O','C','A','L','E',21,14,5,0,
   112,103,'_','P','G',48,23,0,6,'L','O','C','A','L','E',21,14,
   8,0,112,105,103,108,97,116,105,110,-1,14,0,2,1,21,8,0,1,0,0,
   0,25,0,0,0,1,23,0,6,'L','O','C','A','L','E',25,0,1,0,-1,14,0,
   1,21,8,0,0,0,0,0,25,0,0,0,-1,-1,'L'
   };	/* end of blr string for request isc_24 */

static isc_req_handle
   isc_28 = 0;		/* request handle */

static short
   isc_29l = 88;
static char
   isc_29 [] = {
   4,2,4,1,1,0,7,0,4,0,1,0,40,21,0,12,0,2,7,'C',1,'J',7,'L','O',
   'C','A','L','E','S',0,'D',21,8,0,1,0,0,0,'G',47,23,0,6,'L','O',
   'C','A','L','E',25,0,0,0,-1,14,1,2,1,21,8,0,1,0,0,0,25,1,0,0,
   -1,14,1,1,21,8,0,0,0,0,0,25,1,0,0,-1,-1,'L'
   };	/* end of blr string for request isc_29 */


#define gds__blob_null	isc_blob_null	/* compatibility symbols */
#define gds__status	isc_status
#define gds__status2	isc_status2
#define gds__array_length	isc_array_length
#define gds__count	isc_count
#define gds__slack	isc_slack
#define gds__utility	isc_utility	/* end of compatibility symbols */

#ifndef isc_version4
    Generate a compile-time error.
    Picking up a V3 include file after preprocessing with V4 GPRE.
#endif

/**** end of GPRE definitions ****/


static void	ascii_str_to_upper (TEXT *);
static USHORT	do_msgs (TEXT *, TEXT *, USHORT);
static void	propogate (MSGNOD *, MSGNOD *, ULONG, ULONG);
static SLONG	write_bucket (MSGNOD, USHORT);
static void	sanitize (TEXT *);

static SLONG 	file_position;
static int	file;

/* keep the LOCALE_PAT names in sync with gds.h */

#if (defined WIN_NT || defined OS2_ONLY)
#include <io.h>
#define FILENAME	"interbas.msg"
#define LOCALE_PAT	"%.8s.msg"
#define PATH_SEPARATOR	'\\'
#endif

#ifdef PC_PLATFORM
#include <fcntl.h>
#include <io.h>
#define FILENAME	"interbas.msg"
#define LOCALE_PAT	"%.8s.msg"
#define PATH_SEPARATOR	'\\'
#endif

#ifdef mpexl
#define FILENAME	"message.data"
#define LOCALE_PAT	"%.8s.data"
#define PATH_SEPARATOR	'?'
#endif

#ifndef FILENAME
#define FILENAME	"interbase.msg"
#define LOCALE_PAT	"%.10s.msg"
#define PATH_SEPARATOR	'/'
#endif

#ifdef VMS
#include <file.h>
#else
#include <sys/types.h>
#ifndef DELTA
#ifndef XENIX
#ifndef PC_PLATFORM
#ifndef OS2_ONLY
#ifndef WIN_NT
#ifndef mpexl
#include <sys/file.h>
#endif
#endif
#endif
#endif
#endif
#endif
#endif

#ifndef O_RDWR
#include <fcntl.h>
#endif

#ifndef O_BINARY
#define O_BINARY	0
#endif

int CLIB_ROUTINE main (
    int		argc,
    char	**argv)
{
   struct {
          short isc_21;	/* isc_utility */
          char  isc_22 [21];	/* LOCALE */
   } isc_20;
   struct {
          short isc_26;	/* isc_utility */
          char  isc_27 [21];	/* LOCALE */
   } isc_25;
   struct {
          short isc_33;	/* isc_utility */
   } isc_32;
   struct {
          char  isc_31 [21];	/* LOCALE */
   } isc_30;
/**************************************
 *
 *	m a i n
 *
 **************************************
 *
 * Functional description
 *	Top level routine.
 *
 **************************************/
TEXT	*p, **end_args, db_file [256], filename [256],
	*pathname, pathbuffer [256], *locale;
USHORT	sw_bad;
USHORT	sw_warning;
USHORT	i, locale_count;
SSHORT	len;
/*BASED ON LOCALES.LOCALE	this_locale;*/
char
   this_locale[21];


strcpy (db_file, "msg.gdb");
strcpy (filename, FILENAME);
pathname = NULL;
locale = NULL;
sw_warning = 0;

end_args = argv + argc;

for (++argv; argv < end_args;)
    {
    p = *argv++;
    sw_bad = FALSE;
    if (*p != '-')
	sw_bad = TRUE;
    else
	switch (UPPER (p [1]))
	    {
	    case 'D':
		strcpy (db_file, *argv++);
		break;
	    
	    case 'F':
		strcpy (filename, *argv++);
		break;
	    
	    case 'P':
		strcpy (pathbuffer, *argv++);
		pathname = pathbuffer;
		break;

	    case 'L':
		locale = *argv++;
		break;
	    
	    case 'W':
		sw_warning++;
		break;
	    
	    default:
		sw_bad = TRUE;
	    }
    if (sw_bad)
	{
	ib_printf ("Invalid option \"%s\".  Valid options are:\n", p);
	ib_printf ("\t-D\tDatabase name\n");
	ib_printf ("\t-F\tMessage file name\n");
	ib_printf ("\t-P\tMessage file path (should end with '/')\n");
	ib_printf ("\t-L\tLocale name\n");
	ib_printf ("\t-W\tVerbose warning messages\n");
	exit (FINI_ERROR);
	}
    }

/* Get db_file ready to go */

/*READY db_file AS DB;*/
{
isc_attach_database ((long*) 0L, 0, db_file, &DB, 0, (char*) 0);
}
/*START_TRANSACTION;*/
{
{
isc_start_transaction ((long*) 0L, &gds__trans, (short) 1, &DB, (short) 0, (char*) 0);
}
}

/* make sure the path name ends in a '/' */

if (pathname)
    {
    len = strlen (pathname);
    if (pathname [len - 1] != PATH_SEPARATOR)
	{
	pathname [len] = PATH_SEPARATOR;
	pathname [len + 1] = 0;
	}
    }

/* check for the locale option  */

if (!locale)	/* no locale given: do the regular US msgs  */
    {
    if (!pathname)
    	do_msgs (filename, NULL, 0);
    else
	{
    	strcat (pathname, filename);
    	do_msgs (pathname, NULL, 0);
	}
    }
else
    {
    int	got_one = 0;
    /*FOR FIRST 1 L IN LOCALES WITH L.LOCALE = locale*/
    {
    if (!isc_28)
       isc_compile_request2 ((long*) 0L, &DB, &isc_28, (short) sizeof (isc_29), (char ISC_FAR *) isc_29);
    isc_vtov (locale, isc_30.isc_31, 21);
    isc_start_and_send ((long*) 0L, &isc_28, &gds__trans, (short) 0, (short) 21, &isc_30, (short) 0);
    while (1)
       {
       isc_receive ((long*) 0L, &isc_28, (short) 1, (short) 2, &isc_32, (short) 0);
       if (!isc_32.isc_33) break;
	got_one = 1;
    /*END_FOR;*/
       }
    }
    if (got_one)     /* do only 1 locale */
	{
	strcpy (this_locale, locale);
        sanitize (locale);
	if (pathname)
	    {
            sprintf (filename, LOCALE_PAT, locale);
            strcat (pathname, filename);
            do_msgs (pathname, this_locale, sw_warning);
	    }
	else
            do_msgs (filename, this_locale, sw_warning);
	}
    else
	{
	strncpy (this_locale, locale, sizeof (this_locale));
        ascii_str_to_upper (this_locale);
        if (!strcmp (this_locale, "ALL"))         
            {
            /*FOR LC IN LOCALES		*//* do all locales except piglatin *//*
   		WITH LC.LOCALE != "pg_PG" AND LC.LOCALE != "piglatin"*/
	    {
            if (!isc_23)
               isc_compile_request2 ((long*) 0L, &DB, &isc_23, (short) sizeof (isc_24), (char ISC_FAR *) isc_24);
            isc_start_request ((long*) 0L, &isc_23, &gds__trans, (short) 0);
	    while (1)
	       {
               isc_receive ((long*) 0L, &isc_23, (short) 0, (short) 23, &isc_25, (short) 0);
	       if (!isc_25.isc_26) break;; 
		locale = /*LC.LOCALE*/
			 isc_25.isc_27;
                strcpy (this_locale, /*LC.LOCALE*/
				     isc_25.isc_27);
                ib_printf ("build_file: building locale %s", this_locale);
                sanitize (locale);
                sprintf (filename, LOCALE_PAT, locale);
		if (pathname)
		    {
                    strcat (pathname, filename);
                    ib_printf (" to file %s\n", pathname);
                    do_msgs (pathname, this_locale, sw_warning);
		    }
		else
		    {
                    ib_printf (" to file %s\n", filename);
                    do_msgs (filename, this_locale, sw_warning);
		    }
		pathname = NULL;
            /*END_FOR;*/
	       }
	    }
            }
        else
            {
            ib_printf ("build_file: Unknown locale: %s\n", locale); 
            ib_printf ("Valid options are:\n");
            /*FOR LO IN LOCALES*/
	    {
            if (!isc_18)
               isc_compile_request2 ((long*) 0L, &DB, &isc_18, (short) sizeof (isc_19), (char ISC_FAR *) isc_19);
            isc_start_request ((long*) 0L, &isc_18, &gds__trans, (short) 0);
	    while (1)
	       {
               isc_receive ((long*) 0L, &isc_18, (short) 0, (short) 23, &isc_20, (short) 0);
	       if (!isc_20.isc_21) break;
                ib_printf ("\t%s\n", /*LO.LOCALE*/
				     isc_20.isc_22);
            /*END_FOR;*/
	       }
	    }
            ib_printf ("\tall\n");
	    }
	/*COMMIT;*/
	{
	isc_commit_transaction ((long*) 0L, &gds__trans);
	}
	/*FINISH DB;*/
	{
	isc_detach_database ((long*) 0L, &DB);
	}
	exit (FINI_ERROR);
	}
    }

/*COMMIT;*/
{
isc_commit_transaction ((long*) 0L, &gds__trans);
}
/*FINISH;*/
{
if (DB)
   isc_detach_database ((long*) 0L, &DB);
}
    
exit (FINI_OK);
}

static void ascii_str_to_upper (
    TEXT	*s)
{
/**************************************
 *
 *	a s c i i _ s t r _ t o _ u p p e r
 *
 **************************************
 *
 * Functional description
 *	change the a - z chars in string to upper case
 *
 **************************************/

while (*s)
    {
    *s >= 'a' && *s <= 'z' ? *s &= 0xDF : *s;
    *s++;
    }
}

static USHORT do_msgs (
    TEXT	*filename,
    TEXT	*locale,
    USHORT	sw_warning)
{
   struct {
          short isc_7;	/* isc_utility */
          char  isc_8 [119];	/* TEXT */
   } isc_6;
   struct {
          short isc_3;	/* NUMBER */
          short isc_4;	/* FAC_CODE */
          char  isc_5 [21];	/* LOCALE */
   } isc_2;
   struct {
          long isc_12;	/* CODE */
          short isc_13;	/* isc_utility */
          short isc_14;	/* FLAGS */
          short isc_15;	/* NUMBER */
          short isc_16;	/* FAC_CODE */
          char  isc_17 [119];	/* TEXT */
   } isc_11;
/**************************************
 *
 *	d o _ m s g s
 *
 **************************************
 *
 * Functional description
 *	Build the message file
 *
 **************************************/
ISC_MSGHDR  header;
TEXT    buffer [MAX_LEVELS * MSG_BUCKET], *p, *q, *end_leaf, msg_text [256];
MSGREC  leaf_node, leaf;
MSGNOD  buckets [MAX_LEVELS], *ptr, *ptr2, *end, nodes [MAX_LEVELS], node;
USHORT   l, n, levels;
ULONG    position, prior_code;
int	warning_counter;

warning_counter = 0;
 
/* Divy up memory among various buffers */

leaf_node = leaf = (MSGREC) gds__alloc ((SLONG) MSG_BUCKET);
end_leaf = (TEXT*) leaf + MSG_BUCKET;
nodes [0] = NULL;

/* Open output file */

#ifndef mpexl
if ((file = open (filename, O_WRONLY | O_CREAT | O_BINARY, 0666)) == -1)
#else
if ((file = open (filename, O_WRONLY | O_CREAT | O_MPEOPTS, 0666, "b Ds2 E32 S20000")) == -1)
#endif
    {
    ib_printf ("Can't open %s\n", filename);
    return FINI_ERROR;
    }
file_position = 0;

/* Format and write header */

header.msghdr_major_version = MSG_MAJOR_VERSION;
header.msghdr_minor_version = MSG_MINOR_VERSION;
header.msghdr_bucket_size = MSG_BUCKET;
write_bucket (&header, sizeof (header));

/* Write out messages building B-tree */

/*FOR X IN MESSAGES SORTED BY X.CODE*/
{
if (!isc_9)
   isc_compile_request2 ((long*) 0L, &DB, &isc_9, (short) sizeof (isc_10), (char ISC_FAR *) isc_10);
isc_start_request ((long*) 0L, &isc_9, &gds__trans, (short) 0);
while (1)
   {
   isc_receive ((long*) 0L, &isc_9, (short) 0, (short) 131, &isc_11, (short) 0);
   if (!isc_11.isc_13) break;

    /* pre-load with US English message - just in case we don't
     * have a translation available. */

    strcpy (msg_text, /*X.TEXT*/
		      isc_11.isc_17);
    l = strlen (msg_text);
    if (locale)					/* want translated output */
	{
	/* Overwrite English message with translation, if we find one */
	int found_one;
	found_one = 0;
	/*FOR Y IN TRANSMSGS WITH Y.FAC_CODE = X.FAC_CODE
	    AND Y.NUMBER = X.NUMBER
	    AND Y.LOCALE = locale
	    AND Y.TEXT NOT MISSING
	    AND Y.TEXT != " "*/
	{
        if (!isc_0)
           isc_compile_request2 ((long*) 0L, &DB, &isc_0, (short) sizeof (isc_1), (char ISC_FAR *) isc_1);
	isc_2.isc_3 = isc_11.isc_15;
	isc_2.isc_4 = isc_11.isc_16;
	isc_vtov (locale, isc_2.isc_5, 21);
        isc_start_and_send ((long*) 0L, &isc_0, &gds__trans, (short) 0, (short) 25, &isc_2, (short) 0);
	while (1)
	   {
           isc_receive ((long*) 0L, &isc_0, (short) 1, (short) 121, &isc_6, (short) 0);
	   if (!isc_6.isc_7) break;;
	        strcpy (msg_text, /*Y.TEXT*/
				  isc_6.isc_8);
	        l = strlen (msg_text);
	        found_one++;
        /*END_FOR;*/
	   }
	}
	if (!found_one && sw_warning)
	    ib_printf ("build_file: Warning - no %s translation of msg# %d\n", locale, /*X.CODE*/
										       isc_11.isc_12);
        if (found_one > 1 && sw_warning)
	   ib_printf ("build_file: Warning - multiple %s translations of msg# %d\n", locale, /*X.CODE*/
											     isc_11.isc_12);
	if (found_one != 1)
	   warning_counter++;
        }

    if (leaf_node->msgrec_text + l >= end_leaf)
	{
	position = write_bucket (leaf, n);
	propogate (buckets, nodes, prior_code, position);
	leaf_node = leaf;
	}
    leaf_node->msgrec_code = prior_code = MSG_NUMBER (/*X.FAC_CODE*/
						      isc_11.isc_16, /*X.NUMBER*/
  isc_11.isc_15);

    leaf_node->msgrec_length = l;
    leaf_node->msgrec_flags = /*X.FLAGS*/
			      isc_11.isc_14;
    n = OFFSETA (MSGREC, msgrec_text) + l;
    p = leaf_node->msgrec_text;
    if (l)
	{
	q = msg_text;
	do *p++ = *q++; while (--l);
	}
    n = p - (SCHAR*) leaf;
    leaf_node = NEXT_LEAF (leaf_node);
/*END_FOR;*/
   }
}

/* Write a high water mark on leaf node */

if (leaf_node->msgrec_text + l >= end_leaf)
    {
    n = (SCHAR*) leaf_node - (SCHAR*) leaf;
    position = write_bucket (leaf, n);
    propogate (buckets, nodes, prior_code, position);
    leaf_node = leaf;
    }

leaf_node->msgrec_code = -1;
leaf_node->msgrec_length = 0;
leaf_node->msgrec_flags = 0;
n = (SCHAR*) leaf_node - (SCHAR*) leaf;
position = write_bucket (leaf, n);
    
/* Finish off upper levels of tree */

header.msghdr_levels = 1;

for (ptr = nodes, ptr2 = buckets; node = *ptr; ptr++, ptr2++)
    {
    node->msgnod_code = -1;
    node->msgnod_seek = position;
    n = (SCHAR*) (node + 1) - (SCHAR*) *ptr2;
    position = write_bucket (*ptr2, n);
    ++header.msghdr_levels;
    }

header.msghdr_top_tree = position;

/* Re-write header record and finish */

lseek (file, LSEEK_OFFSET_CAST 0, 0);
write (file, &header, sizeof (header));
close (file);
file = -1;

if (warning_counter)
    ib_printf ("build_file: %d messages lack translations in locale %s\n",
	     warning_counter, locale);
return FINI_OK;
}

static void propogate (
    MSGNOD	*buckets,
    MSGNOD	*nodes,
    ULONG	prior_code,
    ULONG	position)
{
/**************************************
 *
 *	p r o p o g a t e
 *
 **************************************
 *
 * Functional description
 *	Propogate a full bucket upward.
 *
 **************************************/
MSGNOD	node, end;

/* Make sure current level has been allocated */

if (!*nodes)
    {
    *nodes = *buckets = (MSGNOD) gds__alloc ((SLONG) MSG_BUCKET);
    nodes [1] = NULL;
    }

/* Insert into current bucket */

node = (*nodes)++;
node->msgnod_code = prior_code;
node->msgnod_seek = position;

/* Check for full bucket.  If not, we're done */

end = (MSGNOD) ((SCHAR*) *buckets + MSG_BUCKET);

if (*nodes < end)
    return;

/* Bucket is full -- write it out, propogate the split, and re-initialize */

position = write_bucket (*buckets, MSG_BUCKET);
propogate (buckets + 1, nodes + 1, prior_code, position);
*nodes = *buckets;
}

static SLONG write_bucket (
    MSGNOD	bucket,
    USHORT	length)
{
/**************************************
 *
 *	w r i t e _ b u c k e t
 *
 **************************************
 *
 * Functional description
 *	Write stuff, return position of stuff written.
 *
 **************************************/
SLONG	position;
int	n;
USHORT	padded_length;
SLONG	zero_bytes = 0;

padded_length = ROUNDUP (length, sizeof (SLONG));
position = file_position;
n = write (file, bucket, length);
if (n == -1)
    {
    ib_fprintf (ib_stderr, "IO error on write()\n" );
    exit (FINI_ERROR);
    }
n = write (file, &zero_bytes, padded_length-length);
if (n == -1)
    {
    ib_fprintf (ib_stderr, "IO error on write()\n" );
    exit (FINI_ERROR);
    }
file_position += padded_length;

return position;
}

static void sanitize (
    TEXT        *locale)
{
/**************************************
 *
 *	s a n i t i z e
 *
 **************************************
 *
 * Functional description
 *	Clean up a locale to make it acceptable for use in file names
 *      for Windows NT, PC, and mpexl: remove any '.' or '_' for mpexl,
 *	replace any period with '_' for NT or PC.
 *      Keep this in sync with gds.c
 *
 **************************************/
SSHORT ch;

while (*locale)
    {
    ch = *locale;
#ifdef mpexl
    if (ch == '.' || ch == '_')
	{
	strcpy (locale, locale + 1);
        locale++;
	}
#else
    if (ch == '.')
        *locale = '_';
#endif
    locale++;
    }
}

