/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/***************** gpre version FB-V6.2.908 Firebird 1.0 **********************/
/*
 *	PROGRAM:	JRD Access Method
 *	MODULE:		dfw.e
 *	DESCRIPTION:	Deferred Work handler
 *
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 * 2001.6.25 Claudio Valderrama: Implement deferred check for udf usage
 * inside a procedure before dropping the uff and creating stub for future
 * processing of dependencies from dropped generators.
 *
 * 2001.8.12 Claudio Valderrama: find_depend_in_dfw() and other functions
 *   should respect identifiers with embedded blanks instead of chopping them
 *.
 * 2001.10.01 Claudio Valderrama: check constraints should fire AFTER the
 *   BEFORE <action> triggers; otherwise they allow invalid data to be stored.
 *   This is a quick fix for SF Bug #444463 until a more robust one is devised
 *   using trigger's rdb$flags or another mechanism.
 *
 * 2001.10.10 Ann Harrison:  Don't increment the format version unless the
 *   table is actually reformatted.  At the same time, break out some of
 *   the parts of make_version making some new subroutines with the goal
 *   of making make_version readable.
 *
 * 2001.10.18 Ann Harrison: some cleanup of trigger & constraint handling.
 *   it now appears to work correctly on new Firebird databases with lots
 *   of system types and on InterBase databases, without checking for 
 *   missing source.
 */

#ifdef SHLIB_DEFS
#define LOCAL_SHLIB_DEFS
#endif

#include "../jrd/ib_stdio.h"
#include <string.h>
#include "../jrd/ibsetjmp.h"
#include "../jrd/common.h"
#include <stdarg.h>
#include "../jrd/gds.h"
#include "../jrd/jrd.h"
#include "../jrd/val.h"
#include "../jrd/irq.h"
#include "../jrd/tra.h"
#include "../jrd/pio.h"
#include "../jrd/ods.h"
#include "../jrd/btr.h"
#include "../jrd/req.h"
#include "../jrd/exe.h"
#include "../jrd/scl.h"
#include "../jrd/blb.h"
#include "../jrd/met.h"
#include "../jrd/lck.h"
#include "../jrd/sdw.h"
#include "../jrd/flags.h"
#include "../jrd/all.h"
#include "../jrd/intl.h"
#include "../intl/charsets.h"
#include "../jrd/align.h"
#include "../jrd/gdsassert.h"
#include "../jrd/constants.h"
#include "../jrd/all_proto.h"
#include "../jrd/blb_proto.h"
#include "../jrd/btr_proto.h"
#include "../jrd/cch_proto.h"
#include "../jrd/cmp_proto.h"
#include "../jrd/dfw_proto.h"
#include "../jrd/dpm_proto.h"
#include "../jrd/dsc_proto.h"
#include "../jrd/err_proto.h"
#include "../jrd/exe_proto.h"
#include "../jrd/ext_proto.h"
#include "../jrd/gds_proto.h"
#include "../jrd/grant_proto.h"
#include "../jrd/idx_proto.h"
#include "../jrd/intl_proto.h"
#include "../jrd/isc_f_proto.h"

#include "../jrd/lck_proto.h"
#include "../jrd/met_proto.h"
#include "../jrd/mov_proto.h"
#include "../jrd/pag_proto.h"
#include "../jrd/pcmet_proto.h"
#include "../jrd/pio_proto.h"
#include "../jrd/sch_proto.h"
#include "../jrd/scl_proto.h"
#include "../jrd/sdw_proto.h"
#include "../jrd/thd_proto.h"
#ifndef WINDOWS_ONLY
#include "../jrd/event_proto.h"
#endif

#ifdef	WINDOWS_ONLY
#include "../jrd/seg_proto.h"
#endif

/* Pick up system relation ids */

#define RELATION(name,id,ods)      id,
#define FIELD(symbol,name,id,update,ods,new_id,new_ods)
#define END_RELATION

typedef ENUM rids {
#include "../jrd/relations.h"
    rel_MAX
} RIDS;

#undef RELATION
#undef FIELD
#undef END_RELATION

/* Define range of user relation ids */

#define MIN_RELATION_ID		rel_MAX
#define MAX_RELATION_ID		32767

#define COMPUTED_FLAG	128
#define NULL_BLOB(id)	(!id.gds_quad_high && !id.gds_quad_low)
#define WAIT_PERIOD	-1

/*DATABASE
    DB = FILENAME "ODS.RDB";*/
static CONST UCHAR	jrd_0 [58] =
   {	/* blr string */

4,2,4,0,1,0,7,0,2,7,'C',1,'K',25,0,0,'D',21,8,0,1,0,0,0,255,14,
0,2,1,21,8,0,1,0,0,0,25,0,0,0,255,14,0,1,21,8,0,0,0,0,0,25,0,
0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_3 [229] =
   {	/* blr string */

4,2,4,1,4,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,4,0,1,0,41,3,0,32,
0,12,0,2,7,'C',1,'K',12,0,0,'G',58,47,24,0,1,0,25,0,0,0,57,56,
24,0,8,0,21,8,0,3,0,0,0,21,8,0,5,0,0,0,58,57,47,24,0,8,0,21,8,
0,0,0,0,0,61,24,0,8,0,60,'C',2,'K',24,0,1,'K',22,0,2,'G',58,47,
24,0,0,0,24,1,1,0,58,47,24,1,0,0,24,2,0,0,57,47,24,2,1,0,21,15,
3,0,5,0,'C','H','E','C','K',47,24,2,1,0,21,15,3,0,11,0,'F','O',
'R','E','I','G','N',32,'K','E','Y',255,'F',1,'H',24,0,2,0,255,
14,1,2,1,24,0,1,0,25,1,0,0,1,24,0,0,0,25,1,1,0,1,21,8,0,1,0,0,
0,25,1,2,0,1,24,0,7,0,25,1,3,0,255,14,1,1,21,8,0,0,0,0,0,25,1,
2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_11 [210] =
   {	/* blr string */

4,2,4,1,4,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,4,0,1,0,41,3,0,32,
0,12,0,2,7,'C',1,'K',12,0,0,'G',58,47,24,0,1,0,25,0,0,0,58,57,
47,24,0,8,0,21,8,0,0,0,0,0,61,24,0,8,0,59,60,'C',2,'K',24,0,1,
'K',22,0,2,'G',58,47,24,0,0,0,24,1,1,0,58,47,24,1,0,0,24,2,0,
0,57,47,24,2,1,0,21,15,3,0,5,0,'C','H','E','C','K',47,24,2,1,
0,21,15,3,0,11,0,'F','O','R','E','I','G','N',32,'K','E','Y',255,
'F',1,'H',24,0,2,0,255,14,1,2,1,24,0,1,0,25,1,0,0,1,24,0,0,0,
25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,1,24,0,7,0,25,1,3,0,255,14,
1,1,21,8,0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_19 [130] =
   {	/* blr string */

4,2,4,1,4,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,4,0,1,0,41,3,0,32,
0,12,0,2,7,'C',1,'K',12,0,0,'G',58,47,24,0,1,0,25,0,0,0,47,24,
0,8,0,21,8,0,1,0,0,0,'F',1,'H',24,0,2,0,255,14,1,2,1,24,0,1,0,
25,1,0,0,1,24,0,0,0,25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,1,24,0,
7,0,25,1,3,0,255,14,1,1,21,8,0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_27 [71] =
   {	/* blr string */

4,2,4,0,1,0,7,0,2,7,'C',1,'K',10,0,0,'D',21,8,0,1,0,0,0,'G',49,
24,0,5,0,21,8,0,0,0,0,0,255,14,0,2,1,21,8,0,1,0,0,0,25,0,0,0,
255,14,0,1,21,8,0,0,0,0,0,25,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_30 [108] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,1,0,7,0,4,1,1,0,7,0,4,0,1,0,7,0,12,0,2,7,
'C',1,'K',8,0,0,'G',58,47,24,0,0,0,25,0,0,0,47,24,0,1,0,21,8,
0,0,0,0,0,255,2,14,1,2,1,21,8,0,1,0,0,0,25,1,0,0,255,17,0,9,13,
12,3,18,0,12,2,5,0,255,255,14,1,1,21,8,0,0,0,0,0,25,1,0,0,255,
255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_39 [84] =
   {	/* blr string */

4,2,4,1,1,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',1,'K',12,0,0,
'G',58,47,24,0,1,0,25,0,0,0,47,24,0,3,0,21,8,0,1,0,0,0,255,14,
1,2,1,21,8,0,1,0,0,0,25,1,0,0,255,14,1,1,21,8,0,0,0,0,0,25,1,
0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_44 [484] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,6,0,7,0,7,0,7,0,7,0,7,0,7,0,4,1,34,0,41,3,
0,32,0,41,3,0,32,0,9,0,9,0,9,0,9,0,41,3,0,32,0,41,3,0,32,0,9,
0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,
7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,4,0,1,0,41,3,0,32,0,12,
0,2,7,'C',2,'K',5,0,0,'K',2,0,1,'G',58,47,24,0,1,0,25,0,0,0,47,
24,0,2,0,24,1,0,0,255,2,14,1,2,1,24,1,0,0,25,1,0,0,1,24,0,14,
0,41,1,1,0,24,0,1,24,1,2,0,25,1,2,0,1,24,1,6,0,25,1,3,0,1,24,
0,12,0,25,1,4,0,1,24,1,12,0,25,1,5,0,1,24,0,4,0,25,1,6,0,1,24,
0,0,0,25,1,7,0,1,24,1,4,0,25,1,8,0,1,21,8,0,1,0,0,0,25,1,9,0,
1,24,1,19,0,25,1,10,0,1,24,1,20,0,25,1,11,0,1,24,1,21,0,25,1,
12,0,1,24,1,22,0,25,1,13,0,1,24,1,11,0,25,1,14,0,1,24,1,8,0,25,
1,15,0,1,24,1,9,0,25,1,16,0,1,24,1,10,0,25,1,17,0,1,24,0,18,0,
41,1,19,0,18,0,1,24,1,25,0,41,1,21,0,20,0,1,24,1,26,0,41,1,23,
0,22,0,1,24,0,16,0,25,1,25,0,1,24,1,23,0,25,1,26,0,1,24,0,10,
0,25,1,27,0,1,24,0,6,0,41,1,29,0,28,0,1,24,0,8,0,41,1,31,0,30,
0,1,24,0,9,0,41,1,33,0,32,0,255,17,0,9,13,12,3,18,0,12,2,10,0,
2,2,1,41,2,5,0,4,0,24,2,6,0,1,41,2,3,0,2,0,24,2,8,0,1,41,2,1,
0,0,0,24,2,9,0,255,255,255,14,1,1,21,8,0,0,0,0,0,25,1,9,0,255,
255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_91 [223] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,4,0,9,0,7,0,7,0,7,0,4,1,8,0,9,0,41,0,0,0,
1,9,0,7,0,7,0,7,0,7,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',1,
'K',6,0,0,'G',47,24,0,8,0,25,0,0,0,255,2,14,1,2,1,24,0,11,0,25,
1,0,0,1,24,0,10,0,25,1,1,0,1,24,0,0,0,25,1,2,0,1,21,8,0,1,0,0,
0,25,1,3,0,1,24,0,5,0,25,1,4,0,1,24,0,7,0,25,1,5,0,1,24,0,6,0,
25,1,6,0,1,24,0,3,0,25,1,7,0,255,17,0,9,13,12,3,18,0,12,2,10,
0,1,2,1,25,2,3,0,24,1,5,0,1,25,2,2,0,24,1,7,0,1,25,2,0,0,24,1,
11,0,1,25,2,1,0,24,1,6,0,255,255,255,14,1,1,21,8,0,0,0,0,0,25,
1,3,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_110 [50] =
   {	/* blr string */

4,2,4,0,3,0,9,0,7,0,7,0,12,0,15,'K',8,0,0,2,1,25,0,0,0,24,0,2,
0,1,25,0,1,0,24,0,0,0,1,25,0,2,0,24,0,1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_115 [96] =
   {	/* blr string */

4,2,4,1,3,0,41,3,0,32,0,9,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,
'C',1,'K',12,0,0,'G',47,24,0,0,0,25,0,0,0,255,14,1,2,1,24,0,1,
0,25,1,0,0,1,24,0,5,0,25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,255,
14,1,1,21,8,0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_122 [82] =
   {	/* blr string */

4,2,4,1,2,0,9,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',1,'K',26,
0,0,'G',47,24,0,0,0,25,0,0,0,255,14,1,2,1,24,0,6,0,25,1,0,0,1,
21,8,0,1,0,0,0,25,1,1,0,255,14,1,1,21,8,0,0,0,0,0,25,1,1,0,255,
255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_128 [104] =
   {	/* blr string */

4,2,4,1,4,0,8,0,8,0,7,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',
1,'K',21,0,0,'G',47,24,0,0,0,25,0,0,0,255,14,1,2,1,24,0,3,0,25,
1,0,0,1,24,0,2,0,25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,1,24,0,1,
0,25,1,3,0,255,14,1,1,21,8,0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_136 [124] =
   {	/* blr string */

4,2,4,1,3,0,41,3,0,32,0,7,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,
'C',3,'K',2,0,0,'K',5,0,1,'K',6,0,2,'G',58,47,24,0,0,0,24,1,2,
0,58,47,24,0,0,0,25,0,0,0,47,24,2,8,0,24,1,1,0,255,14,1,2,1,24,
1,0,0,25,1,0,0,1,21,8,0,1,0,0,0,25,1,1,0,1,24,2,3,0,25,1,2,0,
255,14,1,1,21,8,0,0,0,0,0,25,1,1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_143 [82] =
   {	/* blr string */

4,2,4,1,1,0,7,0,4,0,1,0,7,0,12,0,2,7,'C',2,'K',6,0,0,'K',5,0,
1,'G',58,47,24,1,1,0,24,0,8,0,47,24,0,3,0,25,0,0,0,255,14,1,2,
1,21,8,0,1,0,0,0,25,1,0,0,255,14,1,1,21,8,0,0,0,0,0,25,1,0,0,
255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_148 [68] =
   {	/* blr string */

4,2,4,1,1,0,7,0,4,0,1,0,7,0,12,0,2,7,'C',1,'K',6,0,0,'G',47,24,
0,3,0,25,0,0,0,255,14,1,2,1,21,8,0,1,0,0,0,25,1,0,0,255,14,1,
1,21,8,0,0,0,0,0,25,1,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_153 [149] =
   {	/* blr string */

4,2,4,1,3,0,41,3,0,32,0,41,3,0,32,0,7,0,4,0,2,0,41,3,0,32,0,7,
0,12,0,2,7,'C',3,'K',6,0,0,'K',7,0,1,'K',5,0,2,'G',58,47,24,1,
1,0,24,0,8,0,58,47,24,0,3,0,25,0,1,0,58,47,24,2,10,0,24,1,2,0,
58,47,24,2,1,0,24,1,0,0,47,24,2,4,0,25,0,0,0,255,14,1,2,1,24,
2,4,0,25,1,0,0,1,24,1,0,0,25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,
255,14,1,1,21,8,0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_161 [95] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,1,0,7,0,4,1,1,0,7,0,4,0,1,0,7,0,12,0,2,7,
'C',1,'K',8,0,0,'G',47,24,0,0,0,25,0,0,0,255,2,14,1,2,1,21,8,
0,1,0,0,0,25,1,0,0,255,17,0,9,13,12,3,18,0,12,2,5,0,255,255,14,
1,1,21,8,0,0,0,0,0,25,1,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_170 [85] =
   {	/* blr string */

4,2,4,1,2,0,41,3,0,32,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',
1,'K',7,0,0,'G',47,24,0,1,0,25,0,0,0,255,14,1,2,1,24,0,0,0,25,
1,0,0,1,21,8,0,1,0,0,0,25,1,1,0,255,14,1,1,21,8,0,0,0,0,0,25,
1,1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_176 [78] =
   {	/* blr string */

4,2,4,1,1,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',1,'K',2,0,0,
'G',58,47,24,0,0,0,25,0,0,0,59,61,24,0,4,0,255,14,1,2,1,21,8,
0,1,0,0,0,25,1,0,0,255,14,1,1,21,8,0,0,0,0,0,25,1,0,0,255,255,
76
   };	/* end of blr string */
static CONST UCHAR	jrd_181 [110] =
   {	/* blr string */

4,2,4,1,3,0,41,3,0,32,0,7,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,
'C',2,'K',5,0,0,'K',6,0,1,'G',58,47,24,1,8,0,24,0,1,0,47,24,0,
2,0,25,0,0,0,255,14,1,2,1,24,0,0,0,25,1,0,0,1,21,8,0,1,0,0,0,
25,1,1,0,1,24,1,3,0,25,1,2,0,255,14,1,1,21,8,0,0,0,0,0,25,1,1,
0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_188 [96] =
   {	/* blr string */

4,2,4,1,2,0,7,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',2,'K',7,
0,0,'K',6,0,1,'G',58,47,24,1,8,0,24,0,1,0,47,24,0,0,0,25,0,0,
0,255,14,1,2,1,21,8,0,1,0,0,0,25,1,0,0,1,24,1,5,0,25,1,1,0,255,
14,1,1,21,8,0,0,0,0,0,25,1,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_194 [205] =
   {	/* blr string */

4,2,4,4,1,0,7,0,4,3,1,0,7,0,4,2,2,0,7,0,7,0,4,1,6,0,41,0,0,0,
1,9,0,7,0,7,0,7,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',2,'K',
1,0,0,'K',6,0,1,'G',47,24,1,8,0,25,0,0,0,255,2,14,1,2,1,24,1,
10,0,25,1,0,0,1,24,1,0,0,25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,1,
24,1,5,0,25,1,3,0,1,24,1,3,0,25,1,4,0,1,24,0,1,0,25,1,5,0,255,
17,0,9,13,12,3,18,0,12,4,10,0,2,2,1,25,4,0,0,24,2,1,0,255,12,
2,10,1,3,2,1,25,2,1,0,24,3,5,0,1,25,2,0,0,24,3,3,0,255,255,255,
14,1,1,21,8,0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_211 [106] =
   {	/* blr string */

4,2,4,2,1,0,7,0,4,1,1,0,41,0,0,0,1,4,0,2,0,41,0,0,0,1,7,0,2,7,
'C',1,'K',25,0,0,255,2,14,0,2,1,24,0,0,0,25,0,0,0,1,21,8,0,1,
0,0,0,25,0,1,0,255,17,0,9,13,12,2,18,0,12,1,10,0,1,2,1,25,1,0,
0,24,1,0,0,255,255,255,14,0,1,21,8,0,0,0,0,0,25,0,1,0,255,255,
76
   };	/* end of blr string */
static CONST UCHAR	jrd_219 [431] =
   {	/* blr string */

4,2,4,4,2,0,27,7,0,4,3,1,0,7,0,4,2,2,0,7,0,7,0,4,1,24,0,41,3,
0,32,0,41,3,0,32,0,41,3,0,32,0,27,7,0,7,0,7,0,7,0,7,0,7,0,7,0,
7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,4,0,1,0,41,
3,0,32,0,12,0,2,7,'C',5,'K',4,0,0,'K',3,0,1,'K',5,0,2,'K',2,0,
3,'K',6,0,4,'G',58,58,58,47,24,1,0,0,24,0,0,0,58,47,24,2,0,0,
24,1,1,0,47,24,2,1,0,24,0,1,0,47,24,4,8,0,24,2,1,0,58,47,24,3,
0,0,24,2,2,0,47,24,0,0,0,25,0,0,0,255,2,14,1,2,1,24,2,0,0,25,
1,0,0,1,24,0,0,0,25,1,1,0,1,24,0,8,0,41,1,2,0,16,0,1,24,0,12,
0,25,1,3,0,1,21,8,0,1,0,0,0,25,1,4,0,1,24,3,25,0,41,1,6,0,5,0,
1,24,2,18,0,41,1,8,0,7,0,1,24,3,26,0,41,1,10,0,9,0,1,24,2,9,0,
25,1,11,0,1,24,3,22,0,41,1,13,0,12,0,1,24,3,10,0,25,1,14,0,1,
24,1,2,0,25,1,15,0,1,24,0,7,0,25,1,17,0,1,24,0,3,0,25,1,18,0,
1,24,0,5,0,25,1,19,0,1,24,0,6,0,25,1,20,0,1,24,0,2,0,41,1,22,
0,21,0,1,24,4,3,0,25,1,23,0,255,17,0,9,13,12,3,18,0,12,2,10,0,
6,2,1,41,2,1,0,0,0,24,6,2,0,255,12,4,10,0,5,2,1,25,4,0,0,24,5,
12,0,1,25,4,1,0,24,5,2,0,255,255,255,14,1,1,21,8,0,0,0,0,0,25,
1,4,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_255 [172] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,2,0,7,0,7,0,4,1,6,0,41,3,0,32,0,9,0,7,0,7,
0,7,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',2,'K',4,0,0,'K',6,
0,1,'G',58,47,24,1,8,0,24,0,1,0,47,24,0,0,0,25,0,0,0,255,2,14,
1,2,1,24,0,1,0,25,1,0,0,1,24,1,0,0,41,1,1,0,5,0,1,21,8,0,1,0,
0,0,25,1,2,0,1,24,0,2,0,41,1,4,0,3,0,255,17,0,9,13,12,3,18,0,
12,2,10,0,2,2,1,41,2,1,0,0,0,24,2,2,0,255,255,255,14,1,1,21,8,
0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_270 [71] =
   {	/* blr string */

4,2,4,1,1,0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',1,'K',1,0,0,
'G',47,24,0,2,0,25,0,0,0,255,14,1,2,1,21,8,0,1,0,0,0,25,1,0,0,
255,14,1,1,21,8,0,0,0,0,0,25,1,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_275 [114] =
   {	/* blr string */

4,2,4,1,3,0,41,3,0,32,0,7,0,7,0,4,0,2,0,41,3,0,32,0,7,0,12,0,
2,7,'C',1,'K',13,0,0,'G',58,47,24,0,1,0,25,0,0,0,47,24,0,4,0,
25,0,1,0,'E',1,24,0,0,0,255,14,1,2,1,24,0,0,0,25,1,0,0,1,21,8,
0,1,0,0,0,25,1,1,0,1,24,0,3,0,25,1,2,0,255,14,1,1,21,8,0,0,0,
0,0,25,1,1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_283 [129] =
   {	/* blr string */

4,2,4,1,3,0,41,3,0,32,0,7,0,7,0,4,0,3,0,41,3,0,32,0,41,3,0,32,
0,7,0,12,0,2,7,'C',1,'K',13,0,0,'G',58,47,24,0,1,0,25,0,1,0,58,
47,24,0,4,0,25,0,2,0,47,24,0,2,0,25,0,0,0,'E',1,24,0,0,0,255,
14,1,2,1,24,0,0,0,25,1,0,0,1,21,8,0,1,0,0,0,25,1,1,0,1,24,0,3,
0,25,1,2,0,255,14,1,1,21,8,0,0,0,0,0,25,1,1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_292 [211] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,3,0,8,0,7,0,7,0,4,1,6,0,41,0,0,0,1,8,0,7,
0,7,0,7,0,7,0,4,0,1,0,41,0,0,0,1,12,0,2,7,'C',2,'K',10,0,0,'K',
10,0,1,'G',58,47,24,1,5,0,24,0,5,0,47,24,0,0,0,25,0,0,0,'F',1,
'H',24,1,2,0,255,2,14,1,2,1,24,1,0,0,25,1,0,0,1,24,1,2,0,25,1,
1,0,1,21,8,0,1,0,0,0,25,1,2,0,1,24,1,1,0,25,1,3,0,1,24,1,4,0,
25,1,4,0,1,24,1,5,0,25,1,5,0,255,17,0,9,13,12,3,18,0,12,2,10,
1,2,2,1,25,2,2,0,24,2,1,0,1,25,2,0,0,24,2,2,0,1,25,2,1,0,24,2,
4,0,255,255,255,14,1,1,21,8,0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_308 [149] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,1,0,41,0,0,0,1,4,1,4,0,41,0,0,0,1,7,0,7,0,
7,0,4,0,1,0,41,0,0,0,1,12,0,2,7,'C',1,'K',10,0,0,'G',47,24,0,
0,0,25,0,0,0,255,2,14,1,2,1,24,0,0,0,25,1,0,0,1,21,8,0,1,0,0,
0,25,1,1,0,1,24,0,4,0,25,1,2,0,1,24,0,5,0,25,1,3,0,255,17,0,9,
13,12,3,18,0,12,2,10,0,1,2,1,25,2,0,0,24,1,0,0,255,255,255,14,
1,1,21,8,0,0,0,0,0,25,1,1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_320 [152] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,2,0,8,0,8,0,4,1,3,0,8,0,8,0,7,0,4,0,2,0,7,
0,7,0,12,0,2,7,'C',1,'K',10,0,0,'G',58,47,24,0,1,0,25,0,1,0,47,
24,0,5,0,25,0,0,0,255,2,14,1,2,1,24,0,2,0,25,1,0,0,1,24,0,3,0,
25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,255,17,0,9,13,12,3,18,0,12,
2,10,0,1,2,1,25,2,1,0,24,1,2,0,1,25,2,0,0,24,1,3,0,255,255,255,
14,1,1,21,8,0,0,0,0,0,25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_333 [112] =
   {	/* blr string */

4,2,4,1,3,0,8,0,8,0,7,0,4,0,1,0,7,0,12,0,2,7,'C',1,'K',10,0,0,
'D',21,8,0,1,0,0,0,'G',58,47,24,0,5,0,25,0,0,0,59,61,24,0,1,0,
'F',1,'I',24,0,1,0,255,14,1,2,1,24,0,3,0,25,1,0,0,1,24,0,2,0,
25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,255,14,1,1,21,8,0,0,0,0,0,
25,1,2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_340 [193] =
   {	/* blr string */

4,2,4,4,1,0,41,0,0,0,1,4,3,1,0,7,0,4,2,2,0,8,0,7,0,4,1,5,0,41,
0,0,0,1,8,0,7,0,7,0,7,0,4,0,1,0,41,0,0,0,1,12,0,2,7,'C',1,'K',
10,0,0,'G',47,24,0,0,0,25,0,0,0,255,2,14,1,2,1,24,0,0,0,25,1,
0,0,1,24,0,2,0,25,1,1,0,1,21,8,0,1,0,0,0,25,1,2,0,1,24,0,1,0,
25,1,3,0,1,24,0,5,0,25,1,4,0,255,17,0,9,13,12,3,18,0,12,2,10,
0,2,2,1,25,2,1,0,24,2,1,0,1,25,2,0,0,24,2,2,0,255,12,4,10,0,1,
2,1,25,4,0,0,24,1,0,0,255,255,255,14,1,1,21,8,0,0,0,0,0,25,1,
2,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_356 [141] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,2,0,27,7,0,4,1,3,0,27,7,0,7,0,4,0,1,0,41,
3,0,32,0,12,0,2,7,'C',1,'K',4,0,0,'G',47,24,0,0,0,25,0,0,0,255,
2,14,1,2,1,24,0,12,0,25,1,0,0,1,21,8,0,1,0,0,0,25,1,1,0,1,24,
0,2,0,25,1,2,0,255,17,0,9,13,12,3,18,0,12,2,10,0,1,2,1,25,2,0,
0,24,1,12,0,1,25,2,1,0,24,1,2,0,255,255,255,14,1,1,21,8,0,0,0,
0,0,25,1,1,0,255,255,76
   };	/* end of blr string */
 

/*==================================================================
**
** NOTE:
**
**	The following functions required the same number of
**	parameters to be passed.
**
**==================================================================
*/
static BOOLEAN	add_file		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	add_shadow		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_shadow		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	compute_security	(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	create_index		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_index		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	create_log		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_log		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	create_procedure	(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_procedure	(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	modify_procedure	(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	create_relation		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_relation		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	scan_relation		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	create_trigger		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_trigger		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	modify_trigger		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_exception	(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_generator	(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_udf		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_field		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_global		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_parameter	(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	delete_rfr		(TDBB, SSHORT, DFW, TRA);
static BOOLEAN	make_version		(TDBB, SSHORT, DFW, TRA);

/* ---------------------------------------------------------------- */

static void	check_dependencies	(TDBB, TEXT *, TEXT *,
						USHORT, TRA);
static void	check_filename		(TEXT *, USHORT);
static BOOLEAN	compare_formats		(FMT, FMT);
static BOOLEAN	find_depend_in_dfw	(TDBB, TEXT *, USHORT,
						USHORT, TRA);
static void	get_array_desc		(TDBB, TEXT *, ADS);
static void	get_procedure_dependencies (DFW);
static void	get_trigger_dependencies (DFW);
static void	load_trigs		(TDBB, REL, VEC *);
static FMT	make_format		(TDBB, REL, USHORT *, TFB);
static USHORT	name_length		(TEXT *);
static void	put_summary_blob	(BLB, enum rsr_t, SLONG [2]);
static void	put_summary_record	(BLB, enum rsr_t, UCHAR *, USHORT);
static void	setup_array		(TDBB, BLB, UCHAR *, USHORT, TFB);
static BLB	setup_triggers		(TDBB, REL, BOOLEAN, VEC *, BLB);
static void	setup_trigger_details	(TDBB, REL, BLB, VEC *, UCHAR *, UCHAR *, BOOLEAN);
static BOOLEAN	shadow_defined		(TDBB);
static BOOLEAN	validate_text_type	(TDBB, STATUS *, TFB);
static BOOLEAN	wal_defined		(TDBB);

static CONST UCHAR nonnull_validation_blr [] =
   {
   blr_version5,
   blr_not,
      blr_missing,
         blr_fid, 0, 0,0,
   blr_eoc
   };

typedef struct task {
    ENUM dfw_t	task_type;
    BOOLEAN	(*task_routine) (TDBB, SSHORT, DFW, TRA);
} TASK;

static CONST TASK task_table [] =
    {
    dfw_add_file, add_file,
    dfw_add_shadow, add_shadow,
    dfw_delete_index, delete_index,
    dfw_delete_rfr, delete_rfr,
    dfw_delete_relation, delete_relation,
    dfw_delete_shadow, delete_shadow,
    dfw_delete_field, delete_field,
    dfw_delete_global, delete_global,
    dfw_create_relation, create_relation,
    dfw_update_format, make_version,
    dfw_scan_relation, scan_relation,
    dfw_compute_security, compute_security,
    dfw_create_index, create_index,
#ifdef EXPRESSION_INDICES
    dfw_create_expression_index, PCMET_expression_index,
#endif
    dfw_delete_expression_index, delete_index,
    dfw_grant, GRANT_privileges,
    dfw_create_trigger, create_trigger,
    dfw_delete_trigger, delete_trigger,
    dfw_modify_trigger, modify_trigger,
    dfw_create_log, create_log,
    dfw_delete_log, delete_log,
    dfw_create_procedure, create_procedure,
    dfw_delete_procedure, delete_procedure,
    dfw_modify_procedure, modify_procedure,
    dfw_delete_prm, delete_parameter,
    dfw_delete_exception, delete_exception,
    dfw_delete_generator, delete_generator,
    dfw_delete_udf, delete_udf,
    dfw_null, NULL
    };

#ifdef SHLIB_DEFS
#define strcpy		(*_libgds_strcpy)
#define strlen		(*_libgds_strlen)
#define strcmp		(*_libgds_strcmp)
#define SETJMP		(*_libgds_setjmp)
#define memcmp		(*_libgds_memcmp)
#define strncmp		(*_libgds_strncmp)
#define unlink		(*_libgds_unlink)
#define _iob		(*_libgds__iob)
#define ib_fprintf		(*_libgds_fprintf)

extern int		strlen();
extern int		strcmp();
extern int		SETJMP();
extern int		memcmp();
extern int		strncmp();
extern SCHAR		*strcpy();
extern int		unlink();
extern IB_FILE		_iob [];
extern int		ib_fprintf();
#endif

USHORT DFW_assign_index_type (
    DFW		work,
    SSHORT	field_type,
    SSHORT	ttype)
{
/**************************************
 *
 *	D F W _ a s s i g n _ i n d e x _ t y p e
 *
 **************************************
 *
 * Functional description
 *	Define the index segment type based
 * 	on the field's type and subtype.
 *
 **************************************/
TDBB	tdbb;

tdbb = GET_THREAD_DATA;

if (field_type == dtype_varying || field_type == dtype_text)
    {
    STATUS	status [20];

    if (ttype == ttype_none)
	return idx_string;

    if (ttype == ttype_binary)
	return idx_byte_array;

    if (ttype == ttype_metadata)
	return idx_metadata;

    if (ttype == ttype_ascii)
	return idx_string;

    /* Dynamic text cannot occur here as this is for an on-disk
       index, which must be bound to a text type. */

    assert (ttype != ttype_dynamic);

    if (INTL_defined_type (tdbb, status, ttype))
	return INTL_TEXT_TO_INDEX (ttype);

    ERR_post (gds__no_meta_update, 
	gds_arg_gds, gds__random, gds_arg_string, ERR_cstring (work->dfw_name), 
	status [0], status [1], status [2], status [3],
	0);
    }  

if (field_type == dtype_timestamp)
    return idx_timestamp2;
else if (field_type == dtype_sql_date)
    return idx_sql_date;
else if (field_type == dtype_sql_time)
    return idx_sql_time;


/* idx_numeric2 used for 64-bit Integer support */
if (field_type == dtype_int64)
    return idx_numeric2;


return idx_numeric;
}

void DFW_delete_deferred (
    TRA		transaction,
    SLONG	sav_number)
{
/**************************************
 *
 *	D F W _ d e l e t e _ d e f e r r e d
 *
 **************************************
 *
 * Functional description
 *	Get rid of work deferred that was to be done at 
 *	COMMIT time as the statement has been rolled back.
 *
 *	if (sav_number == -1), then  remove all entries.
 *
 **************************************/
DFW	work, *ptr;
USHORT	deferred_meta;

/* If there is no deferred work, just return */

if (!transaction->tra_deferred_work)
    return;

/* Remove deferred work and events which are to be rolled back */

deferred_meta = 0;

for (ptr = &transaction->tra_deferred_work; work = *ptr;)
    if ((work->dfw_sav_number == sav_number) || (sav_number == -1))
	{
	*ptr = work->dfw_next;
	ALL_release ((FRB) work);
	}
    else
	{
	ptr = &(*ptr)->dfw_next;
        if (work->dfw_type != dfw_post_event)
	    deferred_meta = 1;
	}

if (!deferred_meta)
    transaction->tra_flags &= ~TRA_deferred_meta;
}

void DFW_merge_work (
    TRA		transaction,
    SLONG	old_sav_number,
    SLONG	new_sav_number)
{
/**************************************
 *
 *	D F W _ m e r g e _ w o r k
 *
 **************************************
 *
 * Functional description
 *	Merge the deferred work with the previous level.  This will
 *	be called only if there is a previous level.
 *
 **************************************/
DFW	work, *ptr;
DFW	work_m, *ptr_m;

/* If there is no deferred work, just return */

if (!transaction->tra_deferred_work)
    return;

/* Decrement the save point number in the deferred block
 * i.e. merge with the previous level.
 */

for (ptr = &transaction->tra_deferred_work; work = *ptr;)
    {
    if (work->dfw_sav_number == old_sav_number)
	{
	work->dfw_sav_number = new_sav_number;

	/* merge this entry with other identical entries at
	 * same save point level. Start from the beginning and
	 * stop with the that is being merged.
	 */
	
	for (ptr_m = &transaction->tra_deferred_work; ((work_m = *ptr_m) && 
	    (work_m != work)); ptr_m = &(*ptr_m)->dfw_next)
	    {
	    if (work_m->dfw_type 	== work->dfw_type &&
		work_m->dfw_id 		== work->dfw_id &&
		work_m->dfw_name_length == work->dfw_name_length &&
		work_m->dfw_sav_number 	== work->dfw_sav_number)
		{
		if ((work->dfw_name_length) && 
		    (memcmp (work->dfw_name, work_m->dfw_name, work->dfw_name_length)))
		    continue;

		/* Yes!  There is a duplicate entry.  Take out the
		 * entry for which the save point was decremented
		 */

		*ptr = work->dfw_next;

		if (work_m->dfw_name_length)
		    work_m->dfw_count += work->dfw_count;

		ALL_release ((FRB) work);
		work = (DFW) 0;
		break;
		}
	    }
	}

    if (work)
	ptr = &(*ptr)->dfw_next;
    }
}

void DFW_perform_system_work (void)
{
/**************************************
 *
 *	D F W _ p e r f o r m _ s y s t e m _ w o r k
 *
 **************************************
 *
 * Functional description
 *	Flush out the work left to be done in the
 *	system transaction.
 *
 **************************************/
DBB	dbb;

dbb = GET_DBB;

DFW_perform_work (dbb->dbb_sys_trans);
}

void DFW_perform_work (
    TRA	transaction)
{
/**************************************
 *
 *	D F W _ p e r f o r m _ w o r k
 *
 **************************************
 *
 * Functional description
 *	Do work deferred to COMMIT time 'cause that time has
 *	come.
 *
 **************************************/
TDBB	tdbb;
TASK	*task;
DFW	work, *ptr;
BOOLEAN	dump_shadow, more;
SSHORT	phase;
JMP_BUF	env, *old_env;

tdbb = GET_THREAD_DATA;

/* If no deferred work or it's all deferred event posting
   don't bother */

if (!transaction->tra_deferred_work ||
    !(transaction->tra_flags & TRA_deferred_meta))
    return;

tdbb->tdbb_default = transaction->tra_pool;
dump_shadow = FALSE;

/* Loop for as long as any of the deferred work routines says that it has
   more to do.  A deferred work routine should be able to deal with any
   value of phase, either to say that it wants to be called again in the
   next phase (by returning TRUE) or that it has nothing more to do in this
   or later phases (by returning FALSE). By convention, phase 0 has been
   designated as the cleanup phase. If any non-zero phase punts, then phase 0
   is executed for all deferred work blocks to cleanup work-in-progress. */

phase = 1;

old_env = (JMP_BUF*) tdbb->tdbb_setjmp;
tdbb->tdbb_setjmp = (UCHAR*) env;

if (SETJMP (env))
    {
    /* Do any necessary cleanup */

    tdbb->tdbb_setjmp = (UCHAR*) old_env;
    phase = 0;
    }

do {
    more = FALSE;
    for (task = (char *) task_table; task->task_type != dfw_null; task++)
	for (work = transaction->tra_deferred_work; work; work = work->dfw_next)
	    if (work->dfw_type == task->task_type)
		{
		if (work->dfw_type == dfw_add_shadow)
	 	    dump_shadow = TRUE;
		if ((*task->task_routine) (tdbb, phase, work, transaction))
		    more = TRUE;
		}
    if (!phase)
	ERR_punt();
    phase++;
} while (more);

tdbb->tdbb_setjmp = (UCHAR*) old_env;

/* Remove deferred work blocks so that system transaction and
   commit retaining transactions don't re-execute them. Leave
   events to be posted after commit */

for (ptr = &transaction->tra_deferred_work; work = *ptr;)
    if ((work->dfw_type == dfw_post_event) ||
	(work->dfw_type == dfw_delete_shadow))
	ptr = &(*ptr)->dfw_next;
    else
	{
	*ptr = work->dfw_next;
	ALL_release ((FRB) work);
	}

transaction->tra_flags &= ~TRA_deferred_meta;

if (dump_shadow)
    SDW_dump_pages();
}

void DFW_perform_post_commit_work (
    TRA		transaction)
{
/**************************************
 *
 *	D F W _ p e r f o r m _ p o s t _ c o m m i t _ w o r k
 *
 **************************************
 *
 * Functional description
 *	Perform any post commit work
 *	1. Post any pending events.
 *	2. Unlink shadow files for dropped shadows
 *
 *	Then, delete it from chain of pending work.
 *
 **************************************/
#ifndef WINDOWS_ONLY
DBB	dbb;
LCK	lock;
#endif
STATUS	status [20];
DFW	work, *ptr;

if (!transaction->tra_deferred_work)
    return;

#ifndef WINDOWS_ONLY
dbb = GET_DBB;
lock = dbb->dbb_lock;
#endif

for (ptr = &transaction->tra_deferred_work; work = *ptr;)
    if (work->dfw_type == dfw_post_event)
	{
#ifndef WINDOWS_ONLY /* Events are not supported under LIBS */
	EVENT_post (status, 
		lock->lck_length,
		(TEXT*) &lock->lck_key,
		work->dfw_name_length,
		work->dfw_name,
		work->dfw_count);
#endif
	*ptr = work->dfw_next;
	ALL_release ((FRB) work);
	}
    else if (work->dfw_type == dfw_delete_shadow)
	{
	unlink (work->dfw_name);
	*ptr = work->dfw_next;
	ALL_release ((FRB) work);
	}
    else
	ptr = &(*ptr)->dfw_next;
}

void DFW_post_work (
    TRA		transaction,
    ENUM dfw_t	type,
    DSC		*desc,
    USHORT	id)
{
/**************************************
 *
 *	D F W _ p o s t _ w o r k
 *
 **************************************
 *
 * Functional description
 *	Post a piece of work to be deferred to commit time.
 *	If we already know about it, so much the better.
 *
 **************************************/
DFW		work, *ptr;
UCHAR		*p, *q, *string;
USHORT		length;
TEXT		temp [256];	/* Must hold largest metadata field */
SLONG		sav_number;

if (!desc)
    {
    string = NULL;
    length = 0;
    }
else
    {
    /* Find the actual length of the string, searching until the claimed
       end of the string, or the terminating \0, whichever comes first. */

    length = MOV_make_string (desc, ttype_metadata, &string, temp, sizeof (temp));
    for (p = string, q = string + length; p < q && *p; p++)
	;

    /* Trim trailing blanks (bug 3355) */

    while (--p >= string && *p == ' ')
	;
    length = (p + 1) - string;
    }

/* get the current save point number */

sav_number = transaction->tra_save_point ? 
	transaction->tra_save_point->sav_number : 0;

/* Check to see if work is already posted */

for (ptr = &transaction->tra_deferred_work; work = *ptr;
     ptr = &(*ptr)->dfw_next)
    if (work->dfw_type == type &&
	work->dfw_id == id &&
	work->dfw_name_length == length &&
	work->dfw_sav_number == sav_number)
	{
	if (!length)
	    return;
	if (!memcmp (string, work->dfw_name, length))
	    {
	    ++work->dfw_count;
	    return;
	    }
	}

/* Not already posted, so do so now. */

*ptr = work = (DFW) ALLOCTV (type_dfw, length);
work->dfw_type = type;
work->dfw_id = id;
work->dfw_count = 1;
work->dfw_name_length = length;
work->dfw_sav_number = sav_number;
if (length)
    MOVE_FAST (string, work->dfw_name, length);

if (type != dfw_post_event)
    transaction->tra_flags |= TRA_deferred_meta;
else if (transaction->tra_save_point)
    transaction->tra_save_point->sav_flags |= SAV_event_post;
}

void DFW_update_index (
    DFW		work,
    USHORT	id,
    float	selectivity)
{
   struct {
          SSHORT jrd_367;	/* gds__utility */
   } jrd_366;
   struct {
          double  jrd_364;	/* RDB$STATISTICS */
          SSHORT jrd_365;	/* RDB$INDEX_ID */
   } jrd_363;
   struct {
          double  jrd_360;	/* RDB$STATISTICS */
          SSHORT jrd_361;	/* gds__utility */
          SSHORT jrd_362;	/* RDB$INDEX_ID */
   } jrd_359;
   struct {
          TEXT  jrd_358 [32];	/* RDB$INDEX_NAME */
   } jrd_357;
/**************************************
 *
 *	D F W _ u p d a t e _ i n d e x
 *
 **************************************
 *
 * Functional description
 *	Update information in the index relation after creation
 *	of the index.
 *
 **************************************/
TDBB	tdbb;
DBB	dbb;
REQ	request;

tdbb = GET_THREAD_DATA;
dbb  = tdbb->tdbb_database;

request = (REQ) CMP_find_request (tdbb, irq_m_index, IRQ_REQUESTS);

/*FOR (REQUEST_HANDLE request)
    IDX IN RDB$INDICES WITH IDX.RDB$INDEX_NAME EQ work->dfw_name*/
{
if (!request)
   request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_356, TRUE);
gds__vtov (work->dfw_name, jrd_357.jrd_358, 32);
EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)request, 0, 32, (UCHAR*)&jrd_357);
while (1)
   {
   EXE_receive (tdbb, (REQ)request, 1, 12, (UCHAR*)&jrd_359);
   if (!jrd_359.jrd_361) break;
    if (!REQUEST (irq_m_index))
	REQUEST (irq_m_index) = request;
    /*MODIFY IDX USING*/
    {
    
	/*IDX.RDB$INDEX_ID*/
	jrd_359.jrd_362 = id + 1;
	/*IDX.RDB$STATISTICS*/
	jrd_359.jrd_360 = selectivity;
    /*END_MODIFY*/
    jrd_363.jrd_364 = jrd_359.jrd_360;
    jrd_363.jrd_365 = jrd_359.jrd_362;
    EXE_send (tdbb, (REQ)request, 2, 10, (UCHAR*)&jrd_363);
    };
/*END_FOR*/
   EXE_send (tdbb, (REQ)request, 3, 2, (UCHAR*)&jrd_366);
   }
};

if (!REQUEST (irq_m_index))
    REQUEST (irq_m_index) = (BLK) request;
}

static BOOLEAN add_file (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_332;	/* gds__utility */
   } jrd_331;
   struct {
          SLONG  jrd_329;	/* RDB$FILE_LENGTH */
          SLONG  jrd_330;	/* RDB$FILE_START */
   } jrd_328;
   struct {
          SLONG  jrd_325;	/* RDB$FILE_START */
          SLONG  jrd_326;	/* RDB$FILE_LENGTH */
          SSHORT jrd_327;	/* gds__utility */
   } jrd_324;
   struct {
          SSHORT jrd_322;	/* RDB$SHADOW_NUMBER */
          SSHORT jrd_323;	/* RDB$FILE_SEQUENCE */
   } jrd_321;
   struct {
          SLONG  jrd_337;	/* RDB$FILE_LENGTH */
          SLONG  jrd_338;	/* RDB$FILE_START */
          SSHORT jrd_339;	/* gds__utility */
   } jrd_336;
   struct {
          SSHORT jrd_335;	/* RDB$SHADOW_NUMBER */
   } jrd_334;
   struct {
          TEXT  jrd_355 [256];	/* RDB$FILE_NAME */
   } jrd_354;
   struct {
          SSHORT jrd_353;	/* gds__utility */
   } jrd_352;
   struct {
          SLONG  jrd_350;	/* RDB$FILE_START */
          SSHORT jrd_351;	/* RDB$FILE_SEQUENCE */
   } jrd_349;
   struct {
          TEXT  jrd_344 [256];	/* RDB$FILE_NAME */
          SLONG  jrd_345;	/* RDB$FILE_START */
          SSHORT jrd_346;	/* gds__utility */
          SSHORT jrd_347;	/* RDB$FILE_SEQUENCE */
          SSHORT jrd_348;	/* RDB$SHADOW_NUMBER */
   } jrd_343;
   struct {
          TEXT  jrd_342 [256];	/* RDB$FILE_NAME */
   } jrd_341;
/**************************************
 *
 *	a d d _ f i l e
 *
 **************************************
 *
 * Functional description
 *	Add a file to a database.
 *	This file could be a regular database
 *	file or a shadow file.  Either way we
 *	require exclusive access to the database.
 *
 **************************************/
DBB	dbb;
USHORT	section, shadow_number;
SLONG	start, max;
BLK	handle, handle2;
TEXT	temp [MAX_PATH_LENGTH];

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

switch (phase)
    {
    case 0:
	CCH_release_exclusive (tdbb);
	return FALSE;

    case 1:
    case 2:
	return TRUE;

    case 3:
        if (CCH_exclusive (tdbb, LCK_EX, WAIT_PERIOD))
            return TRUE;
        else
            {
            ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__lock_timeout,
                gds_arg_gds, gds__obj_in_use,
                gds_arg_string, ERR_cstring (dbb->dbb_file->fil_string),
                0);
            return FALSE;
            }
    case 4:
	CCH_flush (tdbb, (USHORT) FLUSH_FINI, 0L);
	max = PIO_max_alloc (dbb) + 1;
	handle = handle2 = NULL;

	/* Check the file name for node name.  This has already been done for 
	** shadows in add_shadow () */

	if (work->dfw_type != dfw_add_shadow)
	    check_filename (work->dfw_name, work->dfw_name_length);

	/* get any files to extend into */

	/*FOR (REQUEST_HANDLE handle) X IN RDB$FILES 
	      WITH X.RDB$FILE_NAME EQ work->dfw_name*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_340, TRUE);
	gds__vtov (work->dfw_name, jrd_341.jrd_342, 256);
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 256, (UCHAR*)&jrd_341);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 266, (UCHAR*)&jrd_343);
	   if (!jrd_343.jrd_346) break;

	    /* First expand the file name This has already been done 
	    ** for shadows in add_shadow ()) */

	    if (work->dfw_type != dfw_add_shadow)
		{
	    	ISC_expand_filename (/*X.RDB$FILE_NAME*/
				     jrd_343.jrd_344, 0, temp); 
	    	/*MODIFY X USING*/
		{
		
                    strcpy(/*X.RDB$FILE_NAME*/
			   jrd_343.jrd_344, temp);
            	/*END_MODIFY*/
		gds__vtov (jrd_343.jrd_344, jrd_354.jrd_355, 256);
		EXE_send (tdbb, (REQ)handle, 4, 256, (UCHAR*)&jrd_354);
		};
		}

	    /* If there is no starting position specified, or if it is
	       too low a value, make a stab at assigning one based on 
	       the indicated preference for the previous file length. */

	    if ((start = /*X.RDB$FILE_START*/
			 jrd_343.jrd_345) < max)
		{
		/*FOR (REQUEST_HANDLE handle2) 
		    FIRST 1 Y IN RDB$FILES
		    WITH Y.RDB$SHADOW_NUMBER EQ X.RDB$SHADOW_NUMBER
		    AND Y.RDB$FILE_SEQUENCE NOT MISSING
		    SORTED BY DESCENDING Y.RDB$FILE_SEQUENCE*/
		{
		if (!handle2)
		   handle2 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_333, TRUE);
		jrd_334.jrd_335 = jrd_343.jrd_348;
		EXE_start (tdbb, (REQ)handle2, dbb->dbb_sys_trans);
		EXE_send (tdbb, (REQ)handle2, 0, 2, (UCHAR*)&jrd_334);
		while (1)
		   {
		   EXE_receive (tdbb, (REQ)handle2, 1, 10, (UCHAR*)&jrd_336);
		   if (!jrd_336.jrd_339) break;
		    start = /*Y.RDB$FILE_START*/
			    jrd_336.jrd_338 + /*Y.RDB$FILE_LENGTH*/
   jrd_336.jrd_337;
		/*END_FOR*/
		   }
		};
		}

	    start = MAX (max, start);
	    shadow_number = /*X.RDB$SHADOW_NUMBER*/
			    jrd_343.jrd_348;
	    if ((shadow_number && (section = SDW_add_file (/*X.RDB$FILE_NAME*/
							   jrd_343.jrd_344, start, shadow_number))) ||
		(section = PAG_add_file (/*X.RDB$FILE_NAME*/
					 jrd_343.jrd_344, start)))
		/*MODIFY X USING*/
		{
		
		    /*X.RDB$FILE_SEQUENCE*/
		    jrd_343.jrd_347 = section;
		    /*X.RDB$FILE_START*/
		    jrd_343.jrd_345 = start;
		/*END_MODIFY*/
		jrd_349.jrd_350 = jrd_343.jrd_345;
		jrd_349.jrd_351 = jrd_343.jrd_347;
		EXE_send (tdbb, (REQ)handle, 2, 6, (UCHAR*)&jrd_349);
		};
	/*END_FOR*/
	   EXE_send (tdbb, (REQ)handle, 3, 2, (UCHAR*)&jrd_352);
	   }
	};

	CMP_release (tdbb, handle);
	if (handle2)
	    CMP_release (tdbb, handle2);

	if (section)
	    {
	    handle = NULL;
	    section--;
	    /*FOR (REQUEST_HANDLE handle) X IN RDB$FILES
		WITH X.RDB$FILE_SEQUENCE EQ section
		AND X.RDB$SHADOW_NUMBER EQ shadow_number*/
	    {
	    if (!handle)
	       handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_320, TRUE);
	    jrd_321.jrd_322 = shadow_number;
	    jrd_321.jrd_323 = section;
	    EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	    EXE_send (tdbb, (REQ)handle, 0, 4, (UCHAR*)&jrd_321);
	    while (1)
	       {
	       EXE_receive (tdbb, (REQ)handle, 1, 10, (UCHAR*)&jrd_324);
	       if (!jrd_324.jrd_327) break;
		    /*MODIFY X USING*/
		    {
		    
			/*X.RDB$FILE_LENGTH*/
			jrd_324.jrd_326 = start - /*X.RDB$FILE_START*/
	   jrd_324.jrd_325;
		    /*END_MODIFY*/
		    jrd_328.jrd_329 = jrd_324.jrd_326;
		    jrd_328.jrd_330 = jrd_324.jrd_325;
		    EXE_send (tdbb, (REQ)handle, 2, 8, (UCHAR*)&jrd_328);
		    };
	    /*END_FOR*/
	       EXE_send (tdbb, (REQ)handle, 3, 2, (UCHAR*)&jrd_331);
	       }
	    };
	    CMP_release (tdbb, handle);
	    }

	CCH_release_exclusive (tdbb);
	break;
    }

return FALSE;
}


static BOOLEAN add_shadow (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_307;	/* gds__utility */
   } jrd_306;
   struct {
          SLONG  jrd_303;	/* RDB$FILE_START */
          SSHORT jrd_304;	/* RDB$FILE_FLAGS */
          SSHORT jrd_305;	/* RDB$FILE_SEQUENCE */
   } jrd_302;
   struct {
          TEXT  jrd_296 [256];	/* RDB$FILE_NAME */
          SLONG  jrd_297;	/* RDB$FILE_START */
          SSHORT jrd_298;	/* gds__utility */
          SSHORT jrd_299;	/* RDB$FILE_SEQUENCE */
          SSHORT jrd_300;	/* RDB$FILE_FLAGS */
          SSHORT jrd_301;	/* RDB$SHADOW_NUMBER */
   } jrd_295;
   struct {
          TEXT  jrd_294 [256];	/* RDB$FILE_NAME */
   } jrd_293;
   struct {
          SSHORT jrd_319;	/* gds__utility */
   } jrd_318;
   struct {
          TEXT  jrd_317 [256];	/* RDB$FILE_NAME */
   } jrd_316;
   struct {
          TEXT  jrd_312 [256];	/* RDB$FILE_NAME */
          SSHORT jrd_313;	/* gds__utility */
          SSHORT jrd_314;	/* RDB$FILE_FLAGS */
          SSHORT jrd_315;	/* RDB$SHADOW_NUMBER */
   } jrd_311;
   struct {
          TEXT  jrd_310 [256];	/* RDB$FILE_NAME */
   } jrd_309;
/**************************************
 *
 *	a d d _ s h a d o w
 *
 **************************************
 *
 * Functional description
 *	A file or files have been added for shadowing.
 *	Get all files for this particular shadow first
 *	in order of starting page, if specified, then
 *	in sequence order.
 *
 **************************************/
DBB	dbb;
BLK	handle;
SDW	shadow;
USHORT	sequence, add_sequence;
BOOLEAN	finished;
ULONG	min_page;
TEXT	expanded_fname [1024];

SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

switch (phase)
    {
    case 0:
	CCH_release_exclusive (tdbb);
	return FALSE;

    case 1:
    case 2:
    case 3:
	return TRUE;

    case 4:
	if (wal_defined (tdbb))
            ERR_post (gds__no_meta_update, 
		gds_arg_gds, gds__wal_shadow_err, 0);
	/* Msg309: Write-Ahead Log with Shadowing configuration not allowed */

	check_filename (work->dfw_name, work->dfw_name_length);

	/* could have two cases: 
	   1) this shadow has already been written to, so add this file using
	      the standard routine to extend a database
	   2) this file is part of a newly added shadow which has already been
	      fetched in totem and prepared for writing to, so just ignore it
	*/

	finished = FALSE;
	handle = NULL;
	/*FOR (REQUEST_HANDLE handle)
	    F IN RDB$FILES
	    WITH F.RDB$FILE_NAME EQ work->dfw_name*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_308, TRUE);
	gds__vtov (work->dfw_name, jrd_309.jrd_310, 256);
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 256, (UCHAR*)&jrd_309);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 262, (UCHAR*)&jrd_311);
	   if (!jrd_311.jrd_313) break;

	    ISC_expand_filename (/*F.RDB$FILE_NAME*/
				 jrd_311.jrd_312, 0, expanded_fname); 
	    /*MODIFY F USING*/
	    {
	    
		strcpy (/*F.RDB$FILE_NAME*/
			jrd_311.jrd_312, expanded_fname);
            /*END_MODIFY*/
	    gds__vtov (jrd_311.jrd_312, jrd_316.jrd_317, 256);
	    EXE_send (tdbb, (REQ)handle, 2, 256, (UCHAR*)&jrd_316);
	    };
	     
	    for (shadow = dbb->dbb_shadow; shadow; shadow = shadow->sdw_next)
		if ((/*F.RDB$SHADOW_NUMBER*/
		     jrd_311.jrd_315 == shadow->sdw_number) &&
	           !(shadow->sdw_flags & SDW_IGNORE))
		    {
		    if (/*F.RDB$FILE_FLAGS*/
			jrd_311.jrd_314 & FILE_shadow)
			/* This is the case of a bogus duplicate posted
			 * work when we added a multi-file shadow 
			 */
			finished = TRUE;
		    else if (shadow->sdw_flags & (SDW_dumped))
			{
			/* Case of adding a file to a currently active
			 * shadow set.
			 * Note: as of 1995-January-31 there is
			 * no SQL syntax that supports this, but there
			 * may be GDML
			 */
			if (!CCH_exclusive (tdbb, LCK_EX, WAIT_PERIOD))
			    ERR_post (gds__no_meta_update,
				gds_arg_gds, gds__lock_timeout,
			        gds_arg_gds, gds__obj_in_use,
			        gds_arg_string, 
				ERR_cstring (dbb->dbb_file->fil_string), 
			        0);
			add_file (tdbb, phase, work, (TRA)0);
			finished = TRUE;
			}
		    else
			{
			/* We cannot add a file to a shadow that is still
			 * in the process of being created.
			 */
			ERR_post (gds__no_meta_update,
			        gds_arg_gds, gds__obj_in_use,
			        gds_arg_string, 
				ERR_cstring (dbb->dbb_file->fil_string), 
			        0);
			}
		    break;
		    }

	/*END_FOR*/
	   EXE_send (tdbb, (REQ)handle, 3, 2, (UCHAR*)&jrd_318);
	   }
	};
	CMP_release (tdbb, handle);

	if (finished)
	    return FALSE;

	/* this file is part of a new shadow, so get all files for the shadow
	   in order of the starting page for the file */

	/* Note that for a multi-file shadow, we have several pieces of
	 * work posted (one dfw_add_shadow for each file).  Rather than
	 * trying to cancel the other pieces of work we ignore them
	 * when they arrive in this routine.
	 */

	sequence = 0;
	min_page = 0;
	shadow = NULL;
	handle = NULL;
	/*FOR (REQUEST_HANDLE handle) 
	      X IN RDB$FILES CROSS
	      Y IN RDB$FILES
	      OVER RDB$SHADOW_NUMBER
	      WITH X.RDB$FILE_NAME EQ expanded_fname
	      SORTED BY Y.RDB$FILE_START*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_292, TRUE);
	gds__vtov (expanded_fname, jrd_293.jrd_294, 256);
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 256, (UCHAR*)&jrd_293);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 268, (UCHAR*)&jrd_295);
	   if (!jrd_295.jrd_298) break;

	    /* for the first file, create a brand new shadow; for secondary
	       files that have a starting page specified, add a file */

	    if (!sequence)
		SDW_add (/*Y.RDB$FILE_NAME*/
			 jrd_295.jrd_296, /*Y.RDB$SHADOW_NUMBER*/
  jrd_295.jrd_301, /*Y.RDB$FILE_FLAGS*/
  jrd_295.jrd_300);
	    else if (/*Y.RDB$FILE_START*/
		     jrd_295.jrd_297)
		{
		if (!shadow)
		    for (shadow = dbb->dbb_shadow; shadow; shadow = shadow->sdw_next)
			if ((/*Y.RDB$SHADOW_NUMBER*/
			     jrd_295.jrd_301 == shadow->sdw_number) &&
	       		    !(shadow->sdw_flags & SDW_IGNORE))
			    break;

		if (!shadow)
		    BUGCHECK (203); /* msg 203 shadow block not found for extend file */

		min_page = MAX ((min_page + 1), /*Y.RDB$FILE_START*/
						jrd_295.jrd_297);
		add_sequence = SDW_add_file (/*Y.RDB$FILE_NAME*/
					     jrd_295.jrd_296, min_page, /*Y.RDB$SHADOW_NUMBER*/
	    jrd_295.jrd_301);
  		}

 	    /* update the sequence number and bless the file entry as being
	       good */

	    if (!sequence || (/*Y.RDB$FILE_START*/
			      jrd_295.jrd_297 && add_sequence))
		{
		/*MODIFY Y*/
		{
		
		    /*Y.RDB$FILE_FLAGS*/
		    jrd_295.jrd_300 |= FILE_shadow;
		    /*Y.RDB$FILE_SEQUENCE*/
		    jrd_295.jrd_299 = sequence;
		    /*Y.RDB$FILE_START*/
		    jrd_295.jrd_297 = min_page;
		/*END_MODIFY*/
		jrd_302.jrd_303 = jrd_295.jrd_297;
		jrd_302.jrd_304 = jrd_295.jrd_300;
		jrd_302.jrd_305 = jrd_295.jrd_299;
		EXE_send (tdbb, (REQ)handle, 2, 8, (UCHAR*)&jrd_302);
		};
		sequence++;
		}
	    
	/*END_FOR*/
	   EXE_send (tdbb, (REQ)handle, 3, 2, (UCHAR*)&jrd_306);
	   }
	};
	CMP_release (tdbb, handle);
	break;
    }

return FALSE;
}

static void check_dependencies (
    TDBB	tdbb,
    TEXT	*dpdo_name,
    TEXT	*field_name,
    USHORT	dpdo_type,
    TRA		transaction)
{
   struct {
          TEXT  jrd_280 [32];	/* RDB$DEPENDENT_NAME */
          SSHORT jrd_281;	/* gds__utility */
          SSHORT jrd_282;	/* RDB$DEPENDENT_TYPE */
   } jrd_279;
   struct {
          TEXT  jrd_277 [32];	/* RDB$DEPENDED_ON_NAME */
          SSHORT jrd_278;	/* RDB$DEPENDED_ON_TYPE */
   } jrd_276;
   struct {
          TEXT  jrd_289 [32];	/* RDB$DEPENDENT_NAME */
          SSHORT jrd_290;	/* gds__utility */
          SSHORT jrd_291;	/* RDB$DEPENDENT_TYPE */
   } jrd_288;
   struct {
          TEXT  jrd_285 [32];	/* RDB$FIELD_NAME */
          TEXT  jrd_286 [32];	/* RDB$DEPENDED_ON_NAME */
          SSHORT jrd_287;	/* RDB$DEPENDED_ON_TYPE */
   } jrd_284;
/**************************************
 *
 *	c h e c k _ d e p e n d e n c i e s
 *
 **************************************
 *
 * Functional description
 *	Check the dependency list for relation or relation.field
 *	before deleting such.
 *
 **************************************/
DBB	dbb;
REQ	request;
USHORT	dep_counts [obj_count], i;
STATUS	obj_type;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

for (i = 0; i < (USHORT) obj_count; i++)
    dep_counts [i] = 0;

if (field_name)
    {
    request = (REQ) CMP_find_request (tdbb, irq_ch_f_dpd, IRQ_REQUESTS);

    /*FOR (REQUEST_HANDLE request) 
	    DEP IN RDB$DEPENDENCIES
	    WITH DEP.RDB$DEPENDED_ON_NAME EQ dpdo_name
	    AND DEP.RDB$DEPENDED_ON_TYPE = dpdo_type
	    AND DEP.RDB$FIELD_NAME EQ field_name
	    REDUCED TO DEP.RDB$DEPENDENT_NAME*/
    {
    if (!request)
       request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_283, TRUE);
    gds__vtov (field_name, jrd_284.jrd_285, 32);
    gds__vtov (dpdo_name, jrd_284.jrd_286, 32);
    jrd_284.jrd_287 = dpdo_type;
    EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)request, 0, 66, (UCHAR*)&jrd_284);
    while (1)
       {
       EXE_receive (tdbb, (REQ)request, 1, 36, (UCHAR*)&jrd_288);
       if (!jrd_288.jrd_290) break;

	if (!REQUEST (irq_ch_f_dpd))
	    REQUEST (irq_ch_f_dpd) = (BLK) request;

	/* If the found object is also being deleted, there's no dependency */

	if (!find_depend_in_dfw (tdbb, /*DEP.RDB$DEPENDENT_NAME*/
				       jrd_288.jrd_289,
				 /*DEP.RDB$DEPENDENT_TYPE*/
				 jrd_288.jrd_291, 0, transaction))
	    dep_counts [/*DEP.RDB$DEPENDENT_TYPE*/
			jrd_288.jrd_291]++;
    /*END_FOR*/
       }
    };

    if (!REQUEST (irq_ch_f_dpd))
	REQUEST (irq_ch_f_dpd) = (BLK) request;
    }
else
    {
    request = (REQ) CMP_find_request (tdbb, irq_ch_dpd, IRQ_REQUESTS);

    /*FOR (REQUEST_HANDLE request) 
	    DEP IN RDB$DEPENDENCIES
	    WITH DEP.RDB$DEPENDED_ON_NAME EQ dpdo_name
	    AND DEP.RDB$DEPENDED_ON_TYPE = dpdo_type
	    REDUCED TO DEP.RDB$DEPENDENT_NAME*/
    {
    if (!request)
       request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_275, TRUE);
    gds__vtov (dpdo_name, jrd_276.jrd_277, 32);
    jrd_276.jrd_278 = dpdo_type;
    EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)request, 0, 34, (UCHAR*)&jrd_276);
    while (1)
       {
       EXE_receive (tdbb, (REQ)request, 1, 36, (UCHAR*)&jrd_279);
       if (!jrd_279.jrd_281) break;

	if (!REQUEST (irq_ch_dpd))
	    REQUEST (irq_ch_dpd) = (BLK) request;

	/* If the found object is also being deleted, there's no dependency */

	if (!find_depend_in_dfw (tdbb, /*DEP.RDB$DEPENDENT_NAME*/
				       jrd_279.jrd_280,
				 /*DEP.RDB$DEPENDENT_TYPE*/
				 jrd_279.jrd_282,
				 0, transaction))
	    dep_counts [/*DEP.RDB$DEPENDENT_TYPE*/
			jrd_279.jrd_282]++;
    /*END_FOR*/
       }
    };

    if (!REQUEST (irq_ch_dpd))
	REQUEST (irq_ch_dpd) = (BLK) request;
    }

for (i = 0; i < obj_count; i++)
    if (dep_counts [i])
	{
		switch (dpdo_type)
		{
		case obj_relation:
			obj_type = gds__table_name;
			break;
		case obj_procedure:
			obj_type = gds__proc_name;
			break;
		case obj_exception:
			obj_type = gds__exception_name;
			break;
		case obj_generator:
			obj_type = gds__generator_name;
			break;
		case obj_udf:
			obj_type = gds__udf_name;
			break;
		default:
			assert (FALSE);
			break;
		}
	if (field_name)
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__no_delete,    /* Msg353: can not delete */
		gds_arg_gds, gds__field_name, gds_arg_string, ERR_cstring (field_name),
		gds_arg_gds, gds__dependency, gds_arg_number, (SLONG) dep_counts [i],
		0);       /* Msg310: there are %ld dependencies */
	else
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__no_delete,            /* can not delete */
		gds_arg_gds, obj_type, gds_arg_string, ERR_cstring (dpdo_name),
		gds_arg_gds, gds__dependency, gds_arg_number, (SLONG) dep_counts [i],
		0);                           /* there are %ld dependencies */
	}
}

static void check_filename (
    TEXT	*name,
    USHORT	l)
{
/**************************************
 *
 *	c h e c k _ f i l e n a m e
 *
 **************************************
 *
 * Functional description
 *	Make sure that a file path doesn't contain an
 *	inet node name.
 *
 **************************************/
TEXT	file_name [MAX_PATH_LENGTH], *p, *q;
BOOLEAN	valid = TRUE;

l = MIN (l, sizeof (file_name) - 1);
for (p = file_name, q = name; l--; *p++ = *q++)
    ;
*p = 0;
for (p = file_name; *p; p++)
    if (p [0] == ':' && p [1] == ':')
	valid = FALSE;

if (!valid || ISC_check_if_remote (file_name, FALSE))
    ERR_post (gds__no_meta_update,
	gds_arg_gds, gds__node_name_err, 0);
    /* Msg305: A node name is not permitted in a secondary, shadow, or log file name */
}

static BOOLEAN compare_formats (
    FMT old_format,
    FMT	new_format)
{
/**************************************
 *
 *	c o m p a r e _ f o r m a t s
 *
 **************************************
 *
 * Functional description
 *	Compare two format blocks
 *
 **************************************/
DSC * old_desc, * new_desc, * end;


if ((old_format->fmt_length != new_format->fmt_length)
    || (old_format->fmt_count != new_format->fmt_count))
    {
    return TRUE;
    }

old_desc = old_format->fmt_desc;
new_desc = new_format->fmt_desc;
end = old_format->fmt_desc + old_format->fmt_count;

while (old_desc < end)
    {
    if ((old_desc->dsc_dtype != new_desc->dsc_dtype)
	||(old_desc->dsc_scale != new_desc->dsc_scale)
	||(old_desc->dsc_length != new_desc->dsc_length)
	||(old_desc->dsc_sub_type != new_desc->dsc_sub_type)
	||(old_desc->dsc_flags != new_desc->dsc_flags)
	|| (old_desc->dsc_address != new_desc->dsc_address))
	{
	return TRUE;
	}
    old_desc++;
    new_desc++;
    }

return FALSE;

}

static BOOLEAN compute_security (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_274;	/* gds__utility */
   } jrd_273;
   struct {
          TEXT  jrd_272 [32];	/* RDB$SECURITY_CLASS */
   } jrd_271;
/**************************************
 *
 *	c o m p u t e _ s e c u r i t y
 *
 **************************************
 *
 * Functional description
 *	There was a change in a security class.  Recompute everything
 *	it touches.
 *
 **************************************/
DBB	dbb;
BLK	handle;
SCL	class;

SET_TDBB (tdbb);
dbb =  tdbb->tdbb_database;

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	/* Get security class.  This may return NULL if it doesn't exist */

	class = SCL_recompute_class (tdbb, work->dfw_name);

	handle = NULL;
	/*FOR (REQUEST_HANDLE handle) X IN RDB$DATABASE
		WITH X.RDB$SECURITY_CLASS EQ work->dfw_name*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_270, TRUE);
	gds__vtov (work->dfw_name, jrd_271.jrd_272, 32);
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 32, (UCHAR*)&jrd_271);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 2, (UCHAR*)&jrd_273);
	   if (!jrd_273.jrd_274) break;
	    tdbb->tdbb_attachment->att_security_class = class;
	/*END_FOR*/
	   }
	};
	CMP_release (tdbb, handle);
	break;
    }

return FALSE;

/**** OBSOLETE!!! Only security class name strings in relations and fields.
      Note: fld_security_class  --> fld_security_name
            rel_security_class  --> rel_security_name

handle = NULL;
for (request_handle handle) x in rdb$relation_fields 
	with x.rdb$security_class eq work->dfw_name
    if (relation = MET_lookup_relation (tdbb, x.rdb$relation_name))
	{
    	id = MET_lookup_field (tdbb, relation, x.rdb$field_name, 0);
    	if (field = MET_get_field (relation, id))
	    field->fld_security_class = class;
	}
end_for;
CMP_release (tdbb, handle);

handle = NULL;
for (request_handle handle) x in rdb$relations 
	with x.rdb$security_class eq work->dfw_name
    if (relation = MET_lookup_relation (tdbb, x.rdb$relation_name))
        relation->rel_security_class = class;
end_for;
CMP_release (tdbb, handle);

****/
}

static BOOLEAN create_index (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          double  jrd_253;	/* RDB$STATISTICS */
          SSHORT jrd_254;	/* RDB$INDEX_ID */
   } jrd_252;
   struct {
          SSHORT jrd_251;	/* gds__utility */
   } jrd_250;
   struct {
          SSHORT jrd_248;	/* gds__null_flag */
          SSHORT jrd_249;	/* RDB$INDEX_ID */
   } jrd_247;
   struct {
          TEXT  jrd_223 [32];	/* RDB$FIELD_NAME */
          TEXT  jrd_224 [32];	/* RDB$INDEX_NAME */
          TEXT  jrd_225 [32];	/* RDB$FOREIGN_KEY */
          double  jrd_226;	/* RDB$STATISTICS */
          SSHORT jrd_227;	/* gds__utility */
          SSHORT jrd_228;	/* gds__null_flag */
          SSHORT jrd_229;	/* RDB$COLLATION_ID */
          SSHORT jrd_230;	/* gds__null_flag */
          SSHORT jrd_231;	/* RDB$COLLATION_ID */
          SSHORT jrd_232;	/* gds__null_flag */
          SSHORT jrd_233;	/* RDB$CHARACTER_SET_ID */
          SSHORT jrd_234;	/* RDB$FIELD_ID */
          SSHORT jrd_235;	/* gds__null_flag */
          SSHORT jrd_236;	/* RDB$DIMENSIONS */
          SSHORT jrd_237;	/* RDB$FIELD_TYPE */
          SSHORT jrd_238;	/* RDB$FIELD_POSITION */
          SSHORT jrd_239;	/* gds__null_flag */
          SSHORT jrd_240;	/* RDB$INDEX_TYPE */
          SSHORT jrd_241;	/* RDB$UNIQUE_FLAG */
          SSHORT jrd_242;	/* RDB$SEGMENT_COUNT */
          SSHORT jrd_243;	/* RDB$INDEX_INACTIVE */
          SSHORT jrd_244;	/* gds__null_flag */
          SSHORT jrd_245;	/* RDB$INDEX_ID */
          SSHORT jrd_246;	/* RDB$RELATION_ID */
   } jrd_222;
   struct {
          TEXT  jrd_221 [32];	/* RDB$INDEX_NAME */
   } jrd_220;
   struct {
          SSHORT jrd_269;	/* gds__utility */
   } jrd_268;
   struct {
          SSHORT jrd_266;	/* gds__null_flag */
          SSHORT jrd_267;	/* RDB$INDEX_ID */
   } jrd_265;
   struct {
          TEXT  jrd_259 [32];	/* RDB$RELATION_NAME */
          GDS__QUAD  jrd_260;	/* RDB$VIEW_BLR */
          SSHORT jrd_261;	/* gds__utility */
          SSHORT jrd_262;	/* gds__null_flag */
          SSHORT jrd_263;	/* RDB$INDEX_ID */
          SSHORT jrd_264;	/* gds__null_flag */
   } jrd_258;
   struct {
          TEXT  jrd_257 [32];	/* RDB$INDEX_NAME */
   } jrd_256;
/**************************************
 *
 *	c r e a t e _ i n d e x
 *
 **************************************
 *
 * Functional description
 *	Create a new index or change the state of an index between active/inactive.
 *
 **************************************/
DBB	dbb;
REQ	request;
REL	relation, partner_relation;
IDX	idx;
int	key_count;
float	selectivity;
SSHORT	text_type;
SSHORT	collate;
BLK	handle;
WIN	window;

SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

switch (phase)
    {
    case 0:
	handle = NULL;

	/* Drop those indices at clean up time. */
	/*FOR (REQUEST_HANDLE handle) IDXN IN RDB$INDICES CROSS
		IREL IN RDB$RELATIONS OVER RDB$RELATION_NAME
		WITH IDXN.RDB$INDEX_NAME EQ work->dfw_name*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_255, TRUE);
	gds__vtov (work->dfw_name, jrd_256.jrd_257, 32);
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 32, (UCHAR*)&jrd_256);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 48, (UCHAR*)&jrd_258);
	   if (!jrd_258.jrd_261) break;

	  /* Views do not have indices */
	  if (/*IREL.RDB$VIEW_BLR.NULL*/
	      jrd_258.jrd_264)
	    {
	    relation = MET_lookup_relation (tdbb, /*IDXN.RDB$RELATION_NAME*/
						  jrd_258.jrd_259);

	    /* Fetch the root index page and mark MUST_WRITE, and then
	       delete the index. It will also clean the index slot. */
	    if (relation->rel_index_root)
	        {
		if (work->dfw_id != MAX_IDX)
		    {
	            window.win_page = relation->rel_index_root;
		    window.win_flags = 0;
	            CCH_FETCH (tdbb, &window, LCK_write, pag_root);
	            CCH_MARK_MUST_WRITE (tdbb, &window);
	            BTR_delete_index (tdbb, &window, work->dfw_id);
		    work->dfw_id = MAX_IDX;
		    }
		if (!/*IDXN.RDB$INDEX_ID.NULL*/
		     jrd_258.jrd_262)
		    {
		    /*MODIFY IDXN USING*/
		    {
		    
	        	/*IDXN.RDB$INDEX_ID.NULL*/
			jrd_258.jrd_262 = TRUE;
		    /*END_MODIFY*/
		    jrd_265.jrd_266 = jrd_258.jrd_262;
		    jrd_265.jrd_267 = jrd_258.jrd_263;
		    EXE_send (tdbb, (REQ)handle, 2, 4, (UCHAR*)&jrd_265);
		    };
		    }
	        }
	    }
	/*END_FOR*/
	   EXE_send (tdbb, (REQ)handle, 3, 2, (UCHAR*)&jrd_268);
	   }
	};

	CMP_release (tdbb, handle);
    	CCH_release_exclusive (tdbb);
	return FALSE;
	    
    case 1:
    case 2:
	return TRUE;

    case 3:
	key_count = 0;
	relation = NULL;
	idx.idx_flags = 0;

	/* Fetch the information necessary to create the index.  On the first
	   time thru, check to see if the index already exists.  If so, delete
	   it.  If the index inactive flag is set, don't create the index */

	request = (REQ) CMP_find_request (tdbb, irq_c_index, IRQ_REQUESTS);

	/*FOR (REQUEST_HANDLE request) 
	    IDX IN RDB$INDICES CROSS
	    SEG IN RDB$INDEX_SEGMENTS OVER RDB$INDEX_NAME CROSS
	    RFR IN RDB$RELATION_FIELDS OVER RDB$FIELD_NAME, RDB$RELATION_NAME CROSS
	    FLD IN RDB$FIELDS CROSS
	    REL IN RDB$RELATIONS OVER RDB$RELATION_NAME WITH
	        FLD.RDB$FIELD_NAME EQ RFR.RDB$FIELD_SOURCE AND
	        IDX.RDB$INDEX_NAME EQ work->dfw_name*/
	{
	if (!request)
	   request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_219, TRUE);
	gds__vtov (work->dfw_name, jrd_220.jrd_221, 32);
	EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)request, 0, 32, (UCHAR*)&jrd_220);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)request, 1, 144, (UCHAR*)&jrd_222);
	   if (!jrd_222.jrd_227) break; 

	    if (!REQUEST (irq_c_index))
		REQUEST (irq_c_index) = (BLK) request;

	    if (!relation)
	        {
	        if (!(relation = MET_lookup_relation_id (tdbb, /*REL.RDB$RELATION_ID*/
							       jrd_222.jrd_246, FALSE)))
		    {
		    EXE_unwind (tdbb, request);
                    ERR_post (gds__no_meta_update,
			gds_arg_gds, gds__idx_create_err,
			gds_arg_string, ERR_cstring (work->dfw_name),
			0);
			/* Msg308: can't create index %s */
		    }
	        if (/*IDX.RDB$INDEX_ID*/
		    jrd_222.jrd_245 && /*IDX.RDB$STATISTICS*/
    jrd_222.jrd_226 < 0.0)
	            {
	            /*MODIFY IDX*/
		    {
		    
	   	        /*IDX.RDB$STATISTICS*/
			jrd_222.jrd_226 = IDX_statistics (tdbb, relation, /*IDX.RDB$INDEX_ID*/
				   jrd_222.jrd_245 - 1);
		    /*END_MODIFY*/
		    jrd_252.jrd_253 = jrd_222.jrd_226;
		    jrd_252.jrd_254 = jrd_222.jrd_245;
		    EXE_send (tdbb, (REQ)request, 4, 10, (UCHAR*)&jrd_252);
		    };
		    EXE_unwind (tdbb, request);
		    return FALSE;
		    }
		if (/*IDX.RDB$INDEX_ID*/
		    jrd_222.jrd_245)
		    {
		    IDX_delete_index (tdbb, relation, /*IDX.RDB$INDEX_ID*/
						      jrd_222.jrd_245 - 1);
		    /*MODIFY IDX*/
		    {
		    
		        /*IDX.RDB$INDEX_ID.NULL*/
			jrd_222.jrd_244 = TRUE;
		    /*END_MODIFY*/
		    jrd_247.jrd_248 = jrd_222.jrd_244;
		    jrd_247.jrd_249 = jrd_222.jrd_245;
		    EXE_send (tdbb, (REQ)request, 2, 4, (UCHAR*)&jrd_247);
		    };
		    }
		if (/*IDX.RDB$INDEX_INACTIVE*/
		    jrd_222.jrd_243)
		    {
		    EXE_unwind (tdbb, request);
		    return FALSE;
		    }
		idx.idx_count = /*IDX.RDB$SEGMENT_COUNT*/
				jrd_222.jrd_242;
		if (!idx.idx_count || idx.idx_count > 16)
		    {
		    EXE_unwind (tdbb, request);
                    if (!idx.idx_count)
			ERR_post (gds__no_meta_update,
			    gds_arg_gds, gds__idx_seg_err,
			    gds_arg_string, ERR_cstring (work->dfw_name),
			    0);
			/* Msg304: segment count of 0 defined for index %s */
		    else
			ERR_post (gds__no_meta_update,
			    gds_arg_gds, gds__idx_key_err,
			    gds_arg_string, ERR_cstring (work->dfw_name),
			    0);
			/* Msg311: too many keys defined for index %s */
		    }
		if (/*IDX.RDB$UNIQUE_FLAG*/
		    jrd_222.jrd_241)
		    idx.idx_flags |= idx_unique;
		if (/*IDX.RDB$INDEX_TYPE*/
		    jrd_222.jrd_240 == 1)
		    idx.idx_flags |= idx_descending;
		if (!/*IDX.RDB$FOREIGN_KEY.NULL*/
		     jrd_222.jrd_239)
		    idx.idx_flags |= idx_foreign;
		if (!strncmp (/*IDX.RDB$INDEX_NAME*/
			      jrd_222.jrd_224, "RDB$PRIMARY", strlen ("RDB$PRIMARY")))
		    idx.idx_flags |= idx_primary;
		}

	    if (++key_count > idx.idx_count ||
		/*SEG.RDB$FIELD_POSITION*/
		jrd_222.jrd_238 > idx.idx_count ||
		/*FLD.RDB$FIELD_TYPE*/
		jrd_222.jrd_237 == blr_blob ||
		!/*FLD.RDB$DIMENSIONS.NULL*/
		 jrd_222.jrd_235)
		{
		EXE_unwind (tdbb, request);
                if (key_count > idx.idx_count)
		    ERR_post (gds__no_meta_update,
			gds_arg_gds, gds__idx_key_err,
			gds_arg_string, ERR_cstring (work->dfw_name),
			0);
			/* Msg311: too many keys defined for index %s */
		else if (/*SEG.RDB$FIELD_POSITION*/
			 jrd_222.jrd_238 > idx.idx_count)
                    ERR_post (gds__no_meta_update,
			gds_arg_gds, gds__inval_key_posn,    
			/* Msg358: invalid key position */
			gds_arg_gds, gds__field_name,
			gds_arg_string, ERR_cstring (/*RFR.RDB$FIELD_NAME*/
						     jrd_222.jrd_223),
			gds_arg_gds, gds__index_name,
			gds_arg_string, ERR_cstring (work->dfw_name),
			0);
		else if (/*FLD.RDB$FIELD_TYPE*/
			 jrd_222.jrd_237 == blr_blob)
                    ERR_post (gds__no_meta_update,
			gds_arg_gds, gds__blob_idx_err,
			gds_arg_string, ERR_cstring (work->dfw_name),
			0);
		    /* Msg350: attempt to index blob column in index %s */
		else
                    ERR_post (gds__no_meta_update,
			gds_arg_gds, gds__array_idx_err,
			gds_arg_string, ERR_cstring (work->dfw_name),
			0);
		    /* Msg351: attempt to index array column in index %s */
		}
                                                                 
	    idx.idx_rpt [/*SEG.RDB$FIELD_POSITION*/
			 jrd_222.jrd_238].idx_field = /*RFR.RDB$FIELD_ID*/
	      jrd_222.jrd_234;

	    if (/*FLD.RDB$CHARACTER_SET_ID.NULL*/
		jrd_222.jrd_232)
	        /*FLD.RDB$CHARACTER_SET_ID*/
		jrd_222.jrd_233 = CS_NONE;

	    if (!/*RFR.RDB$COLLATION_ID.NULL*/
		 jrd_222.jrd_230)
		collate = /*RFR.RDB$COLLATION_ID*/
			  jrd_222.jrd_231;
	    else if (!/*FLD.RDB$COLLATION_ID.NULL*/
		      jrd_222.jrd_228)
		collate = /*FLD.RDB$COLLATION_ID*/
			  jrd_222.jrd_229;
	    else 
		collate = COLLATE_NONE;

	    text_type = INTL_CS_COLL_TO_TTYPE (/*FLD.RDB$CHARACTER_SET_ID*/
					       jrd_222.jrd_233, collate);
            idx.idx_rpt [/*SEG.RDB$FIELD_POSITION*/
			 jrd_222.jrd_238].idx_itype = DFW_assign_index_type (work, gds_cvt_blr_dtype [/*FLD.RDB$FIELD_TYPE*/
							      jrd_222.jrd_237], text_type);
	/*END_FOR*/
	   EXE_send (tdbb, (REQ)request, 3, 2, (UCHAR*)&jrd_250);
	   }
	};

	if (!REQUEST (irq_c_index))
	    REQUEST (irq_c_index) = (BLK) request;

	if (key_count != idx.idx_count)
            ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__key_field_err,
		gds_arg_string, ERR_cstring (work->dfw_name),
		0);
	    /* Msg352: too few key columns found for index %s (incorrect column name?) */
	if (!relation)
            ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__idx_create_err,
		gds_arg_string, ERR_cstring (work->dfw_name),
		0);
		/* Msg308: can't create index %s */

   	/* Make sure the relation info is all current */

	MET_scan_relation (tdbb, relation);

	if (relation->rel_view_rse)
            ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__idx_create_err,
		gds_arg_string, ERR_cstring (work->dfw_name),
		0);
		/* Msg308: can't create index %s */

	/* Actually create the index */

	partner_relation = (REL) NULL_PTR;
	if (idx.idx_flags & idx_foreign)
    {
	    /* Get an exclusive lock on the database if the index being
	       defined enforces a foreign key constraint. This will prevent
	       the constraint from being violated during index construction. */
	       
	    if (MET_lookup_partner (tdbb, relation, &idx, work->dfw_name) &&
	    	(partner_relation = MET_lookup_relation_id (tdbb, idx.idx_primary_relation, TRUE)) &&
		!CCH_exclusive (tdbb, LCK_EX, LCK_NO_WAIT))
	    	    ERR_post (gds__no_meta_update,
			gds_arg_gds, gds__obj_in_use,
			gds_arg_string, partner_relation->rel_name, 
			0);

	/* CVC: Currently, the server doesn't enforce FK creation more than at DYN level.
	If DYN is bypassed, then FK creation succeeds and operation will fail at run-time.
	The aim is to check REFERENCES at DDL time instead of DML time and behave accordingly
	to ANSI SQL rules for REFERENCES rights.
	For testing purposes, I'm calling SCL_check_index, although most of the DFW ops are
	carried using internal metadata structures that are refreshed from system tables. */

		if (partner_relation)
		{
			/* Don't bother if the master's owner is the same than the detail's owner.
			If both tables aren't defined in the same session, partner_relation->rel_owner_name
			won't be loaded hence, we need to be careful about null pointers. */

			if (!relation->rel_owner_name || !partner_relation->rel_owner_name
				|| strcmp(relation->rel_owner_name, partner_relation->rel_owner_name))
				SCL_check_index (tdbb, partner_relation->rel_name, idx.idx_id + 1, SCL_sql_references);
		}
    }
		    
	assert (work->dfw_id == MAX_IDX);
	IDX_create_index (tdbb, relation, &idx,
			  work->dfw_name, &work->dfw_id, transaction, &selectivity);
	assert (work->dfw_id == idx.idx_id);
	DFW_update_index (work, idx.idx_id, selectivity);

	if (partner_relation)
	    {
	    relation->rel_flags |= REL_check_partners;
	    partner_relation->rel_flags |= REL_check_partners;
	    CCH_release_exclusive (tdbb);
	    }
	
	break;
    }

return FALSE;
}

static BOOLEAN create_log (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_218;	/* gds__utility */
   } jrd_217;
   struct {
          TEXT  jrd_216 [256];	/* RDB$FILE_NAME */
   } jrd_215;
   struct {
          TEXT  jrd_213 [256];	/* RDB$FILE_NAME */
          SSHORT jrd_214;	/* gds__utility */
   } jrd_212;
/**************************************
 *
 *	c r e a t e _ l o g
 *
 **************************************
 *
 * Functional description
 *	Do work associated with the addition of records to RDB$LOG_FILES
 *
 **************************************/
BLK     handle;
TEXT	temp [MAX_PATH_LENGTH];
DBB     dbb;

SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

switch (phase)
    {
    case 0:
	CCH_release_exclusive (tdbb);
	return 0;

    case 1:
    case 2:
	return TRUE;

    case 3:
        if (CCH_exclusive (tdbb, LCK_EX, WAIT_PERIOD))
            return TRUE;
        else
            {
            ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__lock_timeout,
                gds_arg_gds, gds__obj_in_use,
                gds_arg_string, ERR_cstring (dbb->dbb_file->fil_string),
                0);
            return FALSE;
            }
    case 4:

	handle = NULL;
	if (shadow_defined (tdbb))
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__wal_shadow_err,
		0);
	    /* Msg309: Write-Ahead Log with Shadowing configuration not allowed */
        check_filename (work->dfw_name, work->dfw_name_length);

	/*FOR (REQUEST_HANDLE handle) X IN RDB$LOG_FILES*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_211, TRUE);
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 0, 258, (UCHAR*)&jrd_212);
	   if (!jrd_212.jrd_214) break;

	    ISC_expand_filename (/*X.RDB$FILE_NAME*/
				 jrd_212.jrd_213, 0, temp);

	    /*MODIFY X USING*/
	    {
	    
		strcpy (/*X.RDB$FILE_NAME*/
			jrd_212.jrd_213, temp);
	    /*END_MODIFY*/
	    gds__vtov (jrd_212.jrd_213, jrd_215.jrd_216, 256);
	    EXE_send (tdbb, (REQ)handle, 1, 256, (UCHAR*)&jrd_215);
	    };
	/*END_FOR*/
	   EXE_send (tdbb, (REQ)handle, 2, 2, (UCHAR*)&jrd_217);
	   }
	};

	CMP_release (tdbb, handle);

	transaction->tra_flags |= TRA_add_log;
	PAG_modify_log (transaction->tra_number, TRA_add_log);
	return TRUE;

    case 5:
	CCH_release_exclusive (tdbb);
	break;
    }

return FALSE;
}

static BOOLEAN create_procedure (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	c r e a t e _ p r o c e d u r e
 *
 **************************************
 *
 * Functional description
 *	Create a new procedure.
 *
 **************************************/
PRC		procedure;

SET_TDBB (tdbb);

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	get_procedure_dependencies (work);
	if (!(procedure = MET_lookup_procedure (tdbb, work->dfw_name)))
	     return FALSE;
	procedure->prc_flags |= PRC_create;
	break;
    }

return FALSE;
}   

static BOOLEAN create_relation (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_192;	/* gds__utility */
          SSHORT jrd_193;	/* RDB$DBKEY_LENGTH */
   } jrd_191;
   struct {
          TEXT  jrd_190 [32];	/* RDB$VIEW_NAME */
   } jrd_189;
   struct {
          SSHORT jrd_210;	/* RDB$RELATION_ID */
   } jrd_209;
   struct {
          SSHORT jrd_208;	/* gds__utility */
   } jrd_207;
   struct {
          SSHORT jrd_205;	/* RDB$RELATION_ID */
          SSHORT jrd_206;	/* RDB$DBKEY_LENGTH */
   } jrd_204;
   struct {
          TEXT  jrd_198 [256];	/* RDB$EXTERNAL_FILE */
          GDS__QUAD  jrd_199;	/* RDB$VIEW_BLR */
          SSHORT jrd_200;	/* gds__utility */
          SSHORT jrd_201;	/* RDB$DBKEY_LENGTH */
          SSHORT jrd_202;	/* RDB$RELATION_ID */
          SSHORT jrd_203;	/* RDB$RELATION_ID */
   } jrd_197;
   struct {
          TEXT  jrd_196 [32];	/* RDB$RELATION_NAME */
   } jrd_195;
/**************************************
 *
 *	c r e a t e _ r e l a t i o n
 *
 **************************************
 *
 * Functional description
 *	Create a new relation.
 *
 **************************************/
DBB		dbb;
REQ		request;
REL		relation;
USHORT		rel_id, external_flag;
GDS__QUAD	blob_id;
BLK		handle;
LCK		lock;
USHORT          major_version, minor_original, local_min_relation_id;


SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

major_version  = (SSHORT) dbb->dbb_ods_version;
minor_original = (SSHORT) dbb->dbb_minor_original;

if (ENCODE_ODS(major_version, minor_original) < ODS_9_0)
    local_min_relation_id = MIN_RELATION_ID;
else
    local_min_relation_id = USER_DEF_REL_INIT_ID;

switch (phase)
    {
    case 0:
	if (work->dfw_lock)
	    {
	    LCK_release (tdbb, work->dfw_lock);
	    ALL_release ((FRB) work->dfw_lock);
	    work->dfw_lock = NULL;
	    }
	break;

    case 1:
    case 2:
	return TRUE;

    case 3:
	/* Take a relation lock on rel id -1 before actually
	   generating a relation id. */

	work->dfw_lock = lock = (LCK) ALLOCDV (type_lck, sizeof (SLONG));
	lock->lck_dbb = dbb;
	lock->lck_attachment = tdbb->tdbb_attachment;
	lock->lck_length = sizeof (SLONG);
	lock->lck_key.lck_long = -1;
	lock->lck_type = LCK_relation;
	lock->lck_owner_handle = LCK_get_owner_handle (tdbb, lock->lck_type);
	lock->lck_parent = dbb->dbb_lock;
	lock->lck_owner = (BLK) tdbb->tdbb_attachment;

	LCK_lock_non_blocking (tdbb, lock, LCK_EX, LCK_WAIT);

	/* Assign a relation ID and dbkey length to the new relation.
	   Probe the candidate relation ID returned from the system
	   relation RDB$DATABASE to make sure it isn't already assigned.
	   This can happen from nefarious manipulation of RDB$DATABASE
	   or wraparound of the next relation ID. Keep looking for a
	   usable relation ID until the search space is exhausted. */

	rel_id = 0;
	request = (REQ) CMP_find_request (tdbb, irq_c_relation, IRQ_REQUESTS);

	/*FOR (REQUEST_HANDLE request) 
		X IN RDB$DATABASE CROSS Y IN RDB$RELATIONS WITH
		Y.RDB$RELATION_NAME EQ work->dfw_name*/
	{
	if (!request)
	   request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_194, TRUE);
	gds__vtov (work->dfw_name, jrd_195.jrd_196, 32);
	EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)request, 0, 32, (UCHAR*)&jrd_195);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)request, 1, 272, (UCHAR*)&jrd_197);
	   if (!jrd_197.jrd_200) break;
	    if (!REQUEST (irq_c_relation))
		REQUEST (irq_c_relation) = (BLK) request;

	    blob_id = /*Y.RDB$VIEW_BLR*/
		      jrd_197.jrd_199;
	    external_flag = /*Y.RDB$EXTERNAL_FILE*/
			    jrd_197.jrd_198 [0];

	    /*MODIFY X USING*/
	    {
	    
		rel_id = /*X.RDB$RELATION_ID*/
			 jrd_197.jrd_203;

		if (rel_id < local_min_relation_id || rel_id > MAX_RELATION_ID)
		    rel_id = /*X.RDB$RELATION_ID*/
			     jrd_197.jrd_203 = local_min_relation_id;

		while (relation = MET_lookup_relation_id (tdbb, rel_id++, FALSE))
		    {
		    if (rel_id < local_min_relation_id || 
                        rel_id > MAX_RELATION_ID)
			rel_id = local_min_relation_id;
		    if (rel_id == /*X.RDB$RELATION_ID*/
				  jrd_197.jrd_203)
		    	{
			EXE_unwind (tdbb, request);
                    	ERR_post (gds__no_meta_update,
		    	    gds_arg_gds, gds__table_name,
		    	    gds_arg_string, ERR_cstring (work->dfw_name),
		    	    gds_arg_gds, gds__imp_exc,
		    	    0);
			}
		    }
		/*X.RDB$RELATION_ID*/
		jrd_197.jrd_203 = (rel_id > MAX_RELATION_ID) ? 
                                              local_min_relation_id : rel_id;
		/*MODIFY Y USING*/
		{
		
		    /*Y.RDB$RELATION_ID*/
		    jrd_197.jrd_202 = --rel_id;
		    if (NULL_BLOB (blob_id))
			/*Y.RDB$DBKEY_LENGTH*/
			jrd_197.jrd_201 = 8;
		    else
			{ 
			/* update the dbkey length to include each of the base
			   relations */

			handle = NULL;
			/*Y.RDB$DBKEY_LENGTH*/
			jrd_197.jrd_201 = 0;
			/*FOR (REQUEST_HANDLE handle) 
				Z IN RDB$VIEW_RELATIONS CROSS
				R IN RDB$RELATIONS OVER RDB$RELATION_NAME WITH 
				Z.RDB$VIEW_NAME = work->dfw_name*/
			{
			if (!handle)
			   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_188, TRUE);
			gds__vtov (work->dfw_name, jrd_189.jrd_190, 32);
			EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
			EXE_send (tdbb, (REQ)handle, 0, 32, (UCHAR*)&jrd_189);
			while (1)
			   {
			   EXE_receive (tdbb, (REQ)handle, 1, 4, (UCHAR*)&jrd_191);
			   if (!jrd_191.jrd_192) break;
			    /*Y.RDB$DBKEY_LENGTH*/
			    jrd_197.jrd_201 += /*R.RDB$DBKEY_LENGTH*/
    jrd_191.jrd_193;
			/*END_FOR*/
			   }
			};
			CMP_release (tdbb, handle);
			}
		/*END_MODIFY*/
		jrd_204.jrd_205 = jrd_197.jrd_202;
		jrd_204.jrd_206 = jrd_197.jrd_201;
		EXE_send (tdbb, (REQ)request, 2, 4, (UCHAR*)&jrd_204);
		}
	    /*END_MODIFY*/
	    jrd_209.jrd_210 = jrd_197.jrd_203;
	    EXE_send (tdbb, (REQ)request, 4, 2, (UCHAR*)&jrd_209);
	    }
	/*END_FOR*/
	   EXE_send (tdbb, (REQ)request, 3, 2, (UCHAR*)&jrd_207);
	   }
	};

	LCK_release (tdbb, lock);
	ALL_release ((FRB) lock);
	work->dfw_lock = NULL;

	if (!REQUEST (irq_c_relation))
	    REQUEST (irq_c_relation) = (BLK) request;

	/* If relation wasn't found, don't do anymore. This can happen
	   when the relation is created and deleted in the same transaction. */

	if (!rel_id)
	    break;

	/* get the relation and flag it to check for dependencies
	   in the view blr (if it exists) and any computed fields */

	relation = MET_relation (tdbb, rel_id);
	relation->rel_flags |= REL_get_dependencies;

	/* if this is not a view, create the relation */

	if (NULL_BLOB (blob_id))
	    {
	    if (!external_flag)
		DPM_create_relation (tdbb, relation);
	    }
	break;
    }

return FALSE;
}   

static BOOLEAN create_trigger (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	c r e a t e _ t r i g g e r 
 *
 **************************************
 *
 * Functional description
 *	Perform required actions on creation of trigger.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	get_trigger_dependencies (work);
	break;
    }

return FALSE;
}

static BOOLEAN delete_exception (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ e x c e p t i o n
 *
 **************************************
 *
 * Functional description
 *	Check if it is allowable to delete
 *	an exception, and if so, clean up after it.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 0:
	return FALSE;

    case 1:
	check_dependencies (tdbb, work->dfw_name, NULL_PTR,
			obj_exception, transaction); 
	return TRUE;

    case 2:
	return TRUE;

    case 3:
	return TRUE;

    case 4:
	break;
    }

return FALSE;
}

static BOOLEAN delete_generator (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ g e n e r a t o r
 *
 **************************************
 *
 * Functional description
 *	Check if it is allowable to delete
 *	a generator, and if so, clean up after it.
 * CVC: This function was modelled after delete_exception.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 0:
	return FALSE;

    case 1:
	check_dependencies (tdbb, work->dfw_name, NULL_PTR,
			obj_generator, transaction); 
	return TRUE;

    case 2:
	return TRUE;

    case 3:
	return TRUE;

    case 4:
	break;
    }

return FALSE;
}

static BOOLEAN delete_udf (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ u d f
 *
 **************************************
 *
 * Functional description
 *	Check if it is allowable to delete
 *	an udf, and if so, clean up after it.
 * CVC: This function was modelled after delete_exception.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 0:
	return FALSE;

    case 1:
	check_dependencies (tdbb, work->dfw_name, NULL_PTR,
			obj_udf, transaction); 
	return TRUE;

    case 2:
	return TRUE;

    case 3:
	return TRUE;

    case 4:
	break;
    }

return FALSE;
}

static BOOLEAN delete_field (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          TEXT  jrd_185 [32];	/* RDB$FIELD_NAME */
          SSHORT jrd_186;	/* gds__utility */
          SSHORT jrd_187;	/* RDB$RELATION_ID */
   } jrd_184;
   struct {
          TEXT  jrd_183 [32];	/* RDB$FIELD_SOURCE */
   } jrd_182;
/**************************************
 *
 *	d e l e t e _ f i e l d
 *
 **************************************
 *
 * Functional description 
 *	This whole routine exists just to
 *	return an error if someone attempts to
 *	delete a global field that is in use
 *
 **************************************/
DBB	dbb;
int	field_count;
BLK	handle;

SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

switch (phase)
    {
    case 1:
	/* Look up the field in RFR.  If we can't find the field,
	   go ahead with the delete. */

	handle = NULL;
	field_count = 0;

	/*FOR (REQUEST_HANDLE handle)
		RFR IN RDB$RELATION_FIELDS CROSS
		REL IN RDB$RELATIONS
		OVER RDB$RELATION_NAME
		WITH RFR.RDB$FIELD_SOURCE EQ work->dfw_name*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_181, TRUE);
	gds__vtov (work->dfw_name, jrd_182.jrd_183, 32);
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 32, (UCHAR*)&jrd_182);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 36, (UCHAR*)&jrd_184);
	   if (!jrd_184.jrd_186) break;

	    /* If the rfr field is also being deleted, there's no dependency */

	    if (!find_depend_in_dfw (tdbb, /*RFR.RDB$FIELD_NAME*/
					   jrd_184.jrd_185,
					obj_computed,
					/*REL.RDB$RELATION_ID*/
					jrd_184.jrd_187, transaction))
		field_count++;
	/*END_FOR*/
	   }
	};
	CMP_release (tdbb, handle);

	if (field_count) 
           ERR_post (gds__no_meta_update,
	  	gds_arg_gds, gds__no_delete,    /* Msg353: can not delete */
		gds_arg_gds, gds__field_name,
		gds_arg_string, ERR_cstring (work->dfw_name),
		gds_arg_gds, gds__dependency,
		gds_arg_number, (SLONG) field_count,
		0);       /* Msg310: there are %ld dependencies */

    case 2:
	return TRUE;

    case 3:
	MET_delete_dependencies (tdbb, work->dfw_name, obj_computed);
	break;
    }

return FALSE;
}

static BOOLEAN delete_global (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_180;	/* gds__utility */
   } jrd_179;
   struct {
          TEXT  jrd_178 [32];	/* RDB$FIELD_NAME */
   } jrd_177;
/**************************************
 *
 *	d e l e t e _ g l o b a l
 *
 **************************************
 *
 * Functional description
 *	If a local field has been deleted,
 *	check to see if its global field
 *	is computed. If so, delete all its
 *	dependencies under the assumption
 *	that a global computed field has only
 *	one local field.
 *
 **************************************/
DBB	dbb;
BLK	handle;

SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	handle = NULL;
	/*FOR (REQUEST_HANDLE handle) 
	      FLD IN RDB$FIELDS WITH 
	      FLD.RDB$FIELD_NAME EQ work->dfw_name AND
	      FLD.RDB$COMPUTED_BLR NOT MISSING*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_176, TRUE);
	gds__vtov (work->dfw_name, jrd_177.jrd_178, 32);
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 32, (UCHAR*)&jrd_177);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 2, (UCHAR*)&jrd_179);
	   if (!jrd_179.jrd_180) break;
	    MET_delete_dependencies (tdbb, work->dfw_name, obj_computed);
	/*END_FOR*/
	   }
	};
	CMP_release (tdbb, handle);
	break;
    }

return FALSE;
}

static BOOLEAN delete_index (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ i n d e x
 *
 **************************************
 *
 * Functional description
 *
 **************************************/
IDL	index, *ptr;
IDB	index_block, *iptr;
REL	relation;
USHORT	id, wait;

SET_TDBB (tdbb);

switch (phase)
    {
    case 0:
	if (!(relation = MET_lookup_relation (tdbb, work->dfw_name)))
	    return FALSE;
	id = work->dfw_id - 1;
	if (index = CMP_get_index_lock (tdbb, relation, id))
	    if (!index->idl_count)
		LCK_release (tdbb, index->idl_lock);
	return FALSE;

    case 1:
    case 2:
	return TRUE;

    case 3:
	/* Look up the relation.  If we can't find the relation,
	   don't worry about the index. */

	if (!(relation = MET_lookup_relation (tdbb, work->dfw_name)))
	    return FALSE;

	/* Make sure nobody is currently using the index */

	id = work->dfw_id - 1;
	if (index = CMP_get_index_lock (tdbb, relation, id))
	    {
	    wait = (transaction->tra_flags & TRA_nowait) ? FALSE : TRUE;
	    if (index->idl_count || !LCK_lock_non_blocking (tdbb, index->idl_lock, LCK_EX, wait))
	    	ERR_post (gds__no_meta_update,
		    gds_arg_gds, gds__obj_in_use, gds_arg_string, "INDEX", 
		    0);
	    index->idl_count++;
	    }
    
	return TRUE;

    case 4:
	if (!(relation = MET_lookup_relation (tdbb, work->dfw_name)))
	    return FALSE;

	id = work->dfw_id - 1;
	index = CMP_get_index_lock (tdbb, relation, id);
	IDX_delete_index (tdbb, relation, id);
	if (work->dfw_type == dfw_delete_expression_index)
            MET_delete_dependencies (tdbb, work->dfw_name, obj_expression_index);

	if (index)
	    {
	    /* in order for us to have gotten the lock in phase 3
             * idl_count HAD to be 0, therefore after having incremented
             * it for the exclusive lock it would have to be 1.
	     * IF now it is NOT 1 then someone else got a lock to
	     * the index and something is seriously wrong */ 
	    assert (index->idl_count == 1);
	    if (!--index->idl_count)
		{
		/* Release index existence lock and memory. */

	    	for (ptr = &relation->rel_index_locks; *ptr; ptr = &(*ptr)->idl_next)
	    	    if (*ptr == index)
		    	{
		    	*ptr = index->idl_next;
		    	break;
		    	}
	    	if (index->idl_lock)
		    {
		    LCK_release (tdbb, index->idl_lock);
		    ALL_release ((FRB) index->idl_lock);
		    }
	    	ALL_release ((FRB) index);

		/* Release index refresh lock and memory. */

	    	for (iptr = &relation->rel_index_blocks; *iptr; iptr = &(*iptr)->idb_next)
	    	    if ((*iptr)->idb_id == id)
		    	{
			index_block = *iptr;
		    	*iptr = index_block->idb_next;

			/* Lock was released in IDX_delete_index(). */

	    		if (index_block->idb_lock)
		    	    ALL_release ((FRB) index_block->idb_lock);
	    		ALL_release ((FRB) index_block);
		    	break;
		    	}
		}
	    }
	break;
    }

return FALSE;
}

static BOOLEAN delete_log (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ l o g
 *
 **************************************
 *
 * Functional description
 *	Do work associated with the deletion of records in RDB$LOG_FILES
 *
 **************************************/
DBB	dbb;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
        if (CCH_exclusive (tdbb, LCK_EX, WAIT_PERIOD))
            return TRUE;
        else
            {
            ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__lock_timeout,
                gds_arg_gds, gds__obj_in_use,
                gds_arg_string, ERR_cstring (dbb->dbb_file->fil_string),
                0);
            return FALSE;
            }
    case 4:
	transaction->tra_flags |= TRA_delete_log;
	PAG_modify_log (transaction->tra_number, TRA_delete_log);
	return TRUE;

    case 5:
	CCH_release_exclusive (tdbb);
	break;
    }

return FALSE;
}

static BOOLEAN delete_parameter (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ p a r a m e t e r
 *
 **************************************
 *
 * Functional description 
 *	Return an error if someone attempts to
 *	delete a field from a procedure and it is
 *	used by a view or procedure.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 1:
	if (MET_lookup_procedure_id (tdbb, work->dfw_id, FALSE, 0))
	    check_dependencies (tdbb, work->dfw_name, work->dfw_name,
			obj_procedure, transaction); 

    case 2:
	return TRUE;

    case 3:
	break;
    }

return FALSE;
}

static BOOLEAN delete_procedure (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ p r o c e d u r e
 *
 **************************************
 *
 * Functional description
 *	Check if it is allowable to delete
 *	a procedure , and if so, clean up after it.
 *
 **************************************/
PRC	procedure;
USHORT	wait;
USHORT  old_flags;

SET_TDBB (tdbb);

switch (phase)
    {
    case 0:
	if (!(procedure = MET_lookup_procedure_id (tdbb, work->dfw_id, FALSE, 0)))
	    return FALSE;

	wait = (transaction->tra_flags & TRA_nowait) ? FALSE : TRUE;
	LCK_convert_non_blocking (tdbb, procedure->prc_existence_lock, LCK_SR, wait);
	return FALSE;

    case 1:
	check_dependencies (tdbb, work->dfw_name, NULL_PTR,
			obj_procedure, transaction); 
	return TRUE;

    case 2:
	if (!(procedure = MET_lookup_procedure_id (tdbb, work->dfw_id, FALSE, 0)))
	    return FALSE;

	wait = (transaction->tra_flags & TRA_nowait) ? FALSE : TRUE;
	if (!LCK_convert_non_blocking (tdbb, procedure->prc_existence_lock,
			LCK_EX, wait))
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__obj_in_use, 
		gds_arg_string, ERR_cstring (work->dfw_name), 
		0);

	/* If we are in a multi-client server, someone else may have marked
	   procedure obsolete. Unmark and we will remark it later. */

	procedure->prc_flags &= ~PRC_obsolete;
	return TRUE;

    case 3:
	return TRUE;

    case 4:
	if (!(procedure = MET_lookup_procedure_id (tdbb, work->dfw_id, TRUE, 0)))
	    return FALSE;

        if (procedure->prc_use_count)
	    {
	    MET_delete_dependencies (tdbb, work->dfw_name, obj_procedure);

	    LCK_release (tdbb, procedure->prc_existence_lock);
	    tdbb->tdbb_database->dbb_procedures->vec_object[procedure->prc_id] = NULL_PTR;
	    return FALSE;
	    }

	old_flags = procedure->prc_flags;
	procedure->prc_flags |= PRC_obsolete;
	if (procedure->prc_request)
	    {
	    if (CMP_clone_active (procedure->prc_request))
		{
	        procedure->prc_flags = old_flags;
		ERR_post (gds__no_meta_update,
		    gds_arg_gds, gds__obj_in_use,
		    gds_arg_string, ERR_cstring (work->dfw_name),
		    0);
		}

	    CMP_release (tdbb, procedure->prc_request);
	    procedure->prc_request = 0;
	    }

	/* delete dependency lists */

	MET_delete_dependencies (tdbb, work->dfw_name, obj_procedure);

	LCK_release (tdbb, procedure->prc_existence_lock);
	break;
    }

return FALSE;
}

static BOOLEAN delete_relation (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_169;	/* gds__utility */
   } jrd_168;
   struct {
          SSHORT jrd_167;	/* gds__utility */
   } jrd_166;
   struct {
          SSHORT jrd_165;	/* gds__utility */
   } jrd_164;
   struct {
          SSHORT jrd_163;	/* RDB$RELATION_ID */
   } jrd_162;
   struct {
          TEXT  jrd_174 [32];	/* RDB$VIEW_NAME */
          SSHORT jrd_175;	/* gds__utility */
   } jrd_173;
   struct {
          TEXT  jrd_172 [32];	/* RDB$RELATION_NAME */
   } jrd_171;
/**************************************
 *
 *	d e l e t e _ r e l a t i o n
 *
 **************************************
 *
 * Functional description
 *	Check if it is allowable to delete
 *	a relation, and if so, clean up after it.
 *
 **************************************/
DBB	dbb;
REQ	request;
REL	relation;
RSC	rsc;
USHORT	wait, view_count, adjusted;

SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

switch (phase)
    {
    case 0:
	if (!(relation = MET_lookup_relation_id (tdbb, work->dfw_id, FALSE)))
	    return FALSE;

	if (relation->rel_existence_lock)
	    {
 	    wait = (transaction->tra_flags & TRA_nowait) ? FALSE : TRUE;
	    LCK_convert_non_blocking (tdbb, relation->rel_existence_lock, LCK_SR, wait);
	    }

	relation->rel_flags &= ~REL_deleting;
	return FALSE;

    case 1:
	/* check if any views use this as a base relation */

	request = NULL;
	view_count = 0;
	/*FOR (REQUEST_HANDLE request) 
	    X IN RDB$VIEW_RELATIONS WITH
	    X.RDB$RELATION_NAME EQ work->dfw_name*/
	{
	if (!request)
	   request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_170, TRUE);
	gds__vtov (work->dfw_name, jrd_171.jrd_172, 32);
	EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)request, 0, 32, (UCHAR*)&jrd_171);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)request, 1, 34, (UCHAR*)&jrd_173);
	   if (!jrd_173.jrd_175) break;

	    /* If the view is also being deleted, there's no dependency */

	    if (!find_depend_in_dfw (tdbb, /*X.RDB$VIEW_NAME*/
					   jrd_173.jrd_174, obj_view, 0,
					transaction))
		view_count++;

	/*END_FOR*/
	   }
	};
	CMP_release (tdbb, request);

        if (view_count)
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__no_delete,    /* Msg353: can not delete */
		gds_arg_gds, gds__table_name, 
		gds_arg_string, ERR_cstring (work->dfw_name),
		gds_arg_gds, gds__dependency,
		gds_arg_number, (SLONG) view_count,
		0);	    /* Msg310: there are %ld dependencies */
	check_dependencies (tdbb, work->dfw_name, NULL_PTR,
			obj_relation, transaction); 
	return TRUE;

    case 2:
	if (!(relation = MET_lookup_relation_id (tdbb, work->dfw_id, FALSE)))
	    return FALSE;

	/* Let relation be deleted if only this transaction is using it */

	adjusted = FALSE;
	if (relation->rel_use_count == 1)
	    for (rsc = transaction->tra_resources; rsc; rsc = rsc->rsc_next)
		if (rsc->rsc_rel == relation)
		    {
		    --relation->rel_use_count;
		    adjusted = TRUE;
		    break;
		    }

	wait = (transaction->tra_flags & TRA_nowait) ? FALSE : TRUE;
	if (relation->rel_use_count ||
	    (relation->rel_existence_lock &&
	     !LCK_convert_non_blocking (tdbb, relation->rel_existence_lock, LCK_EX, wait)))
	    {
	    if (adjusted)
		++relation->rel_use_count;
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__obj_in_use,
		gds_arg_string, ERR_cstring (work->dfw_name), 
		0);
	    }
	return TRUE;

    case 3:
	return TRUE;

    case 4:
	if (!(relation = MET_lookup_relation_id (tdbb, work->dfw_id, TRUE)))
	    return FALSE;

	/* Flag relation delete in progress so that active sweep or
	   garbage collector threads working on relation can skip over it. */

	relation->rel_flags |= REL_deleting;

	/* The sweep and garbage collector threads have no more than
	   a single record latency in responding to the flagged relation
	   deletion. Nevertheless, as a defensive programming measure,
	   don't wait forever if something has gone awry and the sweep
	   count doesn't run down. */

	for (wait = 0; wait < 60; wait++)
	    if (!relation->rel_sweep_count)
		break;
	    else
		{
		THREAD_EXIT;
		THREAD_SLEEP(1*1000);
		THREAD_ENTER;
		}

	if (relation->rel_sweep_count)
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__obj_in_use,
		gds_arg_string, ERR_cstring (work->dfw_name), 
		0);

#ifdef GARBAGE_THREAD
	/* Free any memory associated with the relation's
	   garbage collection bitmap. */

	if (relation->rel_gc_bitmap)
	    {
	    SBM_release (relation->rel_gc_bitmap);
	    relation->rel_gc_bitmap = NULL_PTR;
	    }
#endif
	if (relation->rel_file)
	    EXT_fini (relation);

	if (relation->rel_index_root)
	    IDX_delete_indices (tdbb, relation);

	if (relation->rel_pages)
	    DPM_delete_relation (tdbb, relation);

	/* if this is a view (or even if we don't know),
	   delete dependency lists */

	if (relation->rel_view_rse || !(relation->rel_flags & REL_scanned))
	    MET_delete_dependencies (tdbb, work->dfw_name, obj_view);

	/* Now that the data, pointer, and index pages are gone,
	   get rid of formats as well */

	if (relation->rel_existence_lock)
	    LCK_release (tdbb, relation->rel_existence_lock);
	request = NULL;

	/*FOR (REQUEST_HANDLE request) X IN RDB$FORMATS WITH 
		X.RDB$RELATION_ID EQ relation->rel_id*/
	{
	if (!request)
	   request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_161, TRUE);
	jrd_162.jrd_163 = relation->rel_id;
	EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)request, 0, 2, (UCHAR*)&jrd_162);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)request, 1, 2, (UCHAR*)&jrd_164);
	   if (!jrd_164.jrd_165) break;
	    /*ERASE X*/
	    EXE_send (tdbb, (REQ)request, 2, 2, (UCHAR*)&jrd_166);;
	/*END_FOR*/
	   EXE_send (tdbb, (REQ)request, 3, 2, (UCHAR*)&jrd_168);
	   }
	};

	relation->rel_name = NULL;
	relation->rel_flags |= REL_deleted;
	relation->rel_flags &= ~REL_deleting;
	CMP_release (tdbb, request);
	break;
    }

return FALSE;
}

static BOOLEAN delete_rfr (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_147;	/* gds__utility */
   } jrd_146;
   struct {
          SSHORT jrd_145;	/* RDB$RELATION_ID */
   } jrd_144;
   struct {
          SSHORT jrd_152;	/* gds__utility */
   } jrd_151;
   struct {
          SSHORT jrd_150;	/* RDB$RELATION_ID */
   } jrd_149;
   struct {
          TEXT  jrd_158 [32];	/* RDB$BASE_FIELD */
          TEXT  jrd_159 [32];	/* RDB$VIEW_NAME */
          SSHORT jrd_160;	/* gds__utility */
   } jrd_157;
   struct {
          TEXT  jrd_155 [32];	/* RDB$BASE_FIELD */
          SSHORT jrd_156;	/* RDB$RELATION_ID */
   } jrd_154;
/**************************************
 *
 *	d e l e t e _ r f r
 *
 **************************************
 *
 * Functional description 
 *	This whole routine exists just to
 *	return an error if someone attempts to
 *	1. delete a field from a relation if the relation
 *		is used in a view and the field is referenced in
 *		the view.  
 *	2. drop the last column of a table
 *
 **************************************/
DBB	dbb;
int	rel_exists, field_count, id;
BLK	handle;
TEXT	f [32];
REL	relation;
VEC	vector;

SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

switch (phase)
    {
    case 1:
	/* first check if there are any fields used explicitly by the view */

	handle = NULL;
	field_count = 0;
	/*FOR (REQUEST_HANDLE handle)
		REL IN RDB$RELATIONS CROSS
		VR IN RDB$VIEW_RELATIONS OVER RDB$RELATION_NAME CROSS
		VFLD IN RDB$RELATION_FIELDS WITH  
		REL.RDB$RELATION_ID EQ work->dfw_id AND
		VFLD.RDB$VIEW_CONTEXT EQ VR.RDB$VIEW_CONTEXT AND
                VFLD.RDB$RELATION_NAME EQ VR.RDB$VIEW_NAME AND
		VFLD.RDB$BASE_FIELD EQ work->dfw_name*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_153, TRUE);
	gds__vtov (work->dfw_name, jrd_154.jrd_155, 32);
	jrd_154.jrd_156 = work->dfw_id;
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 34, (UCHAR*)&jrd_154);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 66, (UCHAR*)&jrd_157);
	   if (!jrd_157.jrd_160) break; 

	    /* If the view is also being deleted, there's no dependency */

	    if (!find_depend_in_dfw (tdbb, /*VR.RDB$VIEW_NAME*/
					   jrd_157.jrd_159, obj_view,
					0, transaction))
		{
			TEXT *p = f, *endp = f + sizeof(f)-1, *q;
			for (q = /*VFLD.RDB$BASE_FIELD*/
				 jrd_157.jrd_158; *q && p < endp; *p++ = *q++)
				;
			*p = 0;
			MET_exact_name(f);
			field_count++;
		}
	/*END_FOR*/
	   }
	};
	CMP_release (tdbb, handle);

        if (field_count)
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__no_delete,    /* Msg353: can not delete */
		gds_arg_gds, gds__field_name, gds_arg_string, ERR_cstring (f),
		gds_arg_gds, gds__dependency, 
		gds_arg_number, (SLONG) field_count,
		0);       /* Msg310: there are %ld dependencies */

	/* now check if there are any dependencies generated through the blr
	   that defines the relation */
	     
	if (relation = MET_lookup_relation_id (tdbb, work->dfw_id, FALSE))
	    check_dependencies (tdbb, relation->rel_name, work->dfw_name,
				obj_relation, transaction);

	/* see if the relation itself is being dropped */

	handle = NULL;
	rel_exists = 0;
	/*FOR (REQUEST_HANDLE handle)
		REL IN RDB$RELATIONS WITH REL.RDB$RELATION_ID EQ work->dfw_id*/
	{
	if (!handle)
	   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_148, TRUE);
	jrd_149.jrd_150 = work->dfw_id;
	EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)handle, 0, 2, (UCHAR*)&jrd_149);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)handle, 1, 2, (UCHAR*)&jrd_151);
	   if (!jrd_151.jrd_152) break;
	    rel_exists++;
	/*END_FOR*/
	   }
	};
	if (handle)
	    CMP_release (tdbb, handle);

	/* if table exists, check if this is the last column in the table */

	if (rel_exists)
	    {
	    field_count = 0;
	    handle = NULL;

	    /*FOR (REQUEST_HANDLE handle)
		REL IN RDB$RELATIONS CROSS
		RFLD IN RDB$RELATION_FIELDS OVER RDB$RELATION_NAME WITH
		REL.RDB$RELATION_ID EQ work->dfw_id*/
	    {
	    if (!handle)
	       handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_143, TRUE);
	    jrd_144.jrd_145 = work->dfw_id;
	    EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
	    EXE_send (tdbb, (REQ)handle, 0, 2, (UCHAR*)&jrd_144);
	    while (1)
	       {
	       EXE_receive (tdbb, (REQ)handle, 1, 2, (UCHAR*)&jrd_146);
	       if (!jrd_146.jrd_147) break;

		field_count++;
	    /*END_FOR*/
	       }
	    };
	    if (handle)
		CMP_release (tdbb, handle);

	    if (!field_count)
                ERR_post (gds__no_meta_update,
		    gds_arg_gds, gds__del_last_field,
		    0);
		    /* Msg354: last column in a relation cannot be deleted */
	    }

    case 2:
	return TRUE;

    case 3:
	/* Unlink field from data structures.  Don't try to actually release field and
	   friends -- somebody may be pointing to them */

	if ((relation = MET_lookup_relation_id (tdbb, work->dfw_id, FALSE)) &&
	    (id = MET_lookup_field (tdbb, relation, work->dfw_name, 0)) >= 0 &&
	    (vector = relation->rel_fields) &&
	    id < vector->vec_count &&
	    vector->vec_object [id])
	    {
	    vector->vec_object [id] = NULL;
	    }
	break;
    }

return FALSE;
}

static BOOLEAN delete_shadow (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ s h a d o w
 *
 **************************************
 *
 * Functional description 
 *	Provide deferred work interface to 
 *	MET_delete_shadow.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	MET_delete_shadow (tdbb, work->dfw_id);
	break;
    }

return FALSE;
}

static BOOLEAN delete_trigger (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	d e l e t e _ t r i g g e r 
 *
 **************************************
 *
 * Functional description
 *	Cleanup after a deleted trigger.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	/* get rid of dependencies */

	MET_delete_dependencies (tdbb, work->dfw_name, obj_trigger);
	break;
    }

return FALSE;
}

static BOOLEAN find_depend_in_dfw (
    TDBB	tdbb,
    TEXT	*object_name,
    USHORT	dep_type,
    USHORT	rel_id,
    TRA		transaction)
{
   struct {
          TEXT  jrd_140 [32];	/* RDB$FIELD_NAME */
          SSHORT jrd_141;	/* gds__utility */
          SSHORT jrd_142;	/* RDB$RELATION_ID */
   } jrd_139;
   struct {
          TEXT  jrd_138 [32];	/* RDB$FIELD_NAME */
   } jrd_137;
/**************************************
 *
 *	f i n d _ d e p e n d _ i n _ d f w
 *
 **************************************
 *
 * Functional description
 *	Check the object to see if it is being
 *	deleted as part of the deferred work.
 *	Return TRUE if it is, FALSE otherwise.
 *
 **************************************/
DBB		dbb;
REQ		request;
ENUM dfw_t	dfw_type;
DFW		work;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

MET_exact_name(object_name);

switch (dep_type)
    {
    case obj_view:
	dfw_type = dfw_delete_relation;
	break;
    case obj_trigger:
	dfw_type = dfw_delete_trigger;
	break;
    case obj_computed:
	dfw_type = (rel_id) ? dfw_delete_rfr : dfw_delete_global;
	break;
    case obj_procedure:
	dfw_type = dfw_delete_procedure;
	break;
    case obj_expression_index:
	dfw_type = dfw_delete_index;
	break;  
    default:
	assert (FALSE);
	break;
    }

/* Look to see if an object of the desired type is being deleted. */

for (work = transaction->tra_deferred_work; work; work = work->dfw_next)
    if (work->dfw_type == dfw_type &&
	!strcmp (object_name, work->dfw_name) &&
	(!rel_id || rel_id == work->dfw_id))
	return TRUE;

if (dfw_type == dfw_delete_global)
    {
    /* Computed fields are more complicated.  If the global field isn't being
       deleted, see if all of the fields it is the source for, are. */

    request = (REQ) CMP_find_request (tdbb, irq_ch_cmp_dpd, IRQ_REQUESTS);

    /*FOR (REQUEST_HANDLE request)
	    FLD IN RDB$FIELDS CROSS
	    RFR IN RDB$RELATION_FIELDS CROSS
	    REL IN RDB$RELATIONS
	    WITH FLD.RDB$FIELD_NAME EQ RFR.RDB$FIELD_SOURCE
	    AND FLD.RDB$FIELD_NAME EQ object_name
	    AND REL.RDB$RELATION_NAME EQ RFR.RDB$RELATION_NAME*/
    {
    if (!request)
       request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_136, TRUE);
    gds__vtov (object_name, jrd_137.jrd_138, 32);
    EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)request, 0, 32, (UCHAR*)&jrd_137);
    while (1)
       {
       EXE_receive (tdbb, (REQ)request, 1, 36, (UCHAR*)&jrd_139);
       if (!jrd_139.jrd_141) break;
	if (!REQUEST (irq_ch_cmp_dpd))
	    REQUEST (irq_ch_cmp_dpd) = (BLK) request;
	if (!find_depend_in_dfw (tdbb, /*RFR.RDB$FIELD_NAME*/
				       jrd_139.jrd_140, obj_computed,
				 /*REL.RDB$RELATION_ID*/
				 jrd_139.jrd_142, transaction))
	    {
	    EXE_unwind (tdbb, request);
	    return FALSE;
	    }
    /*END_FOR*/
       }
    };

    if (!REQUEST (irq_ch_cmp_dpd))
	REQUEST (irq_ch_cmp_dpd) = (BLK) request;

    return TRUE;
    }

return FALSE;
}

static void get_array_desc (
    TDBB	tdbb,
    TEXT	*field_name,
    ADS		desc)
{
   struct {
          SLONG  jrd_132;	/* RDB$UPPER_BOUND */
          SLONG  jrd_133;	/* RDB$LOWER_BOUND */
          SSHORT jrd_134;	/* gds__utility */
          SSHORT jrd_135;	/* RDB$DIMENSION */
   } jrd_131;
   struct {
          TEXT  jrd_130 [32];	/* RDB$FIELD_NAME */
   } jrd_129;
/**************************************
 *
 *	g e t _ a r r a y _ d e s c
 *
 **************************************
 *
 * Functional description
 *	Get array descriptor for an array.
 *
 **************************************/
DBB			dbb;
REQ			request;
struct ads_repeat	*ranges;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

request = (REQ) CMP_find_request (tdbb, irq_r_fld_dim, IRQ_REQUESTS);

/*FOR (REQUEST_HANDLE request) 
    D IN RDB$FIELD_DIMENSIONS WITH D.RDB$FIELD_NAME EQ field_name*/
{
if (!request)
   request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_128, TRUE);
gds__vtov (field_name, jrd_129.jrd_130, 32);
EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)request, 0, 32, (UCHAR*)&jrd_129);
while (1)
   {
   EXE_receive (tdbb, (REQ)request, 1, 12, (UCHAR*)&jrd_131);
   if (!jrd_131.jrd_134) break;
    if (!REQUEST (irq_r_fld_dim))
	REQUEST (irq_r_fld_dim) = (BLK) request;
    if (/*D.RDB$DIMENSION*/
	jrd_131.jrd_135 >= 0 && /*D.RDB$DIMENSION*/
	 jrd_131.jrd_135 < desc->ads_dimensions)
	{
	ranges = desc->ads_rpt + /*D.RDB$DIMENSION*/
				 jrd_131.jrd_135;
	ranges->ads_lower = /*D.RDB$LOWER_BOUND*/
			    jrd_131.jrd_133;
	ranges->ads_upper = /*D.RDB$UPPER_BOUND*/
			    jrd_131.jrd_132;
	}
/*END_FOR*/
   }
};

if (!REQUEST (irq_r_fld_dim))
    REQUEST (irq_r_fld_dim) = request;

desc->ads_count = 1;

for (ranges = desc->ads_rpt + desc->ads_dimensions; --ranges >= desc->ads_rpt;)
    {
    ranges->ads_length = desc->ads_count;
    desc->ads_count *= ranges->ads_upper - ranges->ads_lower + 1;
    }

desc->ads_version = ADS_VERSION_1;
desc->ads_length = ADS_LEN (MAX (desc->ads_struct_count, desc->ads_dimensions));
desc->ads_element_length = desc->ads_rpt [0].ads_desc.dsc_length;
desc->ads_total_length = desc->ads_element_length * desc->ads_count;
}

static void get_procedure_dependencies (
    DFW	work)
{
   struct {
          GDS__QUAD  jrd_126;	/* RDB$PROCEDURE_BLR */
          SSHORT jrd_127;	/* gds__utility */
   } jrd_125;
   struct {
          TEXT  jrd_124 [32];	/* RDB$PROCEDURE_NAME */
   } jrd_123;
/**************************************
 *
 *	g e t _ p r o c e d u r e _ d e p e n d e n c i e s
 *
 **************************************
 *
 * Functional description
 *	Get relations and fields on which this
 *	procedure depends, either when it's being
 *	created or when it's modified.
 *
 **************************************/
TDBB		tdbb;
DBB		dbb;
PRC		procedure;
GDS__QUAD	blob_id;
REQ		request;
BLK		handle;      
PLB		old_pool;

tdbb = GET_THREAD_DATA;
dbb =  tdbb->tdbb_database;

procedure = NULL;

handle = (BLK) CMP_find_request (tdbb, irq_c_prc_dpd, IRQ_REQUESTS);

/*FOR (REQUEST_HANDLE handle) 
	X IN RDB$PROCEDURES WITH
	X.RDB$PROCEDURE_NAME EQ work->dfw_name*/
{
if (!handle)
   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_122, TRUE);
gds__vtov (work->dfw_name, jrd_123.jrd_124, 32);
EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)handle, 0, 32, (UCHAR*)&jrd_123);
while (1)
   {
   EXE_receive (tdbb, (REQ)handle, 1, 10, (UCHAR*)&jrd_125);
   if (!jrd_125.jrd_127) break;

    if (!REQUEST (irq_c_prc_dpd))
	REQUEST (irq_c_prc_dpd) = handle;
    blob_id = /*X.RDB$PROCEDURE_BLR*/
	      jrd_125.jrd_126;
    procedure = MET_lookup_procedure (tdbb, work->dfw_name);

/*END_FOR*/
   }
};

if (!REQUEST (irq_c_prc_dpd))
    REQUEST (irq_c_prc_dpd) = handle;

/* get any dependencies now by parsing the blr */

if (procedure && !NULL_BLOB (blob_id))
    {
    old_pool = tdbb->tdbb_default;
    tdbb->tdbb_default = ALL_pool();
    MET_get_dependencies (tdbb, NULL_PTR, 
		      NULL_PTR, 
		      NULL_PTR, 
		      &blob_id,
		      &request, 
		      NULL_PTR, 
		      work->dfw_name, 
		      obj_procedure);
    if (request)
	CMP_release (tdbb, request);
    else
	ALL_rlpool (tdbb->tdbb_default);

    tdbb->tdbb_default = old_pool;
    }
}

static void get_trigger_dependencies (
    DFW	work)
{
   struct {
          TEXT  jrd_119 [32];	/* RDB$RELATION_NAME */
          GDS__QUAD  jrd_120;	/* RDB$TRIGGER_BLR */
          SSHORT jrd_121;	/* gds__utility */
   } jrd_118;
   struct {
          TEXT  jrd_117 [32];	/* RDB$TRIGGER_NAME */
   } jrd_116;
/**************************************
 *
 *	g e t _ t r i g g e r _ d e p e n d e n c i e s
 *
 **************************************
 *
 * Functional description
 *	Get relations and fields on which this
 *	trigger depends, either when it's being
 *	created or when it's modified.
 *
 **************************************/
TDBB		tdbb;
DBB		dbb;
REL		relation;
GDS__QUAD	blob_id;
REQ		request;
BLK		handle;      
PLB		old_pool;

tdbb = GET_THREAD_DATA;
dbb =  tdbb->tdbb_database;

relation = NULL;

handle = (BLK) CMP_find_request (tdbb, irq_c_trigger, IRQ_REQUESTS);

/*FOR (REQUEST_HANDLE handle) 
	X IN RDB$TRIGGERS WITH
	X.RDB$TRIGGER_NAME EQ work->dfw_name*/
{
if (!handle)
   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_115, TRUE);
gds__vtov (work->dfw_name, jrd_116.jrd_117, 32);
EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)handle, 0, 32, (UCHAR*)&jrd_116);
while (1)
   {
   EXE_receive (tdbb, (REQ)handle, 1, 42, (UCHAR*)&jrd_118);
   if (!jrd_118.jrd_121) break;

    if (!REQUEST (irq_c_trigger))
	REQUEST (irq_c_trigger) = handle;
    blob_id = /*X.RDB$TRIGGER_BLR*/
	      jrd_118.jrd_120;
    relation = MET_lookup_relation (tdbb, /*X.RDB$RELATION_NAME*/
					  jrd_118.jrd_119);

/*END_FOR*/
   }
};

if (!REQUEST (irq_c_trigger))
    REQUEST (irq_c_trigger) = handle;

/* get any dependencies now by parsing the blr */

if (relation && !NULL_BLOB (blob_id))
    {
    old_pool = tdbb->tdbb_default;
    tdbb->tdbb_default = ALL_pool();
    MET_get_dependencies (tdbb, relation, 
		      NULL_PTR, 
		      NULL_PTR, 
		      &blob_id,
		      &request, 
		      NULL_PTR, 
		      work->dfw_name, 
		      obj_trigger);
    ALL_rlpool (tdbb->tdbb_default);
    tdbb->tdbb_default = old_pool;
    }
}

static void load_trigs (
    TDBB	tdbb,
    REL		relation,
    VEC		* triggers)
{
/**************************************
 *
 *	l o a d _ t r i g s
 *
 **************************************
 *
 * Functional description
 *	We have just loaded the triggers onto the local vector 
 *      triggers. Its now time to place them at their rightful 
 *      place ie the relation block. 
 *
 **************************************/
VEC tmp_vector;

tmp_vector = relation->rel_pre_store;
relation->rel_pre_store = triggers [TRIGGER_PRE_STORE];
MET_release_triggers (tdbb, &tmp_vector);

tmp_vector = relation->rel_post_store;
relation->rel_post_store = triggers [TRIGGER_POST_STORE];
MET_release_triggers (tdbb, &tmp_vector);

tmp_vector = relation->rel_pre_erase;
relation->rel_pre_erase = triggers [TRIGGER_PRE_ERASE];
MET_release_triggers (tdbb, &tmp_vector);

tmp_vector = relation->rel_post_erase;
relation->rel_post_erase = triggers [TRIGGER_POST_ERASE];
MET_release_triggers (tdbb, &tmp_vector);

tmp_vector = relation->rel_pre_modify;
relation->rel_pre_modify = triggers [TRIGGER_PRE_MODIFY];
MET_release_triggers (tdbb, &tmp_vector);

tmp_vector = relation->rel_post_modify;
relation->rel_post_modify = triggers [TRIGGER_POST_MODIFY];
MET_release_triggers (tdbb, &tmp_vector);

}

static FMT make_format (
    TDBB	tdbb,
    REL		relation,
    USHORT	* version,
    TFB		stack)
{
   struct {
          GDS__QUAD  jrd_112;	/* RDB$DESCRIPTOR */
          SSHORT jrd_113;	/* RDB$RELATION_ID */
          SSHORT jrd_114;	/* RDB$FORMAT */
   } jrd_111;
/**************************************
 *
 *	m a k e _ f o r m a t
 *
 **************************************
 *
 * Functional description
 *	Make a format block for a relation.
 *
 **************************************/
DBB	dbb;
BLK	request;
FMT	format, old_format;
VEC	vector;
TFB	tfb;
BLB	blob;
USHORT	count;
ULONG	offset, old_offset;
DSC	*desc;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

/* Figure out the highest field id and allocate a format block */

count = 0;
for (tfb = stack; tfb; tfb = tfb->tfb_next)
    count = MAX (count, tfb->tfb_id);

format = (FMT) ALLOCPV (type_fmt, count + 1);
format->fmt_count = count + 1;
if (version)
	format->fmt_version = *version;

/* Fill in the format block from the temporary field blocks */

for (tfb = stack; tfb; tfb = tfb->tfb_next)
    {
    desc = format->fmt_desc + tfb->tfb_id;
    if (tfb->tfb_flags & TFB_array)
	{
	desc->dsc_dtype = dtype_array;
	desc->dsc_length = sizeof (GDS__QUAD);
	}
    else
	*desc = tfb->tfb_desc;
    if (tfb->tfb_flags & TFB_computed)
	desc->dsc_dtype |= COMPUTED_FLAG;
    }

/* Compute the offsets of the various fields */

offset = FLAG_BYTES (count);

for (count = 0, desc = format->fmt_desc; count < format->fmt_count; count++, desc++)
    {
    if (desc->dsc_dtype & COMPUTED_FLAG)
	{
	desc->dsc_dtype &= ~COMPUTED_FLAG;
	continue;
	}
    if (desc->dsc_dtype)
	{
	old_offset = offset;
	offset = MET_align (desc, (USHORT)offset);

	/* see of record too big */

	if ( offset < old_offset)
	    {
	    offset += 65536L;
	    break;
	    }
	desc->dsc_address = (UCHAR*) (SLONG) offset;
	offset += desc->dsc_length;
	}
    }

format->fmt_length = offset;

/* Release the temporary field blocks */

while (tfb = stack)
    {
    stack = tfb->tfb_next;
    ALL_release ((FRB) tfb);
    }

if (offset > MAX_FORMAT_SIZE)
    {
    ALL_release ((FRB) format);
    ERR_post (gds__no_meta_update,
	gds_arg_gds, gds__rec_size_err, gds_arg_number, (SLONG) offset,
	gds_arg_gds, gds__table_name, gds_arg_string, ERR_cstring (relation->rel_name),
	0);
	/* Msg361: new record size of %ld bytes is too big */
    }

if ((format->fmt_version)
    && (old_format = MET_format (tdbb, relation, (format->fmt_version - 1)))    
    && (!compare_formats (old_format, format)))
    {
    ALL_release ((FRB) format);
    *version = old_format->fmt_version;
    return old_format;
    }

/* Link the format block into the world */

vector = ALL_vector (dbb->dbb_permanent, &relation->rel_formats, format->fmt_version);
vector->vec_object [format->fmt_version] = (BLK) format;

/* Store format in system relation */

request = (BLK) CMP_find_request (tdbb, irq_format3, IRQ_REQUESTS);

/*STORE (REQUEST_HANDLE request)
	FMT IN RDB$FORMATS*/
{

    if (!REQUEST (irq_format3))
	REQUEST (irq_format3) = request;
    /*FMT.RDB$FORMAT*/
    jrd_111.jrd_114 = format->fmt_version;
    /*FMT.RDB$RELATION_ID*/
    jrd_111.jrd_113 = relation->rel_id;
    blob = BLB_create (tdbb, dbb->dbb_sys_trans, &/*FMT.RDB$DESCRIPTOR*/
						  jrd_111.jrd_112);
    BLB_put_segment (tdbb, blob, format->fmt_desc, format->fmt_count * sizeof (struct dsc));
    BLB_close (tdbb, blob);
/*END_STORE*/
if (!request)
   request = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_110, TRUE);
EXE_start (tdbb, (REQ)request, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)request, 0, 12, (UCHAR*)&jrd_111);
};

if (!REQUEST (irq_format3))
    REQUEST (irq_format3) = request;

return format;
}

static BOOLEAN make_version (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
   struct {
          SSHORT jrd_38;	/* gds__utility */
   } jrd_37;
   struct {
          SSHORT jrd_36;	/* gds__utility */
   } jrd_35;
   struct {
          SSHORT jrd_34;	/* gds__utility */
   } jrd_33;
   struct {
          SSHORT jrd_32;	/* RDB$RELATION_ID */
   } jrd_31;
   struct {
          SSHORT jrd_43;	/* gds__utility */
   } jrd_42;
   struct {
          TEXT  jrd_41 [32];	/* RDB$RELATION_NAME */
   } jrd_40;
   struct {
          SSHORT jrd_90;	/* gds__utility */
   } jrd_89;
   struct {
          SSHORT jrd_83;	/* gds__null_flag */
          SSHORT jrd_84;	/* RDB$FIELD_ID */
          SSHORT jrd_85;	/* gds__null_flag */
          SSHORT jrd_86;	/* RDB$UPDATE_FLAG */
          SSHORT jrd_87;	/* gds__null_flag */
          SSHORT jrd_88;	/* RDB$FIELD_POSITION */
   } jrd_82;
   struct {
          TEXT  jrd_48 [32];	/* RDB$FIELD_NAME */
          TEXT  jrd_49 [32];	/* RDB$SECURITY_CLASS */
          GDS__QUAD  jrd_50;	/* RDB$VALIDATION_BLR */
          GDS__QUAD  jrd_51;	/* RDB$DEFAULT_VALUE */
          GDS__QUAD  jrd_52;	/* RDB$DEFAULT_VALUE */
          GDS__QUAD  jrd_53;	/* RDB$MISSING_VALUE */
          TEXT  jrd_54 [32];	/* RDB$BASE_FIELD */
          TEXT  jrd_55 [32];	/* RDB$FIELD_NAME */
          GDS__QUAD  jrd_56;	/* RDB$COMPUTED_BLR */
          SSHORT jrd_57;	/* gds__utility */
          SSHORT jrd_58;	/* RDB$EXTERNAL_LENGTH */
          SSHORT jrd_59;	/* RDB$EXTERNAL_SCALE */
          SSHORT jrd_60;	/* RDB$EXTERNAL_TYPE */
          SSHORT jrd_61;	/* RDB$DIMENSIONS */
          SSHORT jrd_62;	/* RDB$FIELD_SUB_TYPE */
          SSHORT jrd_63;	/* RDB$FIELD_LENGTH */
          SSHORT jrd_64;	/* RDB$FIELD_SCALE */
          SSHORT jrd_65;	/* RDB$FIELD_TYPE */
          SSHORT jrd_66;	/* gds__null_flag */
          SSHORT jrd_67;	/* RDB$COLLATION_ID */
          SSHORT jrd_68;	/* gds__null_flag */
          SSHORT jrd_69;	/* RDB$COLLATION_ID */
          SSHORT jrd_70;	/* gds__null_flag */
          SSHORT jrd_71;	/* RDB$CHARACTER_SET_ID */
          SSHORT jrd_72;	/* gds__null_flag */
          SSHORT jrd_73;	/* RDB$NULL_FLAG */
          SSHORT jrd_74;	/* RDB$NULL_FLAG */
          SSHORT jrd_75;	/* RDB$VIEW_CONTEXT */
          SSHORT jrd_76;	/* gds__null_flag */
          SSHORT jrd_77;	/* RDB$FIELD_POSITION */
          SSHORT jrd_78;	/* gds__null_flag */
          SSHORT jrd_79;	/* RDB$UPDATE_FLAG */
          SSHORT jrd_80;	/* gds__null_flag */
          SSHORT jrd_81;	/* RDB$FIELD_ID */
   } jrd_47;
   struct {
          TEXT  jrd_46 [32];	/* RDB$RELATION_NAME */
   } jrd_45;
   struct {
          SSHORT jrd_109;	/* gds__utility */
   } jrd_108;
   struct {
          GDS__QUAD  jrd_104;	/* RDB$RUNTIME */
          SSHORT jrd_105;	/* RDB$FORMAT */
          SSHORT jrd_106;	/* RDB$FIELD_ID */
          SSHORT jrd_107;	/* RDB$DBKEY_LENGTH */
   } jrd_103;
   struct {
          GDS__QUAD  jrd_95;	/* RDB$RUNTIME */
          TEXT  jrd_96 [256];	/* RDB$EXTERNAL_FILE */
          GDS__QUAD  jrd_97;	/* RDB$VIEW_BLR */
          SSHORT jrd_98;	/* gds__utility */
          SSHORT jrd_99;	/* RDB$DBKEY_LENGTH */
          SSHORT jrd_100;	/* RDB$FIELD_ID */
          SSHORT jrd_101;	/* RDB$FORMAT */
          SSHORT jrd_102;	/* RDB$RELATION_ID */
   } jrd_94;
   struct {
          TEXT  jrd_93 [32];	/* RDB$RELATION_NAME */
   } jrd_92;
/**************************************
 *
 *	m a k e _ v e r s i o n
 *
 **************************************
 *
 * Functional description
 *	Make a new format version for a relation.  While we're at it, make
 *	sure all fields have id's.  If the relation is a view, make a
 *	a format anyway -- used for view updates.
 *
 *	While we're in the vicinity, also check the updatability of fields.
 *
 **************************************/
DBB		dbb;
BLK		request_fmt1, request_fmtx;
TFB		stack, external, tfb;
REL		relation;
BLB		blob;
GDS__QUAD blob_id;
BLK		temp;
USHORT		version, n, external_flag;
BOOLEAN		null_view, computed_field;
STATUS		status [20];
SSHORT		collation;
VEC		triggers [TRIGGER_MAX];

SET_TDBB (tdbb);
dbb =  tdbb->tdbb_database;

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	relation = NULL;
	stack = external = NULL;
	computed_field = FALSE;

	for (n = 0; n < TRIGGER_MAX; n++)
	    triggers [n] = NULL_PTR;

	request_fmt1 = (BLK) CMP_find_request (tdbb, irq_format1, IRQ_REQUESTS);

	/*FOR (REQUEST_HANDLE request_fmt1) 
		REL IN RDB$RELATIONS WITH REL.RDB$RELATION_NAME EQ work->dfw_name*/
	{
	if (!request_fmt1)
	   request_fmt1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_91, TRUE);
	gds__vtov (work->dfw_name, jrd_92.jrd_93, 32);
	EXE_start (tdbb, (REQ)request_fmt1, dbb->dbb_sys_trans);
	EXE_send (tdbb, (REQ)request_fmt1, 0, 32, (UCHAR*)&jrd_92);
	while (1)
	   {
	   EXE_receive (tdbb, (REQ)request_fmt1, 1, 282, (UCHAR*)&jrd_94);
	   if (!jrd_94.jrd_98) break;
	    if (!REQUEST (irq_format1))
		REQUEST (irq_format1) = request_fmt1;
	    if (!(relation = MET_lookup_relation_id (tdbb, /*REL.RDB$RELATION_ID*/
							   jrd_94.jrd_102, FALSE)))
		{
		EXE_unwind (tdbb, request_fmt1);
		return FALSE;
		}
	    blob_id = /*REL.RDB$VIEW_BLR*/
		      jrd_94.jrd_97;
	    null_view = NULL_BLOB (blob_id);
	    external_flag = /*REL.RDB$EXTERNAL_FILE*/
			    jrd_94.jrd_96 [0];
            if (/*REL.RDB$FORMAT*/
		jrd_94.jrd_101 == 255)
		{
		EXE_unwind (tdbb, request_fmt1);
                ERR_post (gds__no_meta_update,
		    gds_arg_gds, gds__table_name,
		    gds_arg_string, ERR_cstring (work->dfw_name),
		    gds_arg_gds, gds__version_err,
		    0);
		    /* Msg357: too many versions */
		}
	    /*MODIFY REL USING*/
	    {
	    
		blob = BLB_create (tdbb, dbb->dbb_sys_trans, &/*REL.RDB$RUNTIME*/
							      jrd_94.jrd_95);
		request_fmtx = (BLK) CMP_find_request (tdbb, irq_format2, IRQ_REQUESTS);
		/*FOR (REQUEST_HANDLE request_fmtx)
		    RFR IN RDB$RELATION_FIELDS CROSS 
		    FLD IN RDB$FIELDS WITH
			RFR.RDB$RELATION_NAME EQ work->dfw_name AND
			RFR.RDB$FIELD_SOURCE EQ FLD.RDB$FIELD_NAME*/
		{
		if (!request_fmtx)
		   request_fmtx = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_44, TRUE);
		gds__vtov (work->dfw_name, jrd_45.jrd_46, 32);
		EXE_start (tdbb, (REQ)request_fmtx, dbb->dbb_sys_trans);
		EXE_send (tdbb, (REQ)request_fmtx, 0, 32, (UCHAR*)&jrd_45);
		while (1)
		   {
		   EXE_receive (tdbb, (REQ)request_fmtx, 1, 218, (UCHAR*)&jrd_47);
		   if (!jrd_47.jrd_57) break;

		    /* Update RFR to reflect new fields id */

		    if (!/*RFR.RDB$FIELD_ID.NULL*/
			 jrd_47.jrd_80 &&
			/*RFR.RDB$FIELD_ID*/
			jrd_47.jrd_81 >= /*REL.RDB$FIELD_ID*/
    jrd_94.jrd_100)
			/*REL.RDB$FIELD_ID*/
			jrd_94.jrd_100 = /*RFR.RDB$FIELD_ID*/
   jrd_47.jrd_81 + 1;

		    if (/*RFR.RDB$FIELD_ID.NULL*/
			jrd_47.jrd_80 || /*RFR.RDB$UPDATE_FLAG.NULL*/
    jrd_47.jrd_78)
			/*MODIFY RFR USING*/
			{
			
			    if (/*RFR.RDB$FIELD_ID.NULL*/
				jrd_47.jrd_80)
				{
				if (external_flag)
				    {
				    /*RFR.RDB$FIELD_ID*/
				    jrd_47.jrd_81 = /*RFR.RDB$FIELD_POSITION*/
   jrd_47.jrd_77;
				    /* RFR.RDB$FIELD_POSITION.NULL is
				    needed to be referenced in the
				    code somewhere for GPRE to include
				    this field in the structures that
				    it generates at the top of this func. */
				    /*RFR.RDB$FIELD_ID.NULL*/
				    jrd_47.jrd_80 = /*RFR.RDB$FIELD_POSITION.NULL*/
   jrd_47.jrd_76;
				    }
				else
				    {
				    /*RFR.RDB$FIELD_ID*/
				    jrd_47.jrd_81 = /*REL.RDB$FIELD_ID*/
   jrd_94.jrd_100;
				    /*RFR.RDB$FIELD_ID.NULL*/
				    jrd_47.jrd_80 = FALSE;
				    }
				/*REL.RDB$FIELD_ID*/
				jrd_94.jrd_100++;
				}
			    if (/*RFR.RDB$UPDATE_FLAG.NULL*/
				jrd_47.jrd_78)
				{
				/*RFR.RDB$UPDATE_FLAG.NULL*/
				jrd_47.jrd_78 = FALSE;
				/*RFR.RDB$UPDATE_FLAG*/
				jrd_47.jrd_79 = 1;
				if (!NULL_BLOB (/*FLD.RDB$COMPUTED_BLR*/
						jrd_47.jrd_56))
				    {
				    /*RFR.RDB$UPDATE_FLAG*/
				    jrd_47.jrd_79 = 0;
				    computed_field = TRUE;
				    }
				if (!null_view && /*REL.RDB$DBKEY_LENGTH*/
						  jrd_94.jrd_99 > 8)
				    {
				    temp = NULL;
				    /*RFR.RDB$UPDATE_FLAG*/
				    jrd_47.jrd_79 = 0;
				    /*FOR (REQUEST_HANDLE temp) X IN RDB$TRIGGERS WITH 
					    X.RDB$RELATION_NAME EQ work->dfw_name AND
					    X.RDB$TRIGGER_TYPE EQ 1*/
				    {
				    if (!temp)
				       temp = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_39, TRUE);
				    gds__vtov (work->dfw_name, jrd_40.jrd_41, 32);
				    EXE_start (tdbb, (REQ)temp, dbb->dbb_sys_trans);
				    EXE_send (tdbb, (REQ)temp, 0, 32, (UCHAR*)&jrd_40);
				    while (1)
				       {
				       EXE_receive (tdbb, (REQ)temp, 1, 2, (UCHAR*)&jrd_42);
				       if (!jrd_42.jrd_43) break;
					/*RFR.RDB$UPDATE_FLAG*/
					jrd_47.jrd_79 = 1;
				    /*END_FOR*/
				       }
				    };
				    CMP_release (tdbb, temp);
				    }
				}
			/*END_MODIFY*/
			jrd_82.jrd_83 = jrd_47.jrd_80;
			jrd_82.jrd_84 = jrd_47.jrd_81;
			jrd_82.jrd_85 = jrd_47.jrd_78;
			jrd_82.jrd_86 = jrd_47.jrd_79;
			jrd_82.jrd_87 = jrd_47.jrd_76;
			jrd_82.jrd_88 = jrd_47.jrd_77;
			EXE_send (tdbb, (REQ)request_fmtx, 2, 12, (UCHAR*)&jrd_82);
			};

		    /* Store stuff in field summary */

		    n = /*RFR.RDB$FIELD_ID*/
			jrd_47.jrd_81;
		    put_summary_record (blob, RSR_field_id, &n, sizeof (n));
		    put_summary_record (blob, RSR_field_name, 
			/*RFR.RDB$FIELD_NAME*/
			jrd_47.jrd_55, name_length (/*RFR.RDB$FIELD_NAME*/
	       jrd_47.jrd_55));
		    if (!NULL_BLOB (/*FLD.RDB$COMPUTED_BLR*/
				    jrd_47.jrd_56) && !/*RFR.RDB$VIEW_CONTEXT*/
      jrd_47.jrd_75)
			put_summary_blob (blob, RSR_computed_blr, &/*FLD.RDB$COMPUTED_BLR*/
								   jrd_47.jrd_56);
		    else if (!null_view)
			{
			n = /*RFR.RDB$VIEW_CONTEXT*/
			    jrd_47.jrd_75;
			put_summary_record (blob, RSR_view_context, &n, sizeof (n));
			put_summary_record (blob, RSR_base_field,
				/*RFR.RDB$BASE_FIELD*/
				jrd_47.jrd_54, name_length (/*RFR.RDB$BASE_FIELD*/
	       jrd_47.jrd_54));
			}
		    put_summary_blob (blob, RSR_missing_value, &/*FLD.RDB$MISSING_VALUE*/
								jrd_47.jrd_53);
		    put_summary_blob (blob, RSR_default_value, 
			(NULL_BLOB (/*RFR.RDB$DEFAULT_VALUE*/
				    jrd_47.jrd_52)) ? &/*FLD.RDB$DEFAULT_VALUE*/
      jrd_47.jrd_51 : &/*RFR.RDB$DEFAULT_VALUE*/
    jrd_47.jrd_52);
		    put_summary_blob (blob, RSR_validation_blr, &/*FLD.RDB$VALIDATION_BLR*/
								 jrd_47.jrd_50);
                    if (/*FLD.RDB$NULL_FLAG*/
			jrd_47.jrd_74 || /*RFR.RDB$NULL_FLAG*/
    jrd_47.jrd_73)
                          put_summary_record (blob, RSR_field_not_null,
                                              nonnull_validation_blr,
                                              sizeof (nonnull_validation_blr));

		    n = name_length (/*RFR.RDB$SECURITY_CLASS*/
				     jrd_47.jrd_49);
		    if (!/*RFR.RDB$SECURITY_CLASS.NULL*/
			 jrd_47.jrd_72 && n)
			put_summary_record (blob, RSR_security_class, /*RFR.RDB$SECURITY_CLASS*/
								      jrd_47.jrd_49, n);

		    /* Make a temporary field block */

		    tfb = (TFB) ALLOCD (type_tfb);
		    tfb->tfb_next = stack;
		    stack = tfb;

		    /* for text data types, grab the CHARACTER_SET and
		       COLLATION to give the type of international text */

		    if (/*FLD.RDB$CHARACTER_SET_ID.NULL*/
			jrd_47.jrd_70)
		        /*FLD.RDB$CHARACTER_SET_ID*/
			jrd_47.jrd_71 = CS_NONE;

		    collation = COLLATE_NONE;	/* codepoint collation */
		    if (!/*FLD.RDB$COLLATION_ID.NULL*/
			 jrd_47.jrd_68)
			collation = /*FLD.RDB$COLLATION_ID*/
				    jrd_47.jrd_69;
		    if (!/*RFR.RDB$COLLATION_ID.NULL*/
			 jrd_47.jrd_66)
			collation = /*RFR.RDB$COLLATION_ID*/
				    jrd_47.jrd_67;

		    DSC_make_descriptor (&tfb->tfb_desc, /*FLD.RDB$FIELD_TYPE*/
							 jrd_47.jrd_65,
			/*FLD.RDB$FIELD_SCALE*/
			jrd_47.jrd_64, /*FLD.RDB$FIELD_LENGTH*/
  jrd_47.jrd_63, 
			/*FLD.RDB$FIELD_SUB_TYPE*/
			jrd_47.jrd_62, /*FLD.RDB$CHARACTER_SET_ID*/
  jrd_47.jrd_71, 
			collation);

		    if (!(validate_text_type (tdbb, status, tfb)))
			    {
			    EXE_unwind (tdbb, request_fmt1);
			    EXE_unwind (tdbb, request_fmtx);
    			    ERR_post (gds__no_meta_update, 
				gds_arg_gds, gds__random, 
				gds_arg_string, ERR_cstring (work->dfw_name), 
				status [0], status [1], status [2], status [3],
				0);
			    }


		    if (!NULL_BLOB (/*FLD.RDB$COMPUTED_BLR*/
				    jrd_47.jrd_56))
			tfb->tfb_flags |= TFB_computed;
		    
		    tfb->tfb_id = /*RFR.RDB$FIELD_ID*/
				  jrd_47.jrd_81;

		    if (n = /*FLD.RDB$DIMENSIONS*/
			    jrd_47.jrd_61)
			setup_array (tdbb, blob, /*FLD.RDB$FIELD_NAME*/
						 jrd_47.jrd_48, n, tfb);

		    if (external_flag)
			{
			tfb = (TFB) ALLOCD (type_tfb);
			tfb->tfb_next = external;
			external = tfb;
			tfb->tfb_desc.dsc_dtype = /*FLD.RDB$EXTERNAL_TYPE*/
						  jrd_47.jrd_60;
			tfb->tfb_desc.dsc_scale = /*FLD.RDB$EXTERNAL_SCALE*/
						  jrd_47.jrd_59;
			tfb->tfb_desc.dsc_length = /*FLD.RDB$EXTERNAL_LENGTH*/
						   jrd_47.jrd_58;
			tfb->tfb_id = /*RFR.RDB$FIELD_ID*/
				      jrd_47.jrd_81;
			}
		/*END_FOR*/
		   EXE_send (tdbb, (REQ)request_fmtx, 3, 2, (UCHAR*)&jrd_89);
		   }
		};

		if (!REQUEST (irq_format2))
		    REQUEST (irq_format2) = request_fmtx;

		blob = setup_triggers (tdbb, relation, null_view, triggers, blob);

		BLB_close (tdbb, blob);
		version = /*REL.RDB$FORMAT*/
			  jrd_94.jrd_101;
		version++;
		relation->rel_current_format = make_format (tdbb, relation,
						    &version, stack);
		/*REL.RDB$FORMAT*/
		jrd_94.jrd_101 = version;
	    /*END_MODIFY*/
	    jrd_103.jrd_104 = jrd_94.jrd_95;
	    jrd_103.jrd_105 = jrd_94.jrd_101;
	    jrd_103.jrd_106 = jrd_94.jrd_100;
	    jrd_103.jrd_107 = jrd_94.jrd_99;
	    EXE_send (tdbb, (REQ)request_fmt1, 2, 14, (UCHAR*)&jrd_103);
	    };
	/*END_FOR*/
	   EXE_send (tdbb, (REQ)request_fmt1, 3, 2, (UCHAR*)&jrd_108);
	   }
	};

	if (!REQUEST (irq_format1))
	    REQUEST (irq_format1) = request_fmt1;

	/* If we didn't find the relation, it is probably being dropped */

	if (!relation)
	    return FALSE;

	if (!(relation->rel_flags & REL_sys_trigs_being_loaded))
	    load_trigs (tdbb, relation, triggers);

	/* in case somebody changed the view definition or a computed
	   field, reset the dependencies by deleting the current ones
	   and setting a flag for MET_scan_relation to find the new ones */

	if (!null_view)
	    MET_delete_dependencies (tdbb, work->dfw_name, obj_view);

	if (!null_view || computed_field)
	    relation->rel_flags |= REL_get_dependencies;

	if (external_flag)
	    {
	    temp = NULL;
	    /*FOR (REQUEST_HANDLE temp) FMT IN RDB$FORMATS WITH 
		    FMT.RDB$RELATION_ID EQ relation->rel_id AND
		    FMT.RDB$FORMAT EQ 0*/
	    {
	    if (!temp)
	       temp = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_30, TRUE);
	    jrd_31.jrd_32 = relation->rel_id;
	    EXE_start (tdbb, (REQ)temp, dbb->dbb_sys_trans);
	    EXE_send (tdbb, (REQ)temp, 0, 2, (UCHAR*)&jrd_31);
	    while (1)
	       {
	       EXE_receive (tdbb, (REQ)temp, 1, 2, (UCHAR*)&jrd_33);
	       if (!jrd_33.jrd_34) break;
		/*ERASE FMT*/
		EXE_send (tdbb, (REQ)temp, 2, 2, (UCHAR*)&jrd_35);;
	    /*END_FOR*/
	       EXE_send (tdbb, (REQ)temp, 3, 2, (UCHAR*)&jrd_37);
	       }
	    };
	    CMP_release (tdbb, temp);
	    make_format (tdbb, relation, 0, external);
	    }

	relation->rel_flags &= ~REL_scanned;
	DFW_post_work (transaction, dfw_scan_relation, NULL_PTR, relation->rel_id);
	break;
    }

return FALSE;
}

static BOOLEAN modify_procedure (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	m o d i f y _ p r o c e d u r e
 *
 **************************************
 *
 * Functional description
 *	Perform required actions when modifying procedure.
 *
 **************************************/
PRC	procedure;
USHORT	wait;
JMP_BUF env, *old_env;

SET_TDBB (tdbb);

switch (phase)
    {
    case 0:
	if (!(procedure = MET_lookup_procedure_id (tdbb, work->dfw_id, FALSE, 0)))
	    return FALSE;

	wait = (transaction->tra_flags & TRA_nowait) ? FALSE : TRUE;
	LCK_convert_non_blocking (tdbb, procedure->prc_existence_lock, LCK_SR, wait);
	return FALSE;

    case 1:
	return TRUE;

    case 2:
	return TRUE;

    case 3:
	if (!(procedure = MET_lookup_procedure_id (tdbb, work->dfw_id, FALSE, 0)))
	    return FALSE;
	wait = (transaction->tra_flags & TRA_nowait) ? FALSE : TRUE;

	/* Let relation be deleted if only this transaction is using it */

	if (!LCK_convert_non_blocking (tdbb, procedure->prc_existence_lock,
				LCK_EX, wait))
	    ERR_post (gds__no_meta_update,
		gds_arg_gds, gds__obj_in_use,
		gds_arg_string, ERR_cstring (work->dfw_name), 
		0);

	/* If we are in a multi-client server, someone else may have marked
	   procedure obsolete. Unmark and we will remark it later. */

	procedure->prc_flags &= ~PRC_obsolete;
	return TRUE;

    case 4:
	if (!(procedure = MET_lookup_procedure_id (tdbb, work->dfw_id, FALSE, 0)))
	    return FALSE;

        old_env = (JMP_BUF*) tdbb->tdbb_setjmp;
        tdbb->tdbb_setjmp = (UCHAR*) env;
        if (SETJMP (env))
            {
#ifdef SUPERSERVER
            THD_rec_mutex_unlock (&tdbb->tdbb_database->dbb_sp_rec_mutex);
#endif
            tdbb->tdbb_setjmp = (UCHAR*) old_env;
            ERR_punt ();
            }

#ifdef SUPERSERVER
        if (!(tdbb->tdbb_database->dbb_flags & DBB_sp_rec_mutex_init))
            {
            THD_rec_mutex_init (&tdbb->tdbb_database->dbb_sp_rec_mutex);
            tdbb->tdbb_database->dbb_flags |= DBB_sp_rec_mutex_init;
            }
        THREAD_EXIT;
        if (THD_rec_mutex_lock (&tdbb->tdbb_database->dbb_sp_rec_mutex))
            {
            THREAD_ENTER;
            return FALSE;
            }
        THREAD_ENTER;
#endif /* SUPERSERVER */
        if (procedure->prc_use_count)
	    {
	    USHORT prc_alter_count = procedure->prc_alter_count;
	    if (prc_alter_count > MAX_PROC_ALTER )
		{
                ERR_post (gds__no_meta_update,
		    gds_arg_gds, gds__proc_name,
		    gds_arg_string, ERR_cstring (work->dfw_name),
		    gds_arg_gds, gds__version_err,
		    0);
		    /* Msg357: too many versions */
		}
	    LCK_release (tdbb, procedure->prc_existence_lock);
	    tdbb->tdbb_database->dbb_procedures->vec_object[procedure->prc_id] = NULL_PTR;
	    if (!(procedure = MET_lookup_procedure_id (tdbb, work->dfw_id, FALSE, PRC_being_altered )))
		{
#ifdef SUPERSERVER
                THD_rec_mutex_unlock (&tdbb->tdbb_database->dbb_sp_rec_mutex);
#endif
                tdbb->tdbb_setjmp = (UCHAR*) old_env;
		return FALSE;
		}
	    procedure->prc_alter_count = ++prc_alter_count;
	    }

	procedure->prc_flags |= PRC_being_altered;
        if (procedure->prc_request)
	    {
	    if (CMP_clone_active (procedure->prc_request))
		ERR_post (gds__no_meta_update,
		    gds_arg_gds, gds__obj_in_use,
		    gds_arg_string, ERR_cstring (work->dfw_name),
		    0);

	    /* release the request */

	    CMP_release (tdbb, procedure->prc_request);
	    procedure->prc_request = 0;
	    }

	/* delete dependency lists */

	MET_delete_dependencies (tdbb, work->dfw_name, obj_procedure);

	/* the procedure has just been scanned by MET_lookup_procedure_id
	   and its PRC_scanned flag is set. We are going to reread it
	   from file (create all new dependencies) and do not want this
	   flag to be set. That is why we do not add PRC_obsolete and
	   PRC_being_altered flags, we set only these two flags
	*/
	procedure->prc_flags = (PRC_obsolete | PRC_being_altered);

	if (procedure->prc_existence_lock)
	    LCK_release (tdbb, procedure->prc_existence_lock);

	/* remove procedure from cache */

	MET_remove_procedure (tdbb, work->dfw_id, NULL);

	/* Now handle the new definition */

	get_procedure_dependencies (work);

	procedure->prc_flags &= ~(PRC_obsolete | PRC_being_altered);

        tdbb->tdbb_setjmp = (UCHAR*) old_env;
#ifdef SUPERSERVER
        THD_rec_mutex_unlock (&tdbb->tdbb_database->dbb_sp_rec_mutex);
#endif

	break;
    }

return FALSE;
}

static BOOLEAN modify_trigger (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	m o d i f y _ t r i g g e r 
 *
 **************************************
 *
 * Functional description
 *	Perform required actions when modifying trigger.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	/* get rid of old dependencies, bring in the new */

	MET_delete_dependencies (tdbb, work->dfw_name, obj_trigger);
	get_trigger_dependencies (work);
	break;
    }

return FALSE;
}

static USHORT name_length (
    TEXT	*name)
{
/**************************************
 *
 *	n a m e _ l e n g t h
 *
 **************************************
 *
 * Functional description
 *	Compute effective length of system relation name.
 *	Trailing blanks are ignored.
 *
 **************************************/
TEXT	*p, *q;
#define	BLANK	'\040'

q = name - 1;
for (p = name; *p; p++)
    {
    if (*p != BLANK)
	q = p;
    }

return ((q+1) - name);
}

static void put_summary_blob (
    BLB		blob,
    RSR_T	type,
    SLONG	blob_id [2])
{
/**************************************
 *
 *	p u t _ s u m m a r y _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Put an attribute record to the relation summary blob.
 *
 **************************************/
TDBB	tdbb;
DBB	dbb;
BLB	blr;
UCHAR	*buffer, temp [128];
USHORT	length;
JMP_BUF	env, *old_env;

tdbb = GET_THREAD_DATA;
dbb = tdbb->tdbb_database;

/* If blob is null, don't both */

if (!blob_id [0] && !blob_id [1])
    return;

/* Go ahead and open blob */

blr = BLB_open (tdbb, dbb->dbb_sys_trans, blob_id);
length = blr->blb_length;
buffer = (length > sizeof (temp)) ?
    (UCHAR*) ALL_malloc ((SLONG) blr->blb_length, ERR_jmp) : temp;

/* Setup to cleanup after any error that may occur */

old_env = (JMP_BUF*) tdbb->tdbb_setjmp;
tdbb->tdbb_setjmp = (UCHAR*) env;

if (SETJMP (env))
    {
    tdbb->tdbb_setjmp = (UCHAR*) old_env;
    if (buffer != temp)
	ALL_free (buffer);
    ERR_punt();
    }

length = BLB_get_data (tdbb, blr, buffer, (SLONG) length);
put_summary_record (blob, type, buffer, length);

tdbb->tdbb_setjmp = (UCHAR*) old_env;

if (buffer != temp)
    ALL_free (buffer);
}

static void put_summary_record (
    BLB		blob,
    RSR_T	type,
    UCHAR	*data,
    USHORT	length)
{
/**************************************
 *
 *	p u t _ s u m m a r y _ r e c o r d
 *
 **************************************
 *
 * Functional description
 *	Put an attribute record to the relation summary blob.
 *
 **************************************/
TDBB	tdbb;
UCHAR	*p, *buffer, temp [129];
JMP_BUF	env, *old_env;

tdbb = GET_THREAD_DATA;

p = buffer = (length + 1 > sizeof (temp)) ?
    (UCHAR*) ALL_malloc ((SLONG) (length + 1), ERR_jmp) : temp;

*p++ = (UCHAR) type;

if (length)
    do *p++ = *data++; while (--length);

/* Setup to cleanup after any error that may occur */

old_env = (JMP_BUF*) tdbb->tdbb_setjmp;
tdbb->tdbb_setjmp = (UCHAR*) env;

if (SETJMP (env))
    {
    tdbb->tdbb_setjmp = (UCHAR*) old_env;
    if (buffer != temp)
	ALL_free (buffer);
    ERR_punt();
    }

BLB_put_segment (tdbb, blob, buffer, p - buffer);

tdbb->tdbb_setjmp = (UCHAR*) old_env;

if (buffer != temp)
    ALL_free (buffer);
}

static BOOLEAN scan_relation (
    TDBB	tdbb,
    SSHORT	phase,
    DFW		work,
    TRA		transaction)
{
/**************************************
 *
 *	s c a n _ r e l a t i o n
 *
 **************************************
 *
 * Functional description
 *	Call MET_scan_relation with the appropriate 
 *	relation.
 *
 **************************************/

SET_TDBB (tdbb);

switch (phase)
    {
    case 1:
    case 2:
	return TRUE;

    case 3:
	MET_scan_relation (tdbb, MET_relation (tdbb, work->dfw_id)); 
	break;
    }

return FALSE;
}

static BOOLEAN shadow_defined (TDBB	tdbb)
{
   struct {
          SSHORT jrd_29;	/* gds__utility */
   } jrd_28;
/**************************************
 *
 *	s h a d o w _ d e f i n e d
 *
 **************************************
 *
 * Functional description
 *	Return TRUE if any shadows have been has been defined 
 *      for the database else return FALSE.
 *
 **************************************/
DBB	dbb;
BOOLEAN	result;
BLK	handle;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

result = FALSE;
handle = NULL;

/*FOR (REQUEST_HANDLE handle) FIRST 1 X IN RDB$FILES WITH X.RDB$SHADOW_NUMBER > 0*/
{
if (!handle)
   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_27, TRUE);
EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
while (1)
   {
   EXE_receive (tdbb, (REQ)handle, 0, 2, (UCHAR*)&jrd_28);
   if (!jrd_28.jrd_29) break;
    result = TRUE;
/*END_FOR*/
   }
}

CMP_release (tdbb, handle);

return result;
}

static void setup_array (
    TDBB    tdbb,
    BLB	    blob,
    UCHAR   * field_name,
    USHORT  n,
    TFB	    tfb)
{
/**************************************
 *
 *	s e t u p _ a r r a y
 *
 **************************************
 *
 * Functional description
 *
 *	setup an array descriptor in a tfb
 *
 **************************************/

SLONG		stuff [64];
ADS		array;

put_summary_record (blob, RSR_dimensions, &n, sizeof (n));
tfb->tfb_flags |= TFB_array;
array = (ADS) stuff;
MOVE_CLEAR (array, (SLONG) sizeof (struct ads));
array->ads_dimensions = n;
array->ads_struct_count = 1;
array->ads_rpt[0].ads_desc = tfb->tfb_desc;
get_array_desc (tdbb, field_name, array);
put_summary_record (blob, RSR_array_desc, array, array->ads_length);
}

static BLB setup_triggers (
     TDBB	tdbb,
     REL	relation,
     BOOLEAN	null_view,
     VEC	* triggers,
     BLB	blob)
{
   struct {
          TEXT  jrd_7 [32];	/* RDB$RELATION_NAME */
          TEXT  jrd_8 [32];	/* RDB$TRIGGER_NAME */
          SSHORT jrd_9;	/* gds__utility */
          SSHORT jrd_10;	/* RDB$TRIGGER_INACTIVE */
   } jrd_6;
   struct {
          TEXT  jrd_5 [32];	/* RDB$RELATION_NAME */
   } jrd_4;
   struct {
          TEXT  jrd_15 [32];	/* RDB$RELATION_NAME */
          TEXT  jrd_16 [32];	/* RDB$TRIGGER_NAME */
          SSHORT jrd_17;	/* gds__utility */
          SSHORT jrd_18;	/* RDB$TRIGGER_INACTIVE */
   } jrd_14;
   struct {
          TEXT  jrd_13 [32];	/* RDB$RELATION_NAME */
   } jrd_12;
   struct {
          TEXT  jrd_23 [32];	/* RDB$RELATION_NAME */
          TEXT  jrd_24 [32];	/* RDB$TRIGGER_NAME */
          SSHORT jrd_25;	/* gds__utility */
          SSHORT jrd_26;	/* RDB$TRIGGER_INACTIVE */
   } jrd_22;
   struct {
          TEXT  jrd_21 [32];	/* RDB$RELATION_NAME */
   } jrd_20;
/**************************************
 *
 *	s e t u p _ t r i g g e r s
 *
 **************************************
 *
 * Functional description
 *
 *	Get the triggers in the right order, which appears
 *      to be system triggers first, then user triggers,
 *      then triggers that implement check constraints. 
 *
 * BUG #8458: Check constraint triggers have to be loaded
 *	      (and hence executed) after the user-defined 
 *	      triggers because user-defined triggers can modify
 *	      the values being inserted or updated so that
 *	      the end values stored in the database don't
 *	      fulfill the check constraint.     .
 *
 **************************************/
BLK	request_fmtx;
DBB	dbb;

if (!relation)
    return blob;

dbb = tdbb->tdbb_database;


/* system triggers */

request_fmtx = (BLK) CMP_find_request (tdbb, irq_format4, IRQ_REQUESTS);

/*FOR (REQUEST_HANDLE request_fmtx) 
	TRG IN RDB$TRIGGERS 
	WITH TRG.RDB$RELATION_NAME = relation->rel_name 
	    AND TRG.RDB$SYSTEM_FLAG = 1 
	SORTED BY TRG.RDB$TRIGGER_SEQUENCE*/
{
if (!request_fmtx)
   request_fmtx = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_19, TRUE);
gds__vtov (relation->rel_name, jrd_20.jrd_21, 32);
EXE_start (tdbb, (REQ)request_fmtx, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)request_fmtx, 0, 32, (UCHAR*)&jrd_20);
while (1)
   {
   EXE_receive (tdbb, (REQ)request_fmtx, 1, 68, (UCHAR*)&jrd_22);
   if (!jrd_22.jrd_25) break;

    if (!/*TRG.RDB$TRIGGER_INACTIVE*/
	 jrd_22.jrd_26)
	setup_trigger_details (tdbb, relation,  blob,  triggers,  
	    /*TRG.RDB$TRIGGER_NAME*/
	    jrd_22.jrd_24, /*TRG.RDB$RELATION_NAME*/
  jrd_22.jrd_23, null_view);
	        	
/*END_FOR*/
   }
};

if (!REQUEST (irq_format4))
    REQUEST (irq_format4) = request_fmtx;


/* user triggers */

request_fmtx = (BLK) CMP_find_request (tdbb, irq_format5, IRQ_REQUESTS);

/*FOR (REQUEST_HANDLE request_fmtx)
    TRG IN RDB$TRIGGERS
    WITH TRG.RDB$RELATION_NAME EQ relation->rel_name
	AND (TRG.RDB$SYSTEM_FLAG = 0 OR TRG.RDB$SYSTEM_FLAG MISSING)
	AND (NOT ANY 
	    CHK IN RDB$CHECK_CONSTRAINTS CROSS
	    RCN IN RDB$RELATION_CONSTRAINTS
	    WITH TRG.RDB$TRIGGER_NAME EQ CHK.RDB$TRIGGER_NAME
		AND CHK.RDB$CONSTRAINT_NAME EQ RCN.RDB$CONSTRAINT_NAME
		AND (RCN.RDB$CONSTRAINT_TYPE EQ "CHECK"
		    OR RCN.RDB$CONSTRAINT_TYPE EQ "FOREIGN KEY")
	    )
    SORTED BY TRG.RDB$TRIGGER_SEQUENCE*/
{
if (!request_fmtx)
   request_fmtx = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_11, TRUE);
gds__vtov (relation->rel_name, jrd_12.jrd_13, 32);
EXE_start (tdbb, (REQ)request_fmtx, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)request_fmtx, 0, 32, (UCHAR*)&jrd_12);
while (1)
   {
   EXE_receive (tdbb, (REQ)request_fmtx, 1, 68, (UCHAR*)&jrd_14);
   if (!jrd_14.jrd_17) break;
    if (!/*TRG.RDB$TRIGGER_INACTIVE*/
	 jrd_14.jrd_18)
	setup_trigger_details (tdbb, relation,  blob,  triggers,  
	    /*TRG.RDB$TRIGGER_NAME*/
	    jrd_14.jrd_16, /*TRG.RDB$RELATION_NAME*/
  jrd_14.jrd_15, null_view);
/*END_FOR*/
   }
};

if (!REQUEST (irq_format5))
    REQUEST (irq_format5) = request_fmtx;

/* check constraint triggers */

request_fmtx = (BLK) CMP_find_request (tdbb, irq_format6, IRQ_REQUESTS);

/*FOR (REQUEST_HANDLE request_fmtx)
    TRG IN RDB$TRIGGERS
    WITH TRG.RDB$RELATION_NAME = relation->rel_name 
	AND (TRG.RDB$SYSTEM_FLAG BT 3 AND 5	  
	    OR ((TRG.RDB$SYSTEM_FLAG = 0 OR TRG.RDB$SYSTEM_FLAG MISSING)
	        AND ANY 
		CHK IN RDB$CHECK_CONSTRAINTS CROSS
		RCN IN RDB$RELATION_CONSTRAINTS
		    WITH TRG.RDB$TRIGGER_NAME EQ CHK.RDB$TRIGGER_NAME
			AND CHK.RDB$CONSTRAINT_NAME EQ RCN.RDB$CONSTRAINT_NAME
			AND (RCN.RDB$CONSTRAINT_TYPE EQ "CHECK"
			    OR RCN.RDB$CONSTRAINT_TYPE EQ "FOREIGN KEY")
	    	)
	    )
    SORTED BY TRG.RDB$TRIGGER_SEQUENCE*/
{
if (!request_fmtx)
   request_fmtx = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_3, TRUE);
gds__vtov (relation->rel_name, jrd_4.jrd_5, 32);
EXE_start (tdbb, (REQ)request_fmtx, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)request_fmtx, 0, 32, (UCHAR*)&jrd_4);
while (1)
   {
   EXE_receive (tdbb, (REQ)request_fmtx, 1, 68, (UCHAR*)&jrd_6);
   if (!jrd_6.jrd_9) break;

    if (!/*TRG.RDB$TRIGGER_INACTIVE*/
	 jrd_6.jrd_10)
	setup_trigger_details (tdbb, relation,  blob,  triggers,  
	    /*TRG.RDB$TRIGGER_NAME*/
	    jrd_6.jrd_8, /*TRG.RDB$RELATION_NAME*/
  jrd_6.jrd_7, null_view);
    
/*END_FOR*/
   }
};

if (!REQUEST (irq_format6))
    REQUEST (irq_format6) = request_fmtx;
return blob;
}

static void setup_trigger_details (
    TDBB    tdbb,
    REL	    relation,
    BLB	    blob,
    VEC	    * triggers,
    UCHAR * trigger_name,
    UCHAR * relation_name, 
    BOOLEAN null_view)
{
/**************************************
 *
 *	s e t u p _ t r i g g e r _ d e t a i l s
 *
 **************************************
 *
 * Functional description
 *	Stuff trigger details in places.
 *
 * for a view, load the trigger temporarily -- 
 * this is inefficient since it will just be reloaded
 *  in MET_scan_relation () but it needs to be done
 *  in case the view would otherwise be non-updatable 
 *
 **************************************/

put_summary_record (blob, RSR_trigger_name, 
    trigger_name, name_length (trigger_name));

if (!null_view)
    {
    if (!relation->rel_name)
	relation->rel_name = MET_save_name (tdbb, relation_name);
    MET_load_trigger (tdbb, relation,
			trigger_name, triggers);
    }
}	

static BOOLEAN validate_text_type (
    TDBB    tdbb,
    STATUS  * status,
    TFB	    tfb)
{
/**************************************
 *
 *	v a l i d a t e _ t e x t _ t y p e
 *
 **************************************
 *
 * Functional description
 *	Make sure the text type specified is implemented 
 *
 **************************************/

if ((IS_DTYPE_ANY_TEXT (tfb->tfb_desc.dsc_dtype) &&
    !INTL_defined_type (tdbb, status, tfb->tfb_desc.dsc_ttype))
    ||
    (tfb->tfb_desc.dsc_dtype == dtype_blob && 
     tfb->tfb_desc.dsc_sub_type == BLOB_text && 
     !INTL_defined_type (tdbb, status, tfb->tfb_desc.dsc_scale)))

     return FALSE;

return TRUE;
}

static BOOLEAN wal_defined (TDBB	tdbb)
{
   struct {
          SSHORT jrd_2;	/* gds__utility */
   } jrd_1;
/**************************************
 *
 *	w a l _ d e f i n e d
 *
 **************************************
 *
 * Functional description
 *	Return TRUE if Writ_ahead Log (WAL) has been defined 
 *      for the database else return FALSE.
 *
 **************************************/
DBB	dbb;
BOOLEAN	result;
BLK	handle;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

result = FALSE;
handle = NULL;

/*FOR (REQUEST_HANDLE handle) FIRST 1 X IN RDB$LOG_FILES*/
{
if (!handle)
   handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_0, TRUE);
EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
while (1)
   {
   EXE_receive (tdbb, (REQ)handle, 0, 2, (UCHAR*)&jrd_1);
   if (!jrd_1.jrd_2) break;
    result = TRUE;
/*END_FOR*/
   }
}

CMP_release (tdbb, handle);

return result;
}
