/////////////////////////////////////////////////////////////////////////////
//
// gk_wldap_interface.cxx
//
// $Id: gk_wldap_interface.cxx,v 1.1.2.3 2004/05/12 17:46:40 zvision Exp $
//
// Copyright (C) 2003 Franz J Ehrengruber <franz@iptelenet.com>
//  
// PURPOSE OF THIS FILE: Define the non-opaque part to the MS LDAP-C-API
//                       Windows LDAP integration (wldap.h/wldap32.lib)
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  
//
// History:
//      2003/10/01      initial version (Franz J Ehrengruber)
//                      based on gk_ldap_interface.cxx (Nils Bokermann)
//
/////////////////////////////////////////////////////////////////////////////

#ifdef HAS_WLDAP

#include <string.h>
#include "gk_wldap_interface.h"

GK_LDAP *gk_ldap_init (const char *hostname, int portno) {
	GK_LDAP *ld=new GK_LDAP();
	ld->ld=ldap_init((char *)hostname,portno);
	return ld;
}

GK_LDAP *gk_ldap_open (const char *hostname, int portno) {
	GK_LDAP *ld=new GK_LDAP();
	ld->ld=ldap_open((char *)hostname,portno);
	return ld;
}

ULONG gk_ldap_connect(GK_LDAP *ld, struct l_timeval* timeout) {
	return ldap_connect(ld->ld, timeout);
}

int gk_ldap_sasl_bind (GK_LDAP *ld,  char const *dn, char const *mechanism,
		       struct berval const *cred, LDAPControl **serverctrls,
		       LDAPControl **clientctrls, int *msgidp) {
	return ldap_sasl_bind(ld->ld, (char *)dn, (char *)mechanism, cred, serverctrls, clientctrls, msgidp);
}

int gk_ldap_sasl_bind_s (GK_LDAP *ld,  char const *dn, char const *mechanism, 
			 struct berval const *cred, LDAPControl **serverctrls,
			 LDAPControl **clientctrls, struct berval **servercredp) {
	return ldap_sasl_bind_s(ld->ld, (char *)dn, (char *)mechanism, cred, serverctrls, clientctrls, servercredp);
}

int gk_ldap_simple_bind (GK_LDAP *ld, char const *dn, char const *passwd) {
	return ldap_simple_bind(ld->ld, (char *)dn, (char *)passwd);
}

int gk_ldap_simple_bind_s (GK_LDAP *ld,  char const *dn, char const *passwd) {
	return ldap_simple_bind_s(ld->ld, (char *)dn, (char *)passwd);
}

int gk_ldap_bind (GK_LDAP *ld, char const *dn, char const *cred, int method) {
	return ldap_bind(ld->ld, (char *)dn, (char *)cred, method);
}

int gk_ldap_bind_s (GK_LDAP *ld, char const *dn, char const *cred, int method) {
	return ldap_bind_s(ld->ld, (char *)dn, (char *)cred, method);
}

int gk_ldap_unbind (GK_LDAP *ld) {
	return ldap_unbind(ld->ld);
}

int gk_ldap_unbind_s (GK_LDAP *ld) {
	return ldap_unbind_s(ld->ld);
}

int gk_ldap_get_option (GK_LDAP *ld, int option, void *outvalue) {
	return ldap_get_option(ld->ld, option, outvalue);
}

int gk_ldap_set_option (GK_LDAP *ld, int option,  void const *outvalue) {
	return ldap_set_option (ld->ld, option, outvalue);
}

int gk_ldap_search_ext (GK_LDAP *ld,  
						char const *base,
			            int scope,  
						char const *filter, 
						char **attrs, 
						int attrsonly, 
			            LDAPControl **serverctrls, 
						LDAPControl **clientctrls,
			            ULONG timeout, 
						ULONG sizelimit, 
						ULONG *msgidp) {
	return ldap_search_ext(ld->ld, (char *)base, scope, (char *)filter, attrs, attrsonly, serverctrls, clientctrls, timeout, sizelimit, msgidp);
}

int gk_ldap_search_ext_s (GK_LDAP *ld,  
						  char const *base, 
						  int scope,  
						  char const *filter,
			              char **attrs, 
						  int attrsonly, 
						  LDAPControl 
						  **serverctrls,
			              LDAPControl **clientctrls, 
						  struct l_timeval *timeout,
			              ULONG sizelimit, 
						  LDAPMessage **res) {
	return ldap_search_ext_s(ld->ld, (char *)base, scope, (char *)filter, attrs, attrsonly, serverctrls, clientctrls, timeout, sizelimit, res);
}

int gk_ldap_search (GK_LDAP *ld, char const *base, int scope, char const *filter, char **attrs, int attrsonly) {
	return ldap_search(ld->ld, (char *)base, scope, (char *)filter, attrs, attrsonly);
}

int gk_ldap_search_s (GK_LDAP *ld, char const *base, int scope, char const *filter, char **attrs,
		      int attrsonly, LDAPMessage **res){
	return ldap_search_s(ld->ld, (char *)base, scope, (char *)filter, attrs, attrsonly, res);
}

int gk_ldap_search_st (GK_LDAP *ld, 
					   char const *base, 
					   int scope, 
					   char const *filter, 
					   char **attrs,
		               int attrsonly, 
					   struct l_timeval *timeout, 
					   LDAPMessage **res) {
	return ldap_search_st(ld->ld, (char *)base, scope, (char *)filter, attrs, attrsonly, timeout, res);
}

int gk_ldap_compare_ext (GK_LDAP *ld, 
						 char const *dn, 
						 char const *attr,
						 char const *value,
			             struct berval *bvalue, 
						 LDAPControl **serverctrls,
			             LDAPControl **clientctrls, 
						 ULONG *msgidp) {
	return ldap_compare_ext(ld->ld, (char *)dn, (char *)attr, (char *)value, bvalue, serverctrls, clientctrls, msgidp);
}

int gk_ldap_compare_ext_s (GK_LDAP *ld, 
						   char const *dn, 
						   char const *attr,
						   char const *value,
			               struct berval *bvalue, 
						   LDAPControl **serverctrls,
			               LDAPControl **clientctrls){
	return ldap_compare_ext_s(ld->ld, (char *)dn, (char *)attr, (char *)value, bvalue, serverctrls, clientctrls);
}
  
int gk_ldap_compare (GK_LDAP *ld, char const *dn, char const *attr, char const *value){
	return ldap_compare(ld->ld, (char *)dn, (char *)attr, (char *)value);
}

int gk_ldap_compare_s (GK_LDAP *ld, char const *dn, char const *attr, char const *value) {
	return ldap_compare_s(ld->ld, (char *)dn, (char *)attr, (char *)value);
}
    
int gk_ldap_modify_ext (GK_LDAP *ld, char const *dn, LDAPMod **mods, LDAPControl **serverctrls,
			LDAPControl **clientctrls, ULONG *msgidp) {
	return ldap_modify_ext(ld->ld, (char *)dn, mods, serverctrls, clientctrls, msgidp);
} 
 
int gk_ldap_modify_ext_s (GK_LDAP *ld, char const *dn, LDAPMod **mods,
			  LDAPControl **serverctrls, LDAPControl **clientctrls ) {
	return ldap_modify_ext_s(ld->ld, (char *)dn, mods, serverctrls, clientctrls);
}

int gk_ldap_modify (GK_LDAP *ld, char const *dn, LDAPMod **mods){
	return ldap_modify(ld->ld, (char *)dn, mods);
}

int gk_ldap_modify_s (GK_LDAP *ld, char const *dn, LDAPMod **mods){
	return ldap_modify_s(ld->ld, (char *)dn, mods);
}

int gk_ldap_rename (GK_LDAP *ld, 
					char const *dn, 
					char const *newrdn, 
					char const *newSuperior, 
					int deleteoldrdn,
					LDAPControl **servercontrols, 
					LDAPControl **clientcontrols, 
					ULONG *msgidp) {
	return ldap_rename(ld->ld, (char *)dn, (char *)newrdn, (char *)newSuperior, deleteoldrdn, servercontrols, clientcontrols, msgidp);
}

int gk_ldap_rename_s (GK_LDAP *ld, char const *dn, char const *newrdn,
		      char const *newSuperior, int deleteoldrdn, LDAPControl **servercontrols,
		      LDAPControl **clientcontrols){
	return ldap_rename_s(ld->ld, (char *)dn, (char *)newrdn, (char *)newSuperior, deleteoldrdn, servercontrols, clientcontrols); 
}

int gk_ldap_modrdn2 (GK_LDAP *ld, char const *dn, char const *newrdn, int deleteoldrdn) {
	return ldap_modrdn2(ld->ld, (char *)dn, (char *)newrdn, deleteoldrdn);
}

int gk_ldap_modrdn2_s (GK_LDAP *ld, char const *dn, char const *newrdn, int deleteoldrdn) {
	return ldap_modrdn2_s(ld->ld, (char *)dn, (char *)newrdn, deleteoldrdn);
}

int gk_ldap_modrdn (GK_LDAP *ld, char const *dn, char const *newrdn) {
	return ldap_modrdn(ld->ld, (char *)dn, (char *)newrdn);
}

int gk_ldap_modrdn_s (GK_LDAP *ld, char const *dn, char const *newrdn) {
	return ldap_modrdn_s(ld->ld, (char *)dn, (char *)newrdn);
}

int gk_ldap_add_ext (GK_LDAP *ld, char const *dn, LDAPMod **attrs,
		     LDAPControl **serverctrls, LDAPControl **clientctrls, ULONG *msgidp) {
	return ldap_add_ext(ld->ld, (char *)dn, attrs, serverctrls, clientctrls, msgidp);
}

int gk_ldap_add_ext_s (GK_LDAP *ld, char const *dn, LDAPMod **attrs,
		       LDAPControl **serverctrls, LDAPControl **clientctrls) {
	return ldap_add_ext_s(ld->ld, (char *)dn, attrs, serverctrls, clientctrls);
}

int gk_ldap_add (GK_LDAP *ld, char const *dn, LDAPMod **attrs) {
	return ldap_add(ld->ld, (char *)dn, attrs);
}

int gk_ldap_add_s (GK_LDAP *ld, char const *dn, LDAPMod **attrs ) {
	return ldap_add_s(ld->ld, (char *)dn, attrs);
}

int gk_ldap_delete_ext (GK_LDAP *ld, char const *dn, LDAPControl **serverctrls,
			LDAPControl **clientctrls, ULONG *msgidp) {
	return ldap_delete_ext(ld->ld, (char *)dn, serverctrls, clientctrls, msgidp);
}

int gk_ldap_delete_ext_s (GK_LDAP *ld, char const *dn, LDAPControl **serverctrls,
			  LDAPControl **clientctrls) {
	return ldap_delete_ext_s(ld->ld, (char *)dn, serverctrls, clientctrls);
}

int gk_ldap_delete (GK_LDAP *ld, char const *dn ) {
	return ldap_delete(ld->ld, (char *)dn);
}

int gk_ldap_delete_s (GK_LDAP *ld,  char const *dn ) {
	return ldap_delete_s(ld->ld, (char *)dn);
}

int gk_ldap_extended_operation (GK_LDAP *ld, char const *reqoid,
				struct berval *reqdata, LDAPControl **serverctrls,
				LDAPControl **clientctrls, ULONG *msgidp) {
	return ldap_extended_operation(ld->ld, (char *)reqoid, reqdata, serverctrls, clientctrls, msgidp);
}

int gk_ldap_extended_operation_s (GK_LDAP *ld, char *reqoid,
				  struct berval *reqdata, LDAPControl **serverctrls,
				  LDAPControl **clientctrls, char **retoidp, struct berval **retdatap) {
	return ldap_extended_operation_s(ld->ld, (char *)reqoid, reqdata, serverctrls, clientctrls, retoidp, retdatap);
}

int gk_ldap_parse_extended_result (GK_LDAP *ld, LDAPMessage *res,
				   char **retoidp, struct berval **retdatap, int freeit){
	return ldap_parse_extended_result(ld->ld, res, retoidp, retdatap, freeit);
}

int gk_ldap_abandon (GK_LDAP *ld, ULONG msgid) {
	return ldap_abandon(ld->ld, msgid);
}

int gk_ldap_result (GK_LDAP *ld, ULONG msgid, int all, struct l_timeval  *timeout,
		    LDAPMessage **result){
	return ldap_result(ld->ld, msgid, all, timeout, result);
}

int gk_ldap_parse_result (GK_LDAP *ld, 
						  LDAPMessage *res, 
			              ULONG *errcodep, 
						  char **matcheddnp, 
						  char **errmsgp,
			              char ***referralsp, 
						  LDAPControl ***serverctrls,
			              int freeit) {
	return ldap_parse_result(ld->ld, res, errcodep, matcheddnp, errmsgp, referralsp, serverctrls, freeit);
}

const char * gk_ldap_err2string (int err){
	return ldap_err2string(err);
}

int gk_ldap_result2error (GK_LDAP *ld, LDAPMessage *res, int freeit) {
	return ldap_result2error(ld->ld, res, freeit);
}

void gk_ldap_perror (GK_LDAP *ld, char *s) {
	ldap_perror(ld->ld, s);
}

int gk_LdapGetLastError(void) {
	return LdapGetLastError();
}

LDAPMessage * gk_ldap_first_entry (GK_LDAP *ld, LDAPMessage *chain) {
	return ldap_first_entry(ld->ld, chain);
}

LDAPMessage * gk_ldap_next_entry (GK_LDAP *ld, LDAPMessage *entry) {
	return ldap_next_entry(ld->ld, entry);
}

int gk_ldap_count_entries (GK_LDAP *ld, LDAPMessage *chain) {
	return ldap_count_entries(ld->ld, chain);
}

LDAPMessage * gk_ldap_first_reference (GK_LDAP *ld, LDAPMessage *chain) {
	return ldap_first_reference(ld->ld, chain);
}

LDAPMessage * gk_ldap_next_reference (GK_LDAP *ld, LDAPMessage *ref) {
	return ldap_next_reference(ld->ld, ref);
}

int gk_ldap_count_references (GK_LDAP *ld, LDAPMessage *chain) {
	return ldap_count_references(ld->ld, chain);
}

char * gk_ldap_first_attribute (GK_LDAP *ld, LDAPMessage *entry, BerElement **ber) {
	return ldap_first_attribute(ld->ld, entry, ber);
}

char * gk_ldap_next_attribute (GK_LDAP *ld, LDAPMessage *entry, BerElement *ber) {
	return ldap_next_attribute(ld->ld, entry, ber);
}

char ** gk_ldap_get_values (GK_LDAP *ld, LDAPMessage *entry, char const *target) {
	return ldap_get_values(ld->ld, entry, (char *)target);
}

struct berval ** gk_ldap_get_values_len (GK_LDAP *ld, LDAPMessage *entry,
					 char const *target) {
	return ldap_get_values_len(ld->ld, entry, (char *)target);
}

int gk_ldap_count_values (char **vals) {
	return ldap_count_values(vals);
}

int gk_ldap_count_values_len (struct berval **vals) {
	return ldap_count_values_len(vals);
}

char * gk_ldap_get_dn (GK_LDAP *ld, LDAPMessage *entry) {
	return ldap_get_dn(ld->ld, entry);
}

char * gk_ldap_dn2ufn ( char const *dn) {
	return ldap_dn2ufn((char *)dn);
}

char ** gk_ldap_explode_dn (char const *dn, int notypes) {
	return ldap_explode_dn((char *)dn, notypes);
}

int gk_ldap_parse_reference (GK_LDAP *ld, 
							 LDAPMessage *ref,
							 char ***referrals) { 
	return ldap_parse_reference(ld->ld, ref, referrals);
}

void gk_ldap_control_free (LDAPControl *ctrl) {
	ldap_control_free(ctrl);
}

void gk_ldap_controls_free (LDAPControl **ctrl) {
	ldap_controls_free(ctrl);
}

int gk_ldap_msgfree (LDAPMessage *lm) {
	return ldap_msgfree(lm);
}

int gk_ldap_value_free (char **vals) {
	return ldap_value_free(vals);
}

int gk_ldap_value_free_len (struct berval **vals) {
	return ldap_value_free_len(vals);
}

void gk_ldap_memfree (char const *mem) {
	ldap_memfree((char *)mem);
}

void gk_ldap_berfree(BerElement* pBerElement, int fbuf) {
	ber_free(pBerElement, fbuf);
}

#endif // HAS_WLDAP