/* 
MySQL SQL dump
Host - localhost : Database - gkcontrol
Can be tested with sqleg.ini
**************************************************************
*/

create database if not exists `gkcontrol`;

use `gkcontrol`;

/*
Table structure for gwprefix
*/

drop table if exists `gwprefix`;
CREATE TABLE `gwprefix` (
  `gwalias` varchar(20) NOT NULL default '',
  `gwpfx` varchar(40) NOT NULL default '',
  `gk` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`gwalias`)) TYPE=MyISAM;

/*
Table data for gkcontrol.gwprefix
*/

INSERT INTO `gwprefix` VALUES ('GW1','001,002,01','GK001');
INSERT INTO `gwprefix` VALUES ('GW2','003,004,005','GK001');
INSERT INTO `gwprefix` VALUES ('GW3','006','GK002');

/*
Table structure for neighbors
*/

drop table if exists `neighbors`;
CREATE TABLE `neighbors` (
  `nid` varchar(20) NOT NULL default '',
  `niphost` varchar(40) NOT NULL default '',
  `nport` int(11) NOT NULL default '0',
  `npfx` varchar(40) default NULL,
  `npwd` varchar(40) default NULL,
  `ndipflag` enum('0','1') NOT NULL default '0',
  `gk` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`nid`)) TYPE=MyISAM;

/*
Table data for gkcontrol.neighbors
*/

INSERT INTO `neighbors` VALUES ('GK002','192.168.0.100',1720,NULL,NULL,'0','GK001');
INSERT INTO `neighbors` VALUES ('GK003','192.168.0.101',0,NULL,NULL,'0','GK001');
INSERT INTO `neighbors` VALUES ('GK004','192.168.0.102',1720,'658,659',NULL,'0','GK001');
INSERT INTO `neighbors` VALUES ('GK005','192.168.0.103',1800,'523',NULL,'0','GK001');
INSERT INTO `neighbors` VALUES ('GK006','192.168.0.104',1900,'523',NULL,'0','GK002');

/*
Table structure for petable
*/

drop table if exists `petable`;
CREATE TABLE `petable` (
  `peip` varchar(16) NOT NULL default '',
  `peport` int(11) NOT NULL default '0',
  `pealias` varchar(20) NOT NULL default '',
  `peprefix` varchar(40) default NULL,
  `gk` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`peip`)) TYPE=MyISAM;

/*
Table data for gkcontrol.petable
*/

INSERT INTO `petable` VALUES ('192.168.0.75',0,'alpha',NULL,'GK001');
INSERT INTO `petable` VALUES ('192.168.0.76',1720,'beta',NULL,'GK001');
INSERT INTO `petable` VALUES ('192.168.0.77',1800,'gamma',NULL,'GK002');
INSERT INTO `petable` VALUES ('192.168.0.78',0,'delta','456,457,548','GK001');
INSERT INTO `petable` VALUES ('192.168.0.79',1900,'sigma','784,441','GK001');
INSERT INTO `petable` VALUES ('192.168.0.80',0,'hexa','558,784,455','GK001');
INSERT INTO `petable` VALUES ('192.168.0.81',0,'deci','','GK001');

/*
Table structure for rewriterule
*/

drop table if exists `rewriterule`;
CREATE TABLE `rewriterule` (
  `rkey` varchar(20) NOT NULL default '',
  `rvalue` varchar(30) NOT NULL default '',
  `gk` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`rkey`)) TYPE=MyISAM;

/*
Table data for gkcontrol.rewriterule
*/

INSERT INTO `rewriterule` VALUES ('5101','00141254854','GK001');
INSERT INTO `rewriterule` VALUES ('5102','00265892578','GK001');
INSERT INTO `rewriterule` VALUES ('5103','00352458742','GK002');
INSERT INTO `rewriterule` VALUES ('5104','00499584587','GK002');
INSERT INTO `rewriterule` VALUES ('5105','00585478521','GK001');
INSERT INTO `rewriterule` VALUES ('5106','00695845258','GK001');

/*
Table structure for users
*/

drop table if exists `users`;
CREATE TABLE `users` (
  `alias` varchar(20) NOT NULL default '',
  `authcond` varchar(40) NOT NULL default '',
  `h235password` varchar(40) default NULL,
  `active` enum('1','0') NOT NULL default '1',
  `host` varchar(40) NOT NULL default '',
  `port` int(11) NOT NULL default '0',
  `gk` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`alias`)) TYPE=MyISAM;

/*
Table data for gkcontrol.users
*/

INSERT INTO `users` VALUES ('MYEP1','','','1','192.168.0.51',0,'GK001');
INSERT INTO `users` VALUES ('YOUREP','deny','','1','192.168.0.51',1720,'GK002');
INSERT INTO `users` VALUES ('MYEP2','','','1','192.168.0.53',0,'GK001');
INSERT INTO `users` VALUES ('MYEP7','allow','','1','',0,'GK001');

