/* declarations of routines that interface with the kernel's IPsec mechanism
 * Copyright (C) 1998, 1999  D. Hugh Redelmeier.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: kernel.h,v 1.13 2000/01/17 19:50:22 dhr Exp $
 */

extern bool no_klips;	/* don't actually use KLIPS */

extern void pfkey_handle(void);

struct connection;	/* forward declaration of tag */
extern bool route_connection(struct connection *c, bool doit);
extern void unroute_connection(struct connection *c);

struct state;	/* forward declaration of tag */
extern ipsec_spi_t get_ipsec_spi(ipsec_spi_t avoid);

extern bool install_inbound_ipsec_sa(struct state *st);
extern bool install_ipsec_sa(struct state *st, bool inbound_also);
extern bool delete_ipsec_sa(struct state *st, bool inbound_only);
