#include <stdlib.h>
#include <sys/bitypes.h>
#include <io.h>
#include <dirent.h>
#include <string.h>

/*
 * Chicanery to imitate opendir() readdir() closedir()\
 * These UNIX calls have ANSI equivalents _findfirst(), _findnext() and _findclose()
 */

static DIR dir;
static struct _finddata_t *fd = NULL;
static struct dirent *de = NULL;

DIR *opendir(const char *name)
{
	if(fd)
		free(fd);
	if(de)
		free(de);

	fd = (struct _finddata_t *)malloc(sizeof(struct _finddata_t));
	de = (struct dirent *)malloc(sizeof(struct dirent));
	
	dir = _findfirst(name, fd);
	return &dir;
}	

struct dirent* readdir(DIR *dir)
{
	*dir = _findnext(*dir, fd);
	
	/* Fill in the dirent struct */
	de->d_namlen = strlen(fd->name);
	strcpy(de->d_name, fd->name);
	return de;
}

void closedir(DIR *dir)
{
	_findclose(*dir);
	if(fd)
		free(fd);
	fd = NULL;
	if(de)
		free(de);
	de = NULL;
	*dir = 0;
}