#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <exdll.h>

static char* trim(char* str)
{
	char* begin = str;
	char* end = str + strlen(str);
	for (; begin != end; ++begin) {
		if (!isspace(*begin)) {
			break;
		}
	}
	for (; end != begin; --end) {
		if (!isspace(end[-1])) {
			break;
		}
	}
	*end = '\0';
	return begin;
}

static int validateProxySettings(const char* host, const char* port)
{
	char* endptr;
	long port_num = strtol(port, &endptr, 10);
	if (*endptr || port_num <= 0) {
		return 0;
	}
	if (host[0] == '\0') {
		return 0;
	}
	if (!strcmp(host, "localhost") || !strcmp(host, "127.0.0.1")) {
		if (port_num == 8080) {
			// Most likely it points to the previous installation of bfilter.
			// To avoind proxying to itself, we treat it as invalid setting.
			return 0;
		}
	}
	return 1;
}

void __declspec(dllexport) process(HWND hwndParent, int string_size, char *variables, stack_t **stacktop)
{
	char proxy_enabled[16];
	char proxy_string[1024];
	char proxy_host[1024] = "";
	char proxy_port[1024] = "";
	char* http_pos;
	char* http_end;
	char* colon_pos;
	
	EXDLL_INIT();
	popstring(proxy_enabled);
	popstring(proxy_string);
	
	if ((http_pos = strstr(proxy_string, "http=")) &&
	    (http_pos == proxy_string || http_pos[-1] == ';')) {
		http_end = strchr(http_pos, ';');
		if (!http_end) {
			http_end = http_pos + strlen(http_pos);
		}
		colon_pos = memchr(http_pos, ':', http_end - http_pos);
		if (colon_pos) {
			*colon_pos = '\0';
			strcpy(proxy_host, trim(http_pos + 5));
			strcpy(proxy_port, trim(colon_pos + 1));
		}
	} else if (!strchr(proxy_string, ';')) {
		// one proxy for all protocols
		colon_pos = strchr(proxy_string, ':');
		if (colon_pos) {
			*colon_pos = '\0';
			strcpy(proxy_host, trim(proxy_string));
			strcpy(proxy_port, trim(colon_pos + 1));
		}
	}
	
	if (validateProxySettings(proxy_host, proxy_port)) {
		if (strcmp(proxy_enabled, "0")) {
			strcpy(proxy_enabled, "1");
		}
	} else {
		strcpy(proxy_enabled, "0");
	}
	
	pushstring(proxy_port);
	pushstring(proxy_host);
	pushstring(proxy_enabled);
}

BOOL WINAPI DllMain(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}

