/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LogDialog.h"
#include "LogWidget.h"
#include "OperationLog.h"
#include "Application.h"
#include <ace/config.h>
#include <wx/event.h>
#include <wx/sizer.h>
#include <wx/button.h>

using namespace std;

enum {
	ID_LOG_CLEAR_BTN
};

BEGIN_EVENT_TABLE(LogDialog, wxDialog)
	EVT_ACTIVATE(onWindowActivate)
	EVT_CLOSE(onWindowClose)
	EVT_BUTTON(ID_LOG_CLEAR_BTN, onClearLog)
END_EVENT_TABLE()

LogDialog* LogDialog::m_spInstance = 0;

LogDialog::LogDialog()
:	wxDialog(wxGetApp().GetTopWindow(), -1, _T("BFilter Log"),
			 wxDefaultPosition, wxDefaultSize,
			 wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER),
	AbstractLogView(*OperationLog::instance()),
	m_pLogWidget(0)
{
	wxFlexGridSizer *topsizer = new wxFlexGridSizer(1, 0, 0);
	SetSizer(topsizer);
	topsizer->AddGrowableCol(0);
	topsizer->AddGrowableRow(0);
	
	m_pLogWidget = new LogWidget(
		OperationLog::instance(),
		this, -1, wxEmptyString,
		wxDefaultPosition, wxSize(450, 150)
	);
	topsizer->Add(m_pLogWidget, 0, wxEXPAND|wxALL, 5);
	
	wxBoxSizer *hsz2 = new wxBoxSizer(wxHORIZONTAL);
	topsizer->Add(hsz2, 0, wxALIGN_CENTRE|wxALL, 5);
	
	wxButton* ok_btn = new wxButton(this, wxID_OK, _T("OK"));
	hsz2->Add(ok_btn, 0, wxALIGN_CENTRE|wxLEFT|wxRIGHT|wxBOTTOM, 5);
	ok_btn->SetDefault();
	hsz2->Add(
		new wxButton(this, ID_LOG_CLEAR_BTN, _T("Clear Log")),
		0, wxALIGN_CENTRE|wxLEFT|wxRIGHT|wxBOTTOM, 5
	);
	
	topsizer->SetSizeHints(this);
}

LogDialog::~LogDialog()
{
}

void
LogDialog::show()
{
	if (!m_spInstance) {
		m_spInstance = new LogDialog;
		m_spInstance->Show();
	} else {
		m_spInstance->Show();
		m_spInstance->Raise();
	}
}

void
LogDialog::onWindowActivate(wxActivateEvent& evt)
{
	AbstractLogView::reportVisibility(evt.GetActive());
}

void
LogDialog::onWindowClose(wxCloseEvent& evt)
{
	if (m_spInstance == this) {
		m_spInstance = 0;
	}
	Destroy();
}

void
LogDialog::onClearLog(wxCommandEvent& evt)
{
	OperationLog::instance()->clear();
}
